

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmc" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Player.h"
#include "interfaces/legacy/RenderCapture.h"
#include "interfaces/legacy/Keyboard.h"
#include "interfaces/legacy/ModuleXbmc.h"
#include "interfaces/legacy/Monitor.h"

using namespace XBMCAddon;
using namespace xbmc;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif


namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Player
  TypeInfo TyXBMCAddon_xbmc_Player_Type(typeid(XBMCAddon::xbmc::Player));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::RenderCapture
  TypeInfo TyXBMCAddon_xbmc_RenderCapture_Type(typeid(XBMCAddon::xbmc::RenderCapture));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagMusic
  TypeInfo TyXBMCAddon_xbmc_InfoTagMusic_Type(typeid(XBMCAddon::xbmc::InfoTagMusic));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagRadioRDS
  TypeInfo TyXBMCAddon_xbmc_InfoTagRadioRDS_Type(typeid(XBMCAddon::xbmc::InfoTagRadioRDS));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagVideo
  TypeInfo TyXBMCAddon_xbmc_InfoTagVideo_Type(typeid(XBMCAddon::xbmc::InfoTagVideo));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Keyboard
  TypeInfo TyXBMCAddon_xbmc_Keyboard_Type(typeid(XBMCAddon::xbmc::Keyboard));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::PlayList
  TypeInfo TyXBMCAddon_xbmc_PlayList_Type(typeid(XBMCAddon::xbmc::PlayList));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Monitor
  TypeInfo TyXBMCAddon_xbmc_Monitor_Type(typeid(XBMCAddon::xbmc::Monitor));
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmcgui::ListItem from another module 
  extern TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type;
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmc::PlayListItem from another module 
  extern TypeInfo TyXBMCAddon_xbmc_PlayListItem_Type;
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Player. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Player_Director : public Director, public XBMCAddon::xbmc::Player
  {
    public:

      inline XBMCAddon_xbmc_Player_Director(int  playerCore ) : XBMCAddon::xbmc::Player( playerCore ) { } 

      virtual void  onPlayBackStarted(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStarted",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackEnded(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackEnded",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackStopped(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStopped",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackPaused(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackPaused",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackResumed(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackResumed",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onQueueNextItem(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onQueueNextItem",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSpeedChanged(  int  speed  )
      { 
        PyObject* pyspeed = NULL;
        pyspeed = Py_BuildValue((char*)"i", speed);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSpeedChanged",(char*)"(O)", pyspeed );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeek(  int  time,  int  seekOffset  )
      { 
        PyObject* pytime = NULL;
        pytime = Py_BuildValue((char*)"i", time);
        PyObject* pyseekOffset = NULL;
        pyseekOffset = Py_BuildValue((char*)"i", seekOffset);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeek",(char*)"(OO)", pytime , pyseekOffset );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeekChapter(  int  chapter  )
      { 
        PyObject* pychapter = NULL;
        pychapter = Py_BuildValue((char*)"i", chapter);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeekChapter",(char*)"(O)", pychapter );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Monitor. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Monitor_Director : public Director, public XBMCAddon::xbmc::Monitor
  {
    public:

      inline XBMCAddon_xbmc_Monitor_Director() : XBMCAddon::xbmc::Monitor() { } 

      virtual void  onSettingsChanged(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onSettingsChanged",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverActivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverActivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverDeactivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverDeactivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDPMSActivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDPMSActivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDPMSDeactivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDPMSDeactivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScanStarted(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScanStarted",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScanFinished(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScanFinished",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDatabaseScanStarted(  XBMCAddon::String const  database  )
      { 
        PyObject* pydatabase = NULL;
        pydatabase = PyString_FromStringAndSize(database.c_str(), database.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDatabaseScanStarted",(char*)"(O)", pydatabase );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDatabaseUpdated(  XBMCAddon::String const  database  )
      { 
        PyObject* pydatabase = NULL;
        pydatabase = PyString_FromStringAndSize(database.c_str(), database.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDatabaseUpdated",(char*)"(O)", pydatabase );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onCleanStarted(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onCleanStarted",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onCleanFinished(  XBMCAddon::String const  library  )
      { 
        PyObject* pylibrary = NULL;
        pylibrary = PyString_FromStringAndSize(library.c_str(), library.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onCleanFinished",(char*)"(O)", pylibrary );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onAbortRequested(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAbortRequested",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onNotification(  XBMCAddon::String const  sender,  XBMCAddon::String const  method,  XBMCAddon::String const  data  )
      { 
        PyObject* pysender = NULL;
        pysender = PyString_FromStringAndSize(sender.c_str(), sender.length());
        PyObject* pymethod = NULL;
        pymethod = PyString_FromStringAndSize(method.c_str(), method.length());
        PyObject* pydata = NULL;
        pydata = PyString_FromStringAndSize(data.c_str(), data.length());
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onNotification",(char*)"(OOO)", pysender , pymethod , pydata );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  static PyObject* xbmc_log (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "msg",
          "level",
          NULL};
         
    char * msg ;         
    int  level  = lLOGNOTICE;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|i",
       (char**)keywords,
         &msg,
         &level
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::log(  msg,  level  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::log\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::log\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_shutdown (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::shutdown(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_restart (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::restart(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_executescript (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "script",
          NULL};
         
    char * script ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &script
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executescript(  script  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_executebuiltin (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "function",
          "wait",
          NULL};
         
    char * function ;         
    bool  wait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &function,
         &wait
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executebuiltin(  function,  wait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_executeJSONRPC (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "jsonrpccommand",
          NULL};
         
    char * jsonrpccommand ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &jsonrpccommand
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::executeJSONRPC(  jsonrpccommand  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_sleep (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "timemillis",
          NULL};
         
    long  timemillis ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &timemillis
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::sleep(  timemillis  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_getLocalizedString (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    int  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getLocalizedString(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");

    return result; 
  } 

  static PyObject* xbmc_getSkinDir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getSkinDir(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getLanguage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "format",
          "region",
          NULL};
         
    int  format  = CLangCodeExpander::ENGLISH_NAME;         
    bool  region  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|ib",
       (char**)keywords,
         &format,
         &region
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getLanguage(  format,  region  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getIPAddress (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getIPAddress(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getDVDState (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getDVDState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmc_getFreeMem (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getFreeMem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmc_getInfoLabel (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "cLine",
          NULL};
         
    char * cLine ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &cLine
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getInfoLabel(  cLine  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getInfoImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "infotag",
          NULL};
         
    char * infotag ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &infotag
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getInfoImage(  infotag  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_playSFX (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          "useCached",
          NULL};
         
    char * filename ;         
    bool  useCached  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &filename,
         &useCached
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::playSFX(  filename,  useCached  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_stopSFX (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::stopSFX(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::stopSFX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::stopSFX\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_enableNavSounds (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "yesNo",
          NULL};
         
    bool  yesNo ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &yesNo
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::enableNavSounds(  yesNo  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_getCondVisibility (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "condition",
          NULL};
         
    char * condition ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &condition
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::getCondVisibility(  condition  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_getGlobalIdleTime (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (int )XBMCAddon::xbmc::getGlobalIdleTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_getCacheThumbName (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCacheThumbName"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getCacheThumbName(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_makeLegalFilename (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          "fatX",
          NULL};
         
    std::string  filename ;
    PyObject* pyfilename = NULL;         
    bool  fatX  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyfilename,
         &fatX
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyfilename) PyXBMCGetUnicodeString(filename,pyfilename,false,"filename","XBMCAddon::xbmc::makeLegalFilename"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::makeLegalFilename(  filename,  fatX  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_translatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::translatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::translatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getCleanMovieTitle (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          "usefoldername",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;         
    bool  usefoldername  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pypath,
         &usefoldername
       ))
    {
      return NULL;
    }

    Tuple< XBMCAddon::String ,XBMCAddon::String  >  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCleanMovieTitle"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (Tuple< XBMCAddon::String ,XBMCAddon::String  > )XBMCAddon::xbmc::getCleanMovieTitle(  path,  usefoldername  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
    int vecSize = apiResult.GetNumValuesSet();
    result = PyTuple_New(vecSize);
    {
      PyObject* pyentry1; 

      if (vecSize > 0)
      {
        std::string & entry1 = apiResult.first();
        {
          pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        }
        PyTuple_SetItem(result, 0, pyentry1);
      }


      if (vecSize > 1)
      {
        std::string & entry1 = apiResult.second();
        {
          pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        }
        PyTuple_SetItem(result, 1, pyentry1);
      }

    }

    return result; 
  } 

  static PyObject* xbmc_validatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::validatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::validatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getRegion (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    char * id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getRegion(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_getSupportedMedia (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "mediaType",
          NULL};
         
    char * mediaType ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &mediaType
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::getSupportedMedia(  mediaType  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_skinHasImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "image",
          NULL};
         
    char * image ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &image
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::skinHasImage(  image  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_startServer (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iTyp",
          "bStart",
          "bWait",
          NULL};
         
    int  iTyp ;         
    bool  bStart ;         
    bool  bWait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ib|b",
       (char**)keywords,
         &iTyp,
         &bStart,
         &bWait
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::startServer(  iTyp,  bStart,  bWait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_audioSuspend (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioSuspend(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_audioResume (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioResume(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_convertLanguage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "language",
          "format",
          NULL};
         
    char * language ;         
    int  format ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"si",
       (char**)keywords,
         &language,
         &format
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmc::convertLanguage(  language,  format  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::convertLanguage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::convertLanguage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  playerCore  = EPC_NONE;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &playerCore
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Player * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Player *)(&(TyXBMCAddon_xbmc_Player_Type.pythonType) != pytype) ? new XBMCAddon_xbmc_Player_Director( playerCore ) : new XBMCAddon::xbmc::Player(  playerCore  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmc_Player_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmc_Player_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_play (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "listitem",
          "windowed",
          "startpos",
          NULL};
         
    Alternative< XBMCAddon::String ,PlayList const * >  item  = Player::defaultPlayParameter;
    PyObject* pyitem = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    bool  windowed  = false;         
    int  startpos  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OObi",
       (char**)keywords,
         &pyitem,
         &pylistitem,
         &windowed,
         &startpos
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","play");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          PlayList * entry1_1;
          entry1_1 = (PlayList *)retrieveApiInstance(pyentry_1,"p.PlayList","XBMCAddon::xbmc::","play");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.PlayList" );
        }
      }
    } 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","play"); 

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"play","XBMCAddon::xbmc::Player"))-> play(  item,  listitem,  windowed,  startpos  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"play\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"play\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_stop (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"stop","XBMCAddon::xbmc::Player"))-> stop(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"stop\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"stop\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_pause (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"pause","XBMCAddon::xbmc::Player"))-> pause(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"pause\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"pause\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playnext (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playnext","XBMCAddon::xbmc::Player"))-> playnext(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playnext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playnext\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playprevious (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playprevious","XBMCAddon::xbmc::Player"))-> playprevious(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playprevious\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playprevious\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playselected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    int  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"playselected","XBMCAddon::xbmc::Player"))-> playselected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playselected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playselected\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackStarted","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStarted(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackEnded","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackEnded(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackEnded\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackEnded\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackStopped","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStopped(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStopped\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStopped\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackPaused","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackPaused(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackPaused\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackPaused\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackResumed","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackResumed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackResumed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackResumed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onQueueNextItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onQueueNextItem","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onQueueNextItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onQueueNextItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onQueueNextItem\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "speed",
          NULL};
         
    int  speed ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &speed
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSpeedChanged","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSpeedChanged(  speed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSpeedChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSpeedChanged\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "time",
          "seekOffset",
          NULL};
         
    int  time ;         
    int  seekOffset ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii",
       (char**)keywords,
         &time,
         &seekOffset
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSeek","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeek(  time,  seekOffset  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeek\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeek\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "chapter",
          NULL};
         
    int  chapter ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &chapter
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"onPlayBackSeekChapter","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeekChapter(  chapter  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeekChapter\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeekChapter\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlaying (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlaying","XBMCAddon::xbmc::Player"))-> isPlaying(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlaying\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlaying\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingAudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlayingAudio","XBMCAddon::xbmc::Player"))-> isPlayingAudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingAudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingAudio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingVideo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlayingVideo","XBMCAddon::xbmc::Player"))-> isPlayingVideo(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingVideo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingRDS (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"isPlayingRDS","XBMCAddon::xbmc::Player"))-> isPlayingRDS(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingRDS\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingRDS\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getPlayingFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getPlayingFile","XBMCAddon::xbmc::Player"))-> getPlayingFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayingFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayingFile\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getTime","XBMCAddon::xbmc::Player"))-> getTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_seekTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "seekTime",
          NULL};
         
    double  seekTime ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"d",
       (char**)keywords,
         &seekTime
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"seekTime","XBMCAddon::xbmc::Player"))-> seekTime(  seekTime  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"seekTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"seekTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "subtitleFile",
          NULL};
         
    char * subtitleFile ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &subtitleFile
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setSubtitles","XBMCAddon::xbmc::Player"))-> setSubtitles(  subtitleFile  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_showSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "bVisible",
          NULL};
         
    bool  bVisible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &bVisible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"showSubtitles","XBMCAddon::xbmc::Player"))-> showSubtitles(  bVisible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"showSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"showSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getSubtitles","XBMCAddon::xbmc::Player"))-> getSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_disableSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"disableSubtitles","XBMCAddon::xbmc::Player"))-> disableSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"disableSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"disableSubtitles\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< XBMCAddon::String  >  apiResult;
    try
    {

      apiResult = (std::vector< XBMCAddon::String  > )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getAvailableSubtitleStreams","XBMCAddon::xbmc::Player"))-> getAvailableSubtitleStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableSubtitleStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableSubtitleStreams\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
      result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitleStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setSubtitleStream","XBMCAddon::xbmc::Player"))-> setSubtitleStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitleStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitleStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    InfoTagVideo * apiResult;
    try
    {

      apiResult = (InfoTagVideo *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getVideoInfoTag","XBMCAddon::xbmc::Player"))-> getVideoInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVideoInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVideoInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    InfoTagMusic * apiResult;
    try
    {

      apiResult = (InfoTagMusic *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getMusicInfoTag","XBMCAddon::xbmc::Player"))-> getMusicInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getMusicInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getMusicInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getRadioRDSInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    InfoTagRadioRDS * apiResult;
    try
    {

      apiResult = (InfoTagRadioRDS *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getRadioRDSInfoTag","XBMCAddon::xbmc::Player"))-> getRadioRDSInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getRadioRDSInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getRadioRDSInfoTag\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTotalTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getTotalTime","XBMCAddon::xbmc::Player"))-> getTotalTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTotalTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTotalTime\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< XBMCAddon::String  >  apiResult;
    try
    {

      apiResult = (std::vector< XBMCAddon::String  > )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"getAvailableAudioStreams","XBMCAddon::xbmc::Player"))-> getAvailableAudioStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableAudioStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableAudioStreams\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    
      result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setAudioStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"setAudioStream","XBMCAddon::xbmc::Player"))-> setAudioStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAudioStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAudioStream\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::RenderCapture * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::RenderCapture *)new XBMCAddon::xbmc::RenderCapture(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getWidth","XBMCAddon::xbmc::RenderCapture"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getHeight","XBMCAddon::xbmc::RenderCapture"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getCaptureState","XBMCAddon::xbmc::RenderCapture"))-> getCaptureState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCaptureState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCaptureState\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getAspectRatio","XBMCAddon::xbmc::RenderCapture"))-> getAspectRatio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAspectRatio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAspectRatio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    char * apiResult;
    try
    {

      apiResult = (char *)((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getImageFormat","XBMCAddon::xbmc::RenderCapture"))-> getImageFormat(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getImageFormat\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getImageFormat\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromString(apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XbmcCommons::Buffer  apiResult;
    try
    {

      apiResult = (XbmcCommons::Buffer )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"getImage","XBMCAddon::xbmc::RenderCapture"))-> getImage(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getImage\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyByteArray_FromStringAndSize((char*)apiResult.curPosition(),apiResult.remaining());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_capture (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "width",
          "height",
          "flags",
          NULL};
         
    int  width ;         
    int  height ;         
    int  flags  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii|i",
       (char**)keywords,
         &width,
         &height,
         &flags
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"capture","XBMCAddon::xbmc::RenderCapture"))-> capture(  width,  height,  flags  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"capture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"capture\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "msecs",
          NULL};
         
    unsigned int  msecs  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|I",
       (char**)keywords,
         &msecs
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"waitForCaptureStateChangeEvent","XBMCAddon::xbmc::RenderCapture"))-> waitForCaptureStateChangeEvent(  msecs  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::InfoTagMusic * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagMusic *)new XBMCAddon::xbmc::InfoTagMusic(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getURL","XBMCAddon::xbmc::InfoTagMusic"))-> getURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getURL\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getTitle","XBMCAddon::xbmc::InfoTagMusic"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getArtist\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbum","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbum(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbum\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbum\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbumArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbumArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbumArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbumArtist\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getGenre","XBMCAddon::xbmc::InfoTagMusic"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getDuration","XBMCAddon::xbmc::InfoTagMusic"))-> getDuration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDuration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDuration\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getTrack","XBMCAddon::xbmc::InfoTagMusic"))-> getTrack(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTrack\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTrack\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getDisc","XBMCAddon::xbmc::InfoTagMusic"))-> getDisc(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDisc\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDisc\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getReleaseDate","XBMCAddon::xbmc::InfoTagMusic"))-> getReleaseDate(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getReleaseDate\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getReleaseDate\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getListeners","XBMCAddon::xbmc::InfoTagMusic"))-> getListeners(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListeners\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListeners\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagMusic"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagMusic"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getComment","XBMCAddon::xbmc::InfoTagMusic"))-> getComment(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getComment\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getComment\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"getLyrics","XBMCAddon::xbmc::InfoTagMusic"))-> getLyrics(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLyrics\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLyrics\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::InfoTagRadioRDS * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagRadioRDS *)new XBMCAddon::xbmc::InfoTagRadioRDS(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagRadioRDS\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagRadioRDS\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getTitle","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getBand (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getBand","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getBand(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getBand\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getBand\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getArtist","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getArtist\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getComposer (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getComposer","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getComposer(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getComposer\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getComposer\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getConductor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getConductor","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getConductor(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getConductor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getConductor\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getAlbum (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getAlbum","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getAlbum(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbum\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbum\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getComment (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getComment","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getComment(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getComment\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getComment\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getAlbumTrackNumber (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getAlbumTrackNumber","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getAlbumTrackNumber(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbumTrackNumber\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbumTrackNumber\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoNews (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoNews","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoNews(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoNews\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoNews\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoNewsLocal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoNewsLocal","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoNewsLocal(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoNewsLocal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoNewsLocal\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoSport (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoSport","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoSport(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoSport\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoSport\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoStock (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoStock","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoStock(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoStock\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoStock\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoWeather (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoWeather","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoWeather(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoWeather\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoWeather\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoHoroscope (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoHoroscope","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoHoroscope(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoHoroscope\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoHoroscope\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoCinema (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoCinema","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoCinema(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoCinema\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoCinema\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoLottery (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoLottery","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoLottery(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoLottery\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoLottery\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoOther (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getInfoOther","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getInfoOther(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getInfoOther\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getInfoOther\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEditorialStaff (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getEditorialStaff","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getEditorialStaff(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getEditorialStaff\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getEditorialStaff\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgStation (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgStation","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgStation(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgStation\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgStation\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgStyle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgStyle","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgStyle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgStyle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgStyle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgHost (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgHost","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgHost(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgHost\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgHost\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgWebsite (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgWebsite","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgWebsite(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgWebsite\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgWebsite\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgNow (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgNow","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgNow(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgNow\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgNow\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgNext (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getProgNext","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getProgNext(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProgNext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProgNext\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getPhoneHotline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getPhoneHotline","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getPhoneHotline(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPhoneHotline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPhoneHotline\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEMailHotline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getEMailHotline","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getEMailHotline(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getEMailHotline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getEMailHotline\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getPhoneStudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getPhoneStudio","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getPhoneStudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPhoneStudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPhoneStudio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEMailStudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getEMailStudio","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getEMailStudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getEMailStudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getEMailStudio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getSMSStudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"getSMSStudio","XBMCAddon::xbmc::InfoTagRadioRDS"))-> getSMSStudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSMSStudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSMSStudio\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::InfoTagVideo * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagVideo *)new XBMCAddon::xbmc::InfoTagVideo(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getDirector","XBMCAddon::xbmc::InfoTagVideo"))-> getDirector(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDirector\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDirector\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getWritingCredits","XBMCAddon::xbmc::InfoTagVideo"))-> getWritingCredits(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWritingCredits\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWritingCredits\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getGenre","XBMCAddon::xbmc::InfoTagVideo"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getTagLine","XBMCAddon::xbmc::InfoTagVideo"))-> getTagLine(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTagLine\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTagLine\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlotOutline","XBMCAddon::xbmc::InfoTagVideo"))-> getPlotOutline(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlotOutline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlotOutline\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlot","XBMCAddon::xbmc::InfoTagVideo"))-> getPlot(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlot\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlot\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPictureURL","XBMCAddon::xbmc::InfoTagVideo"))-> getPictureURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPictureURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPictureURL\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getVotes","XBMCAddon::xbmc::InfoTagVideo"))-> getVotes(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVotes\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVotes\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getCast","XBMCAddon::xbmc::InfoTagVideo"))-> getCast(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCast\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCast\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getFile","XBMCAddon::xbmc::InfoTagVideo"))-> getFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFile\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPath","XBMCAddon::xbmc::InfoTagVideo"))-> getPath(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPath\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getIMDBNumber","XBMCAddon::xbmc::InfoTagVideo"))-> getIMDBNumber(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getIMDBNumber\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getIMDBNumber\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getYear","XBMCAddon::xbmc::InfoTagVideo"))-> getYear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getYear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getYear\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getRating","XBMCAddon::xbmc::InfoTagVideo"))-> getRating(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getRating\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getRating\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagVideo"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagVideo"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getOriginalTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getOriginalTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getOriginalTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getOriginalTitle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getPremiered","XBMCAddon::xbmc::InfoTagVideo"))-> getPremiered(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPremiered\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPremiered\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"getFirstAired","XBMCAddon::xbmc::InfoTagVideo"))-> getFirstAired(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFirstAired\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFirstAired\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  line  = XBMCAddon::emptyString;
    PyObject* pyline = NULL;         
    std::string  heading  = XBMCAddon::emptyString;
    PyObject* pyheading = NULL;         
    bool  hidden  = false;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|OOb",
       
         &pyline,
         &pyheading,
         &hidden
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Keyboard * apiResult;
    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","Keyboard"); 
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","Keyboard"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Keyboard *)new XBMCAddon::xbmc::Keyboard(  line,  heading,  hidden  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "autoclose",
          NULL};
         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|i",
       (char**)keywords,
         &autoclose
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"doModal","XBMCAddon::xbmc::Keyboard"))-> doModal(  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setDefault (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "line",
          NULL};
         
    std::string  line  = XBMCAddon::emptyString;
    PyObject* pyline = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|O",
       (char**)keywords,
         &pyline
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","setDefault"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setDefault","XBMCAddon::xbmc::Keyboard"))-> setDefault(  line  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDefault\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDefault\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "hidden",
          NULL};
         
    bool  hidden  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|b",
       (char**)keywords,
         &hidden
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setHiddenInput","XBMCAddon::xbmc::Keyboard"))-> setHiddenInput(  hidden  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHiddenInput\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHiddenInput\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHeading (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyheading
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","setHeading"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"setHeading","XBMCAddon::xbmc::Keyboard"))-> setHeading(  heading  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeading\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeading\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"getText","XBMCAddon::xbmc::Keyboard"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"isConfirmed","XBMCAddon::xbmc::Keyboard"))-> isConfirmed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isConfirmed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isConfirmed\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  playList ;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"i",
       
         &playList
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::PlayList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::PlayList *)new XBMCAddon::xbmc::PlayList(  playList  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getPlayListId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"getPlayListId","XBMCAddon::xbmc::PlayList"))-> getPlayListId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayListId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayListId\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_add (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "url",
          "listitem",
          "index",
          NULL};
         
    std::string  url ;
    PyObject* pyurl = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    int  index  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|Oi",
       (char**)keywords,
         &pyurl,
         &pylistitem,
         &index
       ))
    {
      return NULL;
    }


    try
    {
      if (pyurl) PyXBMCGetUnicodeString(url,pyurl,false,"url","add"); 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","add"); 

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"add","XBMCAddon::xbmc::PlayList"))-> add(  url,  listitem,  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"add\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"add\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_load (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"load","XBMCAddon::xbmc::PlayList"))-> load(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"load\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"load\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_remove (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"remove","XBMCAddon::xbmc::PlayList"))-> remove(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"remove\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"remove\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_clear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"clear","XBMCAddon::xbmc::PlayList"))-> clear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clear\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"size","XBMCAddon::xbmc::PlayList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_shuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"shuffle","XBMCAddon::xbmc::PlayList"))-> shuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"shuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"shuffle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_unshuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"unshuffle","XBMCAddon::xbmc::PlayList"))-> unshuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"unshuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"unshuffle\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getposition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"getposition","XBMCAddon::xbmc::PlayList"))-> getposition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getposition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getposition\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_ (PyHolder* self , PyObject* pyi )
  {
    XBMC_TRACE;
         
    long  i ;    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      i = PyInt_AsLong(pyi); 

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> operator [](  i  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"operator []\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"operator []\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmc::Monitor * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Monitor *)(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType) != pytype) ? new XBMCAddon_xbmc_Monitor_Director() : new XBMCAddon::xbmc::Monitor(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmc_Monitor_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmc_Monitor_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onSettingsChanged","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onSettingsChanged(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onSettingsChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onSettingsChanged\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScreensaverActivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverActivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverActivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverActivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScreensaverDeactivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverDeactivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverDeactivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverDeactivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDPMSActivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDPMSActivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDPMSActivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDPMSActivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDPMSActivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDPMSDeactivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDPMSDeactivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDPMSDeactivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDPMSDeactivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDPMSDeactivated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onScanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScanStarted(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScanFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onScanFinished"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onScanFinished","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScanFinished(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScanFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScanFinished\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDatabaseScanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "database",
          NULL};
         
    std::string  database ;
    PyObject* pydatabase = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydatabase
       ))
    {
      return NULL;
    }


    try
    {
      if (pydatabase) PyXBMCGetUnicodeString(database,pydatabase,false,"database","onDatabaseScanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDatabaseScanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDatabaseScanStarted(  database  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDatabaseScanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDatabaseScanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "database",
          NULL};
         
    std::string  database ;
    PyObject* pydatabase = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydatabase
       ))
    {
      return NULL;
    }


    try
    {
      if (pydatabase) PyXBMCGetUnicodeString(database,pydatabase,false,"database","onDatabaseUpdated"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onDatabaseUpdated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDatabaseUpdated(  database  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDatabaseUpdated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDatabaseUpdated\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onCleanStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onCleanStarted"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onCleanStarted","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onCleanStarted(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onCleanStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onCleanStarted\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onCleanFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "library",
          NULL};
         
    std::string  library ;
    PyObject* pylibrary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylibrary
       ))
    {
      return NULL;
    }


    try
    {
      if (pylibrary) PyXBMCGetUnicodeString(library,pylibrary,false,"library","onCleanFinished"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onCleanFinished","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onCleanFinished(  library  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onCleanFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onCleanFinished\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onAbortRequested","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onAbortRequested(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAbortRequested\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAbortRequested\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onNotification (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "sender",
          "method",
          "data",
          NULL};
         
    std::string  sender ;
    PyObject* pysender = NULL;         
    std::string  method ;
    PyObject* pymethod = NULL;         
    std::string  data ;
    PyObject* pydata = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OOO",
       (char**)keywords,
         &pysender,
         &pymethod,
         &pydata
       ))
    {
      return NULL;
    }


    try
    {
      if (pysender) PyXBMCGetUnicodeString(sender,pysender,false,"sender","onNotification"); 
      if (pymethod) PyXBMCGetUnicodeString(method,pymethod,false,"method","onNotification"); 
      if (pydata) PyXBMCGetUnicodeString(data,pydata,false,"data","onNotification"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"onNotification","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onNotification(  sender,  method,  data  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onNotification\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onNotification\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_waitForAbort (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "timeout",
          NULL};
         
    double  timeout  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|d",
       (char**)keywords,
         &timeout
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"waitForAbort","XBMCAddon::xbmc::Monitor"))-> waitForAbort(  timeout  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"waitForAbort\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"waitForAbort\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_abortRequested (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"abortRequested","XBMCAddon::xbmc::Monitor"))-> abortRequested(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"abortRequested\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"abortRequested\""); 
      return NULL; 
    }

    PyObject* result = Py_None;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static void xbmc_XBMCAddon_xbmc_Player_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Player* theObj = (XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Player_Type,"~XBMCAddon::xbmc::Player","XBMCAddon::xbmc::Player");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::RenderCapture* theObj = (XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_RenderCapture_Type,"~XBMCAddon::xbmc::RenderCapture","XBMCAddon::xbmc::RenderCapture");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagMusic* theObj = (XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagMusic_Type,"~XBMCAddon::xbmc::InfoTagMusic","XBMCAddon::xbmc::InfoTagMusic");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagRadioRDS* theObj = (XBMCAddon::xbmc::InfoTagRadioRDS*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type,"~XBMCAddon::xbmc::InfoTagRadioRDS","XBMCAddon::xbmc::InfoTagRadioRDS");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagRadioRDS\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagRadioRDS\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagVideo* theObj = (XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_InfoTagVideo_Type,"~XBMCAddon::xbmc::InfoTagVideo","XBMCAddon::xbmc::InfoTagVideo");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Keyboard_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Keyboard* theObj = (XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Keyboard_Type,"~XBMCAddon::xbmc::Keyboard","XBMCAddon::xbmc::Keyboard");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_PlayList_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::PlayList* theObj = (XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_PlayList_Type,"~XBMCAddon::xbmc::PlayList","XBMCAddon::xbmc::PlayList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Monitor_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmc::Monitor* theObj = (XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmc_Monitor_Type,"~XBMCAddon::xbmc::Monitor","XBMCAddon::xbmc::Monitor");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Player
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Player_methods[] = { 
    {(char*)"play", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_play, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"stop", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_stop, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"pause", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_pause, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"playnext", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playnext, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"playprevious", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playprevious, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"playselected", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playselected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackEnded", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackStopped", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackPaused", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackResumed", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onQueueNextItem", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onQueueNextItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackSpeedChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackSeek", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onPlayBackSeekChapter", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isPlaying", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlaying, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isPlayingAudio", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingAudio, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isPlayingVideo", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingVideo, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isPlayingRDS", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingRDS, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlayingFile", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getPlayingFile, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"seekTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_seekTime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitles, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"showSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_showSubtitles, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getSubtitles, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"disableSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_disableSubtitles, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAvailableSubtitleStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSubtitleStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitleStream, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getVideoInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getMusicInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getRadioRDSInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getRadioRDSInfoTag, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTotalTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTotalTime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAvailableAudioStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setAudioStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setAudioStream, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Player_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Player_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Player";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Player_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_Player_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Player_New;

    TyXBMCAddon_xbmc_Player_Type.swigType="p.XBMCAddon::xbmc::Player";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Player_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::RenderCapture
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_RenderCapture_methods[] = { 
    {(char*)"getWidth", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getWidth, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getHeight", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCaptureState", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAspectRatio", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getImageFormat", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getImage", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"capture", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_capture, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"waitForCaptureStateChangeEvent", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_RenderCapture_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_RenderCapture_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.RenderCapture";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_RenderCapture_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_RenderCapture_New;

    TyXBMCAddon_xbmc_RenderCapture_Type.swigType="p.XBMCAddon::xbmc::RenderCapture";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_RenderCapture_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagMusic
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagMusic_methods[] = { 
    {(char*)"getURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbum", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbumArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getDuration", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTrack", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getDisc", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getReleaseDate", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListeners", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getComment", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLyrics", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagMusic_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.InfoTagMusic";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_InfoTagMusic_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_InfoTagMusic_New;

    TyXBMCAddon_xbmc_InfoTagMusic_Type.swigType="p.XBMCAddon::xbmc::InfoTagMusic";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_InfoTagMusic_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagRadioRDS
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagRadioRDS_methods[] = { 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getBand", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getBand, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getArtist, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getComposer", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getComposer, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getConductor", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getConductor, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbum", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getAlbum, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getComment", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getComment, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbumTrackNumber", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getAlbumTrackNumber, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoNews", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoNews, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoNewsLocal", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoNewsLocal, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoSport", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoSport, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoStock", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoStock, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoWeather", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoWeather, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoHoroscope", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoHoroscope, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoCinema", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoCinema, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoLottery", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoLottery, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoOther", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getInfoOther, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getEditorialStaff", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEditorialStaff, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgStation", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgStation, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgStyle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgStyle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgHost", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgHost, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgWebsite", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgWebsite, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgNow", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgNow, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getProgNext", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getProgNext, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPhoneHotline", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getPhoneHotline, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getEMailHotline", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEMailHotline, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPhoneStudio", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getPhoneStudio, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getEMailStudio", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getEMailStudio, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSMSStudio", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_getSMSStudio, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagRadioRDS_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_InfoTagRadioRDS_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.InfoTagRadioRDS";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_InfoTagRadioRDS_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_InfoTagRadioRDS_New;

    TyXBMCAddon_xbmc_InfoTagRadioRDS_Type.swigType="p.XBMCAddon::xbmc::InfoTagRadioRDS";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_InfoTagRadioRDS_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagVideo
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagVideo_methods[] = { 
    {(char*)"getDirector", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getWritingCredits", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTagLine", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlotOutline", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlot", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPictureURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getVotes", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCast", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFile", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPath", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getIMDBNumber", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getYear", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getRating", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getOriginalTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPremiered", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFirstAired", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagVideo_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.InfoTagVideo";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_InfoTagVideo_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_InfoTagVideo_New;

    TyXBMCAddon_xbmc_InfoTagVideo_Type.swigType="p.XBMCAddon::xbmc::InfoTagVideo";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_InfoTagVideo_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Keyboard
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Keyboard_methods[] = { 
    {(char*)"doModal", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_doModal, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setDefault", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setDefault, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setHiddenInput", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setHeading", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHeading, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getText", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_getText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isConfirmed", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Keyboard_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Keyboard_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Keyboard";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Keyboard_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_Keyboard_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Keyboard_New;

    TyXBMCAddon_xbmc_Keyboard_Type.swigType="p.XBMCAddon::xbmc::Keyboard";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Keyboard_Type);

  }
  //=========================================================================

  static Py_ssize_t xbmc_XBMCAddon_xbmc_PlayList_size_(PyObject* self)
  {
    return (Py_ssize_t)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance(self,&TyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> size();
  }

  //=========================================================================
  // tp_as_mapping struct for XBMCAddon::xbmc::PlayList
  //=========================================================================
  PyMappingMethods xbmc_XBMCAddon_xbmc_PlayList_as_mapping = {
    xbmc_XBMCAddon_xbmc_PlayList_size_,    /* inquiry mp_length;                  __len__ */
    (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_,   /* binaryfunc mp_subscript             __getitem__ */
    0,                  /* objargproc mp_ass_subscript;     __setitem__ */
  };

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::PlayList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_PlayList_methods[] = { 
    {(char*)"getPlayListId", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getPlayListId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"add", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_add, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"load", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_load, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"remove", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_remove, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"clear", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_clear, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"size", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_size, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"shuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_shuffle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"unshuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_unshuffle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getposition", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getposition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_PlayList_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_PlayList_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.PlayList";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_PlayList_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_PlayList_methods; 
    pythonType.tp_as_mapping = &xbmc_XBMCAddon_xbmc_PlayList_as_mapping;


    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_PlayList_New;

    TyXBMCAddon_xbmc_PlayList_Type.swigType="p.XBMCAddon::xbmc::PlayList";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_PlayList_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Monitor
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Monitor_methods[] = { 
    {(char*)"onSettingsChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onScreensaverActivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onScreensaverDeactivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onDPMSActivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDPMSActivated, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onDPMSDeactivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDPMSDeactivated, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onScanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScanStarted, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onScanFinished", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScanFinished, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onDatabaseScanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDatabaseScanStarted, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onDatabaseUpdated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onCleanStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onCleanStarted, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onCleanFinished", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onCleanFinished, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onAbortRequested", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onNotification", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onNotification, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"waitForAbort", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_waitForAbort, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"abortRequested", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_abortRequested, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Monitor_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmc_Monitor_Type.pythonType;
    pythonType.tp_name = (char*)"xbmc.Monitor";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Monitor_Dealloc; 


    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;

    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmc_Monitor_methods; 

    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmc_XBMCAddon_xbmc_Monitor_New;

    TyXBMCAddon_xbmc_Monitor_Type.swigType="p.XBMCAddon::xbmc::Monitor";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmc_Monitor_Type);

  }
  //=========================================================================


  static PyMethodDef xbmc_methods[] = { 
    {(char*)"log", (PyCFunction)xbmc_log, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"shutdown", (PyCFunction)xbmc_shutdown, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"restart", (PyCFunction)xbmc_restart, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"executescript", (PyCFunction)xbmc_executescript, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"executebuiltin", (PyCFunction)xbmc_executebuiltin, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"executeJSONRPC", (PyCFunction)xbmc_executeJSONRPC, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"sleep", (PyCFunction)xbmc_sleep, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLocalizedString", (PyCFunction)xbmc_getLocalizedString, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSkinDir", (PyCFunction)xbmc_getSkinDir, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLanguage", (PyCFunction)xbmc_getLanguage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getIPAddress", (PyCFunction)xbmc_getIPAddress, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getDVDState", (PyCFunction)xbmc_getDVDState, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFreeMem", (PyCFunction)xbmc_getFreeMem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoLabel", (PyCFunction)xbmc_getInfoLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getInfoImage", (PyCFunction)xbmc_getInfoImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"playSFX", (PyCFunction)xbmc_playSFX, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"stopSFX", (PyCFunction)xbmc_stopSFX, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"enableNavSounds", (PyCFunction)xbmc_enableNavSounds, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCondVisibility", (PyCFunction)xbmc_getCondVisibility, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getGlobalIdleTime", (PyCFunction)xbmc_getGlobalIdleTime, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCacheThumbName", (PyCFunction)xbmc_getCacheThumbName, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"makeLegalFilename", (PyCFunction)xbmc_makeLegalFilename, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"translatePath", (PyCFunction)xbmc_translatePath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCleanMovieTitle", (PyCFunction)xbmc_getCleanMovieTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"validatePath", (PyCFunction)xbmc_validatePath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getRegion", (PyCFunction)xbmc_getRegion, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSupportedMedia", (PyCFunction)xbmc_getSupportedMedia, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"skinHasImage", (PyCFunction)xbmc_skinHasImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"startServer", (PyCFunction)xbmc_startServer, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"audioSuspend", (PyCFunction)xbmc_audioSuspend, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"audioResume", (PyCFunction)xbmc_audioResume, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"convertLanguage", (PyCFunction)xbmc_convertLanguage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmc_Player_Type();
      initPyXBMCAddon_xbmc_RenderCapture_Type();
      initPyXBMCAddon_xbmc_InfoTagMusic_Type();
      initPyXBMCAddon_xbmc_InfoTagRadioRDS_Type();
      initPyXBMCAddon_xbmc_InfoTagVideo_Type();
      initPyXBMCAddon_xbmc_Keyboard_Type();
      initPyXBMCAddon_xbmc_PlayList_Type();
      initPyXBMCAddon_xbmc_Monitor_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Player_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_InfoTagRadioRDS_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmc()
  {
    initTypes();

    // init general xbmc modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmc_Player_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_InfoTagRadioRDS_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType));

    module = Py_InitModule((char*)"xbmc", xbmc_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"Player", (PyObject*)(&(TyXBMCAddon_xbmc_Player_Type.pythonType)));
    PyModule_AddObject(module, (char*)"RenderCapture", (PyObject*)(&(TyXBMCAddon_xbmc_RenderCapture_Type.pythonType)));
    PyModule_AddObject(module, (char*)"InfoTagMusic", (PyObject*)(&(TyXBMCAddon_xbmc_InfoTagMusic_Type.pythonType)));
    PyModule_AddObject(module, (char*)"InfoTagRadioRDS", (PyObject*)(&(TyXBMCAddon_xbmc_InfoTagRadioRDS_Type.pythonType)));
    PyModule_AddObject(module, (char*)"InfoTagVideo", (PyObject*)(&(TyXBMCAddon_xbmc_InfoTagVideo_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Keyboard", (PyObject*)(&(TyXBMCAddon_xbmc_Keyboard_Type.pythonType)));
    PyModule_AddObject(module, (char*)"PlayList", (PyObject*)(&(TyXBMCAddon_xbmc_PlayList_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Monitor", (PyObject*)(&(TyXBMCAddon_xbmc_Monitor_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team Kodi <http://kodi.tv>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Mon Apr 25 11:24:19 GMT 2016");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.24.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team Kodi");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"SERVER_WEBSERVER",getSERVER_WEBSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_AIRPLAYSERVER",getSERVER_AIRPLAYSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPSERVER",getSERVER_UPNPSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPRENDERER",getSERVER_UPNPRENDERER()); 
   PyModule_AddIntConstant(module,"SERVER_EVENTSERVER",getSERVER_EVENTSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_JSONRPCSERVER",getSERVER_JSONRPCSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_ZEROCONF",getSERVER_ZEROCONF()); 
   PyModule_AddIntConstant(module,"PLAYLIST_MUSIC",getPLAYLIST_MUSIC()); 
   PyModule_AddIntConstant(module,"PLAYLIST_VIDEO",getPLAYLIST_VIDEO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_AUTO",getPLAYER_CORE_AUTO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_DVDPLAYER",getPLAYER_CORE_DVDPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_MPLAYER",getPLAYER_CORE_MPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_PAPLAYER",getPLAYER_CORE_PAPLAYER()); 
   PyModule_AddIntConstant(module,"TRAY_OPEN",getTRAY_OPEN()); 
   PyModule_AddIntConstant(module,"DRIVE_NOT_READY",getDRIVE_NOT_READY()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_NO_MEDIA",getTRAY_CLOSED_NO_MEDIA()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_MEDIA_PRESENT",getTRAY_CLOSED_MEDIA_PRESENT()); 
   PyModule_AddIntConstant(module,"LOGDEBUG",getLOGDEBUG()); 
   PyModule_AddIntConstant(module,"LOGINFO",getLOGINFO()); 
   PyModule_AddIntConstant(module,"LOGNOTICE",getLOGNOTICE()); 
   PyModule_AddIntConstant(module,"LOGWARNING",getLOGWARNING()); 
   PyModule_AddIntConstant(module,"LOGERROR",getLOGERROR()); 
   PyModule_AddIntConstant(module,"LOGSEVERE",getLOGSEVERE()); 
   PyModule_AddIntConstant(module,"LOGFATAL",getLOGFATAL()); 
   PyModule_AddIntConstant(module,"LOGNONE",getLOGNONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_WORKING",getCAPTURE_STATE_WORKING()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_DONE",getCAPTURE_STATE_DONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_FAILED",getCAPTURE_STATE_FAILED()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_CONTINUOUS",getCAPTURE_FLAG_CONTINUOUS()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_IMMEDIATELY",getCAPTURE_FLAG_IMMEDIATELY()); 
   PyModule_AddIntConstant(module,"ISO_639_1",getISO_639_1()); 
   PyModule_AddIntConstant(module,"ISO_639_2",getISO_639_2()); 
   PyModule_AddIntConstant(module,"ENGLISH_NAME",getENGLISH_NAME()); 
  }

} // end PythonBindings namespace for python type definitions


