#pragma once
/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

namespace JSONRPC
{
  const char* const JSONRPC_SERVICE_ID          = "http://xbmc.org/jsonrpc/ServiceDescription.json";
  const char* const JSONRPC_SERVICE_VERSION     = "6.25.2";
  const char* const JSONRPC_SERVICE_DESCRIPTION = "JSON-RPC API of XBMC";

  const char* const JSONRPC_SERVICE_TYPES[] = {  
    "\"Optional.Boolean\": {"
      "\"type\": [ \"null\", \"boolean\" ],"
      "\"default\": null"
    "}",
    "\"Optional.String\": {"
      "\"type\": [ \"null\", \"string\" ],"
      "\"default\": null"
    "}",
    "\"Optional.Integer\": {"
      "\"type\": [ \"null\", \"integer\" ],"
      "\"default\": null"
    "}",
    "\"Optional.Number\": {"
      "\"type\": [ \"null\", \"number\" ],"
      "\"default\": null"
    "}",
    "\"Array.String\": {"
      "\"type\": \"array\","
      "\"items\": { \"type\": \"string\", \"minLength\": 1 }"
    "}",
    "\"Array.Integer\": {"
      "\"type\": \"array\","
      "\"items\": { \"type\": \"integer\" }"
    "}",
    "\"Global.Time\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"hours\": { \"type\": \"integer\", \"required\": true, \"minimum\": 0, \"maximum\": 23 },"
        "\"minutes\": { \"type\": \"integer\", \"required\": true, \"minimum\": 0, \"maximum\": 59 },"
        "\"seconds\": { \"type\": \"integer\", \"required\": true, \"minimum\": 0, \"maximum\": 59 },"
        "\"milliseconds\": { \"type\": \"integer\", \"required\": true, \"minimum\": 0, \"maximum\": 999 }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Global.Weekday\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"monday\", \"tuesday\", \"wednesday\", \"thursday\","
                "\"friday\", \"saturday\", \"sunday\" ]"
    "}",
    "\"Global.IncrementDecrement\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"increment\", \"decrement\" ]"
    "}",
    "\"Global.Toggle\": {"
      "\"type\": ["
        "{ \"type\": \"boolean\", \"required\": true },"
        "{ \"type\": \"string\", \"enum\": [ \"toggle\" ], \"required\": true }"
      "]"
    "}",
    "\"Global.String.NotEmpty\": {"
      "\"type\": \"string\","
      "\"minLength\": 1"
    "}",
    "\"Configuration.Notifications\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"Player\": { \"type\": \"boolean\", \"required\": true },"
        "\"Playlist\": { \"type\": \"boolean\", \"required\": true },"
        "\"GUI\": { \"type\": \"boolean\", \"required\": true },"
        "\"System\": { \"type\": \"boolean\", \"required\": true },"
        "\"VideoLibrary\": { \"type\": \"boolean\", \"required\": true },"
        "\"AudioLibrary\": { \"type\": \"boolean\", \"required\": true },"
        "\"Application\": { \"type\": \"boolean\", \"required\": true },"
        "\"Input\": { \"type\": \"boolean\", \"required\": true },"
        "\"PVR\": { \"type\": \"boolean\", \"required\": true },"
        "\"Other\": { \"type\": \"boolean\", \"required\": true }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Configuration\": {"
      "\"type\": \"object\", \"required\": true,"
      "\"properties\": {"
        "\"notifications\": { \"$ref\": \"Configuration.Notifications\", \"required\": true }"
      "}"
    "}",
    "\"Files.Media\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"video\", \"music\", \"pictures\", \"files\", \"programs\" ]"
    "}",
    "\"List.Amount\": {"
      "\"type\": \"integer\","
      "\"default\": -1,"
      "\"minimum\": 0"
    "}",
    "\"List.Limits\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"start\": { \"type\": \"integer\", \"minimum\": 0, \"default\": 0, \"description\": \"Index of the first item to return\" },"
        "\"end\": { \"$ref\": \"List.Amount\", \"description\": \"Index of the last item to return\" }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"List.LimitsReturned\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"start\": { \"type\": \"integer\", \"minimum\": 0, \"default\": 0 },"
        "\"end\": { \"$ref\": \"List.Amount\" },"
        "\"total\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"List.Sort\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"method\": { \"type\": \"string\", \"default\": \"none\","
          "\"enum\": [ \"none\", \"label\", \"date\", \"size\", \"file\", \"path\", \"drivetype\", \"title\", \"track\", \"time\", \"artist\","
                    "\"album\", \"albumtype\", \"genre\", \"country\", \"year\", \"rating\", \"votes\", \"top250\", \"programcount\","
                    "\"playlist\", \"episode\", \"season\", \"totalepisodes\", \"watchedepisodes\", \"tvshowstatus\", \"tvshowtitle\","
                    "\"sorttitle\", \"productioncode\", \"mpaa\", \"studio\", \"dateadded\", \"lastplayed\", \"playcount\", \"listeners\","
                    "\"bitrate\", \"random\" ]"
        "},"
        "\"order\": { \"type\": \"string\", \"default\": \"ascending\", \"enum\": [ \"ascending\", \"descending\" ] },"
        "\"ignorearticle\": { \"type\": \"boolean\", \"default\": false }"
      "}"
    "}",
    "\"Library.Id\": {"
      "\"type\": \"integer\","
      "\"default\": -1,"
      "\"minimum\": 1"
    "}",
    "\"PVR.Channel.Type\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"tv\", \"radio\" ]"
    "}",
    "\"Playlist.Id\": {"
      "\"type\": \"integer\","
      "\"minimum\": 0,"
      "\"maximum\": 2,"
      "\"default\": -1"
    "}",
    "\"Playlist.Type\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"unknown\", \"video\", \"audio\", \"picture\", \"mixed\" ]"
    "}",
    "\"Playlist.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"type\", \"size\" ]"
    "}",
    "\"Playlist.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"type\": { \"$ref\": \"Playlist.Type\" },"
        "\"size\": { \"type\": \"integer\", \"minimum\": 0 }"
      "}"
    "}",
    "\"Playlist.Position\": {"
      "\"type\": \"integer\","
      "\"minimum\": 0,"
      "\"default\": -1"
    "}",
    "\"Playlist.Item\": {"
      "\"type\": ["
        "{ \"type\": \"object\", \"properties\": { \"file\": { \"type\": \"string\", \"description\": \"Path to a file (not a directory) to be added to the playlist\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"directory\": { \"type\": \"string\", \"required\": true }, \"recursive\": { \"type\": \"boolean\", \"default\": false }, \"media\": { \"$ref\": \"Files.Media\", \"default\": \"files\" } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"movieid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"episodeid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"musicvideoid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"artistid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"albumid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"songid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
        "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true, \"description\": \"Identification of a genre from the AudioLibrary\" } }, \"additionalProperties\": false }"
      "]"
    "}",
    "\"Player.Id\": {"
      "\"type\": \"integer\","
      "\"minimum\": 0,"
      "\"maximum\": 2,"
      "\"default\": -1"
    "}",
    "\"Player.Type\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"video\", \"audio\", \"picture\" ]"
    "}",
    "\"Player.Position.Percentage\": {"
      "\"type\": \"number\","
      "\"minimum\": 0.0,"
      "\"maximum\": 100.0"
    "}",
    "\"Player.Position.Time\": {"
      "\"type\": \"object\","
      "\"additionalProperties\": false,"
      "\"properties\": {"
        "\"hours\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 23, \"default\": 0 },"
        "\"minutes\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 59, \"default\": 0 },"
        "\"seconds\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 59, \"default\": 0 },"
        "\"milliseconds\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 999, \"default\": 0 }"
      "}"
    "}",
    "\"Player.Speed\": {"
      "\"type\": \"object\","
      "\"required\": true,"
      "\"properties\": {"
        "\"speed\": { \"type\": \"integer\" }"
      "}"
    "}",
    "\"Player.Repeat\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"off\", \"one\", \"all\" ]"
    "}",
    "\"Player.Audio.Stream\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"index\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true },"
        "\"name\": { \"type\": \"string\", \"required\": true },"
        "\"language\": { \"type\": \"string\", \"required\": true },"
        "\"codec\": { \"type\": \"string\", \"required\": true },"
        "\"bitrate\": { \"type\": \"integer\", \"required\": true },"
        "\"channels\": { \"type\": \"integer\", \"required\": true }"
      "}"
    "}",
    "\"Player.Subtitle\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"index\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true },"
        "\"name\": { \"type\": \"string\", \"required\": true },"
        "\"language\": { \"type\": \"string\", \"required\": true }"
      "}"
    "}",
    "\"Player.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"type\", \"partymode\", \"speed\", \"time\", \"percentage\","
                "\"totaltime\", \"playlistid\", \"position\", \"repeat\", \"shuffled\","
                "\"canseek\", \"canchangespeed\", \"canmove\", \"canzoom\", \"canrotate\","
                "\"canshuffle\", \"canrepeat\", \"currentaudiostream\", \"audiostreams\","
                "\"subtitleenabled\", \"currentsubtitle\", \"subtitles\", \"live\" ]"
    "}",
    "\"Player.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"type\": { \"$ref\": \"Player.Type\" },"
        "\"partymode\": { \"type\": \"boolean\" },"
        "\"speed\": { \"type\": \"integer\" },"
        "\"time\": { \"$ref\": \"Global.Time\" },"
        "\"percentage\": { \"$ref\": \"Player.Position.Percentage\" },"
        "\"totaltime\": { \"$ref\": \"Global.Time\" },"
        "\"playlistid\": { \"$ref\": \"Playlist.Id\" },"
        "\"position\": { \"$ref\": \"Playlist.Position\" },"
        "\"repeat\": { \"$ref\": \"Player.Repeat\" },"
        "\"shuffled\": { \"type\": \"boolean\" },"
        "\"canseek\": { \"type\": \"boolean\" },"
        "\"canchangespeed\": { \"type\": \"boolean\" },"
        "\"canmove\": { \"type\": \"boolean\" },"
        "\"canzoom\": { \"type\": \"boolean\" },"
        "\"canrotate\": { \"type\": \"boolean\" },"
        "\"canshuffle\": { \"type\": \"boolean\" },"
        "\"canrepeat\": { \"type\": \"boolean\" },"
        "\"currentaudiostream\": { \"$ref\": \"Player.Audio.Stream\" },"
        "\"audiostreams\": { \"type\": \"array\", \"items\": { \"$ref\": \"Player.Audio.Stream\" } },"
        "\"subtitleenabled\": { \"type\": \"boolean\" },"
        "\"currentsubtitle\": { \"$ref\": \"Player.Subtitle\" },"
        "\"subtitles\": { \"type\": \"array\", \"items\": { \"$ref\": \"Player.Subtitle\" } },"
        "\"live\": { \"type\": \"boolean\" }"
      "}"
    "}",
    "\"Notifications.Item.Type\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"unknown\", \"movie\", \"episode\", \"musicvideo\", \"song\", \"picture\", \"channel\" ]"
    "}",
    "\"Notifications.Item\": {"
      "\"type\": ["
        "{ \"type\": \"object\", \"description\": \"An unknown item does not have any additional information.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"An item known to the database has an identification.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true  }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A movie item has a title and may have a release year.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"title\": { \"type\": \"string\", \"required\": true },"
            "\"year\": { \"type\": \"integer\" }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A tv episode has a title and may have an episode number, season number and the title of the show it belongs to.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"title\": { \"type\": \"string\", \"required\": true },"
            "\"episode\": { \"type\": \"integer\" },"
            "\"season\": { \"type\": \"integer\" },"
            "\"showtitle\": { \"type\": \"string\" }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A music video has a title and may have an album and an artist.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"title\": { \"type\": \"string\", \"required\": true },"
            "\"album\": { \"type\": \"string\" },"
            "\"artist\": { \"type\": \"string\" }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A song has a title and may have an album, an artist and a track number.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"title\": { \"type\": \"string\", \"required\": true },"
            "\"album\": { \"type\": \"string\" },"
            "\"artist\": { \"type\": \"string\" },"
            "\"track\": { \"type\": \"integer\" }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A picture has a file path.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"file\": { \"type\": \"string\", \"required\": true }"
          "}"
        "},"
        "{ \"type\": \"object\", \"description\": \"A PVR channel is either a radio or tv channel and has a title.\","
          "\"properties\": {"
            "\"type\": { \"$ref\": \"Notifications.Item.Type\", \"required\": true },"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true  },"
            "\"title\": { \"type\": \"string\", \"required\": true },"
            "\"channeltype\": { \"$ref\": \"PVR.Channel.Type\", \"required\": true }"
          "}"
        "}"
      "]"
    "}",
    "\"Player.Notifications.Player\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"playerid\": { \"$ref\": \"Player.Id\", \"required\": true },"
        "\"speed\": { \"type\": \"integer\" }"
      "}"
    "}",
    "\"Player.Notifications.Player.Seek\": {"
      "\"extends\": \"Player.Notifications.Player\","
      "\"properties\": {"
        "\"time\": { \"$ref\": \"Global.Time\" },"
        "\"seekoffset\": { \"$ref\": \"Global.Time\" }"
      "}"
    "}",
    "\"Player.Notifications.Data\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"item\": { \"$ref\": \"Notifications.Item\", \"required\": true },"
        "\"player\": { \"$ref\": \"Player.Notifications.Player\", \"required\": true }"
      "}"
    "}",
    "\"Item.Fields.Base\": {"
      "\"type\": \"array\","
      "\"uniqueItems\": true,"
      "\"items\": { \"type\": \"string\" }"
    "}",
    "\"Item.Details.Base\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"label\": { \"type\": \"string\", \"required\": true }"
      "}"
    "}",
    "\"Media.Details.Base\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"fanart\": { \"type\": \"string\" },"
        "\"thumbnail\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Media.Artwork\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"thumb\": { \"$ref\": \"Global.String.NotEmpty\" },"
        "\"poster\": { \"$ref\": \"Global.String.NotEmpty\" },"
        "\"banner\": { \"$ref\": \"Global.String.NotEmpty\" },"
        "\"fanart\": { \"$ref\": \"Global.String.NotEmpty\" }"
      "},"
      "\"additionalProperties\": { \"$ref\": \"Global.String.NotEmpty\" }"
    "}",
    "\"Media.Artwork.Set\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"thumb\": { \"type\": [ \"null\", { \"$ref\": \"Global.String.NotEmpty\", \"required\": true } ], \"default\": \"\" },"
        "\"poster\": { \"type\": [ \"null\", { \"$ref\": \"Global.String.NotEmpty\", \"required\": true } ], \"default\": \"\" },"
        "\"banner\": { \"type\": [ \"null\", { \"$ref\": \"Global.String.NotEmpty\", \"required\": true } ], \"default\": \"\" },"
        "\"fanart\": { \"type\": [ \"null\", { \"$ref\": \"Global.String.NotEmpty\", \"required\": true } ], \"default\": \"\" }"
      "},"
      "\"additionalProperties\": { \"type\": [ \"null\", { \"$ref\": \"Global.String.NotEmpty\", \"required\": true } ] }"
    "}",
    "\"Library.Fields.Genre\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\", \"enum\": [ \"title\", \"thumbnail\" ] }"
    "}",
    "\"Library.Details.Genre\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"genreid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"title\": { \"type\": \"string\" },"
        "\"thumbnail\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Audio.Fields.Artist\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"instrument\", \"style\", \"mood\", \"born\", \"formed\","
                  "\"description\", \"genre\", \"died\", \"disbanded\","
                  "\"yearsactive\", \"musicbrainzartistid\", \"fanart\","
                  "\"thumbnail\", \"compilationartist\" ]"
      "}"
    "}",
    "\"Audio.Fields.Album\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"description\": \"Requesting the genreid and/or artistid field will result in increased response times\","
        "\"enum\": [ \"title\", \"description\", \"artist\", \"genre\","
                  "\"theme\", \"mood\", \"style\", \"type\", \"albumlabel\","
                  "\"rating\", \"year\", \"musicbrainzalbumid\","
                  "\"musicbrainzalbumartistid\", \"fanart\", \"thumbnail\","
                  "\"playcount\", \"genreid\", \"artistid\", \"displayartist\","
                  "\"compilation\", \"releasetype\" ]"
      "}"
    "}",
    "\"Audio.Fields.Song\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"description\": \"Requesting the genreid, artistid and/or albumartistid field will result in increased response times\","
        "\"enum\": [ \"title\", \"artist\", \"albumartist\", \"genre\", \"year\","
                  "\"rating\", \"album\", \"track\", \"duration\", \"comment\","
                  "\"lyrics\", \"musicbrainztrackid\", \"musicbrainzartistid\","
                  "\"musicbrainzalbumid\", \"musicbrainzalbumartistid\","
                  "\"playcount\", \"fanart\", \"thumbnail\", \"file\", \"albumid\","
                  "\"lastplayed\", \"disc\", \"genreid\", \"artistid\", \"displayartist\","
                  "\"albumartistid\", \"albumreleasetype\" ]"
      "}"
    "}",
    "\"Audio.Album.ReleaseType\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"album\", \"single\" ],"
      "\"default\": \"album\""
    "}",
    "\"Audio.Details.Base\": {"
      "\"extends\": \"Media.Details.Base\","
      "\"properties\": {"
        "\"genre\": { \"$ref\": \"Array.String\" }"
      "}"
    "}",
    "\"Audio.Details.Media\": {"
      "\"extends\": \"Audio.Details.Base\","
      "\"properties\": {"
        "\"title\": { \"type\": \"string\" },"
        "\"artist\": { \"$ref\": \"Array.String\" },"
        "\"year\": { \"type\": \"integer\" },"
        "\"rating\": { \"type\": \"integer\" },"
        "\"musicbrainzalbumid\": { \"type\": \"string\" },"
        "\"musicbrainzalbumartistid\": { \"type\": \"string\" },"
        "\"genreid\": { \"$ref\": \"Array.Integer\" },"
        "\"artistid\": { \"$ref\": \"Array.Integer\" },"
        "\"displayartist\": { \"type\" : \"string\" }"
      "}"
    "}",
    "\"Audio.Details.Artist\": {"
      "\"extends\": \"Audio.Details.Base\","
      "\"properties\": {"
        "\"artistid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"artist\": { \"type\": \"string\", \"required\": true },"
        "\"instrument\": { \"$ref\": \"Array.String\" },"
        "\"style\": { \"$ref\": \"Array.String\" },"
        "\"mood\": { \"$ref\": \"Array.String\" },"
        "\"born\": { \"type\": \"string\" },"
        "\"formed\": { \"type\": \"string\" },"
        "\"description\": { \"type\": \"string\" },"
        "\"died\": { \"type\": \"string\" },"
        "\"disbanded\": { \"type\": \"string\" },"
        "\"yearsactive\": { \"$ref\": \"Array.String\" },"
        "\"compilationartist\": { \"type\": \"boolean\" },"
        "\"musicbrainzartistid\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Audio.Details.Album\": {"
      "\"extends\": \"Audio.Details.Media\","
      "\"properties\": {"
        "\"albumid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"description\": { \"type\": \"string\" },"
        "\"theme\": { \"$ref\": \"Array.String\" },"
        "\"mood\": { \"$ref\": \"Array.String\" },"
        "\"style\": { \"$ref\": \"Array.String\" },"
        "\"type\": { \"type\": \"string\" },"
        "\"albumlabel\": { \"type\": \"string\" },"
        "\"playcount\": { \"type\": \"integer\" },"
        "\"compilation\": { \"type\": \"boolean\" },"
        "\"releasetype\": { \"$ref\": \"Audio.Album.ReleaseType\" }"
      "}"
    "}",
    "\"Audio.Details.Song\": {"
      "\"extends\": \"Audio.Details.Media\","
      "\"properties\": {"
        "\"songid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"file\": { \"type\": \"string\" },"
        "\"albumartist\": { \"$ref\": \"Array.String\" },"
        "\"album\": { \"type\": \"string\" },"
        "\"track\": { \"type\": \"integer\" },"
        "\"duration\": { \"type\": \"integer\" },"
        "\"comment\": { \"type\": \"string\" },"
        "\"lyrics\": { \"type\": \"string\" },"
        "\"playcount\": { \"type\": \"integer\" },"
        "\"musicbrainztrackid\": { \"type\": \"string\" },"
        "\"musicbrainzartistid\": { \"type\": \"string\" },"
        "\"albumid\": { \"$ref\": \"Library.Id\" },"
        "\"lastplayed\": { \"type\": \"string\" },"
        "\"disc\": { \"type\": \"integer\" },"
        "\"albumartistid\": { \"$ref\": \"Array.Integer\" },"
        "\"albumreleasetype\": { \"$ref\": \"Audio.Album.ReleaseType\" }"
      "}"
    "}",
    "\"Video.Fields.Movie\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"description\": \"Requesting the cast, showlink and/or tag field will result in increased response times\","
        "\"enum\": [ \"title\", \"genre\", \"year\", \"rating\", \"director\", \"trailer\","
                  "\"tagline\", \"plot\", \"plotoutline\", \"originaltitle\", \"lastplayed\","
                  "\"playcount\", \"writer\", \"studio\", \"mpaa\", \"cast\", \"country\","
                  "\"imdbnumber\", \"runtime\", \"set\", \"showlink\", \"streamdetails\","
                  "\"top250\", \"votes\", \"fanart\", \"thumbnail\", \"file\", \"sorttitle\","
                  "\"resume\", \"setid\", \"dateadded\", \"tag\", \"art\" ]"
      "}"
    "}",
    "\"Video.Fields.MovieSet\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"playcount\", \"fanart\", \"thumbnail\", \"art\" ]"
      "}"
    "}",
    "\"Video.Fields.TVShow\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"description\": \"Requesting the cast field will result in increased response times\","
        "\"enum\": [ \"title\", \"genre\", \"year\", \"rating\", \"plot\","
                  "\"studio\", \"mpaa\", \"cast\", \"playcount\", \"episode\","
                  "\"imdbnumber\", \"premiered\", \"votes\", \"lastplayed\","
                  "\"fanart\", \"thumbnail\", \"file\", \"originaltitle\","
                  "\"sorttitle\", \"episodeguide\", \"season\", \"watchedepisodes\","
                  "\"dateadded\", \"tag\", \"art\" ]"
      "}"
    "}",
    "\"Video.Fields.Season\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"season\", \"showtitle\", \"playcount\", \"episode\", \"fanart\", \"thumbnail\", \"tvshowid\","
                  "\"watchedepisodes\", \"art\" ]"
      "}"
    "}",
    "\"Video.Fields.Episode\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"description\": \"Requesting the cast field will result in increased response times\","
        "\"enum\": [ \"title\", \"plot\", \"votes\", \"rating\", \"writer\","
                  "\"firstaired\", \"playcount\", \"runtime\", \"director\","
                  "\"productioncode\", \"season\", \"episode\", \"originaltitle\","
                  "\"showtitle\", \"cast\", \"streamdetails\", \"lastplayed\", \"fanart\","
                  "\"thumbnail\", \"file\", \"resume\", \"tvshowid\", \"dateadded\","
                  "\"uniqueid\", \"art\", \"specialsortseason\", \"specialsortepisode\" ]"
      "}"
    "}",
    "\"Video.Fields.MusicVideo\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"playcount\", \"runtime\", \"director\","
                  "\"studio\", \"year\", \"plot\", \"album\", \"artist\","
                  "\"genre\", \"track\", \"streamdetails\", \"lastplayed\","
                  "\"fanart\", \"thumbnail\", \"file\", \"resume\", \"dateadded\","
                  "\"tag\", \"art\" ]"
      "}"
    "}",
    "\"Video.Cast\": {"
      "\"type\": \"array\","
      "\"items\": { \"type\": \"object\","
        "\"properties\": {"
          "\"name\": { \"type\": \"string\", \"required\": true },"
          "\"role\": { \"type\": \"string\", \"required\": true },"
          "\"order\": { \"type\": \"integer\", \"required\": true },"
          "\"thumbnail\": { \"type\": \"string\" }"
        "},"
        "\"additionalProperties\": false"
      "}"
    "}",
    "\"Video.Streams\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"audio\": { \"type\": \"array\", \"minItems\": 1,"
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"codec\": { \"type\": \"string\" },"
              "\"language\": { \"type\": \"string\" },"
              "\"channels\": { \"type\": \"integer\" }"
            "},"
            "\"additionalProperties\": false"
          "}"
        "},"
        "\"video\": { \"type\": \"array\", \"minItems\": 1,"
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"codec\": { \"type\": \"string\" },"
              "\"aspect\": { \"type\": \"number\" },"
              "\"width\": { \"type\": \"integer\" },"
              "\"height\": { \"type\": \"integer\" },"
              "\"duration\": { \"type\": \"integer\" }"
            "},"
            "\"additionalProperties\": false"
          "}"
        "},"
        "\"subtitle\": { \"type\": \"array\", \"minItems\": 1,"
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"language\": { \"type\": \"string\" }"
            "},"
            "\"additionalProperties\": false"
          "}"
        "}"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Video.Resume\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"position\": { \"type\": \"number\", \"minimum\": 0 },"
        "\"total\": { \"type\": \"number\", \"minimum\": 0 }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Video.Details.Base\": {"
      "\"extends\": \"Media.Details.Base\","
      "\"properties\": {"
        "\"playcount\": { \"type\": \"integer\" },"
        "\"art\": { \"$ref\": \"Media.Artwork\" }"
      "}"
    "}",
    "\"Video.Details.Media\": {"
      "\"extends\": \"Video.Details.Base\","
      "\"properties\": {"
        "\"title\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Video.Details.Item\": {"
      "\"extends\": \"Video.Details.Media\","
      "\"properties\": {"
        "\"file\": { \"type\": \"string\" },"
        "\"plot\": { \"type\": \"string\" },"
        "\"lastplayed\": { \"type\": \"string\" },"
        "\"dateadded\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Video.Details.File\": {"
      "\"extends\": \"Video.Details.Item\","
      "\"properties\": {"
        "\"runtime\": { \"type\": \"integer\", \"description\": \"Runtime in seconds\" },"
        "\"director\": { \"$ref\": \"Array.String\" },"
        "\"streamdetails\": { \"$ref\": \"Video.Streams\" },"
        "\"resume\": { \"$ref\": \"Video.Resume\" }"
      "}"
    "}",
    "\"Video.Details.Movie\": {"
      "\"extends\": \"Video.Details.File\","
      "\"properties\": {"
        "\"movieid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"genre\": { \"$ref\": \"Array.String\" },"
        "\"year\": { \"type\": \"integer\" },"
        "\"rating\": { \"type\": \"number\" },"
        "\"trailer\": { \"type\": \"string\" },"
        "\"tagline\": { \"type\": \"string\" },"
        "\"plotoutline\": { \"type\": \"string\" },"
        "\"originaltitle\": { \"type\": \"string\" },"
        "\"sorttitle\": { \"type\": \"string\" },"
        "\"writer\": { \"$ref\": \"Array.String\" },"
        "\"studio\": { \"$ref\": \"Array.String\" },"
        "\"mpaa\": { \"type\": \"string\" },"
        "\"cast\": { \"$ref\": \"Video.Cast\" },"
        "\"country\": { \"$ref\": \"Array.String\" },"
        "\"imdbnumber\": { \"type\": \"string\" },"
        "\"set\": { \"type\": \"string\" },"
        "\"showlink\": { \"$ref\": \"Array.String\" },"
        "\"top250\": { \"type\": \"integer\" },"
        "\"votes\": { \"type\": \"string\" },"
        "\"setid\": { \"$ref\": \"Library.Id\" },"
        "\"tag\": { \"$ref\": \"Array.String\" }"
      "}"
    "}",
    "\"Video.Details.MovieSet\": {"
      "\"extends\": \"Video.Details.Media\","
      "\"properties\": {"
        "\"setid\": { \"$ref\": \"Library.Id\", \"required\": true }"
      "}"
    "}",
    "\"Video.Details.MovieSet.Extended\": {"
      "\"extends\": \"Video.Details.MovieSet\","
      "\"properties\": {"
        "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
        "\"movies\": { \"type\": \"array\","
          "\"items\": { \"$ref\": \"Video.Details.Movie\" }"
        "}"
      "}"
    "}",
    "\"Video.Details.TVShow\": {"
      "\"extends\": \"Video.Details.Item\","
      "\"properties\": {"
        "\"tvshowid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"genre\": { \"$ref\": \"Array.String\" },"
        "\"year\": { \"type\": \"integer\" },"
        "\"rating\": { \"type\": \"number\" },"
        "\"originaltitle\": { \"type\": \"string\" },"
        "\"sorttitle\": { \"type\": \"string\" },"
        "\"studio\": { \"$ref\": \"Array.String\" },"
        "\"mpaa\": { \"type\": \"string\" },"
        "\"cast\": { \"$ref\": \"Video.Cast\" },"
        "\"episode\": { \"type\": \"integer\" },"
        "\"watchedepisodes\": { \"type\": \"integer\" },"
        "\"imdbnumber\": { \"type\": \"string\" },"
        "\"premiered\": { \"type\": \"string\" },"
        "\"votes\": { \"type\": \"string\" },"
        "\"episodeguide\": { \"type\": \"string\" },"
        "\"season\": { \"type\": \"integer\" },"
        "\"tag\": { \"$ref\": \"Array.String\" }"
      "}"
    "}",
    "\"Video.Details.Season\": {"
      "\"extends\": \"Video.Details.Base\","
      "\"properties\": {"
        "\"seasonid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"season\": { \"type\": \"integer\", \"required\": true },"
        "\"showtitle\": { \"type\": \"string\" },"
        "\"episode\": { \"type\": \"integer\" },"
        "\"watchedepisodes\": { \"type\": \"integer\" },"
        "\"tvshowid\": { \"$ref\": \"Library.Id\" }"
      "}"
    "}",
    "\"Video.Details.Episode\": {"
      "\"extends\": \"Video.Details.File\","
      "\"properties\": {"
        "\"episodeid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"votes\": { \"type\": \"string\" },"
        "\"rating\": { \"type\": \"number\" },"
        "\"writer\": { \"$ref\": \"Array.String\" },"
        "\"firstaired\": { \"type\": \"string\" },"
        "\"productioncode\": { \"type\": \"string\" },"
        "\"season\": { \"type\": \"integer\" },"
        "\"episode\": { \"type\": \"integer\" },"
        "\"uniqueid\": { \"type\": \"object\", \"additionalProperties\": { \"type\": \"string\", \"minLength\": 1 } },"
        "\"originaltitle\": { \"type\": \"string\" },"
        "\"showtitle\": { \"type\": \"string\" },"
        "\"cast\": { \"$ref\": \"Video.Cast\" },"
        "\"tvshowid\": { \"$ref\": \"Library.Id\" },"
        "\"specialsortseason\": { \"type\": \"integer\" },"
        "\"specialsortepisode\": { \"type\": \"integer\" }"
      "}"
    "}",
    "\"Video.Details.MusicVideo\": {"
      "\"extends\": \"Video.Details.File\","
      "\"properties\": {"
        "\"musicvideoid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"studio\": { \"$ref\": \"Array.String\" },"
        "\"year\": { \"type\": \"integer\" },"
        "\"album\": { \"type\": \"string\" },"
        "\"artist\": { \"$ref\": \"Array.String\" },"
        "\"genre\": { \"$ref\": \"Array.String\" },"
        "\"track\": { \"type\": \"integer\" },"
        "\"tag\": { \"$ref\": \"Array.String\" }"
      "}"
    "}",
    "\"PVR.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"available\", \"recording\", \"scanning\" ]"
    "}",
    "\"PVR.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"available\": { \"type\": \"boolean\" },"
        "\"recording\": { \"type\": \"boolean\" },"
        "\"scanning\": { \"type\": \"boolean\" }"
      "}"
    "}",
    "\"PVR.ChannelGroup.Id\": {"
      "\"type\": ["
        "{ \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"type\": \"string\", \"enum\": [ \"alltv\", \"allradio\" ], \"required\": true }"
      "]"
    "}",
    "\"PVR.Fields.Channel\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"thumbnail\", \"channeltype\", \"hidden\", \"locked\", \"channel\", \"lastplayed\", \"broadcastnow\", \"broadcastnext\" ]"
      "}"
    "}",
    "\"PVR.Details.Channel\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"channelid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"channel\": { \"type\": \"string\" },"
        "\"channeltype\": { \"$ref\": \"PVR.Channel.Type\" },"
        "\"hidden\": { \"type\": \"boolean\" },"
        "\"locked\": { \"type\": \"boolean\" },"
        "\"thumbnail\": { \"type\": \"string\" },"
        "\"lastplayed\": { \"type\": \"string\" },"
        "\"broadcastnow\": { \"$ref\": \"PVR.Details.Broadcast\" },"
        "\"broadcastnext\": { \"$ref\": \"PVR.Details.Broadcast\" }"
      "}"
    "}",
    "\"PVR.Details.ChannelGroup\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"channelgroupid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"channeltype\": { \"$ref\": \"PVR.Channel.Type\", \"required\": true }"
      "}"
    "}",
    "\"PVR.Details.ChannelGroup.Extended\": {"
      "\"extends\": \"PVR.Details.ChannelGroup\","
      "\"properties\": {"
        "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
        "\"channels\": { \"type\": \"array\","
          "\"items\": { \"$ref\": \"PVR.Details.Channel\" }"
        "}"
      "}"
    "}",
    "\"PVR.Fields.Broadcast\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"plot\", \"plotoutline\", \"starttime\","
                  "\"endtime\", \"runtime\", \"progress\", \"progresspercentage\","
                  "\"genre\", \"episodename\", \"episodenum\", \"episodepart\","
                  "\"firstaired\", \"hastimer\", \"isactive\", \"parentalrating\","
                  "\"wasactive\", \"thumbnail\", \"rating\" ]"
      "}"
    "}",
    "\"PVR.Details.Broadcast\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"broadcastid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"title\": { \"type\": \"string\" },"
        "\"plot\": { \"type\": \"string\" },"
        "\"plotoutline\": { \"type\": \"string\" },"
        "\"starttime\": { \"type\": \"string\" },"
        "\"endtime\": { \"type\": \"string\" },"
        "\"runtime\": { \"type\": \"integer\" },"
        "\"progress\": { \"type\": \"integer\" },"
        "\"progresspercentage\": { \"type\": \"number\" },"
        "\"genre\": { \"type\": \"string\" },"
        "\"episodename\": { \"type\": \"string\" },"
        "\"episodenum\": { \"type\": \"integer\" },"
        "\"episodepart\": { \"type\": \"integer\" },"
        "\"firstaired\": { \"type\": \"string\" },"
        "\"hastimer\": { \"type\": \"boolean\" },"
        "\"isactive\": { \"type\": \"boolean\" },"
        "\"parentalrating\": { \"type\": \"integer\" },"
        "\"wasactive\": { \"type\": \"boolean\" },"
        "\"thumbnail\": { \"type\": \"string\" },"
        "\"rating\": { \"type\": \"integer\" }"
      "}"
    "}",
    "\"PVR.TimerState\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"unknown\", \"new\", \"scheduled\", \"recording\", \"completed\","
                "\"aborted\", \"cancelled\", \"conflict_ok\", \"conflict_notok\","
                "\"error\" ]"
    "}",
    "\"PVR.Fields.Timer\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"summary\", \"channelid\", \"isradio\", \"repeating\","
                  "\"starttime\", \"endtime\", \"runtime\", \"lifetime\", \"firstday\","
                  "\"weekdays\", \"priority\", \"startmargin\", \"endmargin\", \"state\","
                  "\"file\", \"directory\" ]"
      "}"
    "}",
    "\"PVR.Details.Timer\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"timerid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"title\": { \"type\": \"string\" },"
        "\"summary\": { \"type\": \"string\" },"
        "\"channelid\": { \"$ref\": \"Library.Id\" },"
        "\"isradio\": { \"type\": \"boolean\" },"
        "\"repeating\": { \"type\": \"boolean\" },"
        "\"starttime\": { \"type\": \"string\" },"
        "\"endtime\": { \"type\": \"string\" },"
        "\"runtime\": { \"type\": \"integer\" },"
        "\"lifetime\": { \"type\": \"integer\" },"
        "\"firstday\": { \"type\": \"string\" },"
        "\"weekdays\": { \"type\": \"array\","
          "\"items\": { \"$ref\": \"Global.Weekday\" },"
          "\"uniqueItems\": true"
        "},"
        "\"priority\": { \"type\": \"integer\" },"
        "\"startmargin\": { \"type\": \"integer\" },"
        "\"endmargin\": { \"type\": \"integer\" },"
        "\"state\": { \"$ref\": \"PVR.TimerState\" },"
        "\"file\": { \"type\": \"string\" },"
        "\"directory\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"PVR.Fields.Recording\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"plot\", \"plotoutline\", \"genre\", \"playcount\","
                  "\"resume\", \"channel\", \"starttime\",\"endtime\", \"runtime\","
                  "\"lifetime\", \"icon\", \"art\", \"streamurl\", \"file\","
                  "\"directory\" ]"
      "}"
    "}",
    "\"PVR.Details.Recording\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"recordingid\": { \"$ref\": \"Library.Id\", \"required\": true },"
        "\"title\": { \"type\": \"string\" },"
        "\"plot\": { \"type\": \"string\" },"
        "\"plotoutline\": { \"type\": \"string\" },"
        "\"genre\": { \"type\": \"string\" },"
        "\"playcount\": { \"type\": \"integer\" },"
        "\"resume\": { \"$ref\": \"Video.Resume\" },"
        "\"channel\": { \"type\": \"string\" },"
        "\"starttime\": { \"type\": \"string\" },"
        "\"endtime\": { \"type\": \"string\" },"
        "\"runtime\": { \"type\": \"integer\" },"
        "\"lifetime\": { \"type\": \"integer\" },"
        "\"icon\": { \"type\": \"string\" },"
        "\"art\": { \"$ref\": \"Media.Artwork\" },"
        "\"streamurl\": { \"type\": \"string\" },"
        "\"file\": { \"type\": \"string\" },"
        "\"directory\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Textures.Details.Size\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"size\": { \"type\": \"integer\", \"description\": \"Size of the texture (1 == largest)\" },"
        "\"width\": { \"type\": \"integer\", \"description\": \"Width of texture\" },"
        "\"height\": { \"type\": \"integer\", \"description\": \"Height of texture\" },"
        "\"usecount\": { \"type\": \"integer\", \"description\": \"Number of uses\" },"
        "\"lastused\": { \"type\": \"string\", \"description\": \"Date of last use\" }"
      "}"
    "}",
    "\"Textures.Fields.Texture\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"url\", \"cachedurl\", \"lasthashcheck\", \"imagehash\", \"sizes\" ]"
      "}"
    "}",
    "\"Textures.Details.Texture\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"textureid\": { \"$ref\": \"Library.Id\", \"required\": \"true\" },"
        "\"url\": { \"type\": \"string\", \"description\": \"Original source URL\" },"
        "\"cachedurl\": { \"type\": \"string\", \"description\": \"Cached URL on disk\" },"
        "\"lasthashcheck\": { \"type\": \"string\", \"description\": \"Last time source was checked for changes\" },"
        "\"imagehash\": { \"type\": \"string\", \"description\": \"Hash of image\" },"
        "\"sizes\": { \"type\": \"array\", \"items\": { \"$ref\": \"Textures.Details.Size\" } }"
      "}"
    "}",
    "\"Profiles.Password\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"value\": { \"type\": \"string\", \"required\": true, \"description\": \"Password\" },"
        "\"encryption\": { \"type\": \"string\", \"description\": \"Password Encryption\", \"default\": \"md5\", \"enum\": [ \"none\", \"md5\" ] }"
      "}"
    "}",
    "\"Profiles.Fields.Profile\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\", \"enum\": [ \"thumbnail\", \"lockmode\" ] }"
    "}",
    "\"Profiles.Details.Profile\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"thumbnail\": { \"type\": \"string\" },"
        "\"lockmode\": { \"type\": \"integer\" }"
      "}"
    "}",
    "\"List.Filter.Rule\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"operator\": { \"$ref\": \"List.Filter.Operators\", \"required\": true },"
        "\"value\": {"
          "\"type\": ["
            "{ \"type\": \"string\", \"required\": true },"
            "{ \"type\": \"array\", \"items\": { \"type\": \"string\" }, \"required\": true }"
          "], \"required\": true"
        "}"
      "}"
    "}",
    "\"List.Filter.Rule.Movies\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Movies\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.TVShows\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.TVShows\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.Episodes\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Episodes\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.MusicVideos\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.MusicVideos\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.Artists\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Artists\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.Albums\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Albums\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.Songs\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Songs\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Rule.Textures\": {"
      "\"extends\": \"List.Filter.Rule\","
      "\"properties\": {"
        "\"field\": { \"$ref\": \"List.Filter.Fields.Textures\", \"required\": true }"
      "}"
    "}",
    "\"List.Filter.Movies\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Movies\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Movies\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Movies\" }"
      "]"
    "}",
    "\"List.Filter.TVShows\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.TVShows\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.TVShows\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.TVShows\" }"
      "]"
    "}",
    "\"List.Filter.Episodes\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Episodes\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Episodes\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Episodes\" }"
      "]"
    "}",
    "\"List.Filter.MusicVideos\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.MusicVideos\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.MusicVideos\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.MusicVideos\" }"
      "]"
    "}",
    "\"List.Filter.Artists\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Artists\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Artists\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Artists\" }"
      "]"
    "}",
    "\"List.Filter.Albums\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Albums\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Albums\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Albums\" }"
      "]"
    "}",
    "\"List.Filter.Songs\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Songs\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Songs\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Songs\" }"
      "]"
    "}",
    "\"List.Filter.Textures\": {"
      "\"type\": ["
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"and\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Textures\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"type\": \"object\","
          "\"properties\": {"
            "\"or\": { \"type\": \"array\","
              "\"items\": { \"$ref\": \"List.Filter.Textures\" },"
              "\"minItems\": 1, \"required\": true"
            "}"
          "}"
        "},"
        "{ \"$ref\": \"List.Filter.Rule.Textures\" }"
      "]"
    "}",
    "\"List.Item.Base\": {"
      "\"extends\": [ \"Video.Details.File\", \"Audio.Details.Media\" ],"
      "\"properties\": {"
        "\"id\": { \"$ref\": \"Library.Id\" },"
        "\"type\": { \"type\": \"string\", \"enum\": [ \"unknown\", \"movie\", \"episode\", \"musicvideo\", \"song\", \"picture\", \"channel\" ] },"
        "\"albumartist\": { \"$ref\": \"Array.String\" },"
        "\"album\": { \"type\": \"string\" },"
        "\"track\": { \"type\": \"integer\" },"
        "\"duration\": { \"type\": \"integer\" },"
        "\"comment\": { \"type\": \"string\" },"
        "\"lyrics\": { \"type\": \"string\" },"
        "\"musicbrainztrackid\": { \"type\": \"string\" },"
        "\"musicbrainzartistid\": { \"type\": \"string\" },"
        "\"trailer\": { \"type\": \"string\" },"
        "\"tagline\": { \"type\": \"string\" },"
        "\"plotoutline\": { \"type\": \"string\" },"
        "\"originaltitle\": { \"type\": \"string\" },"
        "\"writer\": { \"$ref\": \"Array.String\" },"
        "\"studio\": { \"$ref\": \"Array.String\" },"
        "\"mpaa\": { \"type\": \"string\" },"
        "\"cast\": { \"$ref\": \"Video.Cast\" },"
        "\"country\": { \"$ref\": \"Array.String\" },"
        "\"imdbnumber\": { \"type\": \"string\" },"
        "\"premiered\": { \"type\": \"string\" },"
        "\"productioncode\": { \"type\": \"string\" },"
        "\"set\": { \"type\": \"string\" },"
        "\"showlink\": { \"$ref\": \"Array.String\" },"
        "\"top250\": { \"type\": \"integer\" },"
        "\"votes\": { \"type\": \"string\" },"
        "\"firstaired\": { \"type\": \"string\" },"
        "\"season\": { \"type\": \"integer\" },"
        "\"episode\": { \"type\": \"integer\" },"
        "\"showtitle\": { \"type\": \"string\" },"
        "\"albumid\": { \"$ref\": \"Library.Id\" },"
        "\"setid\": { \"$ref\": \"Library.Id\" },"
        "\"tvshowid\": { \"$ref\": \"Library.Id\" },"
        "\"watchedepisodes\": { \"type\": \"integer\" },"
        "\"disc\": { \"type\": \"integer\" },"
        "\"tag\": { \"$ref\": \"Array.String\" },"
        "\"albumartistid\": { \"$ref\": \"Array.Integer\" },"
        "\"uniqueid\": { \"type\": \"object\", \"additionalProperties\": { \"type\": \"string\", \"minLength\": 1 } },"
        "\"episodeguide\": { \"type\": \"string\" },"
        "\"sorttitle\": { \"type\": \"string\" },"
        "\"description\": { \"type\": \"string\" },"
        "\"theme\": { \"$ref\": \"Array.String\" },"
        "\"mood\": { \"$ref\": \"Array.String\" },"
        "\"style\": { \"$ref\": \"Array.String\" },"
        "\"albumlabel\": { \"type\": \"string\" },"
        "\"specialsortseason\": { \"type\": \"integer\" },"
        "\"specialsortepisode\": { \"type\": \"integer\" },"
        "\"compilation\": { \"type\": \"boolean\" },"
        "\"releasetype\": { \"$ref\": \"Audio.Album.ReleaseType\" },"
        "\"albumreleasetype\": { \"$ref\": \"Audio.Album.ReleaseType\" }"
      "}"
    "}",
    "\"List.Fields.All\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"artist\", \"albumartist\", \"genre\", \"year\", \"rating\","
                  "\"album\", \"track\", \"duration\", \"comment\", \"lyrics\", \"musicbrainztrackid\","
                  "\"musicbrainzartistid\", \"musicbrainzalbumid\", \"musicbrainzalbumartistid\","
                  "\"playcount\", \"fanart\", \"director\", \"trailer\", \"tagline\", \"plot\","
                  "\"plotoutline\", \"originaltitle\", \"lastplayed\", \"writer\", \"studio\","
                  "\"mpaa\", \"cast\", \"country\", \"imdbnumber\", \"premiered\", \"productioncode\","
                  "\"runtime\", \"set\", \"showlink\", \"streamdetails\", \"top250\", \"votes\","
                  "\"firstaired\", \"season\", \"episode\", \"showtitle\", \"thumbnail\", \"file\","
                  "\"resume\", \"artistid\", \"albumid\", \"tvshowid\", \"setid\", \"watchedepisodes\","
                  "\"disc\", \"tag\", \"art\", \"genreid\", \"displayartist\", \"albumartistid\","
                  "\"description\", \"theme\", \"mood\", \"style\", \"albumlabel\", \"sorttitle\","
                  "\"episodeguide\", \"uniqueid\", \"dateadded\", \"channel\", \"channeltype\", \"hidden\","
                  "\"locked\", \"channelnumber\", \"starttime\", \"endtime\", \"specialsortseason\","
                  "\"specialsortepisode\", \"compilation\", \"releasetype\", \"albumreleasetype\" ]"
      "}"
    "}",
    "\"List.Item.All\": {"
      "\"extends\": \"List.Item.Base\","
      "\"properties\": {"
        "\"channel\": { \"type\": \"string\" },"
        "\"channeltype\": { \"$ref\": \"PVR.Channel.Type\" },"
        "\"hidden\": { \"type\": \"boolean\" },"
        "\"locked\": { \"type\": \"boolean\" },"
        "\"channelnumber\": { \"type\": \"integer\" },"
        "\"starttime\": { \"type\": \"string\" },"
        "\"endtime\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"List.Fields.Files\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"title\", \"artist\", \"albumartist\", \"genre\", \"year\", \"rating\","
                  "\"album\", \"track\", \"duration\", \"comment\", \"lyrics\", \"musicbrainztrackid\","
                  "\"musicbrainzartistid\", \"musicbrainzalbumid\", \"musicbrainzalbumartistid\","
                  "\"playcount\", \"fanart\", \"director\", \"trailer\", \"tagline\", \"plot\","
                  "\"plotoutline\", \"originaltitle\", \"lastplayed\", \"writer\", \"studio\","
                  "\"mpaa\", \"cast\", \"country\", \"imdbnumber\", \"premiered\", \"productioncode\","
                  "\"runtime\", \"set\", \"showlink\", \"streamdetails\", \"top250\", \"votes\","
                  "\"firstaired\", \"season\", \"episode\", \"showtitle\", \"thumbnail\", \"file\","
                  "\"resume\", \"artistid\", \"albumid\", \"tvshowid\", \"setid\", \"watchedepisodes\","
                  "\"disc\", \"tag\", \"art\", \"genreid\", \"displayartist\", \"albumartistid\","
                  "\"description\", \"theme\", \"mood\", \"style\", \"albumlabel\", \"sorttitle\","
                  "\"episodeguide\", \"uniqueid\", \"dateadded\", \"size\", \"lastmodified\", \"mimetype\","
                  "\"specialsortseason\", \"specialsortepisode\" ]"
      "}"
    "}",
    "\"List.Item.File\": {"
      "\"extends\": \"List.Item.Base\","
      "\"properties\": {"
        "\"file\": { \"type\": \"string\", \"required\": true },"
        "\"filetype\": { \"type\": \"string\", \"enum\": [ \"file\", \"directory\" ], \"required\": true },"
        "\"size\": { \"type\": \"integer\", \"description\": \"Size of the file in bytes\" },"
        "\"lastmodified\": { \"type\": \"string\" },"
        "\"mimetype\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"List.Items.Sources\": {"
      "\"type\": \"array\","
      "\"items\": {"
        "\"extends\": \"Item.Details.Base\","
        "\"properties\": {"
          "\"file\": { \"type\": \"string\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"Addon.Content\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"unknown\", \"video\", \"audio\", \"image\", \"executable\" ],"
      "\"default\": \"unknown\""
    "}",
    "\"Addon.Fields\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"name\", \"version\", \"summary\", \"description\", \"path\", \"author\", \"thumbnail\", \"disclaimer\", \"fanart\","
                  "\"dependencies\", \"broken\", \"extrainfo\", \"rating\", \"enabled\" ]"
      "}"
    "}",
    "\"Addon.Details\": {"
      "\"extends\": \"Item.Details.Base\","
      "\"properties\": {"
        "\"addonid\": { \"type\": \"string\", \"required\": true },"
        "\"type\": { \"$ref\": \"Addon.Types\", \"required\": true },"
        "\"name\": { \"type\": \"string\" },"
        "\"version\": { \"type\": \"string\" },"
        "\"summary\": { \"type\": \"string\" },"
        "\"description\": { \"type\": \"string\" },"
        "\"path\": { \"type\": \"string\" },"
        "\"author\": { \"type\": \"string\" },"
        "\"thumbnail\": { \"type\": \"string\" },"
        "\"disclaimer\": { \"type\": \"string\" },"
        "\"fanart\": { \"type\": \"string\" },"
        "\"dependencies\": { \"type\": \"array\","
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"addonid\": { \"type\": \"string\", \"required\": true },"
              "\"version\": { \"type\": \"string\", \"required\": true },"
              "\"optional\": { \"type\": \"boolean\", \"required\": true }"
            "}"
          "}"
        "},"
        "\"broken\": { \"type\": [ \"boolean\", \"string\" ] },"
        "\"extrainfo\": { \"type\": \"array\","
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"key\": { \"type\": \"string\", \"required\": true },"
              "\"value\": { \"type\": \"string\", \"required\": true }"
            "}"
          "}"
        "},"
        "\"rating\": { \"type\": \"integer\" },"
        "\"enabled\": { \"type\": \"boolean\" }"
      "}"
    "}",
    "\"GUI.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"currentwindow\", \"currentcontrol\", \"skin\", \"fullscreen\", \"stereoscopicmode\" ]"
    "}",
    "\"GUI.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"currentwindow\": { \"type\": \"object\","
          "\"properties\": {"
            "\"id\": { \"type\": \"integer\", \"required\": true },"
            "\"label\": { \"type\": \"string\", \"required\": true }"
          "}"
        "},"
        "\"currentcontrol\": { \"type\": \"object\","
          "\"properties\": {"
            "\"label\": { \"type\": \"string\", \"required\": true }"
          "}"
        "},"
        "\"skin\": { \"type\": \"object\","
          "\"properties\": {"
            "\"id\": { \"type\": \"string\", \"required\": true, \"minLength\": 1 },"
            "\"name\": { \"type\": \"string\" }"
          "}"
        "},"
        "\"fullscreen\": { \"type\": \"boolean\" },"
        "\"stereoscopicmode\": { \"$ref\": \"GUI.Stereoscopy.Mode\" }"
      "}"
    "}",
    "\"GUI.Stereoscopy.Mode\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"mode\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"off\", \"split_vertical\", \"split_horizontal\", \"row_interleaved\", \"hardware_based\", \"anaglyph_cyan_red\", \"anaglyph_green_magenta\", \"anaglyph_yellow_blue\", \"monoscopic\" ] },"
        "\"label\": { \"type\": \"string\", \"required\": true }"
      "}"
    "}",
    "\"System.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"canshutdown\", \"cansuspend\", \"canhibernate\", \"canreboot\" ]"
    "}",
    "\"System.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"canshutdown\": { \"type\": \"boolean\" },"
        "\"cansuspend\": { \"type\": \"boolean\" },"
        "\"canhibernate\": { \"type\": \"boolean\" },"
        "\"canreboot\": { \"type\": \"boolean\" }"
      "}"
    "}",
    "\"Application.Property.Name\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"volume\", \"muted\", \"name\", \"version\" ]"
    "}",
    "\"Application.Property.Value\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"volume\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 100 },"
        "\"muted\": { \"type\": \"boolean\" },"
        "\"name\": { \"type\": \"string\", \"minLength\": 1 },"
        "\"version\": { \"type\": \"object\","
          "\"properties\": {"
            "\"major\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true },"
            "\"minor\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true },"
            "\"revision\": { \"type\": [ \"string\", \"integer\" ] },"
            "\"tag\": { \"type\": \"string\", \"enum\": [ \"prealpha\", \"alpha\", \"beta\", \"releasecandidate\", \"stable\" ], \"required\": true },"
            "\"tagversion\": { \"type\": \"string\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Favourite.Fields.Favourite\": {"
      "\"extends\": \"Item.Fields.Base\","
      "\"items\": { \"type\": \"string\","
        "\"enum\": [ \"window\", \"windowparameter\", \"thumbnail\", \"path\" ]"
      "}"
    "}",
    "\"Favourite.Type\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"media\", \"window\", \"script\", \"unknown\" ]"
    "}",
    "\"Favourite.Details.Favourite\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"title\": { \"type\": \"string\", \"required\": true },"
        "\"type\": { \"$ref\": \"Favourite.Type\", \"required\": true },"
        "\"path\": { \"type\": \"string\" },"
        "\"window\": { \"type\": \"string\" },"
        "\"windowparameter\": { \"type\": \"string\" },"
        "\"thumbnail\": { \"type\": \"string\" }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Type\": {"
      "\"type\": \"string\","
      "\"enum\": ["
        "\"boolean\", \"integer\", \"number\", \"string\", \"action\", \"list\","
        "\"path\", \"addon\""
      "]"
    "}",
    "\"Setting.Level\": {"
      "\"type\": \"string\","
      "\"enum\": [ \"basic\", \"standard\", \"advanced\", \"expert\" ]"
    "}",
    "\"Setting.Value\": {"
      "\"type\": ["
        "{ \"type\": \"boolean\", \"required\": true },"
        "{ \"type\": \"integer\", \"required\": true },"
        "{ \"type\": \"number\", \"required\": true },"
        "{ \"type\": \"string\", \"required\": true }"
      "]"
    "}",
    "\"Setting.Value.List\": {"
      "\"type\": \"array\","
      "\"items\": { \"$ref\": \"Setting.Value\" }"
    "}",
    "\"Setting.Value.Extended\": {"
      "\"type\": ["
        "{ \"type\": \"boolean\", \"required\": true },"
        "{ \"type\": \"integer\", \"required\": true },"
        "{ \"type\": \"number\", \"required\": true },"
        "{ \"type\": \"string\", \"required\": true },"
        "{ \"$ref\": \"Setting.Value.List\", \"required\": true }"
      "]"
    "}",
    "\"Setting.Details.ControlBase\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true },"
        "\"format\": { \"type\": \"string\", \"required\": true },"
        "\"delayed\": { \"type\": \"boolean\", \"required\": true }"
      "}"
    "}",
    "\"Setting.Details.ControlCheckmark\": {"
      "\"extends\": \"Setting.Details.ControlBase\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"toggle\" ] },"
        "\"format\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"boolean\" ] }"
      "}"
    "}",
    "\"Setting.Details.ControlSpinner\": {"
      "\"extends\": \"Setting.Details.ControlBase\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"spinner\" ] },"
        "\"formatlabel\": { \"type\": \"string\" },"
        "\"minimumlabel\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Setting.Details.ControlHeading\": {"
      "\"extends\": \"Setting.Details.ControlBase\","
      "\"properties\": {"
        "\"heading\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Setting.Details.ControlEdit\": {"
      "\"extends\": \"Setting.Details.ControlHeading\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"edit\" ] },"
        "\"hidden\": { \"type\": \"boolean\", \"required\": true },"
        "\"verifynewvalue\": { \"type\": \"boolean\", \"required\": true }"
      "}"
    "}",
    "\"Setting.Details.ControlButton\": {"
      "\"extends\": \"Setting.Details.ControlHeading\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"button\" ] }"
      "}"
    "}",
    "\"Setting.Details.ControlList\": {"
      "\"extends\": \"Setting.Details.ControlHeading\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"list\" ] },"
        "\"multiselect\": { \"type\": \"boolean\", \"required\": true }"
      "}"
    "}",
    "\"Setting.Details.ControlSlider\": {"
      "\"extends\": \"Setting.Details.ControlHeading\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"slider\" ] },"
        "\"formatlabel\": { \"type\": \"string\", \"required\": true },"
        "\"popup\": { \"type\": \"boolean\", \"required\": true }"
      "}"
    "}",
    "\"Setting.Details.ControlRange\": {"
      "\"extends\": \"Setting.Details.ControlBase\","
      "\"properties\": {"
        "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"range\" ] },"
        "\"formatlabel\": { \"type\": \"string\", \"required\": true },"
        "\"formatvalue\": { \"type\": \"string\", \"required\": true }"
      "}"
    "}",
    "\"Setting.Details.Control\": {"
      "\"type\": ["
        "{ \"$ref\": \"Setting.Details.ControlCheckmark\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlSpinner\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlEdit\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlButton\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlList\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlSlider\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.ControlRange\", \"required\": true }"
      "]"
    "}",
    "\"Setting.Details.Base\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"id\": { \"type\": \"string\", \"required\": true, \"minLength\": 1 },"
        "\"label\": { \"type\": \"string\", \"required\": true },"
        "\"help\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Setting.Details.SettingBase\": {"
      "\"extends\": \"Setting.Details.Base\","
      "\"properties\": {"
        "\"type\": { \"$ref\": \"Setting.Type\", \"required\": true },"
        "\"enabled\": { \"type\": \"boolean\", \"required\": true },"
        "\"level\": { \"$ref\": \"Setting.Level\", \"required\": true },"
        "\"parent\": { \"type\": \"string\" },"
        "\"control\": { \"$ref\": \"Setting.Details.Control\" }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingBool\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"properties\": {"
        "\"value\": { \"type\": \"boolean\", \"required\": true },"
        "\"default\": { \"type\": \"boolean\", \"required\": true }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingInt\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"properties\": {"
        "\"value\": { \"type\": \"integer\", \"required\": true },"
        "\"default\": { \"type\": \"integer\", \"required\": true },"
        "\"minimum\": { \"type\": \"integer\" },"
        "\"step\": { \"type\": \"integer\" },"
        "\"maximum\": { \"type\": \"integer\" },"
        "\"options\": { \"type\": \"array\","
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"label\": { \"type\": \"string\", \"required\": true },"
              "\"value\": { \"type\": \"integer\", \"required\": true }"
            "}"
          "}"
        "}"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingNumber\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"properties\": {"
        "\"value\": { \"type\": \"number\", \"required\": true },"
        "\"default\": { \"type\": \"number\", \"required\": true },"
        "\"minimum\": { \"type\": \"number\", \"required\": true },"
        "\"step\": { \"type\": \"number\", \"required\": true },"
        "\"maximum\": { \"type\": \"number\", \"required\": true }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingString\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"properties\": {"
        "\"value\": { \"type\": \"string\", \"required\": true },"
        "\"default\": { \"type\": \"string\", \"required\": true },"
        "\"allowempty\": { \"type\": \"boolean\", \"required\": true },"
        "\"options\": { \"type\": \"array\","
          "\"items\": { \"type\": \"object\","
            "\"properties\": {"
              "\"label\": { \"type\": \"string\", \"required\": true },"
              "\"value\": { \"type\": \"string\", \"required\": true }"
            "}"
          "}"
        "}"
      "}"
    "}",
    "\"Setting.Details.SettingAction\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingList\": {"
      "\"extends\": \"Setting.Details.SettingBase\","
      "\"properties\": {"
        "\"value\": { \"$ref\": \"Setting.Value.List\", \"required\": true },"
        "\"default\": { \"$ref\": \"Setting.Value.List\", \"required\": true },"
        "\"elementtype\": { \"$ref\": \"Setting.Type\", \"required\": true },"
        "\"definition\": { \"$ref\": \"Setting.Details.Setting\", \"required\": true },"
        "\"delimiter\": { \"type\": \"string\", \"required\": true },"
        "\"minimumItems\": { \"type\": \"integer\" },"
        "\"maximumItems\": { \"type\": \"integer\" }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingPath\": {"
      "\"extends\": \"Setting.Details.SettingString\","
      "\"properties\": {"
        "\"writable\": { \"type\": \"boolean\", \"required\": true },"
        "\"sources\": { \"type\": \"array\", \"items\": { \"type\": \"string\" } }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.SettingAddon\": {"
      "\"extends\": \"Setting.Details.SettingString\","
      "\"properties\": {"
        "\"addontype\": { \"$ref\": \"Addon.Types\", \"required\": true }"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.Setting\": {"
      "\"type\": ["
        "{ \"$ref\": \"Setting.Details.SettingBool\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingInt\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingNumber\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingString\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingAction\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingList\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingPath\", \"required\": true },"
        "{ \"$ref\": \"Setting.Details.SettingAddon\", \"required\": true }"
      "]"
    "}",
    "\"Setting.Details.Group\": {"
      "\"type\": \"object\","
      "\"properties\": {"
        "\"id\": { \"type\": \"string\", \"required\": true, \"minLength\": 1 },"
        "\"settings\": {"
          "\"type\": \"array\","
          "\"items\": { \"$ref\": \"Setting.Details.Setting\" },"
          "\"minItems\": 1,"
          "\"uniqueItems\": true"
        "}"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.Category\": {"
      "\"extends\": \"Setting.Details.Base\","
      "\"properties\": {"
        "\"groups\": {"
          "\"type\": \"array\","
          "\"items\": { \"$ref\": \"Setting.Details.Group\" },"
          "\"minItems\": 1,"
          "\"uniqueItems\": true"
        "}"
      "},"
      "\"additionalProperties\": false"
    "}",
    "\"Setting.Details.Section\": {"
      "\"extends\": \"Setting.Details.Base\","
      "\"properties\": {"
        "\"categories\": {"
          "\"type\": \"array\","
          "\"items\": { \"$ref\": \"Setting.Details.Category\" },"
          "\"minItems\": 1,"
          "\"uniqueItems\": true"
        "}"
      "},"
      "\"additionalProperties\": false"
    "}"
  };

  const char* const JSONRPC_SERVICE_METHODS[] = {  
    "\"JSONRPC.Introspect\": {"
      "\"type\": \"method\","
      "\"description\": \"Enumerates all actions and descriptions\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"getdescriptions\", \"type\": \"boolean\", \"default\": true },"
        "{ \"name\": \"getmetadata\", \"type\": \"boolean\", \"default\": false },"
        "{ \"name\": \"filterbytransport\", \"type\": \"boolean\", \"default\": true },"
        "{ \"name\": \"filter\", \"type\": \"object\","
          "\"properties\": {"
            "\"id\": { \"type\": \"string\", \"required\": true, \"description\": \"Name of a namespace, method or type\" },"
            "\"type\": { \"type\": \"string\", \"required\": true, \"enum\": [ \"method\", \"namespace\", \"type\", \"notification\" ], \"description\": \"Type of the given name\" },"
            "\"getreferences\": { \"type\": \"boolean\", \"default\": true, \"description\": \"Whether or not to print the schema for referenced types\" }"
          "}"
        "}"
      "],"
      "\"returns\": \"object\""
    "}",
    "\"JSONRPC.Version\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve the JSON-RPC protocol version.\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"version\": { \"type\": \"object\", \"required\": true,"
            "\"properties\": {"
              "\"major\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true, \"description\": \"Bumped on backwards incompatible changes to the API definition\" },"
              "\"minor\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true, \"description\": \"Bumped on backwards compatible additions/changes to the API definition\" },"
              "\"patch\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true, \"description\": \"Bumped on any changes to the internal implementation but not to the API definition\" }"
            "}"
          "}"
        "}"
      "}"
    "}",
    "\"JSONRPC.Permission\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve the clients permissions\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"ReadData\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlPlayback\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlNotify\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlPower\": { \"type\": \"boolean\", \"required\": true },"
          "\"UpdateData\": { \"type\": \"boolean\", \"required\": true },"
          "\"RemoveData\": { \"type\": \"boolean\", \"required\": true },"
          "\"Navigate\": { \"type\": \"boolean\", \"required\": true },"
          "\"WriteFile\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlSystem\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlGUI\": { \"type\": \"boolean\", \"required\": true },"
          "\"ManageAddon\": { \"type\": \"boolean\", \"required\": true },"
          "\"ExecuteAddon\": { \"type\": \"boolean\", \"required\": true },"
          "\"ControlPVR\": { \"type\": \"boolean\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"JSONRPC.Ping\": {"
      "\"type\": \"method\","
      "\"description\": \"Ping responder\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"JSONRPC.GetConfiguration\": {"
      "\"type\": \"method\","
      "\"description\": \"Get client-specific configurations\","
      "\"transport\": \"Announcing\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": { \"$ref\": \"Configuration\" }"
    "}",
    "\"JSONRPC.SetConfiguration\": {"
      "\"type\": \"method\","
      "\"description\": \"Change the client-specific configuration\","
      "\"transport\": \"Announcing\","
      "\"permission\": \"ControlNotify\","
      "\"params\": ["
        "{ \"name\": \"notifications\", \"type\": \"object\","
          "\"properties\": {"
            "\"Player\": { \"$ref\": \"Optional.Boolean\" },"
            "\"Playlist\": { \"$ref\": \"Optional.Boolean\" },"
            "\"GUI\": { \"$ref\": \"Optional.Boolean\" },"
            "\"System\": { \"$ref\": \"Optional.Boolean\" },"
            "\"AudioLibrary\": { \"$ref\": \"Optional.Boolean\" },"
            "\"VideoLibrary\": { \"$ref\": \"Optional.Boolean\" },"
            "\"Application\": { \"$ref\": \"Optional.Boolean\" },"
            "\"Input\": { \"$ref\": \"Optional.Boolean\" },"
            "\"Other\": { \"$ref\": \"Optional.Boolean\" }"
          "}"
        "}"
      "],"
      "\"returns\": { \"$ref\": \"Configuration\" }"
    "}",
    "\"JSONRPC.NotifyAll\": {"
      "\"type\": \"method\","
      "\"description\": \"Notify all other connected clients\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"message\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"any\", \"default\": null }"
      "],"
      "\"returns\": \"any\""
    "}",
    "\"Player.Open\": {"
      "\"type\": \"method\","
      "\"description\": \"Start playback of either the playlist with the given ID, a slideshow with the pictures from the given directory or a single file or an item from the database.\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"item\","
          "\"type\": ["
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"playlistid\": { \"$ref\": \"Playlist.Id\", \"required\": true },"
                "\"position\": { \"$ref\": \"Playlist.Position\", \"default\": 0 }"
              "}"
            "},"
            "{ \"$ref\": \"Playlist.Item\", \"required\": true },"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"path\": { \"type\": \"string\", \"required\": true },"
                "\"random\": { \"type\": \"boolean\", \"default\": true, \"description\": \"Deprecated, use the shuffled property of the options parameter instead\" },"
                "\"recursive\": { \"type\": \"boolean\", \"default\": true }"
              "}"
            "},"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"partymode\": { \"type\": ["
                    "{ \"type\": \"string\", \"required\": true, \"enum\": [ \"music\", \"video\" ] },"
                    "{ \"type\": \"string\", \"required\": true, \"minLength\": 5, \"description\": \"Path to a smartplaylist (*.xsp) file\" }"
                  "]"
                "}"
              "}"
            "},"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"channelid\": { \"$ref\": \"Library.Id\", \"required\": true }"
              "}"
            "},"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"recordingid\": { \"$ref\": \"Library.Id\", \"required\": true }"
              "}"
            "}"
          "]"
        "},"
        "{ \"name\": \"options\", \"type\": \"object\", \"additionalProperties\": false,"
          "\"properties\": {"
            "\"playercoreid\": { \"type\": ["
                "\"null\","
          "{ \"type\": \"string\", \"enum\": [ \"default\" ], \"required\": true },"
                "{ \"type\": \"integer\", \"minimum\": 1, \"required\": true }"
              "],"
              "\"default\": null },"
            "\"shuffled\": { \"$ref\": \"Optional.Boolean\" },"
            "\"repeat\": { \"type\": [ \"null\", { \"$ref\": \"Player.Repeat\", \"required\": true } ], \"default\": null },"
            "\"resume\": { \"type\": ["
                "{ \"type\": \"boolean\", \"required\": true, \"description\": \"Whether to resume from the resume point or not\" },"
                "{ \"$ref\": \"Player.Position.Percentage\", \"required\": true, \"description\": \"Percentage value to start from\" },"
                "{ \"$ref\": \"Player.Position.Time\", \"required\": true, \"description\": \"Time to start from\" }"
              "],"
              "\"default\": false"
            "}"
          "}"
        "}"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.GetActivePlayers\": {"
      "\"type\": \"method\","
      "\"description\": \"Returns all active players\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": {"
        "\"type\": \"array\","
        "\"uniqueItems\": true,"
        "\"items\": {"
          "\"type\": \"object\","
          "\"properties\": {"
            "\"playerid\": { \"$ref\": \"Player.Id\", \"required\": true },"
            "\"type\": { \"$ref\": \"Player.Type\", \"required\": true }"
          "}"
        "}"
      "}"
    "}",
    "\"Player.GetPlayers\": {"
      "\"type\": \"method\","
      "\"description\": \"Get a list of available players\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"media\", \"type\": \"string\", \"enum\": [ \"all\", \"video\", \"audio\" ], \"default\": \"all\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"array\","
        "\"uniqueItems\": true,"
        "\"items\": {"
          "\"type\": \"object\","
          "\"properties\": {"
            "\"playercoreid\": { \"type\": \"integer\", \"minimum\": 1, \"required\": true },"
            "\"name\": { \"$ref\": \"Global.String.NotEmpty\", \"required\": true },"
            "\"type\": { \"type\": \"string\", \"enum\": [ \"internal\", \"external\", \"remote\" ], \"required\": true },"
            "\"playsvideo\": { \"type\": \"boolean\", \"required\": true },"
            "\"playsaudio\": { \"type\": \"boolean\", \"required\": true }"
          "}"
        "}"
      "}"
    "}",
    "\"Player.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"Player.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"Player.Property.Value\", \"required\": true }"
    "}",
    "\"Player.GetItem\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the currently played item\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"List.Fields.All\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"item\": { \"$ref\": \"List.Item.All\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"Player.PlayPause\": {"
      "\"type\": \"method\","
      "\"description\": \"Pauses or unpause playback and returns the new state\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"play\", \"$ref\": \"Global.Toggle\", \"default\": \"toggle\" }"
      "],"
      "\"returns\": { \"$ref\": \"Player.Speed\" }"
    "}",
    "\"Player.Stop\": {"
      "\"type\": \"method\","
      "\"description\": \"Stops playback\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetSpeed\": {"
      "\"type\": \"method\","
      "\"description\": \"Set the speed of the current playback\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"speed\", \"type\": ["
            "{ \"type\": \"integer\", \"required\": true, \"enum\": [ -32, -16, -8, -4, -2, -1, 0, 1, 2, 4, 8, 16, 32 ] },"
            "{ \"$ref\": \"Global.IncrementDecrement\", \"required\": true }"
          "],"
          "\"required\": true"
        "}"
      "],"
      "\"returns\": { \"$ref\": \"Player.Speed\" }"
    "}",
    "\"Player.Seek\": {"
      "\"type\": \"method\","
      "\"description\": \"Seek through the playing item\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"value\", \"required\": true, \"type\": ["
            "{ \"$ref\": \"Player.Position.Percentage\", \"required\": true, \"description\": \"Percentage value to seek to\" },"
            "{ \"$ref\": \"Player.Position.Time\", \"required\": true, \"description\": \"Time to seek to\" },"
            "{ \"type\": \"string\", \"enum\": [ \"smallforward\", \"smallbackward\", \"bigforward\", \"bigbackward\" ], \"required\": true, \"description\": \"Seek by predefined jumps\" },"
            "{ \"type\": \"object\", \"properties\": { \"percentage\": { \"$ref\": \"Player.Position.Percentage\", \"required\": true, \"description\": \"Percentage value to seek to\" } }, \"additionalProperties\": false, \"required\": true },"
            "{ \"type\": \"object\", \"properties\": { \"time\": { \"$ref\": \"Player.Position.Time\", \"required\": true, \"description\": \"Time to seek to\" } }, \"additionalProperties\": false, \"required\": true },"
            "{ \"type\": \"object\", \"properties\": { \"step\": { \"type\": \"string\", \"enum\": [ \"smallforward\", \"smallbackward\", \"bigforward\", \"bigbackward\" ], \"required\": true, \"description\": \"Seek by predefined jumps\" } }, \"additionalProperties\": false, \"required\": true },"
            "{ \"type\": \"object\", \"properties\": { \"seconds\": { \"type\": \"integer\", \"required\": true, \"description\": \"Seek by the given number of seconds\" } }, \"additionalProperties\": false, \"required\": true }"
          "]"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"percentage\": { \"$ref\": \"Player.Position.Percentage\" },"
          "\"time\": { \"$ref\": \"Global.Time\" },"
          "\"totaltime\": { \"$ref\": \"Global.Time\" }"
        "}"
      "}"
    "}",
    "\"Player.Move\": {"
      "\"type\": \"method\","
      "\"description\": \"If picture is zoomed move viewport left/right/up/down otherwise skip previous/next\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"direction\", \"type\": \"string\", \"enum\": [ \"left\", \"right\", \"up\", \"down\" ], \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.Zoom\": {"
      "\"type\": \"method\","
      "\"description\": \"Zoom current picture\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"zoom\", \"type\": ["
            "{ \"type\": \"string\", \"enum\": [ \"in\", \"out\" ], \"required\": true },"
            "{ \"type\": \"integer\", \"minimum\": 1, \"maximum\": 10, \"description\": \"zoom level\", \"required\": true }"
          "],"
        "\"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.Rotate\": {"
      "\"type\": \"method\","
      "\"description\": \"Rotates current picture\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"value\", \"type\": \"string\", \"enum\": [ \"clockwise\", \"counterclockwise\" ], \"default\": \"clockwise\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.GoTo\": {"
      "\"type\": \"method\","
      "\"description\": \"Go to previous/next/specific item in the playlist\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"to\", \"type\": ["
            "{ \"type\": \"string\", \"enum\": [ \"previous\", \"next\" ], \"required\": true },"
            "{ \"$ref\": \"Playlist.Position\", \"description\": \"position in playlist\", \"required\": true }"
          "],"
        "\"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetShuffle\": {"
      "\"type\": \"method\","
      "\"description\": \"Shuffle/Unshuffle items in the player\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
    "{ \"name\": \"shuffle\", \"$ref\": \"Global.Toggle\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetRepeat\": {"
      "\"type\": \"method\","
      "\"description\": \"Set the repeat mode of the player\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"repeat\", \"type\": ["
            "{ \"$ref\": \"Player.Repeat\", \"required\": true },"
            "{ \"type\": \"string\", \"enum\": [ \"cycle\" ], \"required\": true }"
          "],"
          "\"required\": true"
        "}"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetPartymode\": {"
      "\"type\": \"method\","
      "\"description\": \"Turn partymode on or off\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"partymode\", \"$ref\": \"Global.Toggle\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetAudioStream\": {"
      "\"type\": \"method\","
      "\"description\": \"Set the audio stream played by the player\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"stream\", \"required\": true, \"type\": ["
            "{ \"type\": \"string\", \"enum\": [ \"previous\", \"next\" ] },"
            "{ \"type\": \"integer\", \"minimum\": 0, \"description\": \"Index of the audio stream to play\" }"
          "]"
        "}"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Player.SetSubtitle\": {"
      "\"type\": \"method\","
      "\"description\": \"Set the subtitle displayed by the player\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playerid\", \"$ref\": \"Player.Id\", \"required\": true },"
        "{ \"name\": \"subtitle\", \"required\": true, \"type\": ["
            "{ \"type\": \"string\", \"enum\": [ \"previous\", \"next\", \"off\", \"on\" ] },"
            "{ \"type\": \"integer\", \"minimum\": 0, \"description\": \"Index of the subtitle to display\" }"
          "]"
        "},"
        "{ \"name\": \"enable\", \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to enable subtitles to be displayed after setting the new subtitle\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Playlist.GetPlaylists\": {"
      "\"type\": \"method\","
      "\"description\": \"Returns all existing playlists\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": {"
        "\"type\": \"array\","
        "\"uniqueItems\": true,"
        "\"items\": {"
          "\"type\": \"object\","
          "\"properties\": {"
            "\"playlistid\": { \"$ref\": \"Playlist.Id\", \"required\": true },"
            "\"type\": { \"$ref\": \"Playlist.Type\", \"required\": true }"
          "}"
        "}"
      "}"
    "}",
    "\"Playlist.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"Playlist.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"Playlist.Property.Value\", \"required\": true }"
    "}",
    "\"Playlist.GetItems\": {"
      "\"type\": \"method\","
      "\"description\": \"Get all items from playlist\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"List.Fields.All\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"items\": { \"type\": \"array\", \"items\": { \"$ref\": \"List.Item.All\" }, \"required\": true }"
        "}"
      "}"
    "}",
    "\"Playlist.Add\": {"
      "\"type\": \"method\","
      "\"description\": \"Add item(s) to playlist\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"item\","
          "\"type\": ["
            "{ \"$ref\": \"Playlist.Item\", \"required\": true },"
            "{ \"type\": \"array\", \"items\": { \"$ref\": \"Playlist.Item\" }, \"required\": true }"
          "],"
          "\"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Playlist.Insert\": {"
      "\"type\": \"method\","
      "\"description\": \"Insert item(s) into playlist. Does not work for picture playlists (aka slideshows).\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"position\", \"$ref\": \"Playlist.Position\", \"required\": true },"
        "{ \"name\": \"item\","
          "\"type\": ["
            "{ \"$ref\": \"Playlist.Item\", \"required\": true },"
            "{ \"type\": \"array\", \"items\": { \"$ref\": \"Playlist.Item\" }, \"required\": true }"
          "],"
          "\"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Playlist.Remove\": {"
      "\"type\": \"method\","
      "\"description\": \"Remove item from playlist. Does not work for picture playlists (aka slideshows).\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"position\", \"$ref\": \"Playlist.Position\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Playlist.Clear\": {"
      "\"type\": \"method\","
      "\"description\": \"Clear playlist\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Playlist.Swap\": {"
      "\"type\": \"method\","
      "\"description\": \"Swap items in the playlist. Does not work for picture playlists (aka slideshows).\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"playlistid\", \"$ref\": \"Playlist.Id\", \"required\": true },"
        "{ \"name\": \"position1\", \"$ref\": \"Playlist.Position\", \"required\": true },"
        "{ \"name\": \"position2\", \"$ref\": \"Playlist.Position\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Files.GetSources\": {"
      "\"type\": \"method\","
      "\"description\": \"Get the sources of the media windows\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"media\", \"$ref\": \"Files.Media\", \"required\": true },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"sources\": { \"$ref\": \"List.Items.Sources\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"Files.PrepareDownload\": {"
      "\"type\": \"method\","
      "\"description\": \"Provides a way to download a given file (e.g. providing an URL to the real file location)\","
      "\"transport\": [ \"Response\", \"FileDownloadRedirect\" ],"
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"path\", \"type\": \"string\", \"required\": true }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"protocol\": { \"type\": \"string\", \"enum\": [ \"http\" ], \"required\": true },"
          "\"details\": { \"type\": \"any\", \"required\": true, \"description\": \"Transport specific details on how/from where to download the given file\" },"
          "\"mode\": { \"type\": \"string\", \"enum\": [ \"redirect\", \"direct\" ], \"required\": true, \"description\": \"Direct mode allows using Files.Download whereas redirect mode requires the usage of a different protocol\" }"
        "}"
      "}"
    "}",
    "\"Files.Download\": {"
      "\"type\": \"method\","
      "\"description\": \"Downloads the given file\","
      "\"transport\": [ \"Response\", \"FileDownloadDirect\" ],"
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"path\", \"type\": \"string\", \"required\": true }"
      "],"
      "\"returns\": { \"type\": \"any\", \"required\": true }"
    "}",
    "\"Files.GetDirectory\": {"
      "\"type\": \"method\","
      "\"description\": \"Get the directories and files in the given directory\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"directory\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"media\", \"$ref\": \"Files.Media\", \"default\": \"files\" },"
        "{ \"name\": \"properties\", \"$ref\": \"List.Fields.Files\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\", \"description\": \"Limits are applied after getting the directory content thus retrieval is not faster when they are applied.\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"files\": { \"type\": \"array\", \"items\": { \"$ref\": \"List.Item.File\" }, \"required\": true }"
        "}"
      "}"
    "}",
    "\"Files.GetFileDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Get details for a specific file\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"file\", \"type\": \"string\", \"required\": true, \"description\": \"Full path to the file\" },"
        "{ \"name\": \"media\", \"$ref\": \"Files.Media\", \"default\": \"files\" },"
        "{ \"name\": \"properties\", \"$ref\": \"List.Fields.Files\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"filedetails\": { \"$ref\": \"List.Item.File\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetArtists\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all artists\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"albumartistsonly\", \"$ref\": \"Optional.Boolean\", \"description\": \"Whether or not to include artists only appearing in compilations. If the parameter is not passed or is passed as null the GUI setting will be used\" },"
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Artist\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"albumid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"album\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"songid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.Artists\" }"
          "]"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"artists\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Artist\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetArtistDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific artist\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"artistid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Artist\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"artistdetails\": { \"$ref\": \"Audio.Details.Artist\" }"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetAlbums\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all albums from specified artist or genre\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Album\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"artistid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"artist\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.Albums\" }"
          "]"
        "},"
        "{ \"name\": \"includesingles\", \"type\": \"boolean\", \"default\": false }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"albums\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Album\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetAlbumDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific album\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"albumid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Album\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"albumdetails\": { \"$ref\": \"Audio.Details.Album\" }"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetSongs\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all songs from specified album, artist or genre\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Song\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"artistid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"artist\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"albumid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"album\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.Songs\" }"
          "]"
        "},"
        "{ \"name\": \"includesingles\", \"type\": \"boolean\", \"default\": true }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"songs\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Song\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetSongDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific song\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"songid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Song\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"songdetails\": { \"$ref\": \"Audio.Details.Song\" }"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetRecentlyAddedAlbums\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve recently added albums\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Album\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"albums\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Album\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetRecentlyAddedSongs\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve recently added songs\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"albumlimit\", \"$ref\": \"List.Amount\", \"description\": \"The amount of recently added albums from which to return the songs\" },"
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Song\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"songs\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Song\" }"
          "}"
        "}"
      "}"
    "}",
      "\"AudioLibrary.GetRecentlyPlayedAlbums\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve recently played albums\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Album\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"albums\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Album\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetRecentlyPlayedSongs\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve recently played songs\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Audio.Fields.Song\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"songs\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Audio.Details.Song\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.GetGenres\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all genres\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Library.Fields.Genre\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"genres\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"Library.Details.Genre\" }"
          "}"
        "}"
      "}"
    "}",
    "\"AudioLibrary.SetArtistDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given artist with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"artistid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"artist\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"instrument\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"style\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"mood\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"born\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"formed\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"description\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"died\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"disbanded\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"yearsactive\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"AudioLibrary.SetAlbumDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given album with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"albumid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"artist\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"description\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"theme\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"mood\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"style\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"type\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"albumlabel\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"rating\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"year\", \"$ref\": \"Optional.Integer\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"AudioLibrary.SetSongDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given song with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"songid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"artist\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"albumartist\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"year\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"rating\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"album\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"track\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"disc\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"duration\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"comment\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"musicbrainztrackid\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"musicbrainzartistid\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"musicbrainzalbumid\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"musicbrainzalbumartistid\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"playcount\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"lastplayed\", \"$ref\": \"Optional.String\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"AudioLibrary.Scan\": {"
      "\"type\": \"method\","
      "\"description\": \"Scans the audio sources for new library items\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"directory\", \"type\": \"string\", \"default\": \"\" },"
        "{ \"name\": \"showdialogs\", \"type\": \"boolean\", \"default\": true, \"description\": \"Whether or not to show the progress bar or any other GUI dialog\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"AudioLibrary.Export\": {"
      "\"type\": \"method\","
      "\"description\": \"Exports all items from the audio library\","
      "\"transport\": \"Response\","
      "\"permission\": \"WriteFile\","
      "\"params\": ["
        "{ \"name\": \"options\", \"type\": ["
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"path\": { \"type\": \"string\", \"required\": true, \"minLength\": 1, \"description\": \"Path to the directory to where the data should be exported\" }"
              "}"
            "},"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"overwrite\": { \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to overwrite existing exported files\" },"
                "\"images\": { \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to export thumbnails and fanart images\" }"
              "}"
            "}"
          "]"
        "}"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"AudioLibrary.Clean\": {"
      "\"type\": \"method\","
      "\"description\": \"Cleans the audio library from non-existent items\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"showdialogs\", \"type\": \"boolean\", \"default\": true, \"description\": \"Whether or not to show the progress bar or any other GUI dialog\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.GetMovies\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all movies\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Movie\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"year\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"actor\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"director\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"studio\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"country\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"setid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"set\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"tag\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.Movies\" }"
          "]"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"movies\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.Movie\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetMovieDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific movie\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"movieid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Movie\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"moviedetails\": { \"$ref\": \"Video.Details.Movie\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetMovieSets\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all movie sets\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.MovieSet\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"sets\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.MovieSet\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetMovieSetDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific movie set\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"setid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.MovieSet\" },"
        "{ \"name\": \"movies\", \"type\": \"object\","
          "\"properties\": {"
            "\"properties\": { \"$ref\": \"Video.Fields.Movie\" },"
            "\"limits\": { \"$ref\": \"List.Limits\" },"
            "\"sort\": { \"$ref\": \"List.Sort\" }"
          "}"
        "}"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"setdetails\": { \"$ref\": \"Video.Details.MovieSet.Extended\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetTVShows\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all tv shows\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.TVShow\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"year\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"actor\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"studio\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"tag\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.TVShows\" }"
          "]"
        "}"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"tvshows\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.TVShow\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetTVShowDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific tv show\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"tvshowid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.TVShow\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"tvshowdetails\": { \"$ref\": \"Video.Details.TVShow\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetSeasons\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all tv seasons\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"tvshowid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Season\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"seasons\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.Season\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetSeasonDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific tv show season\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"seasonid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Season\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"seasondetails\": { \"$ref\": \"Video.Details.Season\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetEpisodes\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all tv show episodes\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"tvshowid\", \"$ref\": \"Library.Id\" },"
        "{ \"name\": \"season\", \"type\": \"integer\", \"minimum\": 0, \"default\": -1 },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Episode\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true, \"description\": \"Requires tvshowid to be set\" } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true, \"description\": \"Requires tvshowid to be set\" } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"year\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"actor\": { \"type\": \"string\", \"minLength\": 1, \"required\": true, \"description\": \"Requires tvshowid to be set\" } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"director\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.Episodes\" }"
          "]"
        "}"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"episodes\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.Episode\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetEpisodeDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific tv show episode\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"episodeid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Episode\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"episodedetails\": { \"$ref\": \"Video.Details.Episode\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetMusicVideos\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all music videos\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.MusicVideo\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" },"
        "{ \"name\": \"filter\","
          "\"type\": ["
            "{ \"type\": \"object\", \"properties\": { \"artist\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genreid\": { \"$ref\": \"Library.Id\", \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"genre\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"year\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"director\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"studio\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"type\": \"object\", \"properties\": { \"tag\": { \"type\": \"string\", \"minLength\": 1, \"required\": true } }, \"additionalProperties\": false },"
            "{ \"$ref\": \"List.Filter.MusicVideos\" }"
          "]"
        "}"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"musicvideos\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.MusicVideo\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetMusicVideoDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve details about a specific music video\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"musicvideoid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.MusicVideo\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"musicvideodetails\": { \"$ref\": \"Video.Details.MusicVideo\" }"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetRecentlyAddedMovies\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all recently added movies\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Movie\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"movies\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.Movie\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetRecentlyAddedEpisodes\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all recently added tv episodes\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.Episode\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"episodes\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.Episode\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetRecentlyAddedMusicVideos\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all recently added music videos\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Video.Fields.MusicVideo\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"musicvideos\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Video.Details.MusicVideo\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.GetGenres\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all genres\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"type\", \"type\": \"string\", \"required\": true, \"enum\": [ \"movie\", \"tvshow\", \"musicvideo\"] },"
        "{ \"name\": \"properties\", \"$ref\": \"Library.Fields.Genre\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"genres\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"Library.Details.Genre\" }"
          "}"
        "}"
      "}"
    "}",
    "\"VideoLibrary.SetMovieDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given movie with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"movieid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"playcount\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"runtime\", \"$ref\": \"Optional.Integer\", \"description\": \"Runtime in seconds\" },"
        "{ \"name\": \"director\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"studio\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"year\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"plot\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"rating\", \"$ref\": \"Optional.Number\" },"
        "{ \"name\": \"mpaa\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"imdbnumber\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"votes\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"lastplayed\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"originaltitle\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"trailer\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"tagline\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"plotoutline\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"writer\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"country\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"top250\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"sorttitle\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"set\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"showlink\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"thumbnail\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"fanart\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"tag\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"resume\", \"type\": [ \"null\", { \"$ref\": \"Video.Resume\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.SetMovieSetDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given movie set with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"setid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.SetTVShowDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given tvshow with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"tvshowid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"playcount\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"studio\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"plot\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"rating\", \"$ref\": \"Optional.Number\" },"
        "{ \"name\": \"mpaa\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"imdbnumber\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"premiered\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"votes\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"lastplayed\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"originaltitle\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"sorttitle\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"episodeguide\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"thumbnail\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"fanart\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"tag\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.SetSeasonDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given season with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"seasonid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.SetEpisodeDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given episode with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"episodeid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"playcount\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"runtime\", \"$ref\": \"Optional.Integer\", \"description\": \"Runtime in seconds\" },"
        "{ \"name\": \"director\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"plot\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"rating\", \"$ref\": \"Optional.Number\" },"
        "{ \"name\": \"votes\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"lastplayed\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"writer\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"firstaired\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"productioncode\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"season\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"episode\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"originaltitle\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"thumbnail\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"fanart\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"resume\", \"type\": [ \"null\", { \"$ref\": \"Video.Resume\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.SetMusicVideoDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Update the given music video with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"musicvideoid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"title\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"playcount\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"runtime\", \"$ref\": \"Optional.Integer\", \"description\": \"Runtime in seconds\" },"
        "{ \"name\": \"director\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"studio\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"year\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"plot\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"album\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"artist\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ] },"
        "{ \"name\": \"genre\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"track\", \"$ref\": \"Optional.Integer\" },"
        "{ \"name\": \"lastplayed\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"thumbnail\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"fanart\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"tag\", \"type\": [ \"null\", { \"$ref\": \"Array.String\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"art\", \"type\": [ \"null\", { \"$ref\": \"Media.Artwork.Set\", \"required\": true } ], \"default\": null },"
        "{ \"name\": \"resume\", \"type\": [ \"null\", { \"$ref\": \"Video.Resume\", \"required\": true } ], \"default\": null }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.RemoveMovie\": {"
      "\"type\": \"method\","
      "\"description\": \"Removes the given movie from the library\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"movieid\", \"$ref\": \"Library.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.RemoveTVShow\": {"
      "\"type\": \"method\","
      "\"description\": \"Removes the given tv show from the library\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"tvshowid\", \"$ref\": \"Library.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.RemoveEpisode\": {"
      "\"type\": \"method\","
      "\"description\": \"Removes the given episode from the library\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"episodeid\", \"$ref\": \"Library.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.RemoveMusicVideo\": {"
      "\"type\": \"method\","
      "\"description\": \"Removes the given music video from the library\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"musicvideoid\", \"$ref\": \"Library.Id\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.Scan\": {"
      "\"type\": \"method\","
      "\"description\": \"Scans the video sources for new library items\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"directory\", \"type\": \"string\", \"default\": \"\" },"
        "{ \"name\": \"showdialogs\", \"type\": \"boolean\", \"default\": true, \"description\": \"Whether or not to show the progress bar or any other GUI dialog\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.Export\": {"
      "\"type\": \"method\","
      "\"description\": \"Exports all items from the video library\","
      "\"transport\": \"Response\","
      "\"permission\": \"WriteFile\","
      "\"params\": ["
        "{ \"name\": \"options\", \"type\": ["
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"path\": { \"type\": \"string\", \"required\": true, \"minLength\": 1, \"description\": \"Path to the directory to where the data should be exported\" }"
              "}"
            "},"
            "{ \"type\": \"object\", \"required\": true, \"additionalProperties\": false,"
              "\"properties\": {"
                "\"overwrite\": { \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to overwrite existing exported files\" },"
                "\"images\": { \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to export thumbnails and fanart images\" },"
                "\"actorthumbs\": { \"type\": \"boolean\", \"default\": false, \"description\": \"Whether to export actor thumbnails\" }"
              "}"
            "}"
          "]"
        "}"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"VideoLibrary.Clean\": {"
      "\"type\": \"method\","
      "\"description\": \"Cleans the video library from non-existent items\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"showdialogs\", \"type\": \"boolean\", \"default\": true, \"description\": \"Whether or not to show the progress bar or any other GUI dialog\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"GUI.ActivateWindow\": {"
      "\"type\": \"method\","
      "\"description\": \"Activates the given window\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlGUI\","
      "\"params\": ["
        "{ \"name\": \"window\", \"$ref\": \"GUI.Window\", \"required\": true },"
        "{ \"name\": \"parameters\", \"type\": \"array\", \"items\": { \"type\": \"string\", \"minLength\": 1, \"required\": true }, \"minItems\": 1 }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"GUI.ShowNotification\": {"
      "\"type\": \"method\","
      "\"description\": \"Shows a GUI notification\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlGUI\","
      "\"params\": ["
        "{ \"name\": \"title\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"message\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"image\", \"type\": ["
            "{ \"type\": \"string\", \"required\": true, \"enum\": [ \"info\", \"warning\", \"error\" ] },"
            "{ \"type\": \"string\", \"required\": true }"
          "], \"default\": \"\""
        "},"
        "{ \"name\": \"displaytime\", \"type\": \"integer\", \"minimum\": 1500, \"default\": 5000, \"description\": \"The time in milliseconds the notification will be visible\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"GUI.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"GUI.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"GUI.Property.Value\", \"required\": true }"
    "}",
    "\"GUI.SetFullscreen\": {"
      "\"type\": \"method\","
      "\"description\": \"Toggle fullscreen/GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlGUI\","
      "\"params\": ["
        "{ \"name\": \"fullscreen\", \"required\": true, \"$ref\": \"Global.Toggle\" }"
      "],"
      "\"returns\": { \"type\": \"boolean\", \"description\": \"Fullscreen state\" }"
    "}",
    "\"GUI.SetStereoscopicMode\": {"
      "\"type\": \"method\","
      "\"description\": \"Sets the stereoscopic mode of the GUI to the given mode\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlGUI\","
      "\"params\": ["
        "{ \"name\": \"mode\", \"type\": \"string\", \"enum\": [ \"toggle\", \"tomono\", \"next\", \"previous\", \"select\", \"off\", \"split_vertical\", \"split_horizontal\", \"row_interleaved\", \"hardware_based\", \"anaglyph_cyan_red\", \"anaglyph_green_magenta\", \"monoscopic\" ], \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"GUI.GetStereoscopicModes\": {"
      "\"type\": \"method\","
      "\"description\": \"Returns the supported stereoscopic modes of the GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": [],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"stereoscopicmodes\" : {"
            "\"type\": \"array\","
            "\"uniqueItems\": true,"
            "\"items\": { \"$ref\": \"GUI.Stereoscopy.Mode\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Addons.GetAddons\": {"
      "\"type\": \"method\","
      "\"description\": \"Gets all available addons\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"type\", \"$ref\": \"Addon.Types\" },"
        "{ \"name\": \"content\", \"$ref\": \"Addon.Content\", \"description\": \"Content provided by the addon. Only considered for plugins and scripts.\" },"
        "{ \"name\": \"enabled\", \"type\": [ { \"type\": \"boolean\" }, { \"type\": \"string\", \"enum\": [ \"all\" ] } ], \"default\": \"all\" },"
        "{ \"name\": \"properties\", \"$ref\": \"Addon.Fields\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"addons\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Addon.Details\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Addons.GetAddonDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Gets the details of a specific addon\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"addonid\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"Addon.Fields\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"addon\": { \"$ref\": \"Addon.Details\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"Addons.SetAddonEnabled\": {"
      "\"type\": \"method\","
      "\"description\": \"Enables/Disables a specific addon\","
      "\"transport\": \"Response\","
      "\"permission\": \"ManageAddon\","
      "\"params\": ["
        "{ \"name\": \"addonid\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"enabled\", \"$ref\": \"Global.Toggle\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Addons.ExecuteAddon\": {"
      "\"type\": \"method\","
      "\"description\": \"Executes the given addon with the given parameters (if possible)\","
      "\"transport\": \"Response\","
      "\"permission\": \"ExecuteAddon\","
      "\"params\": ["
        "{ \"name\": \"addonid\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"params\", \"type\": ["
            "{ \"type\": \"object\", \"additionalProperties\": { \"type\": \"string\" } },"
            "{ \"type\": \"array\", \"items\": { \"type\": \"string\" } },"
            "{ \"type\": \"string\", \"description\": \"URL path (must start with / or ?\" }"
          "],"
          "\"default\": \"\""
        "},"
        "{ \"name\": \"wait\", \"type\": \"boolean\", \"default\": false }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"PVR.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"PVR.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"PVR.Property.Value\", \"required\": true }"
    "}",
    "\"PVR.GetChannelGroups\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the channel groups for the specified type\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"channeltype\", \"$ref\": \"PVR.Channel.Type\", \"required\": true },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"channelgroups\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"PVR.Details.ChannelGroup\" }"
          "}"
        "}"
      "}"
    "}",
    "\"PVR.GetChannelGroupDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the details of a specific channel group\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"channelgroupid\", \"$ref\": \"PVR.ChannelGroup.Id\", \"required\": true },"
        "{ \"name\": \"channels\", \"type\": \"object\","
          "\"properties\": {"
            "\"properties\": { \"$ref\": \"PVR.Fields.Channel\" },"
            "\"limits\": { \"$ref\": \"List.Limits\" }"
          "}"
        "}"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"channelgroupdetails\": { \"$ref\": \"PVR.Details.ChannelGroup.Extended\" }"
        "}"
      "}"
    "}",
    "\"PVR.GetChannels\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the channel list\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"channelgroupid\", \"$ref\": \"PVR.ChannelGroup.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Channel\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"channels\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"PVR.Details.Channel\" }"
          "}"
        "}"
      "}"
    "}",
    "\"PVR.GetChannelDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the details of a specific channel\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"channelid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Channel\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"channeldetails\": { \"$ref\": \"PVR.Details.Channel\" }"
        "}"
      "}"
    "}",
    "\"PVR.GetBroadcasts\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the program of a specific channel\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"channelid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Broadcast\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"broadcasts\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"PVR.Details.Broadcast\" }"
          "}"
        "}"
      "}"
    "}",
    "\"PVR.GetBroadcastDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the details of a specific broadcast\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"broadcastid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Broadcast\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"broadcastdetails\": { \"$ref\": \"PVR.Details.Broadcast\" }"
        "}"
      "}"
    "}",
    "\"PVR.GetTimers\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the timers\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Timer\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"timers\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"PVR.Details.Timer\" }"
          "}"
        "}"
      "}"
    "}",
    "\"PVR.GetTimerDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the details of a specific timer\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"timerid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Timer\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"timerdetails\": { \"$ref\": \"PVR.Details.Timer\" }"
        "}"
      "}"
    "}",
    "\"PVR.GetRecordings\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the recordings\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Recording\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"recordings\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"PVR.Details.Recording\" }"
          "}"
        "}"
      "}"
    "}",
    "\"PVR.GetRecordingDetails\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the details of a specific recording\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"recordingid\", \"$ref\": \"Library.Id\", \"required\": true },"
        "{ \"name\": \"properties\", \"$ref\": \"PVR.Fields.Recording\" }"
      "],"
      "\"returns\": { \"type\": \"object\","
        "\"properties\": {"
          "\"recordingdetails\": { \"$ref\": \"PVR.Details.Recording\" }"
        "}"
      "}"
    "}",
    "\"PVR.Record\": {"
      "\"type\": \"method\","
      "\"description\": \"Toggle recording of a channel\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPVR\","
      "\"params\": ["
        "{ \"name\": \"record\", \"$ref\": \"Global.Toggle\", \"default\": \"toggle\" },"
        "{ \"name\": \"channel\", \"type\": ["
            "{ \"type\": \"string\", \"enum\": [ \"current\" ], \"required\": true },"
            "{ \"$ref\": \"Library.Id\", \"required\": true }"
          "],"
          "\"default\": \"current\""
        "}"
      "],"
      "\"returns\":  \"string\""
    "}",
    "\"PVR.Scan\": {"
      "\"type\": \"method\","
      "\"description\": \"Starts a channel scan\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPVR\","
      "\"params\": [ ],"
      "\"returns\":  \"string\""
    "}",
    "\"Textures.GetTextures\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all textures\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Textures.Fields.Texture\" },"
        "{ \"name\": \"filter\", \"$ref\": \"List.Filter.Textures\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"textures\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"Textures.Details.Texture\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Textures.RemoveTexture\": {"
      "\"type\": \"method\","
      "\"description\": \"Remove the specified texture\","
      "\"transport\": \"Response\","
      "\"permission\": \"RemoveData\","
      "\"params\": ["
        "{ \"name\": \"textureid\", \"$ref\": \"Library.Id\", \"required\": true, \"description\": \"Texture database identifier\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Profiles.GetProfiles\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all profiles\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Profiles.Fields.Profile\" },"
        "{ \"name\": \"limits\", \"$ref\": \"List.Limits\" },"
        "{ \"name\": \"sort\", \"$ref\": \"List.Sort\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"profiles\": { \"type\": \"array\", \"required\": true,"
            "\"items\": { \"$ref\": \"Profiles.Details.Profile\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Profiles.GetCurrentProfile\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve the current profile\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"$ref\": \"Profiles.Fields.Profile\" }"
      "],"
      "\"returns\":  { \"$ref\": \"Profiles.Details.Profile\", \"required\": true }"
    "}",
    "\"Profiles.LoadProfile\": {"
      "\"type\": \"method\","
      "\"description\": \"Load the specified profile\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": ["
        "{ \"name\": \"profile\", \"type\": \"string\", \"required\": true, \"description\": \"Profile name\" },"
        "{ \"name\": \"prompt\", \"type\": \"boolean\", \"description\": \"Prompt for password\" },"
        "{ \"name\": \"password\", \"$ref\": \"Profiles.Password\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"System.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"System.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"System.Property.Value\", \"required\": true }"
    "}",
    "\"System.EjectOpticalDrive\": {"
      "\"type\": \"method\","
      "\"description\": \"Ejects or closes the optical disc drive (if available)\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlSystem\","
      "\"params\": [ ],"
      "\"returns\":  \"string\""
    "}",
    "\"System.Shutdown\": {"
      "\"type\": \"method\","
      "\"description\": \"Shuts the system running Kodi down\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPower\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"System.Suspend\": {"
      "\"type\": \"method\","
      "\"description\": \"Suspends the system running Kodi\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPower\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"System.Hibernate\": {"
      "\"type\": \"method\","
      "\"description\": \"Puts the system running Kodi into hibernate mode\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPower\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"System.Reboot\": {"
      "\"type\": \"method\","
      "\"description\": \"Reboots the system running Kodi\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPower\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.SendText\": {"
      "\"type\": \"method\","
      "\"description\": \"Send a generic (unicode) text\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": ["
        "{ \"name\": \"text\", \"type\": \"string\", \"required\": true, \"description\": \"Unicode text\" },"
        "{ \"name\": \"done\", \"type\": \"boolean\", \"default\": true, \"description\": \"Whether this is the whole input or not (closes an open input dialog if true).\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Input.ExecuteAction\": {"
      "\"type\": \"method\","
      "\"description\": \"Execute a specific action\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": ["
        "{ \"name\": \"action\", \"$ref\": \"Input.Action\", \"required\": true }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Left\": {"
      "\"type\": \"method\","
      "\"description\": \"Navigate left in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Right\": {"
      "\"type\": \"method\","
      "\"description\": \"Navigate right in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Down\": {"
      "\"type\": \"method\","
      "\"description\": \"Navigate down in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Up\": {"
      "\"type\": \"method\","
      "\"description\": \"Navigate up in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Select\": {"
      "\"type\": \"method\","
      "\"description\": \"Select current item in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Back\": {"
      "\"type\": \"method\","
      "\"description\": \"Goes back in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.ContextMenu\": {"
      "\"type\": \"method\","
      "\"description\": \"Shows the context menu\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Info\": {"
      "\"type\": \"method\","
      "\"description\": \"Shows the information dialog\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.Home\": {"
      "\"type\": \"method\","
      "\"description\": \"Goes to home window in GUI\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.ShowCodec\": {"
      "\"type\": \"method\","
      "\"description\": \"Show codec information of the playing item\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Input.ShowOSD\": {"
      "\"type\": \"method\","
      "\"description\": \"Show the on-screen display for the current player\","
      "\"transport\": \"Response\","
      "\"permission\": \"Navigate\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"Application.GetProperties\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the values of the given properties\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"properties\", \"type\": \"array\", \"uniqueItems\": true, \"required\": true, \"items\": { \"$ref\": \"Application.Property.Name\" } }"
      "],"
      "\"returns\":  { \"$ref\": \"Application.Property.Value\", \"required\": true }"
    "}",
    "\"Application.SetVolume\": {"
      "\"type\": \"method\","
      "\"description\": \"Set the current volume\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"volume\", \"type\": ["
            "{ \"type\": \"integer\", \"minimum\": 0, \"maximum\": 100, \"required\": true },"
            "{ \"$ref\": \"Global.IncrementDecrement\", \"required\": true }"
          "],"
          "\"required\": true"
        "}"
      "],"
      "\"returns\": \"integer\""
    "}",
    "\"Application.SetMute\": {"
      "\"type\": \"method\","
      "\"description\": \"Toggle mute/unmute\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPlayback\","
      "\"params\": ["
        "{ \"name\": \"mute\", \"required\": true, \"$ref\": \"Global.Toggle\" }"
      "],"
      "\"returns\": { \"type\": \"boolean\", \"description\": \"Mute state\" }"
    "}",
    "\"Application.Quit\": {"
      "\"type\": \"method\","
      "\"description\": \"Quit application\","
      "\"transport\": \"Response\","
      "\"permission\": \"ControlPower\","
      "\"params\": [],"
      "\"returns\": \"string\""
    "}",
    "\"XBMC.GetInfoLabels\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve info labels about Kodi and the system\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"labels\", \"type\": \"array\", \"required\": true, \"items\": { \"type\": \"string\" }, \"minItems\": 1, \"description\": \"See http://kodi.wiki/view/InfoLabels for a list of possible info labels\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"description\": \"Object containing key-value pairs of the retrieved info labels\","
        "\"additionalProperties\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"XBMC.GetInfoBooleans\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve info booleans about Kodi and the system\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"booleans\", \"type\": \"array\", \"required\": true, \"items\": { \"type\": \"string\" }, \"minItems\": 1 }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"description\": \"Object containing key-value pairs of the retrieved info booleans\","
        "\"additionalProperties\": { \"type\": \"string\" }"
      "}"
    "}",
    "\"Favourites.GetFavourites\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieve all favourites\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"type\", \"type\": [ \"null\", { \"$ref\": \"Favourite.Type\" } ], \"default\": null },"
        "{ \"name\": \"properties\", \"$ref\": \"Favourite.Fields.Favourite\" }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"limits\": { \"$ref\": \"List.LimitsReturned\", \"required\": true },"
          "\"favourites\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Favourite.Details.Favourite\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Favourites.AddFavourite\": {"
      "\"type\": \"method\","
      "\"description\": \"Add a favourite with the given details\","
      "\"transport\": \"Response\","
      "\"permission\": \"UpdateData\","
      "\"params\": ["
        "{ \"name\": \"title\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"type\", \"$ref\": \"Favourite.Type\", \"required\": true },"
        "{ \"name\": \"path\", \"$ref\": \"Optional.String\", \"description\": \"Required for media and script favourites types\" },"
        "{ \"name\": \"window\", \"$ref\": \"Optional.String\", \"description\": \"Required for window favourite type\" },"
        "{ \"name\": \"windowparameter\", \"$ref\": \"Optional.String\" },"
        "{ \"name\": \"thumbnail\", \"$ref\": \"Optional.String\" }"
      "],"
      "\"returns\": \"string\""
    "}",
    "\"Settings.GetSections\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves all setting sections\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"level\", \"$ref\": \"Setting.Level\", \"default\": \"standard\" },"
        "{ \"name\": \"properties\", \"extends\": \"Item.Fields.Base\","
          "\"items\": { \"type\": \"string\","
            "\"enum\": [ \"categories\" ]"
          "}"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"sections\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Setting.Details.Section\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Settings.GetCategories\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves all setting categories\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"level\", \"$ref\": \"Setting.Level\", \"default\": \"standard\" },"
        "{ \"name\": \"section\", \"type\": \"string\", \"default\": \"\" },"
        "{ \"name\": \"properties\", \"extends\": \"Item.Fields.Base\","
          "\"items\": { \"type\": \"string\","
            "\"enum\": [ \"settings\" ]"
          "}"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"categories\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Setting.Details.Category\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Settings.GetSettings\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves all settings\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"level\", \"$ref\": \"Setting.Level\", \"default\": \"standard\" },"
        "{ \"name\": \"filter\", \"type\": ["
            "{ \"type\": \"object\","
              "\"properties\": {"
                "\"section\": { \"type\": \"string\", \"required\": true, \"minLength\": 1 },"
                "\"category\": { \"type\": \"string\", \"required\": true, \"minLength\": 1 }"
              "},"
              "\"additionalProperties\": false,"
              "\"required\": true"
            "}"
          "],"
          "\"default\": null"
        "}"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"settings\": { \"type\": \"array\","
            "\"items\": { \"$ref\": \"Setting.Details.Setting\" }"
          "}"
        "}"
      "}"
    "}",
    "\"Settings.GetSettingValue\": {"
      "\"type\": \"method\","
      "\"description\": \"Retrieves the value of a setting\","
      "\"transport\": \"Response\","
      "\"permission\": \"ReadData\","
      "\"params\": ["
        "{ \"name\": \"setting\", \"type\": \"string\", \"required\": true, \"minLength\": 1 }"
      "],"
      "\"returns\": {"
        "\"type\": \"object\","
        "\"properties\": {"
          "\"value\": { \"$ref\": \"Setting.Value.Extended\", \"required\": true }"
        "}"
      "}"
    "}",
    "\"Settings.SetSettingValue\": {"
      "\"type\": \"method\","
      "\"description\": \"Changes the value of a setting\","
      "\"transport\": \"Response\","
      "\"permission\": \"WriteSetting\","
      "\"params\": ["
        "{ \"name\": \"setting\", \"type\": \"string\", \"required\": true, \"minLength\": 1 },"
        "{ \"name\": \"value\", \"$ref\": \"Setting.Value.Extended\", \"required\": true }"
      "],"
      "\"returns\": \"boolean\""
    "}",
    "\"Settings.ResetSettingValue\": {"
      "\"type\": \"method\","
      "\"description\": \"Resets the value of a setting\","
      "\"transport\": \"Response\","
      "\"permission\": \"WriteSetting\","
      "\"params\": ["
        "{ \"name\": \"setting\", \"type\": \"string\", \"required\": true, \"minLength\": 1 }"
      "],"
      "\"returns\": \"string\""
    "}"
  };

  const char* const JSONRPC_SERVICE_NOTIFICATIONS[] = {  
    "\"Player.OnPlay\": {"
      "\"type\": \"notification\","
      "\"description\": \"Playback of a media item has been started or the playback speed has changed. If there is no ID available extra information will be provided.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"$ref\": \"Player.Notifications.Data\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"Player.OnPause\": {"
      "\"type\": \"notification\","
      "\"description\": \"Playback of a media item has been paused. If there is no ID available extra information will be provided.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"$ref\": \"Player.Notifications.Data\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"Player.OnStop\": {"
      "\"type\": \"notification\","
      "\"description\": \"Playback of a media item has been stopped. If there is no ID available extra information will be provided.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"item\": { \"$ref\": \"Notifications.Item\" },"
            "\"end\": { \"type\": \"boolean\", \"required\": true, \"description\": \"Whether the player has reached the end of the playable item(s) or not\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Player.OnSpeedChanged\": {"
      "\"type\": \"notification\","
      "\"description\": \"Speed of the playback of a media item has been changed. If there is no ID available extra information will be provided.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"$ref\": \"Player.Notifications.Data\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"Player.OnSeek\": {"
      "\"type\": \"notification\","
      "\"description\": \"The playback position has been changed. If there is no ID available extra information will be provided.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"item\": { \"$ref\": \"Notifications.Item\" },"
            "\"player\": { \"$ref\": \"Player.Notifications.Player.Seek\", \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Player.OnPropertyChanged\": {"
      "\"type\": \"notification\","
      "\"description\": \"A property of the playing items has changed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"property\": { \"$ref\": \"Player.Property.Value\" },"
            "\"player\": { \"$ref\": \"Player.Notifications.Player\", \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Playlist.OnAdd\": {"
      "\"type\": \"notification\","
      "\"description\": \"A playlist item has been added.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"playlistid\": { \"$ref\": \"Playlist.Id\", \"required\": true },"
            "\"item\": { \"$ref\": \"Notifications.Item\" },"
            "\"position\": { \"$ref\": \"Playlist.Position\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Playlist.OnRemove\": {"
      "\"type\": \"notification\","
      "\"description\": \"A playlist item has been removed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"playlistid\": { \"$ref\": \"Playlist.Id\", \"required\": true },"
            "\"position\": { \"$ref\": \"Playlist.Position\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Playlist.OnClear\": {"
      "\"type\": \"notification\","
      "\"description\": \"A playlist item has been cleared.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"playlistid\": { \"$ref\": \"Playlist.Id\", \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnUpdate\": {"
      "\"type\": \"notification\","
      "\"description\": \"An audio item has been updated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true },"
            "\"type\": { \"type\": \"string\", \"id\": \"Notifications.Library.Audio.Type\", \"enum\": [ \"song\" ], \"required\": true },"
            "\"transaction\": { \"$ref\": \"Optional.Boolean\", \"description\": \"True if the update is being performed within a transaction.\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnRemove\": {"
      "\"type\": \"notification\","
      "\"description\": \"An audio item has been removed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true },"
            "\"type\": { \"$ref\": \"Notifications.Library.Audio.Type\", \"required\": true },"
            "\"transaction\": { \"$ref\": \"Optional.Boolean\", \"description\": \"True if the removal is being performed within a transaction.\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnScanStarted\": {"
      "\"type\": \"notification\","
      "\"description\": \"An audio library scan has started.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnScanFinished\": {"
      "\"type\": \"notification\","
      "\"description\": \"Scanning the audio library has been finished.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnCleanStarted\": {"
      "\"type\": \"notification\","
      "\"description\": \"An audio library clean operation has started.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"AudioLibrary.OnCleanFinished\": {"
      "\"type\": \"notification\","
      "\"description\": \"The audio library has been cleaned.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnUpdate\": {"
      "\"type\": \"notification\","
      "\"description\": \"A video item has been updated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true },"
            "\"type\": { \"type\": \"string\", \"id\": \"Notifications.Library.Video.Type\", \"enum\": [ \"movie\", \"tvshow\", \"episode\", \"musicvideo\" ], \"required\": true },"
            "\"playcount\": { \"type\": \"integer\", \"minimum\": 0, \"default\": -1 },"
            "\"transaction\": { \"$ref\": \"Optional.Boolean\", \"description\": \"True if the update is being performed within a transaction.\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnRemove\": {"
      "\"type\": \"notification\","
      "\"description\": \"A video item has been removed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"id\": { \"$ref\": \"Library.Id\", \"required\": true },"
            "\"type\": { \"$ref\": \"Notifications.Library.Video.Type\", \"required\": true },"
            "\"transaction\": { \"$ref\": \"Optional.Boolean\", \"description\": \"True if the removal is being performed within a transaction.\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnScanStarted\": {"
      "\"type\": \"notification\","
      "\"description\": \"A video library scan has started.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnScanFinished\": {"
      "\"type\": \"notification\","
      "\"description\": \"Scanning the video library has been finished.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnCleanStarted\": {"
      "\"type\": \"notification\","
      "\"description\": \"A video library clean operation has started.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"VideoLibrary.OnCleanFinished\": {"
      "\"type\": \"notification\","
      "\"description\": \"The video library has been cleaned.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"System.OnQuit\": {"
      "\"type\": \"notification\","
      "\"description\": \"Kodi will be closed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"exitcode\": { \"type\": \"integer\", \"minimum\": 0, \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"System.OnRestart\": {"
      "\"type\": \"notification\","
      "\"description\": \"The system will be restarted.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"System.OnSleep\": {"
      "\"type\": \"notification\","
      "\"description\": \"The system will be suspended.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"System.OnWake\": {"
      "\"type\": \"notification\","
      "\"description\": \"The system woke up from suspension.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"System.OnLowBattery\": {"
      "\"type\": \"notification\","
      "\"description\": \"The system is on low battery.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"Application.OnVolumeChanged\": {"
      "\"type\": \"notification\","
      "\"description\": \"The volume of the application has changed.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"volume\": { \"type\": \"integer\", \"minimum\": 0, \"maximum\": 100, \"required\": true },"
            "\"muted\": { \"type\": \"boolean\", \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Input.OnInputRequested\": {"
      "\"type\": \"notification\","
      "\"description\": \"The user is requested to provide some information.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"type\": { \"type\": \"string\", \"enum\": [ \"keyboard\", \"time\", \"date\", \"ip\", \"password\", \"numericpassword\", \"number\", \"seconds\" ], \"required\": true },"
            "\"value\": { \"type\": \"string\", \"required\": true },"
            "\"title\": { \"type\": \"string\" }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"Input.OnInputFinished\": {"
      "\"type\": \"notification\","
      "\"description\": \"The user has provided the requested input.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"GUI.OnScreensaverActivated\": {"
      "\"type\": \"notification\","
      "\"description\": \"The screensaver has been activated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"GUI.OnScreensaverDeactivated\": {"
      "\"type\": \"notification\","
      "\"description\": \"The screensaver has been deactivated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"object\", \"required\": true,"
          "\"properties\": {"
            "\"shuttingdown\": { \"type\": \"boolean\", \"required\": true }"
          "}"
        "}"
      "],"
      "\"returns\": null"
    "}",
    "\"GUI.OnDPMSActivated\": {"
      "\"type\": \"notification\","
      "\"description\": \"Energy saving/DPMS has been activated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}",
    "\"GUI.OnDPMSDeactivated\": {"
      "\"type\": \"notification\","
      "\"description\": \"Energy saving/DPMS has been deactivated.\","
      "\"params\": ["
        "{ \"name\": \"sender\", \"type\": \"string\", \"required\": true },"
        "{ \"name\": \"data\", \"type\": \"null\", \"required\": true }"
      "],"
      "\"returns\": null"
    "}"
  };
}
