/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class AquaVectorTabControlIcon
extends VectorIcon {
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = AquaVectorTabControlIcon.populateInstances();
    private final int buttonId;
    private final int buttonState;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> map, int n, int n2) {
        int n3;
        int n4;
        switch (n) {
            case 1: {
                n4 = 14;
                n3 = 12;
                break;
            }
            case 11: 
            case 12: {
                n4 = 16;
                n3 = 16;
                break;
            }
            case 2: {
                n4 = 14;
                n3 = 12;
                break;
            }
            case 9: {
                n4 = 26;
                n3 = 15;
                break;
            }
            case 10: {
                n4 = 25;
                n3 = 15;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n4 = 20;
                n3 = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        map.put(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2), (Icon)((Object)new AquaVectorTabControlIcon(n, n2, n4, n3)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put("close", 1);
        linkedHashMap.put("pin", 2);
        linkedHashMap.put("restore_group", 11);
        linkedHashMap.put("slide_group", 12);
        linkedHashMap.put("scroll_left", 9);
        linkedHashMap.put("scroll_right", 10);
        linkedHashMap.put("drop_down", 8);
        linkedHashMap.put("maximize", 3);
        linkedHashMap.put("restore", 4);
        LinkedHashMap<String, Integer> linkedHashMap2 = new LinkedHashMap<String, Integer>();
        linkedHashMap2.put("default", 0);
        linkedHashMap2.put("pressed", 1);
        linkedHashMap2.put("disabled", 2);
        linkedHashMap2.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> linkedHashMap3 = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            for (Map.Entry entry2 : linkedHashMap2.entrySet()) {
                AquaVectorTabControlIcon.populateOne(linkedHashMap3, (Integer)entry.getValue(), (Integer)entry2.getValue());
            }
        }
        return Collections.unmodifiableMap(linkedHashMap3);
    }

    private AquaVectorTabControlIcon(int n, int n2, int n3, int n4) {
        super(n3, n4);
        this.buttonId = n;
        this.buttonState = n2;
    }

    public static Icon get(int n, int n2) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2));
    }

    protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        if (this.buttonId == 3 || this.buttonId == 4 || this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            this.paintLargerRectangleIcon(component, graphics2D, n, n2, d);
        } else if (this.buttonId == 1) {
            this.paintSmallCircleCloseIcon(component, graphics2D, n, n2, d);
        } else {
            this.paintSmallRectangleIcon(component, graphics2D, n, n2, d);
        }
    }

    private void paintSmallCircleCloseIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        double d2;
        double d3;
        double d4 = Math.min(n, n2);
        Color color = new Color(0, 0, 0, 0);
        Color color2 = new Color(0, 0, 0, 168);
        if (this.buttonState == 3) {
            color2 = Color.WHITE;
            color = new Color(125, 125, 125, 215);
        } else if (this.buttonState == 1) {
            color2 = Color.WHITE;
            color = new Color(105, 105, 105, 215);
        } else if (this.buttonState == 2) {
            color2 = new Color(0, 0, 0, 60);
        }
        if (color.getAlpha() > 0) {
            d3 = ((double)n - d4) / 2.0;
            d2 = ((double)n2 - d4) / 2.0;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d2, d4, d4);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        }
        graphics2D.setColor(color2);
        d3 = 1.4 * d;
        d2 = (double)n / 2.0;
        double d5 = (double)n2 / 2.0;
        double d6 = 0.45 * (d4 / 2.0);
        BasicStroke basicStroke = new BasicStroke((float)d3, 1, 1);
        Area area = new Area();
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d2 - d6, d5 - d6, d2 + d6, d5 + d6))));
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d2 + d6, d5 - d6, d2 - d6, d5 + d6))));
        graphics2D.fill(area);
    }

    private void paintSmallRectangleIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        Color color = new Color(0, 0, 0, 0);
        Color color2 = new Color(0, 0, 0, 168);
        if (this.buttonState == 2) {
            color2 = new Color(0, 0, 0, 60);
        } else if (this.buttonState == 3) {
            color = new Color(0, 0, 0, 51);
            color2 = Color.WHITE;
        } else if (this.buttonState == 1) {
            color = new Color(0, 0, 0, 94);
            color2 = Color.WHITE;
        }
        if (color.getAlpha() > 0) {
            double d2 = d * 6.0;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n, n2, d2, d2);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        }
        graphics2D.setColor(color2);
        if (this.buttonId == 11) {
            int n3 = AquaVectorTabControlIcon.round((double)(3.0 * d));
            int n4 = AquaVectorTabControlIcon.round((double)(3.0 * d));
            int n5 = AquaVectorTabControlIcon.round((double)(7.0 * d));
            int n6 = AquaVectorTabControlIcon.round((double)(6.0 * d));
            int n7 = n - n3 - n5;
            int n8 = n4;
            int n9 = Math.min((int)Math.floor((double)n7 - 2.0 * d), n3);
            int n10 = Math.max((int)Math.ceil((double)n8 + 2.0 * d), AquaVectorTabControlIcon.round((double)((double)n2 - 9.5 * d)));
            Area area = this.getWindowSymbol(d, n7, n8, n5, n6);
            Area area2 = this.getWindowSymbol(d, n9, n10, n5, n6);
            area.subtract(new Area(area2.getBounds2D()));
            graphics2D.fill(area);
            graphics2D.fill(area2);
        } else if (this.buttonId == 12) {
            int n11 = (int)(3.0 * d);
            int n12 = (int)(4.0 * d);
            int n13 = (int)(4.0 * d);
            Area area = this.getWindowSymbol(d, n11, n12, n - 2 * n11, n2 - n12 - n13);
            graphics2D.fill(area);
        } else if (this.buttonId == 2) {
            int n14 = (int)(3.0 * d);
            int n15 = (int)(2.0 * d);
            int n16 = (int)(2.0 * d);
            Area area = this.getWindowSymbol(d, n14, n15, n - 2 * n14, n2 - n15 - n16);
            graphics2D.fill(area);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void paintLargerRectangleIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        int n3;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        if (this.buttonState == 0) {
            color4 = new Color(191, 191, 191);
            color3 = new Color(135, 135, 135);
            color2 = new Color(81, 81, 81);
            color = new Color(48, 48, 48);
        } else if (this.buttonState == 1) {
            color4 = new Color(182, 182, 182);
            color3 = new Color(129, 129, 129);
            color2 = new Color(81, 81, 81);
            color = new Color(45, 45, 45);
        } else if (this.buttonState == 2) {
            color4 = new Color(166, 166, 166);
            color3 = new Color(137, 137, 137);
            color2 = new Color(111, 111, 111);
            color = new Color(97, 97, 97);
        } else if (this.buttonState == 3) {
            color4 = new Color(198, 198, 198);
            color3 = new Color(149, 149, 149);
            color2 = new Color(81, 81, 81);
            color = new Color(77, 77, 77);
        } else {
            throw new IllegalArgumentException();
        }
        int n4 = AquaVectorTabControlIcon.round((double)(0.6 * d));
        graphics2D.setPaint(new GradientPaint(new Point2D.Double(0.0, n4), color4, new Point2D.Double(0.0, n2 - n4), color3));
        int n5 = this.buttonId == 9 ? 1 : (this.buttonId == 10 ? -1 : 0);
        double d2 = d * 6.0;
        double d3 = (double)n5 * ((double)n4 + d2);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((double)n4 / 2.0 + (n5 < 0 ? d3 : 0.0), (double)n4 / 2.0, (double)(n - n4) + Math.abs(d3), n2 - n4, d2, d2);
        graphics2D.clipRect(0, 0, n, n2);
        graphics2D.fill(double_);
        graphics2D.setStroke(new BasicStroke(n4, 1, 1));
        graphics2D.setColor(color2);
        graphics2D.draw(double_);
        if (this.buttonId == 9) {
            graphics2D.fillRect(n - n4, 0, n4, n2);
            n3 = n - n4;
        } else {
            n3 = n;
        }
        graphics2D.setColor(color);
        if (this.buttonId == 3) {
            int n6 = AquaVectorTabControlIcon.round((double)(4.0 * d));
            int n7 = AquaVectorTabControlIcon.round((double)(3.0 * d));
            int n8 = AquaVectorTabControlIcon.round((double)(3.0 * d));
            graphics2D.fill(this.getWindowSymbol(d, n6, n7, n - 2 * n6, n2 - n7 - n8));
        } else if (this.buttonId == 4) {
            int n9 = AquaVectorTabControlIcon.round((double)(4.0 * d));
            int n10 = AquaVectorTabControlIcon.round((double)(2.0 * d));
            int n11 = AquaVectorTabControlIcon.round((double)(2.5 * d));
            int n12 = AquaVectorTabControlIcon.round((double)(9.0 * d));
            int n13 = AquaVectorTabControlIcon.round((double)(7.0 * d));
            int n14 = n - n9 - n12;
            int n15 = n10;
            int n16 = Math.min((int)Math.floor((double)n14 - 2.0 * d), n9);
            int n17 = Math.max(n15 + AquaVectorTabControlIcon.round((double)(2.7 * d)), n2 - n13 - n11);
            Area area = this.getWindowSymbol(d, n14, n15, n12, n13);
            Area area2 = this.getWindowSymbol(d, n16, n17, n12, n13);
            area.subtract(new Area(area2.getBounds2D()));
            graphics2D.fill(area);
            graphics2D.fill(area2);
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            double d4;
            double d5;
            if (this.buttonId == 9) {
                graphics2D.translate(AquaVectorTabControlIcon.round((double)(1.0 * d)), 0);
                graphics2D.rotate(1.5707963267948966, (double)n3 / 2.0, (double)n2 / 2.0);
            } else if (this.buttonId == 10) {
                graphics2D.translate(-AquaVectorTabControlIcon.round((double)(1.0 * d)), 0);
                graphics2D.rotate(-1.5707963267948966, (double)n3 / 2.0, (double)n2 / 2.0);
            }
            if (this.buttonId == 8) {
                d5 = 6.0 * d;
                d4 = 4.0 * d;
            } else {
                d5 = 6.7 * d;
                d4 = 3.8 * d;
            }
            int n18 = AquaVectorTabControlIcon.round((double)(((double)n2 - d4) / 2.0));
            double d6 = ((double)n3 - d5) / 2.0;
            double d7 = d6 + d5 / 2.0;
            Path2D.Double double_2 = new Path2D.Double();
            double_2.moveTo(d7 - d5 / 2.0, n18);
            double_2.lineTo(d7, (double)n18 + d4);
            double_2.lineTo(d7 + d5 / 2.0, n18);
            double_2.closePath();
            graphics2D.fill(double_2);
        }
    }

    private Area getWindowSymbol(double d, int n, int n2, int n3, int n4) {
        int n5 = AquaVectorTabControlIcon.round((double)(0.8 * d));
        int n6 = this.buttonId == 12 || this.buttonId == 2 ? n5 : Math.max(AquaVectorTabControlIcon.round((double)(1.6 * d)), n5 + n4 / 7);
        int n7 = AquaVectorTabControlIcon.round((double)n);
        int n8 = AquaVectorTabControlIcon.round((double)n2);
        Area area = new Area(new Rectangle2D.Double(n7, n8, n3, n4));
        area.subtract(new Area(new Rectangle2D.Double(n7 + n5, n8 + n6, n3 - n5 * 2, n4 - n5 - n6)));
        if (this.buttonId == 12) {
            area.add(new Area(new Rectangle2D.Double(n7 + n5 * 2, n8 + n4 - n5 * 4, AquaVectorTabControlIcon.round((double)((double)(n3 - n5 * 4) * 0.67)), n5 * 2)));
        } else if (this.buttonId == 2) {
            int n9 = AquaVectorTabControlIcon.round((double)((double)n3 * 0.3));
            int n10 = AquaVectorTabControlIcon.round((double)((double)n4 * 0.3));
            area.add(new Area(new Rectangle2D.Double(n7 + n9, n8 + n10, n3 - n9 * 2, n4 - n10 * 2)));
        }
        return area;
    }
}

