\name{JoinSeriesImageFilter}
\alias{JoinSeriesImageFilter}
\title{JoinSeriesImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Join N-D images into an (N+1)-D image.
JoinSeriesImageFilter}
\details{
This filter is templated over the input image type and the output
image type. The pixel type of them must be the same and the input
dimension must be less than the output dimension. When the input
images are N-dimensional, they are joined in order and the size of the
N+1'th dimension of the output is same as the number of the inputs.
The spacing and the origin (where the first input is placed) for the
N+1'th dimension is specified in this filter. The output image
information for the first N dimensions are taken from the first input.
Note that all the inputs should have the same information.
Hideaki Hiraki
 Contributed in the users list https://public.kitware.com/pipermail/insight-
users/2004-February/006542.html
See:
JoinSeries for the procedural interface
JoinSeriesImageFilter}
%C++ includes: sitkJoinSeriesImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOrigin() const:}{
Set/Get origin of the new dimension
}
\item{double GetSpacing() const:}{
Set/Get spacing of the new dimension
}
\item{ JoinSeriesImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetOrigin(double Origin):}{
Set/Get origin of the new dimension
}
\item{Self SetSpacing(double Spacing):}{
Set/Get spacing of the new dimension
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~JoinSeriesImageFilter():}{
Destructor
}
}
}
