!===============================================================================
! Copyright 2020-2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!*
!
!*  Content:
!*            Log10 example program text (OpenMP offload interface)
!*
!*******************************************************************************/

include "mkl_omp_offload.f90"
include "_vml_common_functions.f90"

! @brief Real single precision function test begin
integer (kind=4) function test_float(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float
    real      (kind=4),allocatable :: varg1(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(VLEN)
    integer   (kind=4) test_ref1(VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'41093E24', & ! 8.57767105
                     Z'4093852F', & ! 4.61000776
                     Z'41011D03', & ! 8.06958294
                     Z'41034C40'  / ! 8.20611572
    data test_ref1 / Z'3F6EF14C', & ! 0.933369398
                     Z'3F29E85A', & ! 0.663701653
                     Z'3F682765', & ! 0.906851113
                     Z'3F6A04ED'  / ! 0.914137661
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_float(test_arg1(i))
        vref1(i) = as_float(test_ref1(i))
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_float(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,vres1)
        !$omp dispatch 
        call vslog10(VLEN, varg1, vres1)
        !$omp end target data

        !$omp target data map(varg1,vmres1)
        !$omp dispatch 
        call vmslog10(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp dispatch 
        call vslog10i(VLEN_2, varg1, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,vmresi1)
        !$omp dispatch 
        call vmslog10i(VLEN_2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float = errs

end function
! @brief Real single precision function test end

! @brief Real double precision function test begin
integer (kind=4) function test_double(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double
    real      (kind=8),allocatable :: varg1(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(VLEN)
    integer   (kind=8) test_ref1(VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'402127C473A3E923', & ! 8.57767068267691535
                     Z'401270A5F32DAE19', & ! 4.6100080486899282
                     Z'402023A0651C4741', & ! 8.06958309145159269
                     Z'40206988134D9FDD'  / ! 8.20611629793705255
    data test_ref1 / Z'3FEDDE297029A3ED', & ! 0.933369368617716355
                     Z'3FE53D0B503006B0', & ! 0.663701683632288209
                     Z'3FED04EC97F0018B', & ! 0.906851097825027153
                     Z'3FED409DA344347E'  / ! 0.914137667541254251
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_double(test_arg1(i))
        vref1(i) = as_double(test_ref1(i))
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_double(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,vres1)
        !$omp dispatch 
        call vdlog10(VLEN, varg1, vres1)
        !$omp end target data

        !$omp target data map(varg1,vmres1)
        !$omp dispatch 
        call vmdlog10(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp dispatch 
        call vdlog10i(VLEN_2, varg1, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,vmresi1)
        !$omp dispatch 
        call vmdlog10i(VLEN_2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double = errs

end function
! @brief Real double precision function test end

! @brief Complex single precision function test begin
integer (kind=4) function test_float_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float_complex
    complex      (kind=4),allocatable :: varg1(:), vres1(:), vmres1(:), vref1(:)
    complex      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(2*VLEN)
    integer   (kind=4) test_ref1(2*VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'4093852F', Z'41093E24', & ! 4.61000776      + i * 8.57767105
                     Z'41034C40', Z'41011D03', & ! 8.20611572      + i * 8.06958294
                     Z'4036ECDE', Z'41136B29', & ! 2.85820723      + i * 9.21366215
                     Z'40FDFDE5', Z'4082ABE3'  / ! 7.93724298      + i * 4.08348227
    data test_ref1 / Z'3F7D0C5A', Z'3EEF9FB3', & ! 0.98846972      + i * 0.468015283
                     Z'3F87D028', Z'3EACC660', & ! 1.06103992      + i * 0.337450981
                     Z'3F7C0091', Z'3F0D3283', & ! 0.984383643     + i * 0.551551998
                     Z'3F735E76', Z'3E534F92'  / ! 0.95066011      + i * 0.206358224
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_float(test_arg1(2*i-1)), as_float(test_arg1(2*i)), 4)
        vref1(i) = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
            vresi1(i)  = CMPLX(999,999,4)
            vmresi1(i) = CMPLX(999,999,4)
        else
            vrefi1(i)  = CMPLX(777,777,4)
            vresi1(i)  = CMPLX(777,777,4)
            vmresi1(i) = CMPLX(777,777,4)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,vres1)
        !$omp dispatch 
        call vclog10(VLEN, varg1, vres1)
        !$omp end target data

        !$omp target data map(varg1,vmres1)
        !$omp dispatch 
        call vmclog10(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp dispatch 
        call vclog10i(VLEN_2, varg1, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,vmresi1)
        !$omp dispatch 
        call vmclog10i(VLEN_2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float_complex = errs

end function
! @brief Complex single precision function test end

! @brief Complex double precision function test begin
integer (kind=4) function test_double_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double_complex
    complex   (kind=8),allocatable :: varg1(:), vres1(:), vmres1(:), vref1(:)
    complex   (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(2*VLEN)
    integer   (kind=8) test_ref1(2*VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'401270A5F32DAE19', Z'402127C473A3E923', & ! 4.6100080486899282        + i * 8.57767068267691535
                     Z'40206988134D9FDD', Z'402023A0651C4741', & ! 8.20611629793705255       + i * 8.06958309145159269
                     Z'4006DD9BBAC0EE6B', Z'40226D6509CA7464', & ! 2.8582071867111174        + i * 9.21366148563738108
                     Z'401FBFBCBB737F7A', Z'4010557C717977C6'  / ! 7.93724339382594657       + i * 4.0834825258625127
    data test_ref1 / Z'3FEFA18B2F6F5838', Z'3FDDF3F652C92C68', & ! 0.988469689031950871      + i * 0.468015271039524894
                     Z'3FF0FA0504CCAB8B', Z'3FD598CBF8E47D48', & ! 1.06103994250108502       + i * 0.337450974520795643
                     Z'3FEF80121DF1D266', Z'3FE1A6505C169339', & ! 0.984383638845042652      + i * 0.551551990375265366
                     Z'3FEE6BCEC337BC1A', Z'3FCA69F241F4C86C'  / ! 0.950660115513417781      + i * 0.206358225064437462
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_double(test_arg1(2*i-1)), as_double(test_arg1(2*i)), 8)
        vref1(i) = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
            vresi1(i)  = CMPLX(999,999,8)
            vmresi1(i) = CMPLX(999,999,8)
        else
            vrefi1(i)  = CMPLX(777,777,8)
            vresi1(i)  = CMPLX(777,777,8)
            vmresi1(i) = CMPLX(777,777,8)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,vres1)
        !$omp dispatch 
        call vzlog10(VLEN, varg1, vres1)
        !$omp end target data

        !$omp target data map(varg1,vmres1)
        !$omp dispatch 
        call vmzlog10(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp dispatch 
        call vzlog10i(VLEN_2, varg1, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,vmresi1)
        !$omp dispatch 
        call vmzlog10i(VLEN_2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double_complex(i, VML_ARG1_RES1, varg1(i), varg1(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double_complex = errs

end function
! @brief Complex double precision function test end

! @brief Main test program begin
program log10_example

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    integer   (kind=4) :: blend_int32
    integer   (kind=4) :: test_float
    integer   (kind=4) :: test_float_complex
    integer   (kind=4) :: test_double
    integer   (kind=4) :: test_double_complex
    integer   (kind=4) errs, total_errs, exit_status
    character (len = *), parameter :: funcname = "log10"

    total_errs = 0

    data FLOAT_MAXULP /FLOAT_MAXULP_HA,FLOAT_MAXULP_LA,FLOAT_MAXULP_EP/
    data COMPLEX_FLOAT_MAXULP /FLOAT_COMPLEX_MAXULP_HA,FLOAT_COMPLEX_MAXULP_LA,FLOAT_COMPLEX_MAXULP_EP/
    data DOUBLE_MAXULP /DOUBLE_MAXULP_HA,DOUBLE_MAXULP_LA,DOUBLE_MAXULP_EP/
    data COMPLEX_DOUBLE_MAXULP /7D7,7D7,7D7/

    write (*, 111) funcname
    111 format ('Running ', A, ' functions:')

    ! Single precision test run begin
    write (*, 112) TAB, funcname
    112 format(A, 'Running ',  A, ' with single precision real data type:')
    errs = test_float(funcname)
    total_errs = total_errs + errs
    write (*, 113) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    113 format(A, A, ' single precision real result: ', A)
    ! Single precision test run end

    ! Real double precision test run begin
    write (*, 117) TAB, funcname
    117 format(A, 'Running ',  A, ' with double precision real data type:')
    errs = test_double(funcname)
    total_errs = total_errs + errs
    write (*, 118) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    118 format(A, A, ' double precision real result: ', A)
    ! Real double precision test run end

    ! Single precision complex test run begin
    write (*, 115) TAB, funcname
    115 format(A, 'Running ',  A, ' with single precision complex data type:')
    errs = test_float_complex(funcname)
    total_errs = total_errs + errs
    write (*, 116) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    116 format(A, A, ' single precision complex result: ', A)
    ! Single precision complex test run end

    ! Complex double precision test run begin
    write (*, 119) TAB, funcname
    119 format(A, 'Running ',  A, ' with double precision complex data type:')
    errs = test_double_complex(funcname)
    total_errs = total_errs + errs
    write (*, 120) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    120 format(A, A, ' double precision complex result: ', A)
    ! Complex double precision  test run end

    write (*, 121) funcname, TEST_RESULT(blend_int32((total_errs>0),2,1))
    121 format(A, ' function result: ', A)

    exit_status = 0
    if (total_errs .ne. 0) then
         exit_status = 1
    endif
    stop exit_status
end program
! @brief Main test program end
