/*******************************************************************************
* Copyright 2018 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*
*******************************************************************************/

#ifndef PIFILILS_T_H__
#define PIFILILS_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippvm.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_t.h"
#include "owni_tl.h"

#ifdef USE_OMP
#include <omp.h>
#endif

typedef struct ILSDFTContext_32f ilsDFTContext_32f;
typedef struct {
    int                 lengthX;
    int                 lengthY;
    IppHintAlgorithm    hint;
    int                 bufSize;
    int                 nThreads;
    ilsDFTContext_32f *ctxDFT_C_Y;
    ilsDFTContext_32f *ctxDFT_R_X;
    ilsDFTContext_32f *ctxDFT_R_Y;
} IlsDFTContext_32f;

struct FilterILSSpec {
    IppiFilterBilateralType filter;
    IppiDistanceMethodType  distMethod;
    IppDataType             dataType;
    int                     nChannels;
    int                     radius;
    float                   valSquareSigma;
    float                   posSquareSigma;

    IlsDFTContext_32f* pDFTSpec;
    float* pDenorminInv;
    float lambda;
    double eps;
    double p;
    double gamma;
    double c;
};
typedef struct {
    Ipp32f*  pSrc1;
    Ipp32f*  pSrc2;
    int      src1Step;
    int      src2Step;
    Ipp32f*  pDst;
    int      dstStep;
    IppiSize roi;
    int      nThreads;
    int      threadLen;
    int      tail;
    Ipp32f   c;
    Ipp32f   p;
    Ipp32f   gamma;
    Ipp32f   eps;
    IppiFilterILSType filter;
    Ipp32f   val;
    int      n;                //for mulpack
    IlsDFTContext_32f *ctxDFT;//for dft
    Ipp8u* buf;                //for dft

} ils_info_t;

#define ALGN64( x )  ((( x ) + 63 )&( ~63 ))
#define ALIGNED_ADDR(ptr)  IPP_ALIGNED_PTR(ptr, 64)
#define RESERVE_SIZE       64
#define USE_THREADS(lenX, lenY) (lenX>=128 && lenY>128)
#define BIG_IMAGE(lenX,LenY)   (lenX>=128 && lenY>128)
#define MULRE(A,B) (A.re * B.re - A.im * B.im)
#define MULIM(A,B) (A.re * B.im + A.im * B.re)

#endif // PIFILILS_T_H__
