!===============================================================================
! Copyright 2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

#include "mkl_omp_offload.f90"

program dgels_batch_strided_example

#ifdef MKL_ILP64
    use onemkl_lapack_omp_offload_ilp64
#else
    use onemkl_lapack_omp_offload_lp64
#endif

#define v(x) (x##d0)

    integer, parameter :: m = 5, n = 5, nrhs = 1, lda = m, stride_a = n*lda, ldb = m, stride_b = nrhs*ldb, batch_size = 2
    integer i, j, num_errors

    double precision :: A(stride_a*batch_size) = (/ &
        v( 1.0 ), v(  0.0 ), v(  0.0 ), v(  0.0 ), v(  0.0 ), &
        v( 1.0 ), v(  0.2 ), v( -0.4 ), v( -0.4 ), v( -0.8 ), &
        v( 1.0 ), v(  0.6 ), v( -0.2 ), v(  0.4 ), v( -1.2 ), &
        v( 1.0 ), v(  1.0 ), v( -1.0 ), v(  0.6 ), v( -0.8 ), &
        v( 1.0 ), v(  1.8 ), v( -0.6 ), v(  0.2 ), v( -0.6 )  &
                                                            , &
        v( 0.2 ), v( -0.4 ), v( -0.4 ), v( -0.8 ), v(  0.0 ), &
        v( 0.4 ), v(  0.2 ), v(  0.8 ), v( -0.4 ), v(  0.0 ), &
        v( 0.4 ), v( -0.8 ), v(  0.2 ), v(  0.4 ), v(  0.0 ), &
        v( 0.8 ), v(  0.4 ), v( -0.4 ), v(  0.2 ), v(  0.0 ), &
        v( 0.0 ), v(  0.0 ), v(  0.0 ), v(  0.0 ), v(  1.0 )  &
    /)

    double precision :: B(stride_b*batch_size) = (/ &
        v( 5.0 ), v(  3.6 ), v( -2.2 ), v(  0.8 ), v( -3.4 )  &
                                                            , &
        v( 1.8 ), v( -0.6 ), v(  0.2 ), v( -0.6 ), v(  1.0 )  &
    /)

    double precision :: X(n*batch_size) = (/ &
        v( 1.0 ), v(  1.0 ), v(  1.0 ), v(  1.0 ), v(  1.0 )  &
                                                            , &
        v( 1.0 ), v(  1.0 ), v(  1.0 ), v(  1.0 ), v(  1.0 )  &
    /)

    integer :: info(batch_size) = -1

    !$omp target data map(A, B, info)
    !$omp dispatch
    call dgels_batch_strided('N', m, n, nrhs, A, lda, stride_a, B, ldb, stride_b, batch_size, info)
    !$omp end target data

    if (count(info/=0)) then
        print '("ERROR: Calculations failed with non-zeroes in info array:")'
        print '(*(I4))', info
        stop 1
    end if

    num_errors = 0
    print '("Results:")'
    do i = 1, stride_b*batch_size, stride_b
        print '(*(G11.4))', B(i:i+n-1)
        do j = 1, n
            if ((isnan(B(i+j-1))).or.(abs(B(i+j-1)-X(i+j-1))).gt.(1e-8)) then
                num_errors = num_errors+1
            end if
        end do
    end do

    if (num_errors.gt.0) then
        print '("ERROR: results mismatch!")'
        print '("Expected:")'
        do i = 1, batch_size
            print '(*(G11.4))', real(X((i-1)*n+1:i*n))
        end do
        stop 1
    else
        print '("Calculations successfully finished")'
    end if

end program
