#!/system/bin/sh
#
# Copyright (C) 2004 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

# =============================================================================
# Filename: sep_vars.sh
# Version: 1.02
# Purpose: SEP Android Runtime environment setup script
# Description: This script should be used to set up the Android OS run-time environment
#              for SEP.  It requires sh.  Run this script before running any
#              SEP executable, e.g., sep or sfdump5
#
# Usage: source sep_vars.sh
# =============================================================================

export SEP_INSTALL_PATH=`pwd`
export SEP_INSTALL_PATH="${SEP_INSTALL_PATH}/bin"
export SEP_BASE_DIR="${SEP_INSTALL_PATH}"
echo "SEP_BASE_DIR=${SEP_BASE_DIR}"

if [ $# -gt 1 ];
then
    echo "Invalid args: Format sep_vars.sh [-no-install]"
    exit 1
elif [ $# -eq 1 ]; then
    if [ "$1" != "-no-install" ]; then
      echo "Invalid args: Format sep_vars.sh [-no-install]"
      exit 1
    fi
fi


function insmod_if_necessary {
    module=$1
    modfile=${module}.ko

    ok=`lsmod | grep $module`
    if [[ -z "$ok" ]]; then
        if [ -f "/system/lib/modules/$modfile" ]; then
            insmod /system/lib/modules/$modfile
        elif then
            insmod /vendor/lib/modules/$modfile
        else
            insmod /lib/modules/$modfile
        fi
        if [ "$?" -eq "0" ]; then
            echo "$module module loaded"
        fi
    fi
}

if [ -f /proc/sys/kernel/nmi_watchdog ]; then
    echo 0 > /proc/sys/kernel/nmi_watchdog
fi

if [ $# -eq 0 ]; then
    insmod_if_necessary pax
    insmod_if_necessary socperf3
    insmod_if_necessary sep5
fi

if [ -z ${PATH} ]; then
    export PATH="${SEP_INSTALL_PATH}"
else
    export PATH="${SEP_INSTALL_PATH}:${PATH}"
fi
if [ -z ${LD_LIBRARY_PATH} ]; then
    export LD_LIBRARY_PATH="${SEP_INSTALL_PATH}"
else
    export LD_LIBRARY_PATH="${SEP_INSTALL_PATH}:${LD_LIBRARY_PATH}"
fi

# show settings of various environment variables
echo SEP is currently installed under $SEP_INSTALL_PATH
echo "PATH=${PATH}"
echo "LD_LIBRARY_PATH=${LD_LIBRARY_PATH}"
