<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:param name="suffix" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown{$suffix}" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>
                        <xsl:text>/RetiredPipelineSlots</xsl:text>
                        <xsl:value-of select="$suffix" />
                    </queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="BASEGroup">
                                <queryInherit>
                                    <xsl:text>/BASE</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BASEGroupExpanded">
                                        <derivedQuery id="FP_ArithGroup">
                                            <queryInherit>
                                                <xsl:text>/FP_Arith</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FP_ArithGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/FP_x87</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/FP_Scalar</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/FP_Vector</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>
                                            <xsl:text>/OTHER</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MicroSequencerGroup">
                                <queryInherit>
                                    <xsl:text>/MicroSequencer</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MicroSequencerGroupExpanded">
                                        <queryRef>
                                            <xsl:text>/Assists</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>
                        <xsl:text>/FrontendBoundPipelineSlots</xsl:text>
                        <xsl:value-of select="$suffix" />
                    </queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>
                                    <xsl:text>/FELatency</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>
                                            <xsl:text>/ICacheMisses</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/ITLBOverhead</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <derivedQuery id="BranchResteersGroup">
                                            <queryInherit>
                                                <xsl:text>/BranchResteers</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="BranchResteersGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/Mispredicts_Resteers</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/Clears_Resteers</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/Unknown_Branches</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>
                                            <xsl:text>/DSBtoMITESwitchCost</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/LCP</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/MSSwitches</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>
                                    <xsl:text>/FEBandwidth</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>
                                            <xsl:text>/FEBandwidthMITE</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/FEBandwidthDSB</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/FEBandwidthLSD</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/DSB_Coverage</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/LSD_Coverage</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>
                        <xsl:text>/CancelledPipelineSlots</xsl:text>
                        <xsl:value-of select="$suffix" />
                    </queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>
                                <xsl:text>/BranchMispredict</xsl:text>
                                <xsl:value-of select="$suffix" />
                            </queryRef>
                            <queryRef>
                                <xsl:text>/MachineClears</xsl:text>
                                <xsl:value-of select="$suffix" />
                            </queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>
                        <xsl:text>/BackendBound</xsl:text>
                        <xsl:value-of select="$suffix" />
                    </queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>
                                    <xsl:text>/MemBound</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <derivedQuery id="L1BoundGroup">
                                            <queryInherit>
                                                <xsl:text>/L1Bound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L1BoundGroupExpanded">
                                                    <derivedQuery id="DTLBOverheadGroup">
                                                        <queryInherit>
                                                            <xsl:text>/DTLBOverhead</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="DTLBOverheadGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/Load_STLB_Hit</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/Load_STLB_Miss</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>
                                                        <xsl:text>/LoadsBlockedbyStoreForwarding</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/LockLatency</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/SplitLoads</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/4KAliasing</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/FBFull</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>
                                            <xsl:text>/L2Bound</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <derivedQuery id="L3BoundGroup">
                                            <queryInherit>
                                                <xsl:text>/L3Bound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L3BoundGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/ContestedAccesses</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/DataSharing</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/L3Latency</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/SQFull</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="DRAMBoundGroup">
                                            <queryInherit>
                                                <xsl:text>/DRAMBound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="DRAMBoundGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/MEMBandwidth</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="MEMLatencyGroup">
                                                        <queryInherit>
                                                            <xsl:text>/MEMLatency</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="MEMLatencyGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/LocalDRAM</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/RemoteDRAM</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/RemoteCache</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <xsl:if test="$is3DXOn">
                                            <queryRef>
                                                <xsl:text>/IXP_Bound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryRef>
                                        </xsl:if>
                                        <derivedQuery id="StoresBoundGroup">
                                            <queryInherit>
                                                <xsl:text>/StoresBound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="StoresBoundGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/StoreLatency</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/FalseSharing</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/SplitStores</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="DTLBStoreOverheadGroup">
                                                        <queryInherit>
                                                            <xsl:text>/DTLBStoreOverhead</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="DTLBStoreOverheadGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/Store_STLB_Hit</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/Store_STLB_Miss</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>
                                    <xsl:text>/CoreBound</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <queryRef>
                                            <xsl:text>/DIVActive</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <derivedQuery id="PortUtilGroup">
                                            <queryInherit>
                                                <xsl:text>/PortUtil</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="PortUtilGroupExpanded">
                                                    <derivedQuery id="Cycles0PortsUtilizedGroup">
                                                        <queryInherit>
                                                            <xsl:text>/Cycles0PortsUtilized</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Cycles0PortsUtilizedGroupExpanded">
                                                                <derivedQuery id="Serializing_OperationGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/Serializing_Operation</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Serializing_OperationGroupExpanded">
                                                                            <queryRef>
                                                                                <xsl:text>/Slow_Pause</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>
                                                        <xsl:text>/Cycles1PortUtilized</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/Cycles2PortsUtilized</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="Cycles3mPortsUtilizedGroup">
                                                        <queryInherit>
                                                            <xsl:text>/Cycles3mPortsUtilized</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Cycles3mPortsUtilizedGroupExpanded">
                                                                <derivedQuery id="ALU_Op_UtilizationGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/ALU_Op_Utilization</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="ALU_Op_UtilizationGroupExpanded">
                                                                            <queryRef>
                                                                                <xsl:text>/Port0</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/Port1</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/Port5</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/Port6</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="Load_Op_UtilizationGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/Load_Op_Utilization</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Load_Op_UtilizationGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="Store_Op_UtilizationGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/Store_Op_Utilization</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="Store_Op_UtilizationGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="BASE{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith{$suffix}">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="FP_x87{$suffix}">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="FP_Scalar{$suffix}">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="FP_Vector{$suffix}">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER{$suffix}">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="Assists{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="Mispredicts_Resteers{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="Clears_Resteers{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="Unknown_Branches{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="DSBtoMITESwitchCost{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="LCP{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="MSSwitches{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="FEBandwidthMITE{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="FEBandwidthDSB{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="FEBandwidthLSD{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="DSB_Coverage{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Coverage" id="LSD_Coverage{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%LSD_CoverageDescriptionAll</description>
                    <helpKeyword>configs.lsd_coverage_lsd_coveragedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="DTLBOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="LockLatency{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="SplitLoads{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%4KAliasing" id="4KAliasing{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%4KAliasingDescriptionAll</description>
                    <helpKeyword>configs.4kaliasing_4kaliasingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="FBFull{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="ContestedAccesses{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="DataSharing{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="L3Latency{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="SQFull{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="MEMBandwidth{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="MEMLatency{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LocalDRAM" id="LocalDRAM{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LocalDRAMDescriptionAll</description>
                    <helpKeyword>configs.localdram_localdramdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%RemoteDRAM" id="RemoteDRAM{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%RemoteDRAMDescriptionAll</description>
                    <helpKeyword>configs.remotedram_remotedramdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="RemoteCache{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%RemoteCacheDescriptionAll</description>
                    <helpKeyword>configs.remotecache_remotecachedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%IXP_Bound" id="IXP_Bound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%IXP_BoundDescriptionAll</description>
                    <helpKeyword>configs.ixp_bound_ixp_bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="StoreLatency{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="FalseSharing{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="SplitStores{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="DTLBStoreOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="Store_STLB_Hit{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="Store_STLB_Miss{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound{$suffix}">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="DIVActive{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="PortUtil{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="Cycles0PortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="Slow_Pause{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="Cycles1PortUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="Cycles2PortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="Cycles3mPortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="ALU_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="Port0{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="Port1{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="Port5{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port5DescriptionAll</description>
                    <helpKeyword>configs.port5_port5descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="Port6{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="Load_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="Store_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port4" id="Port4">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS{$suffix}">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="CORE_CLKS{$suffix}">
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_Miss_Real_Latency" id="Load_Miss_Real_Latency{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Load_Miss_Real_LatencyDescriptionAll</description>
                    <helpKeyword>configs.load_miss_real_latency_load_miss_real_latencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="Fetched_Uops{$suffix}">
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="ORO_DRD_Any_Cycles{$suffix}">
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="ORO_DRD_BW_Cycles{$suffix}">
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_Demand_RFO_C1" id="ORO_Demand_RFO_C1{$suffix}">
                    <description>%ORO_Demand_RFO_C1DescriptionAll</description>
                    <helpKeyword>configs.oro_demand_rfo_c1_oro_demand_rfo_c1descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_L2_Hit_Cycles" id="Store_L2_Hit_Cycles{$suffix}">
                    <description>%Store_L2_Hit_CyclesDescriptionAll</description>
                    <helpKeyword>configs.store_l2_hit_cycles_store_l2_hit_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L1_MISS_NET" id="LOAD_L1_MISS_NET{$suffix}">
                    <description>%LOAD_L1_MISS_NETDescriptionAll</description>
                    <helpKeyword>configs.load_l1_miss_net_load_l1_miss_netdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L2_HIT" id="LOAD_L2_HIT{$suffix}">
                    <description>%LOAD_L2_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l2_hit_load_l2_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L3_HIT" id="LOAD_L3_HIT{$suffix}">
                    <description>%LOAD_L3_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l3_hit_load_l3_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HIT" id="LOAD_XSNP_HIT{$suffix}">
                    <description>%LOAD_XSNP_HITDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hit_load_xsnp_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HITM" id="LOAD_XSNP_HITM{$suffix}">
                    <description>%LOAD_XSNP_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hitm_load_xsnp_hitmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_MISS" id="LOAD_XSNP_MISS{$suffix}">
                    <description>%LOAD_XSNP_MISSDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_miss_load_xsnp_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_LCL_MEM" id="LOAD_LCL_MEM{$suffix}">
                    <description>%LOAD_LCL_MEMDescriptionAll</description>
                    <helpKeyword>configs.load_lcl_mem_load_lcl_memdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_LCL_PMM" id="LOAD_LCL_PMM{$suffix}">
                    <description>%LOAD_LCL_PMMDescriptionAll</description>
                    <helpKeyword>configs.load_lcl_pmm_load_lcl_pmmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_PMM" id="LOAD_RMT_PMM{$suffix}">
                    <description>%LOAD_RMT_PMMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_pmm_load_rmt_pmmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_MEM" id="LOAD_RMT_MEM{$suffix}">
                    <description>%LOAD_RMT_MEMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_mem_load_rmt_memdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_HITM" id="LOAD_RMT_HITM{$suffix}">
                    <description>%LOAD_RMT_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_hitm_load_rmt_hitmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_FWD" id="LOAD_RMT_FWD{$suffix}">
                    <description>%LOAD_RMT_FWDDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_fwd_load_rmt_fwddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="Few_Uops_Executed_Threshold{$suffix}">
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="Core_Bound_Cycles{$suffix}">
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="Backend_Bound_Cycles{$suffix}">
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="Memory_Bound_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L2_Bound_Ratio" id="L2_Bound_Ratio{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%L2_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.l2_bound_ratio_l2_bound_ratiodescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="MEM_Bound_Ratio{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_DDR_Hit_Fraction" id="Mem_DDR_Hit_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_DDR_Hit_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_ddr_hit_fraction_mem_ddr_hit_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Lock_St_Fraction" id="Mem_Lock_St_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Lock_St_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_lock_st_fraction_mem_lock_st_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="Mispred_Clears_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="Retire_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%True_XSNP_HitM_Fraction" id="True_XSNP_HitM_Fraction{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%True_XSNP_HitM_FractionDescriptionAll</description>
                    <helpKeyword>configs.true_xsnp_hitm_fraction_true_xsnp_hitm_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Store_Cost" id="Mem_L2_Store_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_L2_Store_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_store_cost_mem_l2_store_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_STLB_Hit_Cost" id="Mem_STLB_Hit_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_STLB_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_stlb_hit_cost_mem_stlb_hit_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_HitM_Cost" id="Mem_XSNP_HitM_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_XSNP_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hitm_cost_mem_xsnp_hitm_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_XSNP_Hit_Cost" id="MEM_XSNP_Hit_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_XSNP_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hit_cost_mem_xsnp_hit_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_XSNP_None_Cost" id="MEM_XSNP_None_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_XSNP_None_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_none_cost_mem_xsnp_none_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Local_DRAM_Cost" id="Mem_Local_DRAM_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Local_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_local_dram_cost_mem_local_dram_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_DRAM_Cost" id="Mem_Remote_DRAM_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Remote_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_dram_cost_mem_remote_dram_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_HitM_Cost" id="Mem_Remote_HitM_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Remote_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_hitm_cost_mem_remote_hitm_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_Fwd_Cost" id="Mem_Remote_Fwd_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_Remote_Fwd_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_fwd_cost_mem_remote_fwd_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BAClear_Cost" id="BAClear_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%BAClear_CostDescriptionAll</description>
                    <helpKeyword>configs.baclear_cost_baclear_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="MS_Switches_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Avg_Assist_Cost" id="Avg_Assist_Cost{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Avg_Assist_CostDescriptionAll</description>
                    <helpKeyword>configs.avg_assist_cost_avg_assist_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%OneMillion" id="OneMillion{$suffix}">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%OneMillionDescriptionAll</description>
                    <helpKeyword>configs.onemillion_onemilliondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="Retired_Slots{$suffix}">
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%UPC" id="UPC{$suffix}">
                    <description>%UPCDescriptionAll</description>
                    <helpKeyword>configs.upc_upcdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%PMM_App_Direct" id="PMM_App_Direct{$suffix}">
                    <xsl:choose>
                        <xsl:when test="$is3DXOn">
                            <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                            <description>%PMM_App_DirectDescriptionAll</description>
                            <helpKeyword>configs.pmm_app_direct_pmm_app_directdescriptionall</helpKeyword>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>0</valueEval>
                            <queryInherit>/GeMetricNA</queryInherit>
                        </xsl:otherwise>
                    </xsl:choose>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown{$suffix}" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>
                                    <xsl:text>/locatorRetiredPipelineSlots</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBASEGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorBASE</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBASEGroupExpanded">
                                                    <derivedQuery id="locatorFP_ArithGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorFP_Arith</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFP_ArithGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/locatorFP_x87</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorFP_Scalar</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorFP_Vector</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>
                                                        <xsl:text>/locatorOTHER</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMicroSequencerGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorMicroSequencer</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMicroSequencerGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/locatorAssists</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>
                                    <xsl:text>/locatorFrontendBoundPipelineSlots</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorFELatency</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/locatorICacheMisses</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorITLBOverhead</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="locatorBranchResteersGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorBranchResteers</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorBranchResteersGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/locatorMispredicts_Resteers</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorClears_Resteers</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorUnknown_Branches</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>
                                                        <xsl:text>/locatorDSBtoMITESwitchCost</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorLCP</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorMSSwitches</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorFEBandwidth</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/locatorFEBandwidthMITE</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorFEBandwidthDSB</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorFEBandwidthLSD</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorDSB_Coverage</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <queryRef>
                                                        <xsl:text>/locatorLSD_Coverage</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>
                                    <xsl:text>/locatorCancelledPipelineSlots</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>
                                            <xsl:text>/locatorBranchMispredict</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                        <queryRef>
                                            <xsl:text>/locatorMachineClears</xsl:text>
                                            <xsl:value-of select="$suffix" />
                                        </queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>
                                    <xsl:text>/locatorBackendBound</xsl:text>
                                    <xsl:value-of select="$suffix" />
                                </queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorMemBound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorL1Bound</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <derivedQuery id="locatorDTLBOverheadGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/locatorDTLBOverhead</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBOverheadGroupExpanded">
                                                                            <queryRef>
                                                                                <xsl:text>/locatorLoad_STLB_Hit</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/locatorLoad_STLB_Miss</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>
                                                                    <xsl:text>/locatorLoadsBlockedbyStoreForwarding</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorLockLatency</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorSplitLoads</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locator4KAliasing</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorFBFull</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>
                                                        <xsl:text>/locatorL2Bound</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="locatorL3BoundGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorL3Bound</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL3BoundGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/locatorContestedAccesses</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorDataSharing</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorL3Latency</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorSQFull</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorDRAMBoundGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorDRAMBound</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorDRAMBoundGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/locatorMEMBandwidth</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <derivedQuery id="locatorMEMLatencyGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/locatorMEMLatency</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMLatencyGroupExpanded">
                                                                            <queryRef>
                                                                                <xsl:text>/locatorLocalDRAM</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/locatorRemoteDRAM</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/locatorRemoteCache</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <xsl:if test="$is3DXOn">
                                                        <queryRef>
                                                            <xsl:text>/locatorIXP_Bound</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryRef>
                                                    </xsl:if>
                                                    <derivedQuery id="locatorStoresBoundGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorStoresBound</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorStoresBoundGroupExpanded">
                                                                <queryRef>
                                                                    <xsl:text>/locatorStoreLatency</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorFalseSharing</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorSplitStores</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <derivedQuery id="locatorDTLBStoreOverheadGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/locatorDTLBStoreOverhead</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorDTLBStoreOverheadGroupExpanded">
                                                                            <queryRef>
                                                                                <xsl:text>/locatorStore_STLB_Hit</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                            <queryRef>
                                                                                <xsl:text>/locatorStore_STLB_Miss</xsl:text>
                                                                                <xsl:value-of select="$suffix" />
                                                                            </queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>
                                                <xsl:text>/locatorCoreBound</xsl:text>
                                                <xsl:value-of select="$suffix" />
                                            </queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <queryRef>
                                                        <xsl:text>/locatorDIVActive</xsl:text>
                                                        <xsl:value-of select="$suffix" />
                                                    </queryRef>
                                                    <derivedQuery id="locatorPortUtilGroup">
                                                        <queryInherit>
                                                            <xsl:text>/locatorPortUtil</xsl:text>
                                                            <xsl:value-of select="$suffix" />
                                                        </queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorPortUtilGroupExpanded">
                                                                <derivedQuery id="locatorCycles0PortsUtilizedGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/locatorCycles0PortsUtilized</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles0PortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="locatorSerializing_OperationGroup">
                                                                                <queryInherit>
                                                                                    <xsl:text>/locatorSerializing_Operation</xsl:text>
                                                                                    <xsl:value-of select="$suffix" />
                                                                                </queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorSerializing_OperationGroupExpanded">
                                                                                        <queryRef>
                                                                                            <xsl:text>/locatorSlow_Pause</xsl:text>
                                                                                            <xsl:value-of select="$suffix" />
                                                                                        </queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>
                                                                    <xsl:text>/locatorCycles1PortUtilized</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <queryRef>
                                                                    <xsl:text>/locatorCycles2PortsUtilized</xsl:text>
                                                                    <xsl:value-of select="$suffix" />
                                                                </queryRef>
                                                                <derivedQuery id="locatorCycles3mPortsUtilizedGroup">
                                                                    <queryInherit>
                                                                        <xsl:text>/locatorCycles3mPortsUtilized</xsl:text>
                                                                        <xsl:value-of select="$suffix" />
                                                                    </queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorCycles3mPortsUtilizedGroupExpanded">
                                                                            <derivedQuery id="locatorALU_Op_UtilizationGroup">
                                                                                <queryInherit>
                                                                                    <xsl:text>/locatorALU_Op_Utilization</xsl:text>
                                                                                    <xsl:value-of select="$suffix" />
                                                                                </queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorALU_Op_UtilizationGroupExpanded">
                                                                                        <queryRef>
                                                                                            <xsl:text>/locatorPort0</xsl:text>
                                                                                            <xsl:value-of select="$suffix" />
                                                                                        </queryRef>
                                                                                        <queryRef>
                                                                                            <xsl:text>/locatorPort1</xsl:text>
                                                                                            <xsl:value-of select="$suffix" />
                                                                                        </queryRef>
                                                                                        <queryRef>
                                                                                            <xsl:text>/locatorPort5</xsl:text>
                                                                                            <xsl:value-of select="$suffix" />
                                                                                        </queryRef>
                                                                                        <queryRef>
                                                                                            <xsl:text>/locatorPort6</xsl:text>
                                                                                            <xsl:value-of select="$suffix" />
                                                                                        </queryRef>
                                                                                    </vectorQuery>
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorLoad_Op_UtilizationGroup">
                                                                                <queryInherit>
                                                                                    <xsl:text>/locatorLoad_Op_Utilization</xsl:text>
                                                                                    <xsl:value-of select="$suffix" />
                                                                                </queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorLoad_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                            <derivedQuery id="locatorStore_Op_UtilizationGroup">
                                                                                <queryInherit>
                                                                                    <xsl:text>/locatorStore_Op_Utilization</xsl:text>
                                                                                    <xsl:value-of select="$suffix" />
                                                                                </queryInherit>
                                                                                <displayAttributes>
                                                                                    <boolean:expand>false</boolean:expand>
                                                                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                                </displayAttributes>
                                                                                <expand>
                                                                                    <vectorQuery id="locatorStore_Op_UtilizationGroupExpanded" />
                                                                                </expand>
                                                                            </derivedQuery>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="locatorBASE{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="locatorFP_x87{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="locatorFP_Scalar{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="locatorFP_Vector{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Assists" id="locatorAssists{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%AssistsDescriptionAll</description>
                    <helpKeyword>configs.assists_assistsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="locatorMispredicts_Resteers{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispredicts_ResteersDescriptionAll</description>
                    <helpKeyword>configs.mispredicts_resteers_mispredicts_resteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="locatorClears_Resteers{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Clears_ResteersDescriptionAll</description>
                    <helpKeyword>configs.clears_resteers_clears_resteersdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Unknown_Branches" id="locatorUnknown_Branches{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Unknown_BranchesDescriptionAll</description>
                    <helpKeyword>configs.unknown_branches_unknown_branchesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="locatorDSBtoMITESwitchCost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="locatorLCP{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="locatorMSSwitches{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="locatorFEBandwidthMITE{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthMITEDescriptionAll</description>
                    <helpKeyword>configs.febandwidthmite_febandwidthmitedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDSB" id="locatorFEBandwidthDSB{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDSBDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdsb_febandwidthdsbdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthLSD" id="locatorFEBandwidthLSD{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthLSDDescriptionAll</description>
                    <helpKeyword>configs.febandwidthlsd_febandwidthlsddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="locatorDSB_Coverage{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Coverage" id="locatorLSD_Coverage{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LSD_CoverageDescriptionAll</description>
                    <helpKeyword>configs.lsd_coverage_lsd_coveragedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="locatorDTLBOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="locatorLockLatency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LockLatencyDescriptionAll</description>
                    <helpKeyword>configs.locklatency_locklatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SplitLoads" id="locatorSplitLoads{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitLoadsDescriptionAll</description>
                    <helpKeyword>configs.splitloads_splitloadsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%4KAliasing" id="locator4KAliasing{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%4KAliasingDescriptionAll</description>
                    <helpKeyword>configs.4kaliasing_4kaliasingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="locatorFBFull{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FBFullDescriptionAll</description>
                    <helpKeyword>configs.fbfull_fbfulldescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="locatorContestedAccesses{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ContestedAccessesDescriptionAll</description>
                    <helpKeyword>configs.contestedaccesses_contestedaccessesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="locatorDataSharing{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DataSharingDescriptionAll</description>
                    <helpKeyword>configs.datasharing_datasharingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="locatorL3Latency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3LatencyDescriptionAll</description>
                    <helpKeyword>configs.l3latency_l3latencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="locatorSQFull{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SQFullDescriptionAll</description>
                    <helpKeyword>configs.sqfull_sqfulldescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="locatorMEMBandwidth{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="locatorMEMLatency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LocalDRAM" id="locatorLocalDRAM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LocalDRAMDescriptionAll</description>
                    <helpKeyword>configs.localdram_localdramdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%RemoteDRAM" id="locatorRemoteDRAM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RemoteDRAMDescriptionAll</description>
                    <helpKeyword>configs.remotedram_remotedramdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="locatorRemoteCache{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RemoteCacheDescriptionAll</description>
                    <helpKeyword>configs.remotecache_remotecachedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%IXP_Bound" id="locatorIXP_Bound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IXP_BoundDescriptionAll</description>
                    <helpKeyword>configs.ixp_bound_ixp_bounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="locatorStoreLatency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoreLatencyDescriptionAll</description>
                    <helpKeyword>configs.storelatency_storelatencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="locatorFalseSharing{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FalseSharingDescriptionAll</description>
                    <helpKeyword>configs.falsesharing_falsesharingdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="locatorSplitStores{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SplitStoresDescriptionAll</description>
                    <helpKeyword>configs.splitstores_splitstoresdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="locatorDTLBStoreOverhead{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBStoreOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlbstoreoverhead_dtlbstoreoverheaddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Hit" id="locatorStore_STLB_Hit{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_hit_store_stlb_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_STLB_Miss" id="locatorStore_STLB_Miss{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.store_stlb_miss_store_stlb_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="locatorDIVActive{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="locatorPortUtil{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles0PortsUtilized" id="locatorCycles0PortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles0PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles0portsutilized_cycles0portsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Slow_Pause" id="locatorSlow_Pause{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Slow_PauseDescriptionAll</description>
                    <helpKeyword>configs.slow_pause_slow_pausedescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="locatorCycles1PortUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles1PortUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles1portutilized_cycles1portutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="locatorCycles2PortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles2PortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles2portsutilized_cycles2portsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Cycles3mPortsUtilized" id="locatorCycles3mPortsUtilized{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Cycles3mPortsUtilizedDescriptionAll</description>
                    <helpKeyword>configs.cycles3mportsutilized_cycles3mportsutilizeddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ALU_Op_Utilization" id="locatorALU_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ALU_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.alu_op_utilization_alu_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="locatorPort0{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port0DescriptionAll</description>
                    <helpKeyword>configs.port0_port0descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="locatorPort1{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port1DescriptionAll</description>
                    <helpKeyword>configs.port1_port1descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="locatorPort5{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port5DescriptionAll</description>
                    <helpKeyword>configs.port5_port5descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="locatorPort6{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Port6DescriptionAll</description>
                    <helpKeyword>configs.port6_port6descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_Op_Utilization" id="locatorLoad_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.load_op_utilization_load_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_Op_Utilization" id="locatorStore_Op_Utilization{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_Op_UtilizationDescriptionAll</description>
                    <helpKeyword>configs.store_op_utilization_store_op_utilizationdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="locatorCORE_CLKS{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Load_Miss_Real_Latency" id="locatorLoad_Miss_Real_Latency{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_Miss_Real_LatencyDescriptionAll</description>
                    <helpKeyword>configs.load_miss_real_latency_load_miss_real_latencydescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="locatorFetched_Uops{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="locatorORO_DRD_Any_Cycles{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="locatorORO_DRD_BW_Cycles{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%ORO_Demand_RFO_C1" id="locatorORO_Demand_RFO_C1{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_Demand_RFO_C1DescriptionAll</description>
                    <helpKeyword>configs.oro_demand_rfo_c1_oro_demand_rfo_c1descriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Store_L2_Hit_Cycles" id="locatorStore_L2_Hit_Cycles{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Store_L2_Hit_CyclesDescriptionAll</description>
                    <helpKeyword>configs.store_l2_hit_cycles_store_l2_hit_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L1_MISS_NET" id="locatorLOAD_L1_MISS_NET{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L1_MISS_NETDescriptionAll</description>
                    <helpKeyword>configs.load_l1_miss_net_load_l1_miss_netdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L2_HIT" id="locatorLOAD_L2_HIT{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L2_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l2_hit_load_l2_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_L3_HIT" id="locatorLOAD_L3_HIT{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_L3_HITDescriptionAll</description>
                    <helpKeyword>configs.load_l3_hit_load_l3_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HIT" id="locatorLOAD_XSNP_HIT{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_HITDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hit_load_xsnp_hitdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_HITM" id="locatorLOAD_XSNP_HITM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_hitm_load_xsnp_hitmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_XSNP_MISS" id="locatorLOAD_XSNP_MISS{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_XSNP_MISSDescriptionAll</description>
                    <helpKeyword>configs.load_xsnp_miss_load_xsnp_missdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_LCL_MEM" id="locatorLOAD_LCL_MEM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_LCL_MEMDescriptionAll</description>
                    <helpKeyword>configs.load_lcl_mem_load_lcl_memdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_LCL_PMM" id="locatorLOAD_LCL_PMM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_LCL_PMMDescriptionAll</description>
                    <helpKeyword>configs.load_lcl_pmm_load_lcl_pmmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_PMM" id="locatorLOAD_RMT_PMM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_RMT_PMMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_pmm_load_rmt_pmmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_MEM" id="locatorLOAD_RMT_MEM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_RMT_MEMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_mem_load_rmt_memdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_HITM" id="locatorLOAD_RMT_HITM{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_RMT_HITMDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_hitm_load_rmt_hitmdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%LOAD_RMT_FWD" id="locatorLOAD_RMT_FWD{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LOAD_RMT_FWDDescriptionAll</description>
                    <helpKeyword>configs.load_rmt_fwd_load_rmt_fwddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="locatorFew_Uops_Executed_Threshold{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Cycles" id="locatorCore_Bound_Cycles{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Core_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.core_bound_cycles_core_bound_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="locatorBackend_Bound_Cycles{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="locatorMemory_Bound_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%L2_Bound_Ratio" id="locatorL2_Bound_Ratio{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.l2_bound_ratio_l2_bound_ratiodescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_Bound_Ratio" id="locatorMEM_Bound_Ratio{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_Bound_RatioDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_ratio_mem_bound_ratiodescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_DDR_Hit_Fraction" id="locatorMem_DDR_Hit_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_DDR_Hit_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_ddr_hit_fraction_mem_ddr_hit_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Lock_St_Fraction" id="locatorMem_Lock_St_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Lock_St_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_lock_st_fraction_mem_lock_st_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="locatorMispred_Clears_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="locatorRetire_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%True_XSNP_HitM_Fraction" id="locatorTrue_XSNP_HitM_Fraction{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%True_XSNP_HitM_FractionDescriptionAll</description>
                    <helpKeyword>configs.true_xsnp_hitm_fraction_true_xsnp_hitm_fractiondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="locatorPipeline_Width{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L2_Store_Cost" id="locatorMem_L2_Store_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_L2_Store_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_l2_store_cost_mem_l2_store_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_STLB_Hit_Cost" id="locatorMem_STLB_Hit_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_STLB_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_stlb_hit_cost_mem_stlb_hit_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_XSNP_HitM_Cost" id="locatorMem_XSNP_HitM_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_XSNP_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hitm_cost_mem_xsnp_hitm_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_XSNP_Hit_Cost" id="locatorMEM_XSNP_Hit_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_XSNP_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_hit_cost_mem_xsnp_hit_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MEM_XSNP_None_Cost" id="locatorMEM_XSNP_None_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_XSNP_None_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_xsnp_none_cost_mem_xsnp_none_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Local_DRAM_Cost" id="locatorMem_Local_DRAM_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Local_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_local_dram_cost_mem_local_dram_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_DRAM_Cost" id="locatorMem_Remote_DRAM_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Remote_DRAM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_dram_cost_mem_remote_dram_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_HitM_Cost" id="locatorMem_Remote_HitM_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Remote_HitM_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_hitm_cost_mem_remote_hitm_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Remote_Fwd_Cost" id="locatorMem_Remote_Fwd_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Remote_Fwd_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_remote_fwd_cost_mem_remote_fwd_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%BAClear_Cost" id="locatorBAClear_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BAClear_CostDescriptionAll</description>
                    <helpKeyword>configs.baclear_cost_baclear_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="locatorMS_Switches_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Avg_Assist_Cost" id="locatorAvg_Assist_Cost{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Avg_Assist_CostDescriptionAll</description>
                    <helpKeyword>configs.avg_assist_cost_avg_assist_costdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%OneMillion" id="locatorOneMillion{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OneMillionDescriptionAll</description>
                    <helpKeyword>configs.onemillion_onemilliondescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="locatorRetired_Slots{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%UPC" id="locatorUPC{$suffix}">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%UPCDescriptionAll</description>
                    <helpKeyword>configs.upc_upcdescriptionall</helpKeyword>
                </derivedQuery>
                <derivedQuery displayName="%PMM_App_Direct" id="locatorPMM_App_Direct{$suffix}">
                    <xsl:choose>
                        <xsl:when test="$is3DXOn">
                            <queryInherit>/GeMetricBaseLocator</queryInherit>
                            <description>%PMM_App_DirectDescriptionAll</description>
                            <helpKeyword>configs.pmm_app_direct_pmm_app_directdescriptionall</helpKeyword>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>0</valueEval>
                            <queryInherit>/GeMetricNA</queryInherit>
                        </xsl:otherwise>
                    </xsl:choose>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
