/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.Buffer;
import mpi.Comm;
import mpi.Datatype;
import mpi.MPIException;
import mpi.MPIJHelper;
import mpi.Request;
import mpi.Status;

public class PTP {
    public static void send(Buffer buffer, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        int n4 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n4 = buffer.arrayOffset();
        }
        PTP.MPI_Send(buffer, n4, bl, n, datatype.getId(), n2, n3, comm.getHandle());
    }

    public static void send(Object object, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object);
        PTP.MPI_Send(object, 0, false, n, datatype.getId(), n2, n3, comm.getHandle());
    }

    private static native void MPI_Send(Object var0, int var1, boolean var2, int var3, int var4, int var5, int var6, long var7) throws MPIException;

    public static Status recv(Buffer buffer, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        int n4 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n4 = buffer.arrayOffset();
        }
        Status status = new Status();
        PTP.MPI_Recv(buffer, n4, bl, n, datatype.getId(), n2, n3, comm.getHandle(), status.getHandle());
        return status;
    }

    public static Status recv(Object object, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object);
        Status status = new Status();
        PTP.MPI_Recv(object, 0, false, n, datatype.getId(), n2, n3, comm.getHandle(), status.getHandle());
        return status;
    }

    private static native void MPI_Recv(Object var0, int var1, boolean var2, int var3, long var4, int var6, int var7, long var8, long var10);

    public static Request irecv(Buffer buffer, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        int n4 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n4 = buffer.arrayOffset();
        }
        long l = PTP.MPI_Irecv(buffer, n4, bl, n, datatype.getId(), n2, n3, comm.getHandle());
        Request request = new Request(l);
        return request;
    }

    public static Request irecv(Object object, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object);
        long l = PTP.MPI_Irecv(object, 0, false, n, datatype.getId(), n2, n3, comm.getHandle());
        Request request = new Request(l);
        return request;
    }

    private static native long MPI_Irecv(Object var0, int var1, boolean var2, int var3, long var4, int var6, int var7, long var8);

    public static Request isend(Buffer buffer, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        int n4 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n4 = buffer.arrayOffset();
        }
        long l = PTP.MPI_Isend(buffer, n4, bl, n, datatype.getId(), n2, n3, comm.getHandle());
        Request request = new Request(l);
        return request;
    }

    public static Request isend(Object object, int n, Datatype datatype, int n2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object);
        long l = PTP.MPI_Isend(object, 0, false, n, datatype.getId(), n2, n3, comm.getHandle());
        Request request = new Request(l);
        return request;
    }

    private static native long MPI_Isend(Object var0, int var1, boolean var2, int var3, int var4, int var5, int var6, long var7) throws MPIException;

    public static Status sendRecv(Buffer buffer, int n, Datatype datatype, int n2, int n3, Buffer buffer2, int n4, Datatype datatype2, int n5, int n6, Comm comm) throws MPIException {
        int n7 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n7 = buffer.arrayOffset();
        }
        int n8 = 0;
        boolean bl2 = buffer2.isDirect();
        if (!bl2) {
            n8 = buffer2.arrayOffset();
        }
        Status status = new Status();
        PTP.MPI_Sendrecv(buffer, n7, bl, n, datatype.getId(), n2, n3, buffer2, n8, bl2, n4, datatype2.getId(), n5, n6, comm.getHandle(), status.getHandle());
        return status;
    }

    private static native void MPI_Sendrecv(Object var0, int var1, boolean var2, int var3, int var4, int var5, int var6, Object var7, int var8, boolean var9, int var10, int var11, int var12, int var13, long var14, long var16) throws MPIException;
}

