/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;

public class ClangCaseToken
extends ClangToken {
    private PcodeOp op = null;
    private long value = 0L;

    public ClangCaseToken(ClangNode par) {
        super(par);
    }

    @Override
    public boolean isVariableRef() {
        return true;
    }

    @Override
    public Address getMinAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public Address getMaxAddress() {
        if (this.op == null) {
            return null;
        }
        return this.op.getSeqnum().getTarget();
    }

    @Override
    public Varnode getVarnode() {
        PcodeOp switchOp = this.getSwitchOp();
        if (switchOp == null) {
            return null;
        }
        return switchOp.getInput(0);
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public HighVariable getHighVariable() {
        Varnode vn = this.getVarnode();
        if (vn == null) {
            return null;
        }
        return vn.getHigh();
    }

    @Override
    public HighSymbol getHighSymbol(HighFunction highFunction) {
        HighSymbol symbol;
        HighVariable hvar = this.getHighVariable();
        if (hvar != null && (symbol = hvar.getSymbol()) != null) {
            return symbol;
        }
        return null;
    }

    @Override
    public Scalar getScalar() {
        HighVariable hvar = this.getHighVariable();
        if (hvar == null) {
            return null;
        }
        DataType dt = hvar.getDataType();
        int sz = dt.getLength();
        if (sz < 1 || sz > 8) {
            return null;
        }
        boolean isSigned = true;
        if (dt instanceof AbstractIntegerDataType) {
            isSigned = ((AbstractIntegerDataType)dt).isSigned();
        }
        return new Scalar(sz * 8, this.value, isSigned);
    }

    public PcodeOp getSwitchOp() {
        if (this.op == null) {
            return null;
        }
        PcodeBlockBasic parent = this.op.getParent();
        for (int i = 0; i < parent.getInSize(); ++i) {
            PcodeBlockBasic in = (PcodeBlockBasic)parent.getIn(i);
            PcodeOp switchOp = in.getLastOp();
            if (switchOp == null || switchOp.getOpcode() != 6) continue;
            return switchOp;
        }
        return null;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_OPREF.id()) {
                int refid = (int)decoder.readUnsignedInteger();
                this.op = pfactory.getOpRef(refid);
                continue;
            }
            if (attribId != AttributeId.ATTRIB_OFF.id()) continue;
            this.value = decoder.readUnsignedInteger();
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
    }
}

