/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import io.netty.channel.Channel;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.Service;
import org.rzo.netty.ahessian.rpc.stream.InputStreamReplyMessage;
import org.rzo.netty.ahessian.rpc.stream.ServerInputStream;
import org.rzo.netty.ahessian.rpc.stream.ServerInputStreamManager;

public abstract class HessianSkeleton
extends com.caucho.hessian4.server.HessianSkeleton
implements Service,
Constants {
    volatile Object _service;
    HessianRPCServiceHandler _factory;
    ServerInputStreamManager _serverInputStreamManager;
    public static ThreadLocal<Channel> threadLocalChannel = new ThreadLocal();

    public HessianSkeleton(Object service, Class apiClass, HessianRPCServiceHandler factory) {
        super(apiClass);
        this._service = service;
        this._factory = factory;
    }

    public Method getMethod(HessianRPCCallMessage message) {
        Object[] args = message.getArgs();
        String methodName = message.getMethod();
        Method method = null;
        if (args == null || args.length == 0) {
            method = this.getMethod(HessianSkeleton.mangleName(methodName, args));
        }
        if (method == null) {
            method = this.getMethod(message.getMethod());
        }
        return method;
    }

    public static String mangleName(String method, Object[] args) {
        if (args != null && args.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(method);
            sb.append('_');
            sb.append(args.length);
            return sb.toString();
        }
        return method;
    }

    public void writeResult(HessianRPCReplyMessage message) {
        this._factory.writeResult(message);
    }

    public void handleDefaultResult(Object fault, Object result, HessianRPCCallMessage message) {
        HessianRPCReplyMessage reply = new HessianRPCReplyMessage(result, fault, message);
        reply.setCompleted(true);
        reply.setCallId((Long)message.getHeaders().get(CALL_ID_HEADER_KEY));
        reply.setGroup((Integer)message.getHeaders().get(GROUP_HEADER_KEY));
        this.writeResult(reply);
    }

    public void handleInputStreamResult(Object fault, Object result, HessianRPCCallMessage message) {
        ServerInputStream serverInputStream = this._serverInputStreamManager.createServerInputStream((InputStream)result, message.getChannel());
        InputStreamReplyMessage internalReply = new InputStreamReplyMessage();
        internalReply.setId(serverInputStream.getId());
        internalReply.setCreated(true);
        HessianRPCReplyMessage reply = new HessianRPCReplyMessage(result, fault, message);
        reply.setCompleted(true);
        reply.setCallId((Long)message.getHeaders().get(CALL_ID_HEADER_KEY));
        reply.setGroup((Integer)message.getHeaders().get(GROUP_HEADER_KEY));
        this.writeResult(reply);
        serverInputStream.start();
    }

    @Override
    public abstract void messageReceived(HessianRPCCallMessage var1);

    public void setServerInputStreamManager(ServerInputStreamManager serverInputStreamManager) {
        this._serverInputStreamManager = serverInputStreamManager;
    }
}

