/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.quickfix;

import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public abstract class QuickFix {
    private long modificationNumber;
    private QuickFixStatus status = QuickFixStatus.NONE;
    private String statusMessage;
    protected final Program program;
    protected final String original;
    protected final String replacement;
    protected String current;

    protected QuickFix(Program program, String original, String replacement) {
        this.program = program;
        this.original = original;
        this.replacement = replacement;
        this.current = original;
        this.modificationNumber = program.getModificationNumber();
    }

    public abstract String getActionName();

    public abstract String getItemType();

    public abstract Address getAddress();

    public abstract String getPath();

    public String getOriginal() {
        return this.original;
    }

    public final String getCurrent() {
        this.refresh();
        return this.current;
    }

    protected void refresh() {
        if (this.program.getModificationNumber() == this.modificationNumber) {
            return;
        }
        this.modificationNumber = this.program.getModificationNumber();
        if (this.status == QuickFixStatus.ERROR) {
            return;
        }
        this.current = this.doGetCurrent();
        this.updateStatus();
    }

    public final String getPreview() {
        return this.replacement;
    }

    public final void performAction() {
        if (this.status == QuickFixStatus.ERROR || this.status == QuickFixStatus.DONE) {
            return;
        }
        this.execute();
    }

    public final QuickFixStatus getStatus() {
        this.refresh();
        return this.status;
    }

    public String getStatusMessage() {
        if (this.statusMessage != null) {
            return this.statusMessage;
        }
        switch (this.status) {
            case DONE: {
                return "Applied";
            }
            case ERROR: {
                return "Error";
            }
            case NONE: {
                return "Not Applied";
            }
            case WARNING: {
                return "Warning";
            }
            case CHANGED: {
                return "Target changed externally";
            }
            case DELETED: {
                return "Target no longer exists";
            }
        }
        return "";
    }

    public void setStatus(QuickFixStatus status) {
        this.setStatus(status, null);
    }

    public void setStatus(QuickFixStatus status, String message) {
        this.status = status;
        this.statusMessage = message;
    }

    public abstract ProgramLocation getProgramLocation();

    public Map<String, String> getCustomToolTipData() {
        return null;
    }

    protected abstract String doGetCurrent();

    protected abstract void execute();

    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        return false;
    }

    private void updateStatus() {
        QuickFixStatus newStatus = this.computeStatus();
        if (newStatus != this.status) {
            this.setStatus(newStatus);
            this.statusChanged(this.status);
        }
    }

    protected void statusChanged(QuickFixStatus newStatus) {
    }

    private QuickFixStatus computeStatus() {
        if (this.current == null) {
            return QuickFixStatus.DELETED;
        }
        if (this.current.equals(this.original)) {
            return QuickFixStatus.NONE;
        }
        if (this.current.equals(this.replacement)) {
            return QuickFixStatus.DONE;
        }
        return QuickFixStatus.CHANGED;
    }
}

