/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Register;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GoFunctionMultiReturn {
    public static final String MULTIVALUE_RETURNTYPE_SUFFIX = "_multivalue_return_type";
    public static final String SHORT_MULTIVALUE_RETURNTYPE_PREFIX = "multireturn{";
    public static final String SHORT_MULTIVALUE_RETURNTYPE_SUFFIX = "}";
    private static final String ORDINAL_PREFIX = "ordinal: ";
    private static final String TMP_NAME = "--TEMP_NAME_REPLACE_ASAP--";
    private static final Pattern ORDINAL_REGEX = Pattern.compile(".*ordinal: ([\\d]+)[^\\d]*");
    private Structure struct;
    private List<DataTypeComponent> normalStorageComponents = new ArrayList<DataTypeComponent>();
    private List<DataTypeComponent> stackStorageComponents = new ArrayList<DataTypeComponent>();

    public static boolean isMultiReturnDataType(DataType dt) {
        return dt instanceof Structure && (dt.getName().endsWith(MULTIVALUE_RETURNTYPE_SUFFIX) || dt.getName().startsWith(SHORT_MULTIVALUE_RETURNTYPE_PREFIX));
    }

    public static GoFunctionMultiReturn fromStructure(DataType dt, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        return GoFunctionMultiReturn.isMultiReturnDataType(dt) ? new GoFunctionMultiReturn((Structure)dt, dtm, storageAllocator) : null;
    }

    public GoFunctionMultiReturn(CategoryPath categoryPath, List<DWARFVariable> returnParams, DWARFFunction dfunc, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        Structure newStruct = this.mkStruct(categoryPath, dtm);
        int ordinalNum = 0;
        for (DWARFVariable dvar : returnParams) {
            newStruct.add(dvar.type, dvar.name.getName(), ORDINAL_PREFIX + ordinalNum);
            ++ordinalNum;
        }
        this.regenerateMultireturnStruct(newStruct, dtm, storageAllocator);
    }

    public GoFunctionMultiReturn(CategoryPath categoryPath, List<DataType> types, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        Structure newStruct = this.mkStruct(categoryPath, dtm);
        int ordinalNum = 0;
        for (DataType dt : types) {
            newStruct.add(dt, "~r%d".formatted(ordinalNum), ORDINAL_PREFIX + ordinalNum);
            ++ordinalNum;
        }
        this.regenerateMultireturnStruct(newStruct, dtm, storageAllocator);
    }

    public GoFunctionMultiReturn(CategoryPath categoryPath, ParameterDefinition[] returnParams, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        Structure newStruct = this.mkStruct(categoryPath, dtm);
        int ordinalNum = 0;
        for (ParameterDefinition pd : returnParams) {
            String retParamName = pd.getName() != null && !pd.getName().isBlank() ? pd.getName() : "~r%d".formatted(ordinalNum);
            newStruct.add(pd.getDataType(), retParamName, ORDINAL_PREFIX + ordinalNum);
            ++ordinalNum;
        }
        this.regenerateMultireturnStruct(newStruct, dtm, storageAllocator);
    }

    private Structure mkStruct(CategoryPath cp, DataTypeManager dtm) {
        StructureDataType newStruct = new StructureDataType(cp, TMP_NAME, 0, dtm);
        newStruct.setPackingEnabled(true);
        newStruct.setExplicitPackingValue(1);
        newStruct.setDescription("Artificial data type to hold a function's return values");
        return newStruct;
    }

    public GoFunctionMultiReturn(Structure struct, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        this.regenerateMultireturnStruct(struct, dtm, storageAllocator);
    }

    public Structure getStruct() {
        return this.struct;
    }

    public List<DataTypeComponent> getNormalStorageComponents() {
        return this.normalStorageComponents;
    }

    public List<DataTypeComponent> getStackStorageComponents() {
        return this.stackStorageComponents;
    }

    public List<DataTypeComponent> getComponentsInOriginalOrder() {
        return GoFunctionMultiReturn.getComponentsInOriginalOrder(this.struct);
    }

    private void regenerateMultireturnStruct(Structure newStruct, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        String name = GoFunctionMultiReturn.getComponentsInOriginalOrder(newStruct).stream().map(dtc -> dtc.getDataType().getName()).collect(Collectors.joining(";", SHORT_MULTIVALUE_RETURNTYPE_PREFIX, SHORT_MULTIVALUE_RETURNTYPE_SUFFIX));
        if (newStruct.getName().equals(TMP_NAME)) {
            try {
                newStruct.setName(name);
            }
            catch (InvalidNameException | DuplicateNameException throwable) {
                // empty catch block
            }
        }
        if (storageAllocator == null) {
            this.struct = newStruct;
            for (DataTypeComponent dtc2 : GoFunctionMultiReturn.getComponentsInOriginalOrder(newStruct)) {
                this.stackStorageComponents.add(dtc2);
            }
            return;
        }
        StructureDataType adjustedStruct = new StructureDataType(newStruct.getCategoryPath(), name + "_" + storageAllocator.getArchDescription(), 0, dtm);
        adjustedStruct.setPackingEnabled(true);
        adjustedStruct.setExplicitPackingValue(1);
        storageAllocator = storageAllocator.clone();
        ArrayList<StackComponentInfo> stackResults = new ArrayList<StackComponentInfo>();
        int compNum = 0;
        for (DataTypeComponent dtc3 : GoFunctionMultiReturn.getComponentsInOriginalOrder(newStruct)) {
            List<Register> regs = storageAllocator.getRegistersFor(dtc3.getDataType());
            if (regs == null || regs.isEmpty()) {
                long stackOffset = storageAllocator.getStackAllocation(dtc3.getDataType());
                String comment = "stack[%d] %s%d".formatted(stackOffset, ORDINAL_PREFIX, compNum);
                stackResults.add(new StackComponentInfo(dtc3, compNum, comment));
            } else {
                String comment = "%s %s%d".formatted(regs, ORDINAL_PREFIX, compNum);
                DataTypeComponent newDTC = adjustedStruct.add(dtc3.getDataType(), dtc3.getFieldName(), comment);
                this.normalStorageComponents.add(newDTC);
            }
            ++compNum;
        }
        for (int i = 0; i < stackResults.size(); ++i) {
            StackComponentInfo sci = (StackComponentInfo)stackResults.get(i);
            DataTypeComponent dtc4 = sci.dtc;
            DataTypeComponent newDTC = storageAllocator.isBigEndian() ? adjustedStruct.add(dtc4.getDataType(), dtc4.getFieldName(), sci.comment) : adjustedStruct.insert(i, dtc4.getDataType(), -1, dtc4.getFieldName(), sci.comment);
            this.stackStorageComponents.add(newDTC);
        }
        boolean isEquiv = DWARFDataTypeConflictHandler.INSTANCE.resolveConflict((DataType)adjustedStruct, (DataType)newStruct) == DataTypeConflictHandler.ConflictResult.USE_EXISTING;
        this.struct = isEquiv ? newStruct : adjustedStruct;
    }

    private static int getOrdinalNumber(DataTypeComponent dtc) {
        String comment = Objects.requireNonNullElse(dtc.getComment(), "");
        Matcher m = ORDINAL_REGEX.matcher(comment);
        try {
            return m.matches() ? Integer.parseInt(m.group(1)) : -1;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static List<DataTypeComponent> getComponentsInOriginalOrder(Structure struct) {
        ArrayList<DataTypeComponent> dtcs = new ArrayList<DataTypeComponent>(List.of(struct.getDefinedComponents()));
        Collections.sort(dtcs, (dtc1, dtc2) -> Integer.compare(GoFunctionMultiReturn.getOrdinalNumber(dtc1), GoFunctionMultiReturn.getOrdinalNumber(dtc2)));
        return dtcs;
    }

    private record StackComponentInfo(DataTypeComponent dtc, int ordinal, String comment) {
    }
}

