/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.app.cmd.disassemble.SetFlowOverrideCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.util.ProgramSelection;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

class SetFlowOverrideDialog
extends DialogComponentProvider {
    private static final String DEFAULT_CHOICE = "-DEFAULT-";
    private GhidraComboBox<Object> flowOverrideComboBox;
    private PluginTool tool;
    private Instruction instruction;
    private Program program;
    private ProgramSelection selection;

    SetFlowOverrideDialog(PluginTool tool, Instruction instruction) {
        super("Modify Instruction Flow: " + String.valueOf(instruction.getMinAddress()), true, false, true, false);
        this.tool = tool;
        this.instruction = instruction;
        this.program = instruction.getProgram();
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
    }

    SetFlowOverrideDialog(PluginTool tool, Program program, ProgramSelection selection) {
        super("Modify Instruction Flow on Selection", true, false, true, false);
        this.tool = tool;
        this.program = program;
        this.selection = selection;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        if (this.instruction != null) {
            mainPanel.add(this.buildCurrentFlowPanel());
        }
        mainPanel.add(this.buildFlowOverridePanel());
        if (this.instruction != null && this.instruction.getFlowType().isConditional()) {
            mainPanel.add(this.buildNotePanel("*Conditional flow will be preserved"));
        }
        mainPanel.getAccessibleContext().setAccessibleName("Set Flow Override");
        return mainPanel;
    }

    private JPanel buildCurrentFlowPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        FlowType flowType = this.instruction.getFlowType();
        panel.add((Component)new GLabel("Current Flow: " + flowType.getName() + (flowType.isConditional() ? "*" : "")));
        panel.add(Box.createGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.getAccessibleContext().setAccessibleName("Current Flow");
        return panel;
    }

    private JPanel buildNotePanel(String note) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add((Component)new GLabel(note));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.getAccessibleContext().setAccessibleName("Note");
        return panel;
    }

    private JPanel buildFlowOverridePanel() {
        FlowOverride flowOverride;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.flowOverrideComboBox = new GhidraComboBox();
        this.flowOverrideComboBox.getAccessibleContext().setAccessibleName("Flow Override");
        this.flowOverrideComboBox.addItem((Object)DEFAULT_CHOICE);
        for (FlowOverride element : FlowOverride.values()) {
            if (element == FlowOverride.NONE) continue;
            this.flowOverrideComboBox.addItem((Object)element);
        }
        FlowOverride flowOverride2 = flowOverride = this.instruction != null ? this.instruction.getFlowOverride() : null;
        if (flowOverride == null) {
            this.flowOverrideComboBox.setSelectedItem((Object)DEFAULT_CHOICE);
        } else {
            this.flowOverrideComboBox.setSelectedItem((Object)flowOverride);
        }
        panel.add((Component)new GLabel("Instruction Flow:"));
        panel.add((Component)this.flowOverrideComboBox);
        panel.add(Box.createGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.getAccessibleContext().setAccessibleName("Flow Override");
        return panel;
    }

    protected PluginTool getTool() {
        return this.tool;
    }

    protected void okCallback() {
        if (this.executeCommand()) {
            this.close();
        }
    }

    protected void cancelCallback() {
        this.setStatusText("");
        this.close();
    }

    private boolean executeCommand() {
        FlowOverride flow = FlowOverride.NONE;
        Object choice = this.flowOverrideComboBox.getSelectedItem();
        if (!DEFAULT_CHOICE.equals(choice)) {
            flow = (FlowOverride)choice;
        }
        if (this.instruction == null) {
            this.tool.executeBackgroundCommand((BackgroundCommand)new SetFlowOverrideCmd(this.selection, flow), (DomainObject)this.program);
        } else {
            if (this.instruction.getFlowOverride() == flow) {
                return true;
            }
            this.tool.executeBackgroundCommand((BackgroundCommand)new SetFlowOverrideCmd(this.instruction.getMinAddress(), flow), (DomainObject)this.program);
        }
        return true;
    }
}

