/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.table.GTableHeaderRenderer;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;

class StructureEditorModel
extends CompEditorModel<Structure> {
    private static final long serialVersionUID = 1L;
    private static final int OFFSET = 0;
    private static final int LENGTH = 1;
    private static final int MNEMONIC = 2;
    private static final int DATATYPE = 3;
    private static final int FIELDNAME = 4;
    private static final int COMMENT = 5;
    private static final int ORDINAL = 6;
    private List<TableColumn> hiddenColumns;

    StructureEditorModel(StructureEditorProvider provider, boolean showHexNumbers) {
        super(provider);
        this.headers = new String[]{"Offset", "Length", "Mnemonic", "DataType", "Name", "Comment"};
        this.columnWidths = new int[]{75, 75, 100, 100, 100, 150};
        this.columnOffsets = new int[this.headers.length];
        this.adjustOffsets();
        this.showHexNumbers = showHexNumbers;
        ArrayList<TableColumn> additionalColumns = new ArrayList<TableColumn>();
        TableColumn ordinalColumn = new TableColumn(6, 75);
        ordinalColumn.setHeaderRenderer((TableCellRenderer)new GTableHeaderRenderer());
        ordinalColumn.setHeaderValue("Ordinal");
        additionalColumns.add(ordinalColumn);
        this.hiddenColumns = Collections.unmodifiableList(additionalColumns);
    }

    @Override
    public String getTypeName() {
        return "Structure";
    }

    @Override
    protected List<TableColumn> getHiddenColumns() {
        return this.hiddenColumns;
    }

    @Override
    public int getOffsetColumn() {
        return 0;
    }

    @Override
    public int getLengthColumn() {
        return 1;
    }

    @Override
    public int getMnemonicColumn() {
        return 2;
    }

    @Override
    public int getDataTypeColumn() {
        return 3;
    }

    @Override
    public int getNameColumn() {
        return 4;
    }

    @Override
    public int getCommentColumn() {
        return 5;
    }

    @Override
    public int getRowCount() {
        int componentCount = this.getNumComponents();
        int rowCount = componentCount + 1;
        return rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.viewComposite == null || rowIndex < 0 || columnIndex < 0) {
            return "";
        }
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            if (columnIndex == this.getDataTypeColumn()) {
                return null;
            }
            return "";
        }
        Object value = null;
        if (columnIndex == this.getOffsetColumn()) {
            int offset = dtc.getOffset();
            value = this.showHexNumbers ? StructureEditorModel.getHexString(offset, true) : Integer.toString(offset);
        } else if (columnIndex == this.getLengthColumn()) {
            int compLen = dtc.getLength();
            value = this.showHexNumbers ? StructureEditorModel.getHexString(compLen, true) : Integer.toString(compLen);
        } else if (columnIndex == this.getMnemonicColumn()) {
            int dtLen;
            DataType dt = dtc.getDataType();
            value = dt.getMnemonic(dtc.getDefaultSettings());
            int compLen = dtc.getLength();
            int n = dtLen = dt.isZeroLength() ? 0 : dt.getLength();
            if (dtLen > compLen) {
                value = "TooBig: " + (String)value + " needs " + dtLen + " has " + compLen;
            }
        } else {
            if (columnIndex == this.getDataTypeColumn()) {
                DataType dt;
                int dtLen = (dt = dtc.getDataType()).getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : dtc.getLength()), (boolean)this.usesAlignedLengthComponents());
            }
            if (columnIndex == this.getNameColumn()) {
                value = dtc.getFieldName();
            } else if (columnIndex == this.getCommentColumn()) {
                value = dtc.getComment();
            } else if (columnIndex == 6) {
                int ordinal = dtc.getOrdinal();
                value = this.showHexNumbers ? StructureEditorModel.getHexString(ordinal, true) : Integer.toString(ordinal);
            }
        }
        return value == null ? "" : value;
    }

    @Override
    public DataTypeComponent getComponent(int rowIndex) {
        int numComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex == numComponents) {
            return null;
        }
        if (rowIndex > numComponents) {
            return null;
        }
        if (this.isShowingUndefinedBytes()) {
            return ((Structure)this.viewComposite).getComponent(rowIndex);
        }
        DataTypeComponent[] definedComponents = ((Structure)this.viewComposite).getDefinedComponents();
        return definedComponents[rowIndex];
    }

    @Override
    public int getNumComponents() {
        return this.viewComposite == null ? 0 : ((Structure)this.viewComposite).getNumComponents();
    }

    @Override
    protected boolean isSizeEditable() {
        return !this.isPackingEnabled();
    }

    void setStructureSize(int size) {
        int currentLength;
        if (this.viewComposite == null || ((Structure)this.viewComposite).isPackingEnabled()) {
            return;
        }
        int n = currentLength = ((Structure)this.viewComposite).isZeroLength() ? 0 : ((Structure)this.viewComposite).getLength();
        if (currentLength == size) {
            return;
        }
        this.viewDTM.withTransaction("Set Size", () -> ((Structure)this.viewComposite).setLength(size));
        this.notifyCompositeChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getNumSelectedRows() != 1) {
            return false;
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        switch (columnIndex) {
            case 3: {
                return true;
            }
            case 4: 
            case 5: {
                DataTypeComponent dtc = this.getComponent(rowIndex);
                if (dtc == null) {
                    return false;
                }
                DataType dt = dtc.getDataType();
                return dt != DataType.DEFAULT;
            }
        }
        return false;
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        if (!this.isClearAllowed()) {
            throw new UsrException("Clearing is not allowed.");
        }
        if (this.getNumSelectedComponentRows() <= 0) {
            throw new UsrException("Only selections can be cleared.");
        }
        this.clearComponents(this.getSelectedComponentRows());
    }

    @Override
    public void clearComponents(int[] indices) {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        Arrays.sort(indices);
        this.viewDTM.withTransaction("Clear Components", () -> {
            for (int i = indices.length - 1; i >= 0; --i) {
                DataTypeComponent comp = this.getComponent(indices[i]);
                if (comp == null) continue;
                boolean isSelected = this.selection.containsEntirely(BigInteger.valueOf(indices[i]));
                int numBytes = comp.getLength();
                ((Structure)this.viewComposite).clearComponent(indices[i]);
                this.adjustSelection(indices[i] + 1, numBytes - 1);
                if (isSelected && numBytes > 1) {
                    this.selection.addRange(indices[i] + 1, indices[i] + numBytes);
                }
                if (indices[i] <= 0) continue;
                this.consumeByComponent(indices[i] - 1);
            }
        });
    }

    @Override
    protected void deleteComponents(int[] rows) {
        if (this.isShowingUndefinedBytes()) {
            super.deleteComponents(rows);
            return;
        }
        int[] ordinals = this.convertRowsToOrdinals(rows);
        for (int i = ordinals.length - 1; i >= 0; --i) {
            ((Structure)this.viewComposite).delete(ordinals[i]);
        }
        this.notifyCompositeChanged();
    }

    private int[] convertRowsToOrdinals(int[] rows) {
        int[] ordinals = new int[rows.length];
        DataTypeComponent[] definedComponents = ((Structure)this.viewComposite).getDefinedComponents();
        for (int i = rows.length - 1; i >= 0; --i) {
            ordinals[i] = definedComponents[rows[i]].getOrdinal();
        }
        return ordinals;
    }

    @Override
    protected int convertRowToOrdinal(int rowIndex) {
        int numRowComponents = this.getNumComponents();
        if (rowIndex < 0 || rowIndex > numRowComponents) {
            return -1;
        }
        if (rowIndex == numRowComponents) {
            return ((Structure)this.viewComposite).getNumComponents();
        }
        if (this.isShowingUndefinedBytes()) {
            return rowIndex;
        }
        DataTypeComponent[] definedComponents = ((Structure)this.viewComposite).getDefinedComponents();
        return definedComponents[rowIndex].getOrdinal();
    }

    @Override
    public void duplicateMultiple(int index, int multiple, TaskMonitor monitor) throws UsrException {
        DataTypeComponent originalComp;
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        if ((originalComp = this.getComponent(index)) == null) {
            throw new IllegalArgumentException("Invalid component index specified");
        }
        DataType dt = originalComp.getDataType();
        int dtcLen = originalComp.getLength();
        this.checkIsAllowableDataType(dt);
        this.viewDTM.withTransaction("Duplicate Components", () -> {
            int startIndex = index + 1;
            if (dtcLen > 0 && dt != DataType.DEFAULT && this.isShowingUndefinedBytes() && !this.isAtEnd(index)) {
                int endIndex = startIndex + dtcLen * multiple - 1;
                if (startIndex < this.getNumComponents()) {
                    this.deleteComponentRange(startIndex, endIndex, monitor);
                }
            }
            this.insertComponentMultiple(startIndex, dt, originalComp.getLength(), multiple, monitor);
        });
        this.setSelection(new int[]{index + multiple});
        this.lastNumDuplicates = multiple;
    }

    private boolean shiftComponentsUp(int startIndex, int endIndex) {
        int numComps = this.getNumComponents();
        if (startIndex > endIndex || startIndex <= 0 || startIndex >= numComps || endIndex <= 0 || endIndex >= numComps) {
            return false;
        }
        int len = this.getLength();
        return (Boolean)this.viewDTM.withTransaction("Shift Up", () -> {
            DataTypeComponent comp = this.deleteComponentAndResidual(startIndex - 1);
            try {
                if (!this.isPackingEnabled() && comp.isBitFieldComponent()) {
                    int lenChange = len - this.getLength();
                    this.insert(endIndex, DataType.DEFAULT, 1, lenChange, TaskMonitor.DUMMY);
                }
                this.insert(endIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            }
            catch (CancelledException lenChange) {
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
            return true;
        });
    }

    private boolean shiftComponentsDown(int startIndex, int endIndex) {
        int numComponents = this.getNumComponents();
        if (startIndex > endIndex || startIndex < 0 || startIndex >= numComponents - 1 || endIndex < 0 || endIndex >= numComponents - 1) {
            return false;
        }
        int len = this.getLength();
        return (Boolean)this.viewDTM.withTransaction("Shift Down", () -> {
            DataTypeComponent comp = this.deleteComponentAndResidual(endIndex + 1);
            try {
                if (!this.isPackingEnabled() && comp.isBitFieldComponent()) {
                    int lenChange = len - this.getLength();
                    this.insert(startIndex, DataType.DEFAULT, 1, lenChange, TaskMonitor.DUMMY);
                }
                this.insert(startIndex, comp.getDataType(), comp.getLength(), comp.getFieldName(), comp.getComment());
            }
            catch (CancelledException lenChange) {
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
            return true;
        });
    }

    private DataTypeComponent deleteComponentAndResidual(int index) {
        DataTypeComponent comp = this.getComponent(index);
        this.deleteComponent(index);
        if (this.isPackingEnabled() || !comp.isBitFieldComponent() || index >= this.getNumComponents()) {
            return comp;
        }
        int startOffset = comp.getOffset();
        for (int i = index + comp.getLength() - 1; i >= index; --i) {
            DataTypeComponent dtc = this.getComponent(i);
            if (dtc == null || dtc.getDataType() != DataType.DEFAULT || dtc.getOffset() < startOffset) continue;
            this.deleteComponent(i);
        }
        return comp;
    }

    @Override
    public boolean moveUp() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startRowIndex = range.getStart().getIndex().intValue();
        int endRowIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endRowIndex - startRowIndex + 1;
        boolean moved = false;
        int newIndex = startRowIndex - 1;
        moved = this.shiftComponentsUp(startRowIndex, endRowIndex);
        if (moved) {
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean moveDown() throws NoSuchElementException {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        FieldRange range = this.selection.getFieldRange(0);
        int startIndex = range.getStart().getIndex().intValue();
        int endIndex = range.getEnd().getIndex().intValue() - 1;
        int numSelected = endIndex - startIndex + 1;
        boolean moved = false;
        int newIndex = startIndex + 1;
        moved = this.shiftComponentsDown(startIndex, endIndex);
        if (moved) {
            FieldSelection tmpFieldSelection = new FieldSelection();
            tmpFieldSelection.addRange(newIndex, newIndex + numSelected);
            this.setSelection(tmpFieldSelection);
        }
        return moved;
    }

    @Override
    public boolean isBitFieldAllowed() {
        return this.isSingleRowSelection();
    }

    @Override
    public boolean isArrayAllowed() {
        boolean allowed = false;
        if (!this.isContiguousSelection()) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        DataTypeComponent comp = this.getComponent(range.getStart().getIndex().intValue());
        if (comp == null || comp.isBitFieldComponent()) {
            return false;
        }
        DataType dt = comp.getDataType();
        int dtLen = dt.getLength();
        if (dtLen < 0 || dtLen == comp.getLength()) {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public boolean isClearAllowed() {
        return this.hasComponentSelection() && this.isShowingUndefinedBytes();
    }

    @Override
    public boolean isDeleteAllowed() {
        if (!this.hasSelection()) {
            return false;
        }
        int rowIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        return this.getComponent(rowIndex) != null;
    }

    @Override
    public boolean isDuplicateAllowed() {
        if (!this.isSingleRowSelection() || this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int rowIndex = this.getRow();
        DataTypeComponent comp = this.getComponent(rowIndex);
        if (comp == null) {
            return false;
        }
        if (((Structure)this.viewComposite).isPackingEnabled() || this.isAtEnd(rowIndex)) {
            return true;
        }
        DataType dt = comp.getDataType();
        if (dt.equals((Object)DataType.DEFAULT) || dt.isZeroLength()) {
            return true;
        }
        if (comp.isBitFieldComponent()) {
            return false;
        }
        int dtSize = dt.getLength();
        if (dtSize <= 0) {
            dtSize = comp.getLength();
        }
        return dtSize <= this.getNumUndefinedBytesAfter(comp);
    }

    @Override
    public boolean isUnpackageAllowed() {
        boolean unpackageAllowed = false;
        if (this.getNumSelectedComponentRows() != 1) {
            return false;
        }
        int currentIndex = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        FieldRange range = this.getSelectedRangeContaining(currentIndex);
        boolean notInMultiLineSelection = true;
        if (range != null && range.getEnd().getIndex().intValue() - range.getStart().getIndex().intValue() > 1) {
            notInMultiLineSelection = false;
        }
        if (notInMultiLineSelection && currentIndex < this.getNumComponents()) {
            DataTypeComponent comp = this.getComponent(currentIndex);
            DataType dt = comp.getDataType();
            if (comp.getLength() == dt.getLength()) {
                if (dt instanceof TypeDef) {
                    TypeDef td = (TypeDef)dt;
                    dt = td.getBaseDataType();
                }
                if (dt instanceof Array || dt instanceof Structure) {
                    unpackageAllowed = true;
                }
            }
        }
        return unpackageAllowed;
    }

    @Override
    public boolean isAddAllowed(int currentIndex, DataType datatype) {
        boolean isOneComponent;
        DataType compDt;
        DataTypeComponent comp;
        if (currentIndex < 0 || currentIndex > this.getRowCount()) {
            return false;
        }
        if (datatype instanceof Array && (comp = this.getComponent(currentIndex)) != null && ((compDt = comp.getDataType()) instanceof Array || compDt instanceof Pointer)) {
            return false;
        }
        FieldRange currentRange = this.getSelectedRangeContaining(currentIndex);
        boolean bl = isOneComponent = currentRange == null || currentRange.getStart().getIndex().intValue() + 1 == currentRange.getEnd().getIndex().intValue();
        if (isOneComponent) {
            if (this.isPackingEnabled() || this.isAtEnd(currentIndex)) {
                return true;
            }
            DataTypeComponent comp2 = this.getComponent(currentIndex);
            if (comp2 != null) {
                DataType compDt2 = comp2.getDataType();
                if (compDt2 instanceof Pointer || DataTypeHelper.getBaseType(compDt2) instanceof Pointer) {
                    return !datatype.equals((Object)DataType.DEFAULT);
                }
                int numAvailable = comp2.getLength() + this.getNumUndefinedBytesAfter(comp2);
                return datatype.getLength() <= numAvailable;
            }
            return true;
        }
        int numComps = this.getNumComponents();
        int firstIndex = currentRange.getStart().getIndex().intValue();
        int lastIndex = currentRange.getEnd().getIndex().intValue() - 1;
        if (firstIndex >= numComps || lastIndex >= numComps) {
            return false;
        }
        DataTypeComponent startComp = this.getComponent(firstIndex);
        DataTypeComponent endComp = this.getComponent(lastIndex);
        int numAvailable = endComp.getOffset() + endComp.getLength() - startComp.getOffset();
        return datatype.getLength() <= numAvailable;
    }

    @Override
    public boolean isInsertAllowed(int currentIndex, DataType datatype) {
        return currentIndex <= this.getNumComponents();
    }

    @Override
    public boolean isReplaceAllowed(int rowIndex, DataType dataType) {
        DataTypeComponent dtc = this.getComponent(rowIndex);
        if (dtc == null) {
            return false;
        }
        try {
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (this.isPackingEnabled() || this.isAtEnd(rowIndex)) {
            return true;
        }
        int undefSize = this.getNumUndefinedBytesAfter(dtc);
        if (undefSize < 0) {
            return true;
        }
        int numAvailable = dtc.getLength() + undefSize;
        return dataType.getLength() <= numAvailable;
    }

    @Override
    public int getMaxAddLength(int rowIndex) {
        boolean isOneComponent;
        if (rowIndex >= this.getNumComponents() - 1) {
            return Integer.MAX_VALUE;
        }
        if (this.isPackingEnabled() || this.isAtEnd(rowIndex)) {
            return Integer.MAX_VALUE;
        }
        DataTypeComponent comp = this.getComponent(rowIndex);
        FieldRange currentRange = this.getSelectedRangeContaining(rowIndex);
        boolean bl = isOneComponent = currentRange == null || currentRange.getStart().getIndex().intValue() + 1 == currentRange.getEnd().getIndex().intValue();
        if (isOneComponent) {
            return comp.getLength() + this.getNumUndefinedBytesAfter(comp);
        }
        return this.getNumBytesInRange(currentRange);
    }

    @Override
    public int getMaxReplaceLength(int currentIndex) {
        boolean isOneComponent;
        if (currentIndex >= this.getNumComponents() - 1) {
            return Integer.MAX_VALUE;
        }
        if (this.isPackingEnabled() || this.isAtEnd(currentIndex)) {
            return Integer.MAX_VALUE;
        }
        DataTypeComponent comp = this.getComponent(currentIndex);
        int numComponents = this.getNumComponents();
        if (currentIndex >= numComponents - 1 && currentIndex <= numComponents) {
            return Integer.MAX_VALUE;
        }
        if (comp == null) {
            return 0;
        }
        FieldRange currentRange = this.getSelectedRangeContaining(currentIndex);
        boolean bl = isOneComponent = currentRange == null || currentRange.getStart().getIndex().intValue() + 1 == currentRange.getEnd().getIndex().intValue();
        if (isOneComponent) {
            return comp.getLength() + this.getNumUndefinedBytesAfter(comp);
        }
        return this.getNumBytesInRange(currentRange);
    }

    @Override
    protected int getNumBytesInRange(FieldRange range) {
        int numBytesInRange = 0;
        if (range != null) {
            int startIndex = range.getStart().getIndex().intValue();
            int endIndex = range.getEnd().getIndex().intValue() - 1;
            DataTypeComponent startComp = this.getComponent(startIndex);
            DataTypeComponent endComp = this.getComponent(endIndex);
            numBytesInRange = endComp.getOffset() + endComp.getLength();
            numBytesInRange -= startComp.getOffset();
        }
        return numBytesInRange;
    }

    @Override
    protected DataTypeComponent insert(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            return (DataTypeComponent)this.viewDTM.withTransaction("Insert Component", () -> {
                DataTypeComponent dtc;
                if (this.isPackingEnabled() || !(dataType instanceof BitFieldDataType)) {
                    dtc = ((Structure)this.viewComposite).insert(rowIndex, dataType, length, name, comment);
                } else {
                    BitFieldDataType bitfield = (BitFieldDataType)dataType;
                    dtc = ((Structure)this.viewComposite).insertBitField(rowIndex, length, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), name, comment);
                }
                if (rowIndex <= this.currentEditRow) {
                    ++this.currentEditRow;
                }
                this.adjustSelection(rowIndex, 1);
                this.consumeByComponent(rowIndex - 1);
                return dtc;
            });
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    @Override
    protected void insert(int rowIndex, DataType dataType, int length, int numCopies, TaskMonitor monitor) throws InvalidDataTypeException, CancelledException {
        this.checkIsAllowableDataType(dataType);
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        monitor.initialize((long)numCopies);
        try {
            this.viewDTM.withTransaction("Insert Multiple", () -> {
                for (int i = 0; i < numCopies; ++i) {
                    monitor.checkCancelled();
                    monitor.setMessage("Inserting " + (i + 1) + " of " + numCopies);
                    ((Structure)this.viewComposite).insert(componentOrdinal, dataType, length);
                    monitor.incrementProgress(1L);
                }
                if (rowIndex <= this.currentEditRow) {
                    this.currentEditRow += numCopies;
                }
                this.adjustSelection(componentOrdinal, numCopies);
                this.consumeByComponent(componentOrdinal - numCopies);
            });
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    @Override
    protected DataTypeComponent replace(int rowIndex, DataType dataType, int length, String name, String comment) throws InvalidDataTypeException {
        this.checkIsAllowableDataType(dataType);
        try {
            DataTypeComponent dtc = null;
            boolean isSelected = this.selection.containsEntirely(BigInteger.valueOf(rowIndex));
            int diffLen = 0;
            int componentOrdinal = this.convertRowToOrdinal(rowIndex);
            if (!this.isPackingEnabled() && !this.isAtEnd(rowIndex)) {
                int origLen = this.getComponent(rowIndex).getLength();
                dtc = (DataTypeComponent)this.viewDTM.withTransaction("Replace Component", () -> ((Structure)this.viewComposite).replace(componentOrdinal, dataType, length, name, comment));
                diffLen = origLen - dtc.getLength();
                int nextRowIndex = rowIndex + 1;
                if (diffLen < 0) {
                    this.selection.removeRange(nextRowIndex, nextRowIndex - diffLen);
                    this.adjustSelection(nextRowIndex, diffLen);
                } else if (diffLen > 0) {
                    this.adjustSelection(nextRowIndex, diffLen);
                    if (isSelected) {
                        this.selection.addRange(nextRowIndex, nextRowIndex + diffLen);
                    }
                }
                if (rowIndex < this.currentEditRow) {
                    this.currentEditRow += diffLen;
                }
            } else {
                dtc = (DataTypeComponent)this.viewDTM.withTransaction("Replace Component", () -> {
                    int avail;
                    DataTypeComponent comp = this.getComponent(rowIndex);
                    if (!this.isPackingEnabled() && length > (avail = comp.getLength() + this.getNumUndefinedBytesAfter(comp))) {
                        ((Structure)this.viewComposite).growStructure(length - avail);
                    }
                    return ((Structure)this.viewComposite).replace(componentOrdinal, dataType, length, name, comment);
                });
            }
            return dtc;
        }
        catch (IllegalArgumentException exc) {
            throw new InvalidDataTypeException(exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean replaceRange(int startRowIndex, int endRowIndex, DataType datatype, int length, TaskMonitor monitor) throws InvalidDataTypeException, InsufficientBytesException, CancelledException {
        if (startRowIndex > endRowIndex) {
            return false;
        }
        DataTypeComponent startComp = this.getComponent(startRowIndex);
        DataTypeComponent endComp = this.getComponent(endRowIndex);
        int numBytesInRange = endComp.getOffset() + endComp.getLength();
        if (length > (numBytesInRange -= startComp.getOffset())) {
            throw new InsufficientBytesException("\"" + datatype.getDisplayName() + "\" does not fit in selection.");
        }
        int numComps = numBytesInRange / length;
        String fieldName = startComp.getFieldName();
        String comment = startComp.getComment();
        FieldSelection overlap = new FieldSelection();
        overlap.addRange(startRowIndex, endRowIndex + 1);
        overlap.intersect(this.selection);
        boolean replacedSelected = overlap.getNumRanges() > 0;
        int txId = this.viewDTM.startTransaction("Replace Multiple");
        try {
            this.deleteComponentRange(startRowIndex, endRowIndex, monitor);
            int beginUndefs = startRowIndex + numComps;
            this.insertMultiple(startRowIndex, datatype, length, numComps, monitor);
            int indexAfterMultiple = startRowIndex + numComps;
            if (replacedSelected) {
                this.selection.addRange(startRowIndex, indexAfterMultiple);
                this.fixSelection();
            }
            DataTypeComponent comp = this.getComponent(startRowIndex);
            try {
                comp.setFieldName(fieldName);
            }
            catch (DuplicateNameException exc) {
                Msg.showError((Object)this, null, null, null);
            }
            comp.setComment(comment);
            int remainingLength = numBytesInRange - numComps * length;
            if (remainingLength > 0 && this.isShowingUndefinedBytes()) {
                try {
                    this.insertComponentMultiple(beginUndefs, DataType.DEFAULT, DataType.DEFAULT.getLength(), remainingLength, monitor);
                    if (replacedSelected) {
                        this.selection.addRange(indexAfterMultiple, indexAfterMultiple + remainingLength);
                    }
                }
                catch (InvalidDataTypeException idte) {
                    Msg.showError((Object)this, null, (String)"Structure Editor Error", (Object)idte.getMessage());
                }
            } else if (remainingLength < 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.viewDTM.endTransaction(txId, true);
        }
    }

    @Override
    protected void replaceOriginalComponents() {
        if (this.originalComposite == null) {
            throw new RuntimeException("ERROR: Couldn't replace structure components in " + this.getOriginalDataTypeName() + ".");
        }
        ((Structure)this.originalComposite).replaceWith((DataType)this.viewComposite);
    }

    @Override
    public boolean isShowingUndefinedBytes() {
        return !((Structure)this.viewComposite).isPackingEnabled();
    }

    void createInternalStructure() throws UsrException {
        int choice;
        if (this.selection.getNumRanges() != 1) {
            throw new UsrException("Can only create structure on a contiguous selection.");
        }
        FieldRange fieldRange = this.selection.getFieldRange(0);
        int minRow = fieldRange.getStart().getIndex().intValue();
        int maxRow = fieldRange.getEnd().getIndex().intValue();
        int selectedRowCount = maxRow - minRow;
        if (selectedRowCount == 1 && (choice = OptionDialog.showYesNoDialog((Component)this.provider.getComponent(), (String)"Create Structure From Selected Components", (String)"You only have a single component selected.\nAre you sure you want to create a structure from the selection?")) == 2) {
            return;
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        DataTypeManager originalDtm = this.getOriginalDataTypeManager();
        CategoryPath originalCategoryPath = this.getOriginalCategoryPath();
        String uniqueName = this.getUniqueDataTypeName(originalCategoryPath, "struct");
        String specifiedName = this.showNameDialog(uniqueName, originalCategoryPath, ((Structure)this.viewComposite).getName(), originalDtm);
        if (specifiedName == null) {
            return;
        }
        TaskLauncher.launchModal((String)"Create Structure", monitor -> {
            try {
                this.doCreateInternalStructure(originalDtm, originalCategoryPath, specifiedName, monitor);
            }
            catch (UsrException e) {
                this.setStatus(e.getMessage(), true);
            }
        });
    }

    private String getUniqueDataTypeName(CategoryPath path, String baseName) {
        int pos = baseName.lastIndexOf(95);
        int oneUpNumber = 0;
        Object name = baseName;
        if (pos > 0) {
            String numString = baseName.substring(pos + 1);
            try {
                oneUpNumber = Integer.parseInt(numString);
                name = baseName;
                baseName = baseName.substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DataTypeManager originalDtm = this.getOriginalDataTypeManager();
        while (originalDtm.getDataType(path, (String)name) != null || this.viewDTM.getDataType(path, (String)name) != null) {
            name = baseName + "_" + ++oneUpNumber;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateInternalStructure(DataTypeManager dtm, CategoryPath categoryPath, String name, TaskMonitor monitor) throws InvalidDataTypeException, UsrException {
        int length = 0;
        StructureDataType structureDataType = new StructureDataType(categoryPath, name, length, dtm);
        structureDataType.setPackingEnabled(this.isPackingEnabled());
        if (this.getPackingType() == PackingType.EXPLICIT) {
            structureDataType.setExplicitPackingValue(this.getExplicitPackingValue());
        }
        FieldRange fieldRange = this.selection.getFieldRange(0);
        int minRow = fieldRange.getStart().getIndex().intValue();
        int maxRow = fieldRange.getEnd().getIndex().intValue();
        DataTypeComponent firstDtc = null;
        DataTypeComponent lastDtc = null;
        for (int rowIndex = minRow; rowIndex < maxRow; ++rowIndex) {
            DataTypeComponent component = this.getComponent(rowIndex);
            if (rowIndex == minRow) {
                firstDtc = component;
            }
            if (component == null) {
                lastDtc = component;
                continue;
            }
            DataType dt = component.getDataType();
            int compLength = component.getLength();
            length += compLength;
            if (!structureDataType.isPackingEnabled() && component.isBitFieldComponent()) {
                BitFieldDataType bitfield = (BitFieldDataType)dt;
                structureDataType.insertBitFieldAt(component.getOffset() - firstDtc.getOffset(), compLength, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), component.getFieldName(), component.getComment());
            } else {
                structureDataType.add(dt, compLength, component.getFieldName(), component.getComment());
            }
            lastDtc = component;
        }
        DataType addedDataType = this.createDataTypeInOriginalDTM(structureDataType);
        int txId = this.viewDTM.startTransaction("Replace w/Structure");
        try {
            if (((Structure)this.viewComposite).isPackingEnabled()) {
                this.deleteSelectedComponents();
                this.insert(minRow, addedDataType, addedDataType.getLength());
            } else {
                DataTypeComponent dtc;
                DataTypeComponent dtc2;
                int adjustmentBytes = 0;
                if (firstDtc != null && firstDtc.isBitFieldComponent() && minRow > 0 && (dtc2 = this.getComponent(minRow - 1)).getEndOffset() == firstDtc.getOffset()) {
                    ++adjustmentBytes;
                }
                if (lastDtc != null && lastDtc.isBitFieldComponent() && maxRow < this.getNumComponents() && (dtc = this.getComponent(maxRow)).getOffset() == lastDtc.getEndOffset()) {
                    ++adjustmentBytes;
                }
                this.clearSelectedComponents();
                this.insertMultiple(minRow, DataType.DEFAULT, 1, adjustmentBytes, monitor);
                this.replace(minRow, addedDataType, addedDataType.getLength());
            }
        }
        finally {
            this.viewDTM.endTransaction(txId, true);
        }
    }

    private String showNameDialog(String defaultName, CategoryPath catPath, String parentStructureName, DataTypeManager applyDTM) {
        InputDialogListener listener = dialog -> {
            String name = dialog.getValue();
            if (name == null || name.length() == 0) {
                dialog.setStatusText("A name must be specified.");
                return false;
            }
            if (name.equals(parentStructureName)) {
                dialog.setStatusText("The name cannot match the external structure name.");
                return false;
            }
            DataTypeManager originalDtm = this.getOriginalDataTypeManager();
            DataType conflictingDt = originalDtm.getDataType(this.getOriginalCategoryPath(), name);
            if (conflictingDt != null) {
                dialog.setStatusText("A data type named \"" + name + "\" already exists.");
                return false;
            }
            return true;
        };
        String title = "Specify the Structure's Name";
        InputDialog nameStructureDialog = new InputDialog(title, new String[]{"New Structure's Name: "}, new String[]{defaultName}, listener);
        this.provider.getPlugin().getTool().showDialog((DialogComponentProvider)nameStructureDialog);
        if (nameStructureDialog.isCanceled()) {
            return null;
        }
        return nameStructureDialog.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType createDataTypeInOriginalDTM(StructureDataType structureDataType) {
        boolean commit = false;
        int transactionID = this.originalDTM.startTransaction("Create structure " + structureDataType.getName());
        try {
            DataType addedDataType = this.originalDTM.addDataType((DataType)structureDataType, DataTypeConflictHandler.DEFAULT_HANDLER);
            commit = true;
            DataType dataType = addedDataType;
            return dataType;
        }
        finally {
            this.originalDTM.endTransaction(transactionID, commit);
        }
    }

    public void unpackage(int rowIndex, TaskMonitor monitor) throws UsrException {
        int componentOrdinal = this.convertRowToOrdinal(rowIndex);
        DataTypeComponent currentComp = ((Structure)this.viewComposite).getComponent(componentOrdinal);
        if (currentComp == null) {
            throw new UsrException("Can only unpackage an array or structure.");
        }
        DataType dt = currentComp.getDataType();
        if (dt instanceof TypeDef) {
            TypeDef td = (TypeDef)dt;
            dt = td.getBaseDataType();
        }
        if (!(dt instanceof Array) && !(dt instanceof Structure)) {
            throw new UsrException("Can only unpackage an array or structure.");
        }
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        DataType currentDataType = dt;
        this.viewDTM.withTransaction("Unpack Component", () -> {
            Structure struct;
            String fieldName = currentComp.getFieldName();
            String comment = currentComp.getComment();
            int numComps = 0;
            if (currentDataType instanceof Array) {
                Array array = (Array)currentDataType;
                int elementLen = array.getElementLength();
                numComps = array.getNumElements();
                this.delete(componentOrdinal);
                if (array.isZeroLength()) {
                    return;
                }
                if (numComps > 0) {
                    try {
                        DataType arrayBaseDt = array.getDataType();
                        this.insertMultiple(rowIndex, arrayBaseDt, elementLen, numComps, monitor);
                    }
                    catch (InvalidDataTypeException arrayBaseDt) {
                    }
                    catch (OutOfMemoryError memExc) {
                        throw memExc;
                    }
                }
            } else if (currentDataType instanceof Structure && (numComps = (struct = (Structure)currentDataType).getNumComponents()) > 0) {
                DataTypeComponent dtc;
                int currentOffset = currentComp.getOffset();
                Stack<DataTypeComponent> zeroDtcStack = new Stack<DataTypeComponent>();
                int zeroStackOffset = -1;
                int zeroStackOrdinal = -1;
                int packedOrdinal = 0;
                this.deleteComponent(rowIndex);
                if (struct.isZeroLength()) {
                    return;
                }
                if (rowIndex != 0 && !((Structure)this.viewComposite).isPackingEnabled() && (dtc = ((Structure)this.viewComposite).getDefinedComponentAtOrAfterOffset(currentOffset)) != null && dtc.getOffset() == currentOffset) {
                    zeroStackOffset = 0;
                    int componentCount = ((Structure)this.viewComposite).getNumComponents();
                    while (dtc != null && dtc.getOffset() == currentOffset) {
                        int ordinal = dtc.getOrdinal();
                        zeroDtcStack.push(dtc);
                        ((Structure)this.viewComposite).delete(ordinal);
                        dtc = ordinal < --componentCount ? ((Structure)this.viewComposite).getComponent(ordinal) : null;
                    }
                }
                for (DataTypeComponent dtc2 : struct.getDefinedComponents()) {
                    DataType compDt = dtc2.getDataType();
                    int compLength = dtc2.getLength();
                    int compOffset = dtc2.getOffset();
                    if (compOffset != zeroStackOffset && !zeroDtcStack.isEmpty()) {
                        packedOrdinal += zeroDtcStack.size();
                        this.applyZeroDtcStack((Structure)this.viewComposite, currentOffset, componentOrdinal, zeroDtcStack, zeroStackOffset, zeroStackOrdinal);
                    }
                    if (compLength == 0) {
                        if (zeroStackOffset != compOffset) {
                            zeroStackOffset = compOffset;
                            zeroStackOrdinal = packedOrdinal;
                        }
                        zeroDtcStack.push(dtc2);
                        continue;
                    }
                    if (!this.isPackingEnabled()) {
                        if (dtc2.isBitFieldComponent()) {
                            BitFieldDataType bitfield = (BitFieldDataType)compDt;
                            ((Structure)this.viewComposite).insertBitFieldAt(currentOffset + compOffset, compLength, bitfield.getBitOffset(), bitfield.getBaseDataType(), bitfield.getDeclaredBitSize(), dtc2.getFieldName(), dtc2.getComment());
                        } else {
                            ((Structure)this.viewComposite).insertAtOffset(currentOffset + compOffset, compDt, compLength, dtc2.getFieldName(), dtc2.getComment());
                        }
                    } else {
                        ((Structure)this.viewComposite).insert(componentOrdinal + packedOrdinal, compDt, compLength, dtc2.getFieldName(), dtc2.getComment());
                    }
                    ++packedOrdinal;
                }
                if (!zeroDtcStack.isEmpty()) {
                    this.applyZeroDtcStack((Structure)this.viewComposite, currentOffset, componentOrdinal, zeroDtcStack, zeroStackOffset, zeroStackOrdinal);
                }
            }
            this.selection.clear();
            this.selection.addRange(rowIndex, rowIndex + numComps);
            DataTypeComponent comp = this.getComponent(rowIndex);
            try {
                if (comp.getFieldName() == null) {
                    comp.setFieldName(fieldName);
                }
            }
            catch (DuplicateNameException exc) {
                Msg.showError((Object)this, null, null, null);
            }
            if (StringUtils.isBlank((CharSequence)comp.getComment())) {
                comp.setComment(comment);
            }
        });
        this.fixSelection();
        this.selectionChanged();
    }

    private void applyZeroDtcStack(Structure viewStruct, int unpackOffset, int unpackOrdinal, Stack<DataTypeComponent> zeroDtcStack, int zeroStackOffset, int zeroStackOrdinal) {
        while (!zeroDtcStack.isEmpty()) {
            DataTypeComponent zeroDtc = zeroDtcStack.pop();
            if (!this.isPackingEnabled()) {
                viewStruct.insertAtOffset(unpackOffset + zeroStackOffset, zeroDtc.getDataType(), 0, zeroDtc.getFieldName(), zeroDtc.getComment());
                continue;
            }
            viewStruct.insert(unpackOrdinal + zeroStackOrdinal, zeroDtc.getDataType(), 0, zeroDtc.getFieldName(), zeroDtc.getComment());
        }
    }
}

