/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.app.util.NamespaceUtils;
import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;

public class CreateNamespacesCmd
implements Command<Program> {
    private String statusMsg;
    private Namespace rootNamespace;
    private String namespacesString;
    private SourceType source;
    private Namespace leafNamespace;

    public CreateNamespacesCmd(String namespacesString, SourceType source) {
        this(namespacesString, null, source);
    }

    public CreateNamespacesCmd(String namespacesString, Namespace parentNamespace, SourceType source) {
        if (namespacesString == null) {
            throw new NullPointerException("Cannot create namespaces from a null namespacesString value.");
        }
        this.namespacesString = namespacesString;
        this.rootNamespace = parentNamespace;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        try {
            this.leafNamespace = NamespaceUtils.createNamespaceHierarchy((String)this.namespacesString, (Namespace)this.rootNamespace, (Program)program, (SourceType)this.source);
            if (this.leafNamespace != null) {
                return true;
            }
        }
        catch (InvalidInputException e) {
            this.statusMsg = e.getMessage();
            return false;
        }
        this.statusMsg = "Unable to create namespaces from namespace string: " + this.namespacesString;
        return false;
    }

    public Namespace getNamespace() {
        return this.leafNamespace;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Create Namespaces";
    }
}

