/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class EditingPopupGraphMousePlugin<V, E>
extends AbstractPopupGraphMousePlugin {
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;

    public EditingPopupGraphMousePlugin(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    @Override
    protected void handlePopup(MouseEvent e) {
        final VisualizationViewer vv = (VisualizationViewer)e.getSource();
        final Layout layout = vv.getGraphLayout();
        final Graph graph = layout.getGraph();
        final Point p = e.getPoint();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        if (pickSupport != null) {
            final Object vertex = pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
            final Object edge = pickSupport.getEdge(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
            final PickedState pickedVertexState = vv.getPickedVertexState();
            final PickedState pickedEdgeState = vv.getPickedEdgeState();
            JPopupMenu popup = new JPopupMenu();
            if (vertex != null) {
                Set picked = pickedVertexState.getPicked();
                if (picked.size() > 0) {
                    if (!(graph instanceof UndirectedGraph)) {
                        JMenu directedMenu = new JMenu("Create Directed Edge");
                        popup.add(directedMenu);
                        for (final Object other : picked) {
                            directedMenu.add(new AbstractAction("[" + other + "," + vertex + "]"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    graph.addEdge(EditingPopupGraphMousePlugin.this.edgeFactory.get(), other, vertex, EdgeType.DIRECTED);
                                    vv.repaint();
                                }
                            });
                        }
                    }
                    if (!(graph instanceof DirectedGraph)) {
                        JMenu undirectedMenu = new JMenu("Create Undirected Edge");
                        popup.add(undirectedMenu);
                        for (final Object other : picked) {
                            undirectedMenu.add(new AbstractAction("[" + other + "," + vertex + "]"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    graph.addEdge(EditingPopupGraphMousePlugin.this.edgeFactory.get(), other, vertex);
                                    vv.repaint();
                                }
                            });
                        }
                    }
                }
                popup.add(new AbstractAction("Delete Vertex"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedVertexState.pick(vertex, false);
                        graph.removeVertex(vertex);
                        vv.repaint();
                    }
                });
            } else if (edge != null) {
                popup.add(new AbstractAction("Delete Edge"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedEdgeState.pick(edge, false);
                        graph.removeEdge(edge);
                        vv.repaint();
                    }
                });
            } else {
                popup.add(new AbstractAction("Create Vertex"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object newVertex = EditingPopupGraphMousePlugin.this.vertexFactory.get();
                        graph.addVertex(newVertex);
                        layout.setLocation(newVertex, vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p));
                        vv.repaint();
                    }
                });
            }
            if (popup.getComponentCount() > 0) {
                popup.show(vv, e.getX(), e.getY());
            }
        }
    }
}

