/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FileChooserToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    static final Border RAISED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    static final Border NO_BORDER = new EmptyBorder(RAISED_BORDER.getBorderInsets(new JButton()));
    static final Border LOWERED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));

    public FileChooserToggleButton(String text) {
        super(text);
        this.initBorder();
    }

    public FileChooserToggleButton(Action action) {
        super(action);
        this.initBorder();
    }

    private void initBorder() {
        this.setForeground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.setOpaque(true);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.clearBorder();
        this.setContentAreaFilled(false);
        this.addMouseListener(new ButtonMouseListener());
        this.addChangeListener(e -> {
            if (this.isSelected()) {
                this.setBorder(LOWERED_BORDER);
            } else {
                this.setBorder(NO_BORDER);
            }
        });
        this.setFocusable(false);
    }

    void clearBorder() {
        this.setBorder(NO_BORDER);
    }

    File getFile() {
        return null;
    }

    private class ButtonMouseListener
    extends MouseAdapter {
        private boolean inside = false;
        private Border defaultBorder;

        private ButtonMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            if (FileChooserToggleButton.this.isSelected()) {
                return;
            }
            this.defaultBorder = FileChooserToggleButton.this.getBorder();
            FileChooserToggleButton.this.setBorder(RAISED_BORDER);
            this.inside = true;
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (FileChooserToggleButton.this.isSelected()) {
                return;
            }
            this.inside = false;
            this.restoreBorder();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (FileChooserToggleButton.this.isSelected()) {
                return;
            }
            if (e.getButton() == 1) {
                FileChooserToggleButton.this.setBorder(LOWERED_BORDER);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FileChooserToggleButton.this.isSelected()) {
                return;
            }
            if (this.inside) {
                FileChooserToggleButton.this.setBorder(RAISED_BORDER);
            } else {
                this.restoreBorder();
            }
        }

        private void restoreBorder() {
            if (this.defaultBorder != null) {
                FileChooserToggleButton.this.setBorder(this.defaultBorder);
            } else {
                FileChooserToggleButton.this.setBorder(NO_BORDER);
            }
        }
    }
}

