/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandler;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;

public class GhidraURLResultHandlerAdapter
implements GhidraURLResultHandler {
    private final boolean throwErrorByDefault;

    public GhidraURLResultHandlerAdapter() {
        this.throwErrorByDefault = false;
    }

    public GhidraURLResultHandlerAdapter(boolean throwErrorByDefault) {
        this.throwErrorByDefault = throwErrorByDefault;
    }

    @Override
    public void processResult(DomainFile domainFile, URL url, TaskMonitor monitor) throws IOException, CancelledException {
        this.handleError("Unsupported Content", "File URL: " + String.valueOf(url), null, null);
    }

    @Override
    public void processResult(DomainFolder domainFolder, URL url, TaskMonitor monitor) throws IOException, CancelledException {
        this.handleError("Unsupported Content", "Folder URL: " + String.valueOf(url), null, null);
    }

    @Override
    public void handleError(String title, String message, URL url, IOException cause) throws IOException {
        if (!this.throwErrorByDefault) {
            Msg.showError(GhidraURLQuery.class, null, (String)title, (Object)(message + ":\n" + String.valueOf(url)));
        }
        if (cause != null) {
            throw cause;
        }
        throw new IOException(title + ": " + message);
    }
}

