/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.functiontype;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.functiontype.MDArgumentsList;
import mdemangler.functiontype.MDCallingConvention;
import mdemangler.functiontype.MDThrowAttribute;

public class MDFunctionType
extends MDType {
    private MDCallingConvention convention;
    private MDDataType retType;
    private MDArgumentsList argsList;
    private MDCVMod thisPointerCVMod;
    private MDThrowAttribute throwAttribute;
    private boolean hasCVModifier = false;
    private boolean hasReturn;
    private boolean hasArgs;
    private boolean isTypeCast;
    protected boolean fromModifier = false;
    protected MDBasedAttribute based;

    public void setBased(MDBasedAttribute based) {
        this.based = based;
    }

    public MDFunctionType(MDMang dmang) {
        this(dmang, true, true);
    }

    public MDFunctionType(MDMang dmang, boolean hasArgs, boolean hasReturn) {
        super(dmang);
        this.hasArgs = hasArgs;
        this.hasReturn = hasReturn;
    }

    public MDCallingConvention getCallingConvention() {
        return this.convention;
    }

    public MDDataType getReturnType() {
        return this.retType;
    }

    public MDArgumentsList getArgumentsList() {
        return this.argsList;
    }

    public MDCVMod getThisPointerCVMod() {
        return this.thisPointerCVMod;
    }

    public MDThrowAttribute getThrowAttribute() {
        return this.throwAttribute;
    }

    public void setFromModifier() {
        this.fromModifier = true;
    }

    public void setThisPointerCVMod(MDCVMod thisPointerCVMod) {
        this.thisPointerCVMod = thisPointerCVMod;
    }

    public void setHasCVModifier() {
        this.hasCVModifier = true;
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public boolean hasArgs() {
        return this.hasArgs;
    }

    public boolean isTypeCast() {
        return this.isTypeCast;
    }

    public void setTypeCast() {
        this.isTypeCast = true;
    }

    @Override
    protected void parseInternal() throws MDException {
        super.parseInternal();
        this.dmang.pushFunctionContext();
        if (this.hasCVModifier) {
            this.thisPointerCVMod = new MDCVMod(this.dmang);
            this.thisPointerCVMod.setThisPointerMod();
            this.thisPointerCVMod.parse();
        }
        this.convention = new MDCallingConvention(this.dmang);
        this.convention.parse();
        if (this.hasReturn) {
            this.retType = MDDataTypeParser.parseDataType(this.dmang, this.isTypeCast);
            this.retType.parse();
        }
        if (this.hasArgs) {
            this.argsList = new MDArgumentsList(this.dmang);
            this.argsList.parse();
            this.throwAttribute = new MDThrowAttribute(this.dmang);
            this.throwAttribute.parse();
        }
        this.dmang.popContext();
    }

    @Override
    public void insert(StringBuilder builder) {
        String ta;
        super.insert(builder);
        String badChars = "*&( ";
        if (builder.length() != 0 && badChars.indexOf(builder.charAt(0)) == -1) {
            this.dmang.insertString(builder, " ");
        }
        StringBuilder conventionBuilder = new StringBuilder();
        this.convention.insert(conventionBuilder);
        if (this.based != null) {
            this.based.append(conventionBuilder);
        }
        this.dmang.cleanOutput(conventionBuilder);
        this.dmang.insertString(builder, conventionBuilder.toString());
        if (this.fromModifier) {
            this.dmang.insertString(builder, "(");
            this.dmang.appendString(builder, ")");
        }
        if (this.hasArgs & this.argsList != null) {
            this.dmang.appendString(builder, "(");
            this.argsList.insert(builder);
            this.dmang.appendString(builder, ")");
        }
        if (this.thisPointerCVMod != null) {
            StringBuilder cvBuilder = new StringBuilder();
            this.thisPointerCVMod.insert(cvBuilder);
            this.dmang.appendString(builder, cvBuilder.toString());
        }
        if (this.hasReturn && this.retType != null && !this.isTypeCast) {
            this.retType.insert(builder);
        }
        if (this.throwAttribute != null && (ta = this.throwAttribute.toString()).length() != 0) {
            this.dmang.appendString(builder, " " + ta);
        }
    }
}

