/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.symbol.VariableStorageDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VariableStorageDBAdapterV2
extends VariableStorageDBAdapter {
    private static final int TABLE_VERSION = 2;
    private Table variableStorageTable;
    private DBHandle handle;

    VariableStorageDBAdapterV2(DBHandle handle, boolean create) throws VersionException, IOException {
        this.handle = handle;
        if (create) {
            this.variableStorageTable = handle.createTable("Variable Storage", VARIABLE_STORAGE_SCHEMA, new int[]{0});
        } else {
            this.variableStorageTable = handle.getTable("Variable Storage");
            if (this.variableStorageTable == null) {
                throw new VersionException(1, true);
            }
            int version = this.variableStorageTable.getSchema().getVersion();
            if (version < 2) {
                throw new VersionException(1, true);
            }
            if (version > 2) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    void deleteTable() throws IOException {
        this.handle.deleteTable("Variable Storage");
    }

    @Override
    long getNextStorageID() {
        long nextKey = this.variableStorageTable.getMaxKey() + 1L;
        if (nextKey <= 0L) {
            nextKey = 1L;
        }
        return nextKey;
    }

    @Override
    long findRecordKey(long hash) throws IOException {
        Field[] recs = this.variableStorageTable.findRecords((Field)new LongField(hash), 0);
        return recs.length == 0 ? -1L : recs[0].getLongValue();
    }

    @Override
    void deleteRecord(long key) throws IOException {
        this.variableStorageTable.deleteRecord(key);
    }

    @Override
    DBRecord getRecord(long key) throws IOException {
        return this.variableStorageTable.getRecord(key);
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.variableStorageTable.putRecord(record);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.variableStorageTable.iterator();
    }

    @Override
    int getRecordCount() {
        return this.variableStorageTable.getRecordCount();
    }

    public static VariableStorageDBAdapter upgrade(DBHandle dbHandle, VariableStorageDBAdapter oldAdapter, TaskMonitor monitor) throws IOException {
        try {
            return new VariableStorageDBAdapterV2(dbHandle, true);
        }
        catch (VersionException e) {
            throw new AssertException((Throwable)e);
        }
    }
}

