/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.OldVariableStorageDBAdapterV0V1;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Hashtable;

public class OldVariableStorageManagerDB {
    private AddressMap addrMap;
    private OldVariableStorageDBAdapterV0V1 adapter;
    private DBHandle handle;
    private long lastNamespaceCacheID;
    private Hashtable<Address, OldVariableStorage> variableAddrLookupCache = new Hashtable();
    private Hashtable<Address, OldVariableStorage> storageAddrLookupCache = new Hashtable();

    public OldVariableStorageManagerDB(DBHandle handle, AddressMap addrMap, TaskMonitor monitor) throws IOException, CancelledException {
        this.addrMap = addrMap;
        this.handle = handle;
        this.adapter = new OldVariableStorageDBAdapterV0V1(handle);
    }

    static boolean isOldVariableStorageManagerUpgradeRequired(DBHandle handle) {
        return handle.getTable("VariableStorage") != null;
    }

    void deleteTable() throws IOException {
        this.handle.deleteTable("VariableStorage");
    }

    private void cacheNamespaceStorage(long namespaceID) throws IOException {
        DBRecord[] records;
        this.variableAddrLookupCache.clear();
        this.storageAddrLookupCache.clear();
        this.lastNamespaceCacheID = namespaceID;
        for (DBRecord rec : records = this.adapter.getRecordsForNamespace(namespaceID)) {
            OldVariableStorage varStore = new OldVariableStorage(this, rec);
            this.variableAddrLookupCache.put(varStore.variableAddr, varStore);
            this.storageAddrLookupCache.put(varStore.storageAddr, varStore);
        }
    }

    private OldVariableStorage getVariableStorage(Address variableAddr) throws IOException {
        OldVariableStorage varStore;
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException();
        }
        if (this.lastNamespaceCacheID != -1L && (varStore = this.variableAddrLookupCache.get(variableAddr)) != null) {
            return varStore;
        }
        DBRecord rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        this.cacheNamespaceStorage(rec.getLongValue(1));
        return this.variableAddrLookupCache.get(variableAddr);
    }

    public Address getStorageAddress(Address variableAddr) throws IOException {
        OldVariableStorage varStore = this.getVariableStorage(variableAddr);
        return varStore != null ? varStore.storageAddr : null;
    }

    private class OldVariableStorage {
        private final Address variableAddr;
        private final Address storageAddr;

        private OldVariableStorage(OldVariableStorageManagerDB oldVariableStorageManagerDB, DBRecord record) {
            this.variableAddr = AddressSpace.VARIABLE_SPACE.getAddress(record.getKey());
            this.storageAddr = oldVariableStorageManagerDB.addrMap.decodeAddress(record.getLongValue(0));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OldVariableStorage)) {
                return false;
            }
            return this.variableAddr.getOffset() == ((OldVariableStorage)obj).variableAddr.getOffset();
        }

        public int hashCode() {
            return (int)this.variableAddr.getOffset();
        }
    }
}

