/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import docking.widgets.table.TableRowMapper;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMarkupItemSourceAddressToProgramLocationTableRowMapper
extends ProgramLocationTableRowMapper<VTMarkupItem, ProgramLocation> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMarkupItem, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> sourceColumn) {
        if (sourceColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)sourceColumn;
            return new VTMarkupItemSourceWrappedMappedProgramLocationTableColumn(this, this, programColumn);
        }
        return new VTMarkupItemSourceWrappedMappedTableColumn<COLUMN_TYPE>(this, (TableRowMapper<VTMarkupItem, ProgramLocation, Program>)this, sourceColumn);
    }

    public ProgramLocation map(VTMarkupItem rowObject, Program program, ServiceProvider serviceProvider) {
        Address address = rowObject.getSourceAddress();
        return new ProgramLocation(program, address);
    }

    private class VTMarkupItemSourceWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMarkupItem, ProgramLocation, COLUMN_TYPE> {
        public VTMarkupItemSourceWrappedMappedProgramLocationTableColumn(VTMarkupItemSourceAddressToProgramLocationTableRowMapper vTMarkupItemSourceAddressToProgramLocationTableRowMapper, ProgramLocationTableRowMapper<VTMarkupItem, ProgramLocation> mapper, ProgramLocationTableColumn<ProgramLocation, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }

    private class VTMarkupItemSourceWrappedMappedTableColumn<COLUMN_TYPE>
    extends MappedTableColumn<VTMarkupItem, ProgramLocation, COLUMN_TYPE, Program> {
        public VTMarkupItemSourceWrappedMappedTableColumn(VTMarkupItemSourceAddressToProgramLocationTableRowMapper vTMarkupItemSourceAddressToProgramLocationTableRowMapper, TableRowMapper<VTMarkupItem, ProgramLocation, Program> mapper, DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }
}

