/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.markuptype.CommentMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;

public class PostCommentMarkupType
extends CommentMarkupType {
    public static final VTMarkupType INSTANCE = new PostCommentMarkupType();

    private PostCommentMarkupType() {
        super("Post Comment");
    }

    @Override
    protected CommentType getCodeUnitCommentType() {
        return CommentType.POST;
    }

    @Override
    protected ProgramLocation getLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        return new PostCommentFieldLocation(program, address, null, null, 0, 0);
    }

    @Override
    public VTMatchApplyChoices.CommentChoices getCommentChoice(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices commentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        return commentChoice;
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices commentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        switch (commentChoice) {
            case APPEND_TO_EXISTING: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case OVERWRITE_EXISTING: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                options.setEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
                break;
            }
            case ADD_AS_PRIMARY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform an Add As Primary action.");
            }
            case REPLACE_DEFAULT_ONLY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform a Replace Default Only action.");
            }
            case REPLACE: {
                options.setEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
            }
        }
        return options;
    }
}

