#!/bin/sh

width=$(xdpyinfo 2>&1 | grep dimens | awk '{ print $2 }' | cut -dx -f1)
echo "Screen width: $width"
if [ "$width" -gt 2048 ]; then
    xrandr --dpi 144
    mkdir -p /etc/sddm.conf.d/
    cat >/etc/sddm.conf.d/dpi.conf <<EOF
[X11]
ServerArguments=-nolisten tcp -dpi 144

[Wayland]
EnableHiDPI=true

[X11]
EnableHiDPI=true
EOF
    grep -q KScreen /etc/xdg/kdeglobals || cat >>/etc/xdg/kdeglobals <<EOF
[KScreen]
ScaleFactor=1.5
ScreenScaleFactors=None-1=1.5;
EOF
    cat >/etc/xdg/kcmfonts <<EOF
[General]
forceFontDPI=144
EOF
fi

sleep 0.2

export HOME=/run/user/0/calamares-home
rm -rf "$HOME"
mkdir -p "$HOME"
mkdir -p "$HOME"/.config

cat > "$HOME"/.config/kwinrc <<EOF
[Compositing]
OpenGLIsUnsafe=false

[MouseBindings]
CommandActiveTitlebar3=Nothing
CommandInactiveTitlebar3=Nothing

[org.kde.kdecoration2]
ButtonsOnLeft=
ButtonsOnRight=AX
EOF

cat > "$HOME"/.config/kwinrulesrc <<EOF
[1]
Description=Settings for calamares
above=true
aboverule=2
wmclass=calamares
wmclassmatch=1

[2]
Description=Settings for feh
below=true
belowrule=2
wmclass=feh
wmclassmatch=1
acceptfocusrule=2

[General]
count=2
rules=1,2
EOF

mkdir -p "$HOME"/.config/feh
cat > "$HOME"/.config/feh/buttons <<EOF
pan
zoom
menu
EOF

kwin_x11 &

sleep 0.2

feh --zoom fill -N -F /usr/share/wallpapers/Bamboo/contents/images/5120x2880.png &

calamares -D6 && systemctl disable calamares.service
