/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

final class RetrieverConnection {
    private static final Logger LOGGER = Logger.getLogger(RetrieverConnection.class.getName());
    private final DatabaseConnectionSource dataSource;
    private final JavaSqlTypes javaSqlTypes;
    private final SchemaRetrievalOptions schemaRetrievalOptions;

    RetrieverConnection(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions) throws SQLException {
        this.dataSource = Objects.requireNonNull(dataSource, "Database connection source not provided");
        this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database specific overrides provided");
        this.javaSqlTypes = new JavaSqlTypes();
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        return this.schemaRetrievalOptions.get(schemaInfoMetadataRetrievalStrategy);
    }

    Connection getConnection(String reason) {
        LOGGER.log(Level.FINE, () -> {
            if (!Utility.isBlank((CharSequence)reason)) {
                return "Getting database connnection for %s".formatted(reason);
            }
            return "Getting database connnection";
        });
        return (Connection)this.dataSource.get();
    }

    EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.schemaRetrievalOptions.getEnumDataTypeHelper();
    }

    Identifiers getIdentifiers() {
        return this.schemaRetrievalOptions.getIdentifiers();
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.schemaRetrievalOptions.getInformationSchemaViews();
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    TableTypes getTableTypes() {
        return this.schemaRetrievalOptions.getTableTypes();
    }

    TypeMap getTypeMap() {
        return this.schemaRetrievalOptions.getTypeMap();
    }

    boolean isSupportsCatalogs() {
        return this.schemaRetrievalOptions.isSupportsCatalogs();
    }

    boolean isSupportsSchemas() {
        return this.schemaRetrievalOptions.isSupportsSchemas();
    }
}

