/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.ImplAccessor;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.lang.reflect.Field;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class FrameWithoutBoxing
implements VirtualFrame,
MaterializedFrame {
    private static final String UNEXPECTED_STATIC_WRITE = "Unexpected static write of non-static frame slot";
    private static final String UNEXPECTED_NON_STATIC_READ = "Unexpected non-static read of static frame slot";
    private static final String UNEXPECTED_NON_STATIC_WRITE = "Unexpected non-static write of static frame slot";
    private static final boolean ASSERTIONS_ENABLED;
    private final FrameDescriptor descriptor;
    private final Object[] arguments;
    private final Object[] indexedLocals;
    private final long[] indexedPrimitiveLocals;
    private final byte[] indexedTags;
    private Object[] auxiliarySlots;
    private static final Object OBJECT_LOCATION;
    private static final Object PRIMITIVE_LOCATION;
    private static final long INT_MASK = 0xFFFFFFFFL;
    public static final byte OBJECT_TAG = 0;
    public static final byte LONG_TAG = 1;
    public static final byte INT_TAG = 2;
    public static final byte DOUBLE_TAG = 3;
    public static final byte FLOAT_TAG = 4;
    public static final byte BOOLEAN_TAG = 5;
    public static final byte BYTE_TAG = 6;
    public static final byte ILLEGAL_TAG = 7;
    public static final byte STATIC_TAG = 8;
    private static final byte STATIC_OBJECT_TAG = 8;
    private static final byte STATIC_LONG_TAG = 9;
    private static final byte STATIC_INT_TAG = 10;
    private static final byte STATIC_DOUBLE_TAG = 11;
    private static final byte STATIC_FLOAT_TAG = 12;
    private static final byte STATIC_BOOLEAN_TAG = 13;
    private static final byte STATIC_BYTE_TAG = 14;
    private static final byte STATIC_ILLEGAL_TAG = 15;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final long[] EMPTY_LONG_ARRAY;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final Unsafe UNSAFE;
    private static final Object ILLEGAL_DEFAULT;

    private static boolean areAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    public FrameWithoutBoxing(FrameDescriptor descriptor, Object[] arguments) {
        byte[] indexedTagsArray;
        long[] indexedPrimitiveLocalsArray;
        Object[] indexedLocalsArray;
        assert (ASSERTIONS_ENABLED);
        int indexedSize = descriptor.getNumberOfSlots();
        int auxiliarySize = descriptor.getNumberOfAuxiliarySlots();
        Object defaultValue = descriptor.getDefaultValue();
        if (indexedSize == 0) {
            indexedLocalsArray = EMPTY_OBJECT_ARRAY;
            indexedPrimitiveLocalsArray = EMPTY_LONG_ARRAY;
            indexedTagsArray = EMPTY_BYTE_ARRAY;
        } else {
            indexedLocalsArray = new Object[indexedSize];
            indexedPrimitiveLocalsArray = new long[indexedSize];
            indexedTagsArray = new byte[indexedSize];
            if (defaultValue == ILLEGAL_DEFAULT) {
                Arrays.fill(indexedTagsArray, (byte)7);
            } else if (defaultValue != null) {
                Arrays.fill(indexedLocalsArray, defaultValue);
            }
        }
        Object[] auxiliarySlotsArray = auxiliarySize == 0 ? EMPTY_OBJECT_ARRAY : new Object[auxiliarySize];
        this.descriptor = descriptor;
        this.arguments = arguments;
        this.indexedLocals = indexedLocalsArray;
        this.indexedPrimitiveLocals = indexedPrimitiveLocalsArray;
        this.indexedTags = indexedTagsArray;
        this.auxiliarySlots = auxiliarySlotsArray;
    }

    void reset() {
        byte defaultTag;
        Object defaultValue = this.descriptor.getDefaultValue();
        if (defaultValue == ILLEGAL_DEFAULT) {
            defaultTag = 7;
            defaultValue = null;
        } else {
            defaultTag = 0;
        }
        Arrays.fill(this.indexedTags, defaultTag);
        Arrays.fill(this.indexedLocals, defaultValue);
        Arrays.fill(this.indexedPrimitiveLocals, 0L);
        Arrays.fill(this.auxiliarySlots, null);
    }

    @Override
    public Object[] getArguments() {
        return FrameWithoutBoxing.unsafeCast(this.arguments, Object[].class, true, true, true);
    }

    @Override
    public FrameWithoutBoxing materialize() {
        ImplAccessor.frameSupportAccessor().markMaterializeCalled(this.descriptor);
        return this;
    }

    private static long extend(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private static int narrow(long value) {
        return (int)value;
    }

    @Override
    public FrameDescriptor getFrameDescriptor() {
        return FrameWithoutBoxing.unsafeCast(this.descriptor, FrameDescriptor.class, true, true, false);
    }

    private static FrameSlotTypeException frameSlotTypeException(int slot, byte expectedTag, byte actualTag) throws FrameSlotTypeException {
        throw FrameSlotTypeException.create(slot, FrameSlotKind.fromTag(expectedTag), FrameSlotKind.fromTag(actualTag));
    }

    private static long getObjectOffset(int slotIndex) {
        return (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE;
    }

    private static long getPrimitiveOffset(int slotIndex) {
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_LONG_INDEX_SCALE;
    }

    @Override
    public byte getTag(int slotIndex) {
        byte tag = this.getIndexedTags()[slotIndex];
        return tag < 8 ? tag : (byte)8;
    }

    private boolean isNonStaticType(int slotIndex, byte tag) {
        assert (!this.isStatic(slotIndex)) : "Using isType on static slots is to be avoided.";
        return this.getIndexedTags()[slotIndex] == tag;
    }

    byte unsafeGetTag(int slotIndex) {
        return this.unsafeGetIndexedTag(slotIndex);
    }

    private static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    private static long unsafeGetLong(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getLong(receiver, offset);
    }

    private static int unsafeGetLongAndNarrowInt(Object receiver, long offset, boolean condition, Object locationIdentity) {
        if (CompilerDirectives.inCompiledCode()) {
            return FrameWithoutBoxing.narrow(FrameWithoutBoxing.unsafeGetLong(receiver, offset, condition, locationIdentity));
        }
        return UNSAFE.getInt(receiver, offset);
    }

    private static byte unsafeGetLongAndNarrowByte(Object receiver, long offset, boolean condition, Object locationIdentity) {
        if (CompilerDirectives.inCompiledCode()) {
            return (byte)FrameWithoutBoxing.narrow(FrameWithoutBoxing.unsafeGetLong(receiver, offset, condition, locationIdentity));
        }
        return UNSAFE.getByte(receiver, offset);
    }

    private static Object unsafeGetObject(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getObject(receiver, offset);
    }

    private static void unsafePutLong(Object receiver, long offset, long value, Object locationIdentity) {
        UNSAFE.putLong(receiver, offset, value);
    }

    private static void unsafePutLongAndExtendByte(Object receiver, long offset, byte value, Object locationIdentity) {
        if (CompilerDirectives.inCompiledCode()) {
            FrameWithoutBoxing.unsafePutLong(receiver, offset, FrameWithoutBoxing.extend(value), locationIdentity);
        } else {
            UNSAFE.putByte(receiver, offset, value);
        }
    }

    private static void unsafePutLongAndExtendInt(Object receiver, long offset, int value, Object locationIdentity) {
        if (CompilerDirectives.inCompiledCode()) {
            FrameWithoutBoxing.unsafePutLong(receiver, offset, FrameWithoutBoxing.extend(value), locationIdentity);
        } else {
            UNSAFE.putInt(receiver, offset, value);
        }
    }

    private static void unsafePutObject(Object receiver, long offset, Object value, Object locationIdentity) {
        UNSAFE.putObject(receiver, offset, value);
    }

    @Override
    public Object getValue(int slot) {
        byte tag = this.getTag(slot);
        assert (!this.isStatic(slot)) : "Unexpected non-static read of static frame slot";
        switch (tag) {
            case 5: {
                return this.getBoolean(slot);
            }
            case 6: {
                return this.getByte(slot);
            }
            case 2: {
                return this.getInt(slot);
            }
            case 3: {
                return this.getDouble(slot);
            }
            case 1: {
                return this.getLong(slot);
            }
            case 4: {
                return Float.valueOf(this.getFloat(slot));
            }
            case 0: {
                return this.getObject(slot);
            }
            case 7: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw FrameWithoutBoxing.frameSlotTypeException(slot, (byte)0, tag);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private Object[] getIndexedLocals() {
        return FrameWithoutBoxing.unsafeCast(this.indexedLocals, Object[].class, true, true, true);
    }

    private long[] getIndexedPrimitiveLocals() {
        return FrameWithoutBoxing.unsafeCast(this.indexedPrimitiveLocals, long[].class, true, true, true);
    }

    private byte[] getIndexedTags() {
        return FrameWithoutBoxing.unsafeCast(this.indexedTags, byte[].class, true, true, true);
    }

    @Override
    public Object getObject(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), condition, OBJECT_LOCATION);
    }

    @Override
    public Object expectObject(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), condition, OBJECT_LOCATION);
    }

    Object unsafeGetObject(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), condition, OBJECT_LOCATION);
    }

    Object unsafeUncheckedGetObject(int slot) {
        assert (this.getIndexedTagChecked(slot) == 0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), true, OBJECT_LOCATION);
    }

    Object unsafeExpectObject(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)0);
        return FrameWithoutBoxing.unsafeGetObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), condition, OBJECT_LOCATION);
    }

    @Override
    public void setObject(int slot, Object value) {
        this.verifyIndexedSet(slot, (byte)0);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), value, OBJECT_LOCATION);
    }

    void unsafeSetObject(int slot, Object value) throws FrameSlotTypeException {
        this.unsafeVerifyIndexedSet(slot, (byte)0);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), value, OBJECT_LOCATION);
    }

    @Override
    public byte getByte(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)6);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public byte expectByte(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)6);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    byte unsafeGetByte(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)6);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    byte unsafeExpectByte(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)6);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setByte(int slot, byte value) {
        this.verifyIndexedSet(slot, (byte)6);
        FrameWithoutBoxing.unsafePutLongAndExtendByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    void unsafeSetByte(int slot, byte value) {
        this.unsafeVerifyIndexedSet(slot, (byte)6);
        FrameWithoutBoxing.unsafePutLongAndExtendByte(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public boolean getBoolean(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)5);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
    }

    @Override
    public boolean expectBoolean(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)5);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
    }

    boolean unsafeExpectBoolean(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)5);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
    }

    boolean unsafeGetBoolean(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)5);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION) != 0;
    }

    @Override
    public void setBoolean(int slot, boolean value) {
        this.verifyIndexedSet(slot, (byte)5);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), FrameWithoutBoxing.extend(value ? 1 : 0), PRIMITIVE_LOCATION);
    }

    void unsafeSetBoolean(int slot, boolean value) {
        this.unsafeVerifyIndexedSet(slot, (byte)5);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value ? 1L : 0L, PRIMITIVE_LOCATION);
    }

    @Override
    public float getFloat(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)4);
        return Float.intBitsToFloat(FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    @Override
    public float expectFloat(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)4);
        return Float.intBitsToFloat(FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    float unsafeExpectFloat(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)4);
        return Float.intBitsToFloat(FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    float unsafeGetFloat(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)4);
        return Float.intBitsToFloat(FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    @Override
    public void setFloat(int slot, float value) {
        this.verifyIndexedSet(slot, (byte)4);
        FrameWithoutBoxing.unsafePutLongAndExtendInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), Float.floatToRawIntBits(value), PRIMITIVE_LOCATION);
    }

    void unsafeSetFloat(int slot, float value) {
        this.unsafeVerifyIndexedSet(slot, (byte)4);
        FrameWithoutBoxing.unsafePutLongAndExtendInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), Float.floatToRawIntBits(value), PRIMITIVE_LOCATION);
    }

    @Override
    public long getLong(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)1);
        return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public long expectLong(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)1);
        return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    long unsafeGetLong(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)1);
        return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    long unsafeExpectLong(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)1);
        return FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setLong(int slot, long value) {
        this.verifyIndexedSet(slot, (byte)1);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    void unsafeSetLong(int slot, long value) {
        this.unsafeVerifyIndexedSet(slot, (byte)1);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public int getInt(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)2);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public int expectInt(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)2);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    int unsafeGetInt(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)2);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    int unsafeExpectInt(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)2);
        return FrameWithoutBoxing.unsafeGetLongAndNarrowInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION);
    }

    @Override
    public void setInt(int slot, int value) {
        this.verifyIndexedSet(slot, (byte)2);
        FrameWithoutBoxing.unsafePutLongAndExtendInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    void unsafeSetInt(int slot, int value) {
        this.unsafeVerifyIndexedSet(slot, (byte)2);
        FrameWithoutBoxing.unsafePutLongAndExtendInt(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), value, PRIMITIVE_LOCATION);
    }

    @Override
    public double getDouble(int slot) throws FrameSlotTypeException {
        boolean condition = this.verifyIndexedGet(slot, (byte)3);
        return Double.longBitsToDouble(FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    @Override
    public double expectDouble(int slot) throws UnexpectedResultException {
        boolean condition = this.verifyIndexedGetUnexpected(slot, (byte)3);
        return Double.longBitsToDouble(FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    double unsafeGetDouble(int slot) throws FrameSlotTypeException {
        boolean condition = this.unsafeVerifyIndexedGet(slot, (byte)3);
        return Double.longBitsToDouble(FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    double unsafeExpectDouble(int slot) throws UnexpectedResultException {
        boolean condition = this.unsafeVerifyIndexedGetUnexpected(slot, (byte)3);
        return Double.longBitsToDouble(FrameWithoutBoxing.unsafeGetLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), condition, PRIMITIVE_LOCATION));
    }

    @Override
    public void setDouble(int slot, double value) {
        this.verifyIndexedSet(slot, (byte)3);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), Double.doubleToRawLongBits(value), PRIMITIVE_LOCATION);
    }

    void unsafeSetDouble(int slot, double value) {
        this.unsafeVerifyIndexedSet(slot, (byte)3);
        FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), Double.doubleToRawLongBits(value), PRIMITIVE_LOCATION);
    }

    @Override
    public void copy(int srcSlot, int destSlot) {
        byte tag = this.getIndexedTagChecked(srcSlot);
        Object[] referenceLocals = this.getIndexedLocals();
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        Object value = FrameWithoutBoxing.unsafeGetObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(srcSlot), true, OBJECT_LOCATION);
        this.verifyIndexedSet(destSlot, tag);
        FrameWithoutBoxing.unsafePutObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(destSlot), value, OBJECT_LOCATION);
        long primitiveValue = FrameWithoutBoxing.unsafeGetLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(srcSlot), true, PRIMITIVE_LOCATION);
        FrameWithoutBoxing.unsafePutLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(destSlot), primitiveValue, PRIMITIVE_LOCATION);
    }

    void unsafeCopy(int srcSlot, int destSlot) {
        byte tag = this.unsafeGetIndexedTag(srcSlot);
        Object[] referenceLocals = this.getIndexedLocals();
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        Object value = FrameWithoutBoxing.unsafeGetObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(srcSlot), true, OBJECT_LOCATION);
        this.unsafeVerifyIndexedSet(destSlot, tag);
        FrameWithoutBoxing.unsafePutObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(destSlot), value, OBJECT_LOCATION);
        long primitiveValue = FrameWithoutBoxing.unsafeGetLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(srcSlot), true, PRIMITIVE_LOCATION);
        FrameWithoutBoxing.unsafePutLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(destSlot), primitiveValue, PRIMITIVE_LOCATION);
    }

    @Override
    public void swap(int first, int second) {
        Object[] referenceLocals = this.getIndexedLocals();
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        byte firstTag = this.getIndexedTagChecked(first);
        Object firstValue = FrameWithoutBoxing.unsafeGetObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(first), true, OBJECT_LOCATION);
        long firstPrimitiveValue = FrameWithoutBoxing.unsafeGetLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(first), true, PRIMITIVE_LOCATION);
        byte secondTag = this.getIndexedTagChecked(second);
        Object secondValue = FrameWithoutBoxing.unsafeGetObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(second), true, OBJECT_LOCATION);
        long secondPrimitiveValue = FrameWithoutBoxing.unsafeGetLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(second), true, PRIMITIVE_LOCATION);
        this.verifyIndexedSet(first, secondTag);
        this.verifyIndexedSet(second, firstTag);
        FrameWithoutBoxing.unsafePutObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(first), secondValue, OBJECT_LOCATION);
        FrameWithoutBoxing.unsafePutLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(first), secondPrimitiveValue, PRIMITIVE_LOCATION);
        FrameWithoutBoxing.unsafePutObject(referenceLocals, FrameWithoutBoxing.getObjectOffset(second), firstValue, OBJECT_LOCATION);
        FrameWithoutBoxing.unsafePutLong(primitiveLocals, FrameWithoutBoxing.getPrimitiveOffset(second), firstPrimitiveValue, PRIMITIVE_LOCATION);
    }

    private void verifyIndexedSet(int slot, byte tag) {
        assert ((this.getIndexedTags()[slot] & 8) == 0) : "Unexpected non-static write of static frame slot";
        this.getIndexedTags()[slot] = tag;
    }

    private void unsafeVerifyIndexedSet(int slot, byte tag) {
        assert (this.getIndexedTags()[slot] != 8) : "Unexpected non-static write of static frame slot";
        UNSAFE.putByte(this.getIndexedTags(), Unsafe.ARRAY_BYTE_BASE_OFFSET + slot * Unsafe.ARRAY_BYTE_INDEX_SCALE, tag);
    }

    private boolean verifyIndexedGetUnexpected(int slot, byte expectedTag) throws UnexpectedResultException {
        boolean condition;
        byte actualTag = this.getIndexedTagChecked(slot);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw this.unexpectedValue(slot);
        }
        return condition;
    }

    private UnexpectedResultException unexpectedValue(int slot) throws UnexpectedResultException {
        throw new UnexpectedResultException(this.getValue(slot));
    }

    private boolean verifyIndexedGet(int slot, byte expectedTag) throws FrameSlotTypeException {
        boolean condition;
        byte actualTag = this.getIndexedTagChecked(slot);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw FrameWithoutBoxing.frameSlotTypeException(slot, expectedTag, actualTag);
        }
        return condition;
    }

    private boolean unsafeVerifyIndexedGet(int slot, byte expectedTag) throws FrameSlotTypeException {
        boolean condition;
        byte actualTag = this.unsafeGetIndexedTag(slot);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw FrameWithoutBoxing.frameSlotTypeException(slot, expectedTag, actualTag);
        }
        return condition;
    }

    private boolean unsafeVerifyIndexedGetUnexpected(int slot, byte expectedTag) throws UnexpectedResultException {
        boolean condition;
        byte actualTag = this.unsafeGetIndexedTag(slot);
        boolean bl = condition = actualTag == expectedTag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw this.unexpectedValue(slot);
        }
        return condition;
    }

    private byte getIndexedTagChecked(int slot) {
        byte tag = this.getIndexedTags()[slot];
        assert ((tag & 8) == 0) : "Unexpected non-static read of static frame slot";
        return tag;
    }

    private byte unsafeGetIndexedTag(int slot) {
        assert (this.getIndexedTags()[slot] >= 0);
        byte tag = UNSAFE.getByte(this.getIndexedTags(), Unsafe.ARRAY_BYTE_BASE_OFFSET + slot * Unsafe.ARRAY_BYTE_INDEX_SCALE);
        assert ((tag & 8) == 0) : "Unexpected non-static read of static frame slot";
        return tag;
    }

    @Override
    public boolean isObject(int slot) {
        return this.isNonStaticType(slot, (byte)0);
    }

    @Override
    public boolean isByte(int slot) {
        return this.isNonStaticType(slot, (byte)6);
    }

    @Override
    public boolean isBoolean(int slot) {
        return this.isNonStaticType(slot, (byte)5);
    }

    @Override
    public boolean isInt(int slot) {
        return this.isNonStaticType(slot, (byte)2);
    }

    @Override
    public boolean isLong(int slot) {
        return this.isNonStaticType(slot, (byte)1);
    }

    @Override
    public boolean isFloat(int slot) {
        return this.isNonStaticType(slot, (byte)4);
    }

    @Override
    public boolean isDouble(int slot) {
        return this.isNonStaticType(slot, (byte)3);
    }

    @Override
    public boolean isStatic(int slot) {
        return this.getFrameDescriptor().getSlotKind(slot) == FrameSlotKind.Static;
    }

    @Override
    public void clear(int slot) {
        this.verifyIndexedSet(slot, (byte)7);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), null, OBJECT_LOCATION);
        if (CompilerDirectives.inCompiledCode()) {
            FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), 0L, PRIMITIVE_LOCATION);
        }
    }

    void unsafeClear(int slot) {
        this.unsafeVerifyIndexedSet(slot, (byte)7);
        FrameWithoutBoxing.unsafePutObject(this.getIndexedLocals(), FrameWithoutBoxing.getObjectOffset(slot), null, OBJECT_LOCATION);
        if (CompilerDirectives.inCompiledCode()) {
            FrameWithoutBoxing.unsafePutLong(this.getIndexedPrimitiveLocals(), FrameWithoutBoxing.getPrimitiveOffset(slot), 0L, PRIMITIVE_LOCATION);
        }
    }

    @Override
    public void setAuxiliarySlot(int slot, Object value) {
        if (this.auxiliarySlots.length <= slot) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.auxiliarySlots = Arrays.copyOf(this.auxiliarySlots, this.descriptor.getNumberOfAuxiliarySlots());
        }
        this.auxiliarySlots[slot] = value;
    }

    @Override
    public Object getAuxiliarySlot(int slot) {
        return slot < this.auxiliarySlots.length ? this.auxiliarySlots[slot] : null;
    }

    @Override
    public Object getObjectStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)8)) : "Unexpected read of static object value";
        return this.getIndexedLocals()[slot];
    }

    @Override
    public void setObjectStatic(int slot, Object value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 8;
        }
        this.getIndexedLocals()[slot] = value;
    }

    @Override
    public byte getByteStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)14)) : "Unexpected read of static byte value";
        return (byte)FrameWithoutBoxing.narrow(this.getIndexedPrimitiveLocals()[slot]);
    }

    @Override
    public void setByteStatic(int slot, byte value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 14;
        }
        this.getIndexedPrimitiveLocals()[slot] = FrameWithoutBoxing.extend(value);
    }

    @Override
    public boolean getBooleanStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)13)) : "Unexpected read of static boolean value";
        return FrameWithoutBoxing.narrow(this.getIndexedPrimitiveLocals()[slot]) != 0;
    }

    @Override
    public void setBooleanStatic(int slot, boolean value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 13;
        }
        this.getIndexedPrimitiveLocals()[slot] = FrameWithoutBoxing.extend(value ? 1 : 0);
    }

    @Override
    public int getIntStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)10)) : "Unexpected read of static int value";
        return FrameWithoutBoxing.narrow(this.getIndexedPrimitiveLocals()[slot]);
    }

    @Override
    public void setIntStatic(int slot, int value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 10;
        }
        this.getIndexedPrimitiveLocals()[slot] = FrameWithoutBoxing.extend(value);
    }

    @Override
    public long getLongStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)9)) : "Unexpected read of static long value";
        return this.getIndexedPrimitiveLocals()[slot];
    }

    @Override
    public void setLongStatic(int slot, long value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 9;
        }
        this.getIndexedPrimitiveLocals()[slot] = value;
    }

    @Override
    public float getFloatStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)12)) : "Unexpected read of static float value";
        return Float.intBitsToFloat(FrameWithoutBoxing.narrow(this.getIndexedPrimitiveLocals()[slot]));
    }

    @Override
    public void setFloatStatic(int slot, float value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 12;
        }
        this.getIndexedPrimitiveLocals()[slot] = FrameWithoutBoxing.extend(Float.floatToRawIntBits(value));
    }

    @Override
    public double getDoubleStatic(int slot) {
        assert (this.checkStaticGet(slot, (byte)11)) : "Unexpected read of static double value";
        return Double.longBitsToDouble(this.getIndexedPrimitiveLocals()[slot]);
    }

    @Override
    public void setDoubleStatic(int slot, double value) {
        assert (this.checkStatic(slot)) : "Unexpected static write of non-static frame slot";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 11;
        }
        this.getIndexedPrimitiveLocals()[slot] = Double.doubleToRawLongBits(value);
    }

    @Override
    public void copyPrimitiveStatic(int srcSlot, int destSlot) {
        assert (this.checkStaticPrimitive(srcSlot) && this.checkStatic(destSlot)) : "Unexpected copy of static primitive value ";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[destSlot] = this.indexedTags[srcSlot];
        }
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        primitiveLocals[destSlot] = primitiveLocals[srcSlot];
    }

    @Override
    public void copyObjectStatic(int srcSlot, int destSlot) {
        assert (this.checkStaticObject(srcSlot) && this.checkStatic(destSlot)) : "Unexpected copy of static object value";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[destSlot] = this.indexedTags[srcSlot];
        }
        Object[] referenceLocals = this.getIndexedLocals();
        referenceLocals[destSlot] = referenceLocals[srcSlot];
    }

    @Override
    public void copyStatic(int srcSlot, int destSlot) {
        assert (this.checkStatic(srcSlot) && this.checkStatic(destSlot)) : "Unexpected copy of static value";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[destSlot] = this.indexedTags[srcSlot];
        }
        Object[] referenceLocals = this.getIndexedLocals();
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        referenceLocals[destSlot] = referenceLocals[srcSlot];
        primitiveLocals[destSlot] = primitiveLocals[srcSlot];
    }

    @Override
    public void swapPrimitiveStatic(int first, int second) {
        long secondValue;
        assert (this.checkStaticPrimitive(first) && this.checkStaticPrimitive(second)) : "Unexpected swap of static primitive value";
        if (ASSERTIONS_ENABLED) {
            byte swapTag = this.indexedTags[first];
            this.indexedTags[first] = this.indexedTags[second];
            this.indexedTags[second] = swapTag;
        }
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        long firstValue = primitiveLocals[first];
        primitiveLocals[first] = secondValue = primitiveLocals[second];
        primitiveLocals[second] = firstValue;
    }

    @Override
    public void swapObjectStatic(int first, int second) {
        Object secondValue;
        assert (this.checkStaticObject(first) && this.checkStaticObject(second)) : "Unexpected swap of static object value";
        if (ASSERTIONS_ENABLED) {
            byte swapTag = this.indexedTags[first];
            this.indexedTags[first] = this.indexedTags[second];
            this.indexedTags[second] = swapTag;
        }
        Object[] referenceLocals = this.getIndexedLocals();
        Object firstValue = referenceLocals[first];
        referenceLocals[first] = secondValue = referenceLocals[second];
        referenceLocals[second] = firstValue;
    }

    @Override
    public void swapStatic(int first, int second) {
        assert (this.checkStatic(first) && this.checkStatic(second)) : "Unexpected swap of static value";
        if (ASSERTIONS_ENABLED) {
            byte swapTag = this.indexedTags[first];
            this.indexedTags[first] = this.indexedTags[second];
            this.indexedTags[second] = swapTag;
        }
        Object[] referenceLocals = this.getIndexedLocals();
        long[] primitiveLocals = this.getIndexedPrimitiveLocals();
        Object firstValue = referenceLocals[first];
        Object secondValue = referenceLocals[second];
        long firstPrimitiveValue = primitiveLocals[first];
        long secondPrimitiveValue = primitiveLocals[second];
        referenceLocals[first] = secondValue;
        referenceLocals[second] = firstValue;
        primitiveLocals[first] = secondPrimitiveValue;
        primitiveLocals[second] = firstPrimitiveValue;
    }

    @Override
    public void clearPrimitiveStatic(int slot) {
        assert (this.checkStaticPrimitive(slot)) : "Unexpected clear of static primitive value";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 15;
        }
        if (CompilerDirectives.inCompiledCode()) {
            this.getIndexedPrimitiveLocals()[slot] = 0L;
        }
    }

    @Override
    public void clearObjectStatic(int slot) {
        assert (this.checkStaticObject(slot)) : "Unexpected clear of static object value";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 15;
        }
        this.getIndexedLocals()[slot] = null;
    }

    @Override
    public void copyTo(int sourceOffset, Frame destination, int destinationOffset, int length) {
        FrameWithoutBoxing o = (FrameWithoutBoxing)destination;
        if (o.descriptor != this.descriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid frame with wrong frame descriptor passed.");
        }
        if (length < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("Illegal length passed.");
        }
        if (sourceOffset < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("Illegal sourceOffset passed.");
        }
        if (sourceOffset + length > this.getIndexedTags().length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("Illegal sourceOffset or length passed.");
        }
        if (destinationOffset < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("Illegal destinationOffset passed.");
        }
        if (destinationOffset + length > o.getIndexedTags().length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("Illegal destinationOffset or length passed.");
        }
        this.unsafeCopyTo(sourceOffset, o, destinationOffset, length);
    }

    void unsafeCopyTo(int srcOffset, FrameWithoutBoxing o, int dstOffset, int length) {
        if (length == 0) {
            return;
        }
        System.arraycopy(this.getIndexedTags(), srcOffset, o.getIndexedTags(), dstOffset, length);
        System.arraycopy(this.getIndexedLocals(), srcOffset, o.getIndexedLocals(), dstOffset, length);
        System.arraycopy(this.getIndexedPrimitiveLocals(), srcOffset, o.getIndexedPrimitiveLocals(), dstOffset, length);
    }

    @Override
    public void clearStatic(int slot) {
        assert (this.checkStatic(slot)) : "Unexpected clear of static value";
        if (ASSERTIONS_ENABLED) {
            this.indexedTags[slot] = 15;
        }
        if (CompilerDirectives.inCompiledCode()) {
            this.getIndexedPrimitiveLocals()[slot] = 0L;
        }
        this.getIndexedLocals()[slot] = null;
    }

    private boolean checkStaticGet(int slot, byte tag) {
        byte frameTag = this.indexedTags[slot];
        if (frameTag == 0) {
            return this.isStatic(slot);
        }
        return frameTag == tag;
    }

    private boolean checkStatic(int slot) {
        byte frameTag = this.indexedTags[slot];
        if (frameTag == 0) {
            return this.isStatic(slot);
        }
        return frameTag >= 8;
    }

    private boolean checkStaticPrimitive(int slot) {
        byte frameTag = this.indexedTags[slot];
        if (frameTag == 0) {
            return this.isStatic(slot);
        }
        return frameTag > 8;
    }

    private boolean checkStaticObject(int slot) {
        byte frameTag = this.indexedTags[slot];
        if (frameTag == 0) {
            return this.isStatic(slot);
        }
        return frameTag == 8 || frameTag == 15;
    }

    void startOSRTransfer() {
    }

    void transferOSRStaticSlot(FrameWithoutBoxing target, int slot) {
        if (ASSERTIONS_ENABLED) {
            byte tag = this.indexedTags[slot];
            this.indexedTags[slot] = 8;
            target.setObjectStatic(slot, this.getObjectStatic(slot));
            this.indexedTags[slot] = 9;
            target.setLongStatic(slot, this.getLongStatic(slot));
            this.indexedTags[slot] = tag;
            target.setStaticSlotTag(slot, tag);
        } else {
            target.setObjectStatic(slot, this.getObjectStatic(slot));
            target.setLongStatic(slot, this.getLongStatic(slot));
        }
    }

    private void setStaticSlotTag(int slot, byte tag) {
        this.indexedTags[slot] = tag;
    }

    static {
        OBJECT_LOCATION = new Object();
        PRIMITIVE_LOCATION = new Object();
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_BYTE_ARRAY = new byte[0];
        UNSAFE = FrameWithoutBoxing.initUnsafe();
        assert (0 == FrameSlotKind.Object.tag);
        assert (7 == FrameSlotKind.Illegal.tag);
        assert (1 == FrameSlotKind.Long.tag);
        assert (2 == FrameSlotKind.Int.tag);
        assert (3 == FrameSlotKind.Double.tag);
        assert (4 == FrameSlotKind.Float.tag);
        assert (5 == FrameSlotKind.Boolean.tag);
        assert (6 == FrameSlotKind.Byte.tag);
        assert (8 == FrameSlotKind.Static.tag);
        ASSERTIONS_ENABLED = FrameWithoutBoxing.areAssertionsEnabled();
        ILLEGAL_DEFAULT = ImplAccessor.frameSupportAccessor().getIllegalDefault();
    }
}

