/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;

public final class IndirectCallData {
    private static final IndirectCallData UNCACHED = new IndirectCallData(Assumption.NEVER_VALID, Assumption.NEVER_VALID);
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedExceptionState;
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedMyFrame;

    private IndirectCallData(Assumption nativeCodeDoesntNeedExceptionState, Assumption nativeCodeDoesntNeedMyFrame) {
        this.nativeCodeDoesntNeedExceptionState = nativeCodeDoesntNeedExceptionState;
        this.nativeCodeDoesntNeedMyFrame = nativeCodeDoesntNeedMyFrame;
    }

    public IndirectCallData() {
    }

    public boolean isUncached() {
        return this == UNCACHED;
    }

    public boolean calleeNeedsCallerFrame() {
        return !this.needNotPassFrameAssumption().isValid();
    }

    public boolean calleeNeedsExceptionState() {
        return !this.needNotPassExceptionAssumption().isValid();
    }

    public void setCalleeNeedsCallerFrame() {
        this.needNotPassFrameAssumption().invalidate();
    }

    public void setCalleeNeedsExceptionState() {
        this.needNotPassExceptionAssumption().invalidate();
    }

    public static boolean setEncapsulatingNeedsToPassCallerFrame(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null; pythonCallNode = pythonCallNode.getParent()) {
            IndirectCallData data = PythonLanguage.lookupIndirectCallData(pythonCallNode);
            if (data == null) continue;
            data.setCalleeNeedsCallerFrame();
            return true;
        }
        return false;
    }

    public static void setEncapsulatingNeedsToPassExceptionState(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null; pythonCallNode = pythonCallNode.getParent()) {
            IndirectCallData data = PythonLanguage.lookupIndirectCallData(pythonCallNode);
            if (data == null) continue;
            data.setCalleeNeedsExceptionState();
            break;
        }
    }

    private Assumption needNotPassFrameAssumption() {
        if (this.nativeCodeDoesntNeedMyFrame == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedMyFrame;
    }

    private Assumption needNotPassExceptionAssumption() {
        if (this.nativeCodeDoesntNeedExceptionState == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedExceptionState;
    }

    @NeverDefault
    public static IndirectCallData createFor(Node node) {
        return PythonLanguage.createIndirectCallData(node);
    }

    @NeverDefault
    public static IndirectCallData getUncached() {
        return UNCACHED;
    }
}

