/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.list;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SortNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyListCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PList})
@HashNotImplemented
public final class ListBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ListBuiltinsSlotsGen.SLOTS;

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ListBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReverseNode
    extends PythonUnaryBuiltinNode {
        ReverseNode() {
        }

        @Specialization
        static Object reverse(Object self, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorage, @Bind PythonLanguage language) {
            int len = getStorage.execute(inliningTarget, self).length();
            return PFactory.createSequenceReverseIterator(language, self, len);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isIntStorage(primary)"})
        static PIntegerSequenceIterator doPListInt(PList primary, @Bind PythonLanguage language) {
            return PFactory.createIntegerSequenceIterator(language, (IntSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isLongStorage(primary)"})
        static PLongSequenceIterator doPListLong(PList primary, @Bind PythonLanguage language) {
            return PFactory.createLongSequenceIterator(language, (LongSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isDoubleStorage(primary)"})
        static PDoubleSequenceIterator doPListDouble(PList primary, @Bind PythonLanguage language) {
            return PFactory.createDoubleSequenceIterator(language, (DoubleSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Fallback
        static PSequenceIterator doOther(Object primary, @Bind PythonLanguage language) {
            return PFactory.createSequenceIterator(language, primary);
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        boolean contains(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorage, @Cached SequenceStorageNodes.ContainsNode containsNode) {
            return containsNode.execute(frame, inliningTarget, getStorage.execute(inliningTarget, self), other);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class ListRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        ListRichCmpNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object left, Object right, RichCmpOp op, @Bind Node inliningTarget, @Cached PyListCheckNode isLeftList, @Cached PyListCheckNode isRightList, @Cached InlinedConditionProfile listCheckProfile, @Cached SequenceStorageNodes.CmpNode cmpNode, @Cached ListNodes.GetListStorageNode getStorageNode) {
            if (listCheckProfile.profile(inliningTarget, isLeftList.execute(inliningTarget, left) && isRightList.execute(inliningTarget, right))) {
                SequenceStorage leftStorage = getStorageNode.execute(inliningTarget, left);
                SequenceStorage rightStorage = getStorageNode.execute(inliningTarget, right);
                return cmpNode.execute(frame, inliningTarget, leftStorage, rightStorage, true, left, right, op);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_repeat, isComplex=true)
    @GenerateNodeFactory
    static abstract class IMulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        IMulNode() {
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object list, int right, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached SequenceStorageNodes.RepeatNode repeatNode) {
            SequenceStorage store = getStorageNode.execute(inliningTarget, list);
            SequenceStorage updated = repeatNode.execute(frame, store, right);
            updateStorageNode.execute(inliningTarget, list, store, updated);
            return list;
        }
    }

    @Slot(value=Slot.SlotKind.sq_repeat, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doPListInt(VirtualFrame frame, Object left, int right, @Bind Node inliningTarget, @Cached PyListCheckNode isListNode, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached SequenceStorageNodes.RepeatNode repeatNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (!isListNode.execute(inliningTarget, left)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, left);
            try {
                SequenceStorage repeated = repeatNode.execute(frame, sequenceStorage, right);
                return PFactory.createList(language, repeated);
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.MemoryError);
            }
        }
    }

    @Slot(value=Slot.SlotKind.sq_inplace_concat, isComplex=true)
    @GenerateNodeFactory
    static abstract class IAddNode
    extends PythonBinaryBuiltinNode {
        IAddNode() {
        }

        @Specialization
        Object extendSequence(VirtualFrame frame, Object list, Object iterable, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") SequenceStorageNodes.ExtendNode extendNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            int len = lenNode.execute(frame, inliningTarget, iterable);
            SequenceStorage newStorage = extendNode.execute(frame, sequenceStorage, iterable, len);
            updateStorageNode.execute(inliningTarget, list, sequenceStorage, newStorage);
            return list;
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
        }
    }

    @Slot(value=Slot.SlotKind.sq_concat, isComplex=true)
    @GenerateNodeFactory
    static abstract class ConcatNode
    extends TpSlotBinaryFunc.SqConcatBuiltinNode {
        ConcatNode() {
        }

        @Specialization
        static PList doPList(Object left, Object right, @Bind Node inliningTarget, @Cached PyListCheckNode isListNode, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached ListNodes.GetClassForNewListNode getClassForNewListNode, @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isListNode.execute(inliningTarget, right)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "list", right, "list");
            }
            SequenceStorage leftStorage = getStorageNode.execute(inliningTarget, left);
            SequenceStorage rightStorage = getStorageNode.execute(inliningTarget, right);
            SequenceStorage newStore = concatNode.execute(inliningTarget, leftStorage, rightStorage);
            Object newClass = getClassForNewListNode.execute(inliningTarget, left);
            return PFactory.createList(language, newClass, getInstanceShape.execute(newClass), newStore);
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        int doGeneric(Object list, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode) {
            return getStorageNode.execute(inliningTarget, list).length();
        }
    }

    @Builtin(name="sort", minNumOfPositionalArgs=1, parameterNames={"$self"}, keywordOnlyNames={"key", "reverse"})
    @ArgumentClinic(name="reverse", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")
    @GenerateNodeFactory
    public static abstract class ListSortNode
    extends PythonClinicBuiltinNode {
        public final Object execute(VirtualFrame frame, Object list) {
            return this.execute(frame, list, PNone.NO_VALUE, false);
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doPList(VirtualFrame frame, PList list, Object keyfunc, boolean reverse, @Bind Node inliningTarget, @Cached.Shared @Cached SortNodes.SortSequenceStorageNode sortSequenceStorageNode, @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = list.getSequenceStorage();
            list.setSequenceStorage(EmptySequenceStorage.INSTANCE);
            try {
                sortSequenceStorageNode.execute(frame, storage, keyfunc, reverse);
                if (list.getSequenceStorage() != EmptySequenceStorage.INSTANCE) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.LIST_MODIFIED_DURING_SORT);
                }
            }
            finally {
                list.setSequenceStorage(storage);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isList(list)"})
        static Object doForeign(VirtualFrame frame, Object list, Object keyfunc, boolean reverse, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached.Shared @Cached SortNodes.SortSequenceStorageNode sortSequenceStorageNode) {
            SequenceStorage storage = getStorageNode.execute(inliningTarget, list);
            sortSequenceStorageNode.execute(frame, storage, keyfunc, reverse);
            return PNone.NONE;
        }

        @NeverDefault
        public static ListSortNode create() {
            return ListBuiltinsFactory.ListSortNodeFactory.create(null);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ListBuiltinsClinicProviders.ListSortNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListReverseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone reverse(Object list, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached SequenceStorageNodes.ReverseNode reverseNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            reverseNode.execute(inliningTarget, sequenceStorage);
            return PNone.NONE;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone clear(Object list, @Bind Node inliningTarget, @Cached ListNodes.ClearListStorageNode clearSequenceNode) {
            clearSequenceNode.execute(inliningTarget, list);
            return PNone.NONE;
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListCountNode
    extends PythonBuiltinNode {
        @Specialization
        long count(VirtualFrame frame, Object list, Object value, @Bind Node inliningTarget, @Cached InlinedLoopConditionProfile loopProfile, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectRichCompareBool eqNode) {
            long count = 0L;
            SequenceStorage s = getStorageNode.execute(inliningTarget, list);
            loopProfile.profileCounted(inliningTarget, (long)s.length());
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < s.length())) {
                Object seqItem = getItemNode.execute(s, i);
                if (eqNode.execute((Frame)frame, inliningTarget, seqItem, value, RichCmpOp.Py_EQ)) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    ++count;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)s.length());
            return count;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=4, parameterNames={"$self", "value", "start", "stop"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0"), @ArgumentClinic(name="stop", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE")})
    @GenerateNodeFactory
    public static abstract class ListIndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Specialization
        static Object index(VirtualFrame frame, Object self, Object value, int start, int stop, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getListStorageNode, @Cached InlinedBranchProfile startAdjust, @Cached InlinedBranchProfile stopAdjust, @Cached SequenceStorageNodes.ItemIndexNode indexNode, @Cached PRaiseNode raiseNode) {
            SequenceStorage s = getListStorageNode.execute(inliningTarget, self);
            int idx = indexNode.execute(frame, inliningTarget, s, value, start = ListIndexNode.adjustIndex(inliningTarget, s, start, startAdjust), stop = ListIndexNode.adjustIndex(inliningTarget, s, stop, stopAdjust));
            if (idx != -1) {
                return idx;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.X_NOT_IN_LIST);
        }

        private static int adjustIndex(Node inliningTarget, SequenceStorage s, int index, InlinedBranchProfile profile) {
            if (index < 0) {
                profile.enter(inliningTarget);
                if ((index += s.length()) < 0) {
                    return 0;
                }
            }
            return index;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ListBuiltinsClinicProviders.ListIndexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListPopNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object popLast(VirtualFrame frame, Object list, PNone none, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.GetListStorageNode getStorageNode, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage store = getStorageNode.execute(inliningTarget, list);
            Object ret = getItemNode.execute(store, -1);
            deleteNode.execute(frame, store, -1);
            return ret;
        }

        @Specialization(guards={"!isNoValue(idx)", "!isPSlice(idx)"})
        static Object doIndex(VirtualFrame frame, Object list, Object idx, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.GetListStorageNode getStorageNode, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage store = getStorageNode.execute(inliningTarget, list);
            Object ret = getItemNode.execute(frame, store, idx);
            deleteNode.execute(frame, store, idx);
            return ret;
        }

        @Fallback
        static Object doError(Object list, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }

        @NeverDefault
        protected static SequenceStorageNodes.DeleteNode createDelete() {
            return SequenceStorageNodes.DeleteNode.create(ListPopNode.createNormalize());
        }

        @NeverDefault
        private static IndexNodes.NormalizeIndexNode createNormalize() {
            return IndexNodes.NormalizeIndexNode.create(ErrorMessages.POP_INDEX_OUT_OF_RANGE);
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListRemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone remove(VirtualFrame frame, Object list, Object value, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached PyObjectRichCompareBool eqNode, @Cached PRaiseNode raiseNode) {
            SequenceStorage listStore = getStorageNode.execute(inliningTarget, list);
            int len = listStore.length();
            loopProfile.profileCounted(inliningTarget, (long)len);
            for (int i = 0; i < len; ++i) {
                Object object = getItemNode.execute(listStore, i);
                if (!eqNode.execute((Frame)frame, inliningTarget, object, value, RichCmpOp.Py_EQ)) continue;
                deleteNode.execute(frame, listStore, i);
                LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                return PNone.NONE;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)len);
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NOT_IN_LIST_MESSAGE);
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, numOfPositionalOnlyArgs=3, parameterNames={"$self", "index", "object"})
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    public static abstract class ListInsertNode
    extends PythonTernaryClinicBuiltinNode {
        @Specialization
        static PNone insert(Object list, int index, Object value, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached InlinedBranchProfile negativeProfile, @Cached InlinedBranchProfile tooFarProfile, @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached SequenceStorageNodes.InsertItemNode insertItem) {
            SequenceStorage store = getStorageNode.execute(inliningTarget, list);
            int len = store.length();
            if (index < 0) {
                negativeProfile.enter(inliningTarget);
                if ((index += len) < 0) {
                    index = 0;
                }
            }
            if (index > len) {
                tooFarProfile.enter(inliningTarget);
                index = len;
            }
            SequenceStorage newStorage = insertItem.execute(inliningTarget, store, index, value);
            updateStorageNode.execute(inliningTarget, list, store, newStorage);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ListBuiltinsClinicProviders.ListInsertNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PList copySequence(Object list, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached SequenceStorageNodes.CopyNode copy, @Cached ListNodes.GetClassForNewListNode getClassForNewListNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            Object newClass = getClassForNewListNode.execute(inliningTarget, list);
            return PFactory.createList(language, newClass, getInstanceShape.execute(newClass), copy.execute(inliningTarget, sequenceStorage));
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListExtendNode
    extends PythonBinaryBuiltinNode {
        @Override
        public abstract PNone execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public static PNone extendSequence(VirtualFrame frame, Object list, Object iterable, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") SequenceStorageNodes.ExtendNode extendNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            int len = lenNode.execute(frame, inliningTarget, iterable);
            SequenceStorage newStorage = extendNode.execute(frame, sequenceStorage, iterable, len);
            updateStorageNode.execute(inliningTarget, list, sequenceStorage, newStorage);
            return PNone.NONE;
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
        }

        @NeverDefault
        public static ListExtendNode create() {
            return ListBuiltinsFactory.ListExtendNodeFactory.create();
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "object"})
    @GenerateNodeFactory
    public static abstract class ListAppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public PNone appendObjectGeneric(Object list, Object arg, @Cached ListNodes.AppendNode appendNode) {
            appendNode.execute(list, arg);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.mp_ass_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetSubscriptNode
    extends TpSlotMpAssSubscript.MpAssSubscriptBuiltinNode {
        @Specialization(guards={"!isNoValue(value)"})
        static void doIntSet(Object self, int index, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.GetListStorageNode getStorageNode, @Cached.Shared @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached.Shared(value="setItem") @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, self);
            SequenceStorage newStorage = setItemNode.execute(sequenceStorage, index, value);
            updateStorageNode.execute(inliningTarget, self, sequenceStorage, newStorage);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isNoValue(value)", "isIndexOrSlice(this, indexCheckNode, key)"})
        static void doGenericSet(VirtualFrame frame, Object self, Object key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.GetListStorageNode getStorageNode, @Cached.Shared @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached.Shared(value="indexCheckNode") @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared(value="setItem") @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, self);
            SequenceStorage newStorage = setItemNode.execute(frame, sequenceStorage, key, value);
            updateStorageNode.execute(inliningTarget, self, sequenceStorage, newStorage);
        }

        @Specialization(guards={"isNoValue(value)", "isIndexOrSlice(this, indexCheckNode, key)"})
        static void doGenericDel(VirtualFrame frame, Object list, Object key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="indexCheckNode") @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached ListNodes.GetListStorageNode getStorageNode, @Cached SequenceStorageNodes.DeleteNode deleteNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            deleteNode.execute(frame, sequenceStorage, key);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isIndexOrSlice(this, indexCheckNode, key)"})
        static void doError(Object self, Object key, Object value, @Cached.Shared(value="indexCheckNode") @Cached PyIndexCheckNode indexCheckNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "list", key);
        }

        @NeverDefault
        protected static SetSubscriptNode create() {
            return ListBuiltinsFactory.SetSubscriptNodeFactory.create();
        }
    }

    @Slot(value=Slot.SlotKind.sq_ass_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends TpSlotSqAssItem.SqAssItemBuiltinNode {
        @Specialization(guards={"!isNoValue(value)"})
        static void doInt(Object self, int index, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached ListNodes.GetListStorageNode getStorageNode, @Cached ListNodes.UpdateListStorageNode updateStorageNode, @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, self);
            SequenceStorage newStorage = setItemNode.execute(sequenceStorage, index, value);
            updateStorageNode.execute(inliningTarget, self, sequenceStorage, newStorage);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doGeneric(Object list, int index, Object value, @Bind Node inliningTarget, @Cached.Exclusive @Cached ListNodes.GetListStorageNode getStorageNode, @Cached IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached SequenceStorageNodes.DeleteItemNode deleteItemNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, list);
            index = normalizeIndexNode.execute(index, sequenceStorage.length());
            deleteItemNode.execute(inliningTarget, sequenceStorage, index);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode raiseNode, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                GetItemNode.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, self);
            return subscriptNode.execute(frame, inliningTarget, sequenceStorage, idx, ErrorMessages.LIST_INDEX_OUT_OF_RANGE, PFactory::createList);
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseNonIntIndex(Node inliningTarget, PRaiseNode raiseNode, Object index) {
            raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "list", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ListSqItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        @Specialization
        static Object doIt(Object self, int index, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @Cached SequenceStorageNodes.SequenceStorageSqItemNode sqItemNode) {
            SequenceStorage sequenceStorage = getStorageNode.execute(inliningTarget, self);
            return sqItemNode.execute(inliningTarget, sequenceStorage, index, ErrorMessages.LIST_INDEX_OUT_OF_RANGE);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="list", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListInitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone initTruffleString(PList list, TruffleString value, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.ClearListStorageNode clearStorageNode, @Cached.Shared(value="cpIt") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="cpItNext") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="fromCp") @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode) {
            clearStorageNode.execute(inliningTarget, list);
            TruffleStringIterator iterator = createCodePointIteratorNode.execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING);
            while (iterator.hasNext()) {
                int cp = nextNode.execute(iterator, PythonUtils.TS_ENCODING);
                appendNode.execute(list, fromCodePointNode.execute(cp, PythonUtils.TS_ENCODING, true));
            }
            return PNone.NONE;
        }

        @Specialization
        static PNone initPString(PList list, PString value, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached.Exclusive @Cached ListNodes.ClearListStorageNode clearStorageNode, @Cached.Shared(value="cpIt") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="cpItNext") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="fromCp") @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode) {
            return ListInitNode.initTruffleString(list, castStr.execute(inliningTarget, value), inliningTarget, clearStorageNode, createCodePointIteratorNode, nextNode, fromCodePointNode, appendNode);
        }

        @Specialization(guards={"isNoValue(none)"})
        static PNone init(Object list, PNone none, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.ClearListStorageNode clearStorageNode) {
            clearStorageNode.execute(inliningTarget, list);
            return PNone.NONE;
        }

        @Specialization
        static PNone listRange(PList list, PIntRange range, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.ClearListStorageNode clearStorageNode) {
            clearStorageNode.execute(inliningTarget, list);
            int start = range.getIntStart();
            int step = range.getIntStep();
            int len = range.getIntLength();
            int[] array = new int[len];
            int value = start;
            for (int i = 0; i < len; ++i) {
                array[i] = value;
                value += step;
            }
            list.setSequenceStorage(new IntSequenceStorage(array));
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(iterable)", "!isString(iterable)", "!isPIntRange(iterable)"})
        static PNone listIterable(VirtualFrame frame, PList list, Object iterable, @Bind Node inliningTarget, @Cached.Exclusive @Cached ListNodes.ClearListStorageNode clearStorageNode, @Cached IteratorNodes.GetLength lenNode, @Cached PyObjectGetIter getIter, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode storageNode) {
            clearStorageNode.execute(inliningTarget, list);
            int len = lenNode.execute(frame, inliningTarget, iterable);
            Object iterObj = getIter.execute((Frame)frame, inliningTarget, iterable);
            list.setSequenceStorage(storageNode.execute(frame, iterObj, len));
            return PNone.NONE;
        }

        @Specialization(guards={"!isList(list)", "!isNoValue(iterable)"})
        static PNone foreignListIterable(VirtualFrame frame, Object list, Object iterable, @Bind Node inliningTarget, @Cached.Shared @Cached ListNodes.ClearListStorageNode clearStorageNode, @Cached ListExtendNode extendNode) {
            clearStorageNode.execute(inliningTarget, list);
            extendNode.execute(frame, list, iterable);
            return PNone.NONE;
        }

        protected static boolean isPIntRange(Object object) {
            return object instanceof PIntRange;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public TruffleString repr(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached ListNodes.GetListStorageNode getStorageNode, @CachedLibrary(limit="2") InteropLibrary interopLib, @Cached SequenceStorageNodes.GetItemNode getItem, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            PythonContext context;
            SequenceStorage storage = getStorageNode.execute(inliningTarget, self);
            int length = storage.length();
            if (length == 0) {
                return StringLiterals.T_EMPTY_BRACKETS;
            }
            Object reprIdentity = self;
            if (!PGuards.isAnyPythonObject(self) && interopLib.hasIdentity(self)) {
                try {
                    reprIdentity = interopLib.identityHashCode(self);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (!(context = PythonContext.get(this)).reprEnter(reprIdentity)) {
                return StringLiterals.T_ELLIPSIS_IN_BRACKETS;
            }
            try {
                TruffleStringBuilder buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_LBRACKET);
                boolean initial = true;
                for (int index = 0; index < length; ++index) {
                    if (initial) {
                        initial = false;
                    } else {
                        appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    }
                    Object value = getItem.execute(storage, index);
                    appendStringNode.execute(buf, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, value));
                }
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_RBRACKET);
                TruffleString truffleString = toStringNode.execute(buf);
                return truffleString;
            }
            finally {
                context.reprLeave(reprIdentity);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="list", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ListNode
    extends PythonVarargsBuiltinNode {
        @Specialization(guards={"isBuiltinList(cls)"})
        PList doBuiltin(Object cls, Object[] arguments, PKeyword[] keywords, @Bind PythonLanguage language) {
            return PFactory.createList(language);
        }

        @Fallback
        protected PList constructList(Object cls, Object[] arguments, PKeyword[] keywords, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createList(language, cls, getInstanceShape.execute(cls));
        }

        protected static boolean isBuiltinList(Object cls) {
            return cls == PythonBuiltinClassType.PList;
        }
    }
}

