/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.metrics;

import java.time.Clock;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.LongAdder;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.metrics.Counter;

public class RollingCounter
implements Counter<Long> {
    private final long capacity;
    private final long window;
    private final long interval;
    private final Clock clock;
    private final ConcurrentSkipListMap<Long, Long> time2CountWin;
    private final LongAdder count;

    public RollingCounter() {
        this((Long)LocalClusterState.state().getSettingValue(Settings.Key.METRICS_ROLLING_WINDOW), (Long)LocalClusterState.state().getSettingValue(Settings.Key.METRICS_ROLLING_INTERVAL));
    }

    public RollingCounter(long window, long interval, Clock clock) {
        this.window = window;
        this.interval = interval;
        this.clock = clock;
        this.time2CountWin = new ConcurrentSkipListMap();
        this.count = new LongAdder();
        this.capacity = window / interval * 2L;
    }

    public RollingCounter(long window, long interval) {
        this(window, interval, Clock.systemDefaultZone());
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    @Override
    public void add(long n) {
        this.trim();
        this.time2CountWin.compute(this.getKey(this.clock.millis()), (k, v) -> v == null ? n : v + n);
    }

    @Override
    public Long getValue() {
        return this.getValue(this.getPreKey(this.clock.millis()));
    }

    public long getValue(long key) {
        Long res = this.time2CountWin.get(key);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    public long getSum() {
        return this.count.longValue();
    }

    private void trim() {
        if ((long)this.time2CountWin.size() > this.capacity) {
            this.time2CountWin.headMap((Object)this.getKey(this.clock.millis() - this.window * 1000L)).clear();
        }
    }

    private long getKey(long millis) {
        return millis / 1000L / this.interval;
    }

    private long getPreKey(long millis) {
        return this.getKey(millis) - 1L;
    }

    public int size() {
        return this.time2CountWin.size();
    }

    @Override
    public void reset() {
        this.time2CountWin.clear();
    }
}

