/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class WeekFunction
extends ImplementorUDF {
    public WeekFunction() {
        super(new WeekImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.INTEGER_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATETIME_OPTIONAL_INTEGER;
    }

    public static class WeekImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            return Expressions.call(WeekImplementor.class, "week", list);
        }

        public static int week(String date) {
            ExprDateValue dateValue = new ExprDateValue(date);
            return (Integer)DateTimeFunctions.exprWeekWithoutMode(dateValue).valueForCalcite();
        }

        public static int week(String date, int mode) {
            ExprDateValue dateValue = new ExprDateValue(date);
            ExprIntegerValue modeValue = new ExprIntegerValue(mode);
            ExprValue woyExpr = DateTimeFunctions.exprWeek(dateValue, modeValue);
            return (Integer)woyExpr.valueForCalcite();
        }
    }
}

