/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport.format;

import java.util.Map;
import lombok.Generated;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryRequest;
import org.opensearch.sql.prometheus.model.PrometheusOptions;
import org.opensearch.sql.prometheus.model.PrometheusQueryType;
import org.opensearch.sql.spark.rest.model.LangType;

public final class DirectQueryRequestConverter {
    public static ExecuteDirectQueryRequest fromXContentParser(XContentParser parser) throws Exception {
        ExecuteDirectQueryRequest request = new ExecuteDirectQueryRequest();
        Map options = null;
        try {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "datasource": {
                        request.setDataSources(parser.textOrNull());
                        continue block24;
                    }
                    case "query": {
                        request.setQuery(parser.textOrNull());
                        continue block24;
                    }
                    case "sessionId": {
                        request.setSessionId(parser.textOrNull());
                        continue block24;
                    }
                    case "language": {
                        String language = parser.textOrNull();
                        if (language == null) continue block24;
                        try {
                            request.setLanguage(LangType.fromString(language));
                            continue block24;
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid languageType: " + language);
                        }
                    }
                    case "sourceVersion": {
                        request.setSourceVersion(parser.textOrNull());
                        continue block24;
                    }
                    case "maxResults": {
                        request.setMaxResults(parser.intValue());
                        continue block24;
                    }
                    case "timeout": {
                        request.setTimeout(parser.intValue());
                        continue block24;
                    }
                    case "options": {
                        options = parser.map();
                        continue block24;
                    }
                }
                parser.skipChildren();
            }
            if (request.getLanguage() == LangType.PROMQL) {
                request.setOptions(DirectQueryRequestConverter.createPrometheusOptions(options));
            }
            return request;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error while parsing the direct query request: %s", e.getMessage()), e);
        }
    }

    private static PrometheusOptions createPrometheusOptions(Map<String, Object> options) {
        PrometheusOptions prometheusOptions = new PrometheusOptions();
        if (options != null) {
            if (options.containsKey("queryType")) {
                prometheusOptions.setQueryType(PrometheusQueryType.fromString((String)options.get("queryType")));
            }
            if (options.containsKey("step")) {
                prometheusOptions.setStep((String)options.get("step"));
            }
            if (options.containsKey("time")) {
                prometheusOptions.setTime((String)options.get("time"));
            }
            if (options.containsKey("start")) {
                prometheusOptions.setStart((String)options.get("start"));
            }
            if (options.containsKey("end")) {
                prometheusOptions.setEnd((String)options.get("end"));
            }
        }
        return prometheusOptions;
    }

    @Generated
    private DirectQueryRequestConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

