/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.udaf;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;

public class ValuesAggFunction
implements UserDefinedAggFunction<ValuesAccumulator> {
    @Override
    public ValuesAccumulator init() {
        return new ValuesAccumulator();
    }

    @Override
    public Object result(ValuesAccumulator accumulator) {
        return accumulator.value(new Object[0]);
    }

    @Override
    public ValuesAccumulator add(ValuesAccumulator acc, Object ... values2) {
        if (values2 == null || values2.length == 0) {
            return acc;
        }
        Object value = values2[0];
        int limit = 0;
        if (values2.length > 1 && values2[1] != null) {
            limit = (Integer)values2[1];
        }
        if (value != null && (limit == 0 || acc.size() < limit)) {
            String stringValue = String.valueOf(value);
            acc.add(stringValue, limit);
        }
        return acc;
    }

    public static class ValuesAccumulator
    implements UserDefinedAggFunction.Accumulator {
        private final Set<String> values = new TreeSet<String>();

        @Override
        public Object value(Object ... argList) {
            return new ArrayList<String>(this.values);
        }

        public void add(String value, int limit) {
            if (limit == 0 || this.values.size() < limit) {
                this.values.add(value);
            }
        }

        public int size() {
            return this.values.size();
        }
    }
}

