/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.utils.StringUtils;

public abstract class AbstractConnector
implements Connector {
    public static final String ACCESS_KEY_FIELD = "access_key";
    public static final String SECRET_KEY_FIELD = "secret_key";
    public static final String SESSION_TOKEN_FIELD = "session_token";
    public static final String NAME_FIELD = "name";
    public static final String VERSION_FIELD = "version";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PROTOCOL_FIELD = "protocol";
    public static final String ACTIONS_FIELD = "actions";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String OWNER_FIELD = "owner";
    public static final String ACCESS_FIELD = "access";
    public static final String CLIENT_CONFIG_FIELD = "client_config";
    protected String name;
    protected String description;
    protected String version;
    protected String protocol;
    protected Map<String, String> parameters;
    protected Map<String, String> credential;
    protected Map<String, String> decryptedHeaders;
    protected Map<String, String> decryptedCredential;
    protected List<ConnectorAction> actions;
    protected List<String> backendRoles;
    protected User owner;
    protected AccessMode access;
    protected Instant createdTime;
    protected Instant lastUpdateTime;
    protected ConnectorClientConfig connectorClientConfig;
    protected String tenantId;

    protected Map<String, String> createDecryptedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> decryptedHeaders = new HashMap<String, String>();
        StringSubstitutor substitutor = new StringSubstitutor(this.getDecryptedCredential(), "${credential.", "}");
        for (String key : headers.keySet()) {
            decryptedHeaders.put(key, substitutor.replace(headers.get(key)));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            substitutor = new StringSubstitutor(this.parameters, "${parameters.", "}");
            for (String key : decryptedHeaders.keySet()) {
                decryptedHeaders.put(key, substitutor.replace((String)decryptedHeaders.get(key)));
            }
        }
        return decryptedHeaders;
    }

    @Override
    public <T> void parseResponse(T response, List<ModelTensor> modelTensors, boolean modelTensorJson) throws IOException {
        if (modelTensorJson) {
            String modelTensorJsonContent = (String)response;
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, null, modelTensorJsonContent);
            parser.nextToken();
            if (XContentParser.Token.START_ARRAY == parser.currentToken()) {
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    ModelTensor modelTensor = ModelTensor.parser(parser);
                    modelTensors.add(modelTensor);
                }
            } else {
                ModelTensor modelTensor = ModelTensor.parser(parser);
                modelTensors.add(modelTensor);
            }
            return;
        }
        if (response instanceof String && StringUtils.isJson((String)response)) {
            Map<String, Object> data2 = StringUtils.fromJson((String)response, "response");
            modelTensors.add(ModelTensor.builder().name("response").dataAsMap(data2).build());
        } else if (response instanceof Map) {
            modelTensors.add(ModelTensor.builder().name("response").dataAsMap((Map)response).build());
        } else {
            HashMap<String, T> map = new HashMap<String, T>();
            map.put("response", response);
            modelTensors.add(ModelTensor.builder().name("response").dataAsMap(map).build());
        }
    }

    @Override
    public Optional<ConnectorAction> findAction(String action) {
        if (this.actions != null) {
            return this.actions.stream().filter(a -> a.getActionType().name().equalsIgnoreCase(action)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public void addAction(ConnectorAction action) {
        this.actions.add(action);
    }

    @Override
    public void removeCredential() {
        this.credential = null;
        this.decryptedCredential = null;
        this.decryptedHeaders = null;
    }

    @Override
    public String getActionEndpoint(String action, Map<String, String> parameters2) {
        Optional<ConnectorAction> actionEndpoint = this.findAction(action);
        if (actionEndpoint.isEmpty()) {
            return null;
        }
        String predictEndpoint = actionEndpoint.get().getUrl();
        if (parameters2 != null && !parameters2.isEmpty()) {
            StringSubstitutor substitutor = new StringSubstitutor(parameters2, "${parameters.", "}");
            predictEndpoint = substitutor.replace(predictEndpoint);
        }
        return predictEndpoint;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Override
    @Generated
    public Map<String, String> getDecryptedHeaders() {
        return this.decryptedHeaders;
    }

    @Override
    @Generated
    public Map<String, String> getDecryptedCredential() {
        return this.decryptedCredential;
    }

    @Override
    @Generated
    public List<ConnectorAction> getActions() {
        return this.actions;
    }

    @Override
    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Override
    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public AccessMode getAccess() {
        return this.access;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Generated
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setDecryptedCredential(Map<String, String> decryptedCredential) {
        this.decryptedCredential = decryptedCredential;
    }

    @Override
    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Override
    @Generated
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    @Generated
    public void setAccess(AccessMode access) {
        this.access = access;
    }

    @Override
    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Override
    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

