/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model.remote.monitors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\t\u0010\u001b\u001a\u00020\u0010H\u00d6\u0001J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput;", "Lorg/opensearch/commons/alerting/model/Input;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "input", "Lorg/opensearch/core/common/bytes/BytesReference;", "docLevelMonitorInput", "Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;", "(Lorg/opensearch/core/common/bytes/BytesReference;Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;)V", "getDocLevelMonitorInput", "()Lorg/opensearch/commons/alerting/model/DocLevelMonitorInput;", "getInput", "()Lorg/opensearch/core/common/bytes/BytesReference;", "asTemplateArg", "", "", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "name", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class RemoteDocLevelMonitorInput
implements Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesReference input;
    @NotNull
    private final DocLevelMonitorInput docLevelMonitorInput;
    @NotNull
    public static final String INPUT_FIELD = "input";
    @NotNull
    public static final String INPUT_SIZE = "size";
    @NotNull
    public static final String REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD = "remote_doc_level_monitor_input";

    public RemoteDocLevelMonitorInput(@NotNull BytesReference input, @NotNull DocLevelMonitorInput docLevelMonitorInput) {
        Intrinsics.checkNotNullParameter(input, INPUT_FIELD);
        Intrinsics.checkNotNullParameter(docLevelMonitorInput, "docLevelMonitorInput");
        this.input = input;
        this.docLevelMonitorInput = docLevelMonitorInput;
    }

    @NotNull
    public final BytesReference getInput() {
        return this.input;
    }

    @NotNull
    public final DocLevelMonitorInput getDocLevelMonitorInput() {
        return this.docLevelMonitorInput;
    }

    public RemoteDocLevelMonitorInput(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        BytesReference bytesReference = sin.readBytesReference();
        Intrinsics.checkNotNullExpressionValue(bytesReference, "readBytesReference(...)");
        this(bytesReference, DocLevelMonitorInput.Companion.readFrom(sin));
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        byte[] bytes = this.input.toBytesRef().bytes;
        Pair[] pairArray = new Pair[]{TuplesKt.to(INPUT_SIZE, bytes.length), TuplesKt.to(INPUT_FIELD, bytes), TuplesKt.to("doc_level_input", this.docLevelMonitorInput)};
        return MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public String name() {
        return REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeBytesReference(this.input);
        this.docLevelMonitorInput.writeTo(out);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(params, "params");
        byte[] bytes = this.input.toBytesRef().bytes;
        XContentBuilder xContentBuilder = builder.startObject().startObject(REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD).field(INPUT_SIZE, bytes.length).field(INPUT_FIELD, bytes).field("doc_level_input", (ToXContent)this.docLevelMonitorInput).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue(xContentBuilder, "endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final BytesReference component1() {
        return this.input;
    }

    @NotNull
    public final DocLevelMonitorInput component2() {
        return this.docLevelMonitorInput;
    }

    @NotNull
    public final RemoteDocLevelMonitorInput copy(@NotNull BytesReference input, @NotNull DocLevelMonitorInput docLevelMonitorInput) {
        Intrinsics.checkNotNullParameter(input, INPUT_FIELD);
        Intrinsics.checkNotNullParameter(docLevelMonitorInput, "docLevelMonitorInput");
        return new RemoteDocLevelMonitorInput(input, docLevelMonitorInput);
    }

    public static /* synthetic */ RemoteDocLevelMonitorInput copy$default(RemoteDocLevelMonitorInput remoteDocLevelMonitorInput, BytesReference bytesReference, DocLevelMonitorInput docLevelMonitorInput, int n, Object object) {
        if ((n & 1) != 0) {
            bytesReference = remoteDocLevelMonitorInput.input;
        }
        if ((n & 2) != 0) {
            docLevelMonitorInput = remoteDocLevelMonitorInput.docLevelMonitorInput;
        }
        return remoteDocLevelMonitorInput.copy(bytesReference, docLevelMonitorInput);
    }

    @NotNull
    public String toString() {
        return "RemoteDocLevelMonitorInput(input=" + this.input + ", docLevelMonitorInput=" + this.docLevelMonitorInput + ")";
    }

    public int hashCode() {
        int result2 = this.input.hashCode();
        result2 = result2 * 31 + this.docLevelMonitorInput.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteDocLevelMonitorInput)) {
            return false;
        }
        RemoteDocLevelMonitorInput remoteDocLevelMonitorInput = (RemoteDocLevelMonitorInput)other;
        if (!Intrinsics.areEqual(this.input, remoteDocLevelMonitorInput.input)) {
            return false;
        }
        return Intrinsics.areEqual(this.docLevelMonitorInput, remoteDocLevelMonitorInput.docLevelMonitorInput);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput$Companion;", "", "()V", "INPUT_FIELD", "", "INPUT_SIZE", "REMOTE_DOC_LEVEL_MONITOR_INPUT_FIELD", "parse", "Lorg/opensearch/commons/alerting/model/remote/monitors/RemoteDocLevelMonitorInput;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteDocLevelMonitorInput parse(@NotNull XContentParser xcp) {
            Intrinsics.checkNotNullParameter(xcp, "xcp");
            byte[] bytes = null;
            int size = 0;
            DocLevelMonitorInput docLevelMonitorInput = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual(string, RemoteDocLevelMonitorInput.INPUT_FIELD)) {
                    bytes = xcp.binaryValue();
                    continue;
                }
                if (Intrinsics.areEqual(string, RemoteDocLevelMonitorInput.INPUT_SIZE)) {
                    size = xcp.intValue();
                    continue;
                }
                if (!Intrinsics.areEqual(string, Input.Type.DOCUMENT_LEVEL_INPUT.getValue())) continue;
                docLevelMonitorInput = DocLevelMonitorInput.Companion.parse(xcp);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            }
            BytesReference input = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes, 0, size));
            Intrinsics.checkNotNull(input);
            DocLevelMonitorInput docLevelMonitorInput2 = docLevelMonitorInput;
            Intrinsics.checkNotNull(docLevelMonitorInput2);
            return new RemoteDocLevelMonitorInput(input, docLevelMonitorInput2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

