/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;

public class SQLBinaryOpExpr
extends SQLExprImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SQLExpr left;
    private SQLExpr right;
    private SQLBinaryOperator operator;
    private String dbType;

    public SQLBinaryOpExpr() {
    }

    public SQLBinaryOpExpr(String dbType) {
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right) {
        this(left, operator, right, null);
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right, String dbType) {
        this.setLeft(left);
        this.setRight(right);
        this.operator = operator;
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLExpr right, SQLBinaryOperator operator) {
        this.setLeft(left);
        this.setRight(right);
        this.operator = operator;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public SQLExpr getLeft() {
        return this.left;
    }

    public void setLeft(SQLExpr left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLExpr getRight() {
        return this.right;
    }

    public void setRight(SQLExpr right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor2) {
        if (visitor2.visit(this)) {
            this.acceptChild(visitor2, this.left);
            this.acceptChild(visitor2, this.right);
        }
        visitor2.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.left == null ? 0 : this.left.hashCode());
        result2 = 31 * result2 + (this.operator == null ? 0 : this.operator.hashCode());
        result2 = 31 * result2 + (this.right == null ? 0 : this.right.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr other = (SQLBinaryOpExpr)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.getDbType());
    }
}

