"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchEnhancements = void 0;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const createAction = (client, components, options) => {
  const {
    endpoint,
    method,
    needBody = false,
    paramKey,
    params
  } = options;
  let urlConfig;
  if (paramKey) {
    urlConfig = {
      fmt: `${endpoint}/<%=${paramKey}%>`,
      req: {
        [paramKey]: {
          type: 'string',
          required: true
        }
      }
    };
  } else if (params) {
    urlConfig = {
      fmt: endpoint,
      params
    };
  } else {
    urlConfig = {
      fmt: endpoint
    };
  }
  return components.clientAction.factory({
    url: urlConfig,
    needBody,
    method
  });
};
const OpenSearchEnhancements = (client, config, components) => {
  client.prototype.enhancements = components.clientAction.namespaceFactory();
  const enhancements = client.prototype.enhancements.prototype;
  enhancements.pplQuery = createAction(client, components, {
    endpoint: _common.URI.PPL,
    method: 'POST',
    needBody: true
  });
  enhancements.sqlQuery = createAction(client, components, {
    endpoint: _common.URI.SQL,
    method: 'POST',
    needBody: true
  });
  enhancements.getDataConnectionById = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.DATA_CONNECTIONS,
    method: 'GET',
    paramKey: 'dataconnection'
  });
  enhancements.deleteDataConnection = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.DATA_CONNECTIONS,
    method: 'DELETE',
    paramKey: 'dataconnection'
  });
  enhancements.createDataSource = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.DATA_CONNECTIONS,
    method: 'POST',
    needBody: true
  });
  enhancements.modifyDataConnection = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.DATA_CONNECTIONS,
    method: 'PATCH',
    needBody: true
  });
  enhancements.getDataConnections = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.DATA_CONNECTIONS,
    method: 'GET'
  });
  enhancements.getObject = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.PANELS,
    method: 'GET',
    params: {
      objectId: {
        type: 'string'
      },
      objectIdList: {
        type: 'string'
      },
      objectType: {
        type: 'string'
      },
      sortField: {
        type: 'string'
      },
      sortOrder: {
        type: 'string'
      },
      fromIndex: {
        type: 'number'
      },
      maxItems: {
        type: 'number'
      },
      name: {
        type: 'string'
      },
      lastUpdatedTimeMs: {
        type: 'string'
      },
      createdTimeMs: {
        type: 'string'
      }
    }
  });
  enhancements.getObjectById = createAction(client, components, {
    endpoint: `${_common.OPENSEARCH_API.PANELS}/<%=objectId%>`,
    method: 'GET',
    paramKey: 'objectId'
  });
  enhancements.createObject = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.PANELS,
    method: 'POST',
    needBody: true
  });
  enhancements.updateObjectById = createAction(client, components, {
    endpoint: `${_common.OPENSEARCH_API.PANELS}/<%=objectId%>`,
    method: 'PUT',
    paramKey: 'objectId',
    needBody: true
  });
  enhancements.deleteObjectById = createAction(client, components, {
    endpoint: `${_common.OPENSEARCH_API.PANELS}/<%=objectId%>`,
    method: 'DELETE',
    paramKey: 'objectId'
  });
  enhancements.deleteObjectByIdList = createAction(client, components, {
    endpoint: _common.OPENSEARCH_API.PANELS,
    method: 'DELETE',
    params: {
      objectIdList: {
        type: 'string',
        required: true
      }
    }
  });
  enhancements.getJobStatus = createAction(client, components, {
    endpoint: `${_common.URI.ASYNC_QUERY}`,
    method: 'GET',
    paramKey: 'queryId'
  });
  enhancements.deleteJob = createAction(client, components, {
    endpoint: `${_common.URI.ASYNC_QUERY}`,
    method: 'DELETE',
    paramKey: 'queryId'
  });
  enhancements.runDirectQuery = createAction(client, components, {
    endpoint: _common.URI.ASYNC_QUERY,
    method: 'POST',
    needBody: true
  });
};
exports.OpenSearchEnhancements = OpenSearchEnhancements;