/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.installer.platform.win32.WinGuiHelper;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WinTaskBar {
    private static boolean initialized;

    private static native void initTaskBar0();

    private static native void setOverlayIcon0(long var0, long var2);

    private static native void setProgress0(long var0, long var2, long var4);

    private static native void setState0(long var0, int var2);

    private static synchronized void initTaskBar() {
        if (!initialized) {
            initialized = true;
            WinTaskBar.initTaskBar0();
        }
    }

    public abstract void setProgressState(ProgressState var1);

    public abstract void setProgress(long var1, long var3);

    public abstract void setOverlayIcon(@Nullable byte[] var1, int var2);

    public abstract void flash();

    @NotNull
    public static WinTaskBar getTaskBar(Window window) {
        if (!Util.isWindows() || window == null) {
            return new NoopTaskBar();
        }
        final long hwnd = WinGuiHelper.getHwnd(window);
        if (hwnd == 0L) {
            return new NoopTaskBar();
        }
        WinTaskBar.initTaskBar();
        return new WinTaskBar(){
            private ProgressState lastState;
            private long lastCompleted;
            private long lastTotal;

            @Override
            public void setProgressState(ProgressState progressState) {
                if (progressState != this.lastState) {
                    this.lastState = progressState;
                    WinTaskBar.setState0(hwnd, progressState.intValue);
                }
            }

            @Override
            public void setProgress(long completed, long total) {
                if (completed != this.lastCompleted || total != this.lastTotal) {
                    this.lastCompleted = completed;
                    this.lastTotal = total;
                    WinTaskBar.setProgress0(hwnd, completed, total);
                }
            }

            @Override
            public void setOverlayIcon(byte[] icoData, int iconSize) {
                if (icoData == null) {
                    WinTaskBar.setOverlayIcon0(hwnd, 0L);
                } else {
                    long hicon = WinGuiHelper.createHIcon(icoData, iconSize, iconSize);
                    if (hicon != 0L) {
                        WinTaskBar.setOverlayIcon0(hwnd, hicon);
                        WinGuiHelper.destroyHIcon(hicon);
                    }
                }
            }

            @Override
            public void flash() {
                WinGuiHelper.flashWindow(hwnd);
            }
        };
    }

    static {
        Common.init();
    }

    public static enum ProgressState {
        NOPROGRESS(0),
        INDETERMINATE(1),
        NORMAL(2),
        ERROR(4),
        PAUSED(8);

        final int intValue;

        private ProgressState(int intValue) {
            this.intValue = intValue;
        }
    }

    private static class NoopTaskBar
    extends WinTaskBar {
        private NoopTaskBar() {
        }

        @Override
        public void setProgressState(ProgressState progressState) {
        }

        @Override
        public void setProgress(long completed, long total) {
        }

        @Override
        public void setOverlayIcon(byte[] icoData, int iconSize) {
        }

        @Override
        public void flash() {
        }
    }
}

