/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jaybird.xca.FBStandAloneConnectionManager;
import org.firebirdsql.jaybird.xca.FBTpb;
import org.firebirdsql.jaybird.xca.FBXAException;
import org.firebirdsql.jaybird.xca.FBXid;
import org.firebirdsql.jaybird.xca.XcaConnectionManager;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class FBManagedConnectionFactory
implements FirebirdConnectionProperties,
Serializable {
    private static final Map<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>> mcfInstances = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>>();
    private static final ReferenceQueue<FBManagedConnectionFactory> mcfReferenceQueue = new ReferenceQueue();
    private static final String DEFAULT_CONNECTION_MANAGER_TYPE = "CONNECTION_MANAGER_TYPE";
    private XcaConnectionManager defaultCm;
    private int hashCode;
    private GDSType gdsType;
    private final Map<Xid, FBManagedConnection> xidMap = new ConcurrentHashMap<Xid, FBManagedConnection>();
    private final Object startLock = new Object();
    private boolean started = false;
    private final boolean shared;
    private final FBConnectionProperties connectionProperties;

    public FBManagedConnectionFactory() {
        this(true);
    }

    public FBManagedConnectionFactory(boolean shared) {
        this(shared, GDSFactory.getDefaultGDSType(), null);
    }

    public FBManagedConnectionFactory(GDSType gdsType) {
        this(true, gdsType);
    }

    public FBManagedConnectionFactory(boolean shared, GDSType gdsType) {
        this(shared, gdsType, null);
    }

    public FBManagedConnectionFactory(GDSType gdsType, FBConnectionProperties connectionProperties) {
        this(true, gdsType, connectionProperties);
    }

    public FBManagedConnectionFactory(boolean shared, GDSType gdsType, FBConnectionProperties connectionProperties) {
        this.shared = shared;
        this.connectionProperties = connectionProperties != null ? (FBConnectionProperties)connectionProperties.clone() : new FBConnectionProperties();
        this.setType(gdsType.toString());
        this.setDefaultConnectionManager(new FBStandAloneConnectionManager());
    }

    public FbDatabaseFactory getDatabaseFactory() {
        return GDSFactory.getDatabaseFactoryForType(this.getGDSType());
    }

    public GDSType getGDSType() {
        if (this.gdsType != null) {
            return this.gdsType;
        }
        this.gdsType = GDSType.getType(this.getType());
        return this.gdsType;
    }

    public boolean getShared() {
        return this.shared;
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.ensureCanModify(() -> this.connectionProperties.setNonStandardProperty(propertyMapping));
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.ensureCanModify(() -> this.connectionProperties.setTransactionParameters(isolation, tpb));
    }

    public void setDefaultConnectionManager(XcaConnectionManager defaultCm) {
        this.ensureCanModify(() -> {
            this.connectionProperties.setProperty(DEFAULT_CONNECTION_MANAGER_TYPE, defaultCm.getClass().getName());
            this.defaultCm = defaultCm;
        });
    }

    @Override
    public String getProperty(String name) {
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.ensureCanModify(() -> {
            if ("type".equals(name) && this.gdsType != null) {
                throw new IllegalStateException("Cannot change GDS type at runtime.");
            }
            this.connectionProperties.setProperty(name, value);
        });
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.connectionProperties.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.ensureCanModify(() -> this.connectionProperties.setIntProperty(name, value));
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.connectionProperties.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.ensureCanModify(() -> this.connectionProperties.setBooleanProperty(name, value));
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.connectionProperties.connectionPropertyValues();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (!this.started) {
            return this.hashCodeImpl();
        }
        this.hashCode = this.hashCodeImpl();
        return this.hashCode;
    }

    private int hashCodeImpl() {
        int result = this.connectionProperties.hashCode();
        if (result == 0) {
            return 17;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) {
            return false;
        }
        FBManagedConnectionFactory that = (FBManagedConnectionFactory)other;
        return this.connectionProperties.equals(that.connectionProperties);
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() throws SQLException {
        return new FBConnectionRequestInfo(this.connectionProperties.asIConnectionProperties().asNewMutable());
    }

    public FBTpb getDefaultTpb() throws SQLException {
        int defaultTransactionIsolation = this.connectionProperties.getDefaultTransactionIsolation();
        return this.getTpb(defaultTransactionIsolation);
    }

    public FBTpb getTpb(int isolation) throws SQLException {
        return new FBTpb(this.connectionProperties.getMapper().getMapping(isolation));
    }

    FBTpbMapper getTransactionMappingCopy() throws SQLException {
        return (FBTpbMapper)this.connectionProperties.getMapper().clone();
    }

    public DataSource createConnectionFactory(XcaConnectionManager connectionManager) {
        this.start();
        return new FBDataSource(this, connectionManager);
    }

    public DataSource createConnectionFactory() {
        return this.createConnectionFactory(this.defaultCm);
    }

    public FBManagedConnection createManagedConnection() throws SQLException {
        this.start();
        return new FBManagedConnection(null, this);
    }

    public FBManagedConnection createManagedConnection(FBConnectionRequestInfo connectionRequestInfo) throws SQLException {
        this.start();
        return new FBManagedConnection(connectionRequestInfo, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf;
        Logger logger;
        if (!this.shared && (logger = LoggerFactory.getLogger(FBManagedConnectionFactory.class)).isDebugEnabled()) {
            logger.debug("canonicalize called on MCF with shared=false", new RuntimeException("trace exception"));
        }
        if ((mcf = this.internalCanonicalize()) != null) {
            return mcf;
        }
        this.start();
        return this;
    }

    private FBManagedConnectionFactory internalCanonicalize() {
        SoftReference<FBManagedConnectionFactory> factoryReference = mcfInstances.get(this.getCacheKey());
        return factoryReference != null ? factoryReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            if (this.shared) {
                mcfInstances.put(this.getCacheKey(), new SoftReference<FBManagedConnectionFactory>(this, mcfReferenceQueue));
            }
        }
        this.cleanMcfInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCanModify(Runnable runnable) {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started && this.shared) {
                throw new IllegalStateException("Managed connection factory is shared and already started, configuration change not allowed");
            }
            runnable.run();
            this.hashCode = 0;
        }
    }

    private void cleanMcfInstances() {
        Reference<FBManagedConnectionFactory> reference;
        while ((reference = mcfReferenceQueue.poll()) != null) {
            mcfInstances.values().remove(reference);
        }
    }

    void notifyStart(FBManagedConnection mc, Xid xid) {
        this.xidMap.put(xid, mc);
    }

    void notifyEnd(FBManagedConnection mc, Xid xid) throws XAException {
    }

    int notifyPrepare(FBManagedConnection mc, Xid xid) throws XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        return targetMc.internalPrepare(xid);
    }

    void notifyCommit(FBManagedConnection mc, Xid xid, boolean onePhase) throws XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(xid, true);
        } else {
            targetMc.internalCommit(xid, onePhase);
        }
        this.xidMap.remove(xid);
    }

    void notifyRollback(FBManagedConnection mc, Xid xid) throws XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(xid, false);
        } else {
            targetMc.internalRollback(xid);
        }
        this.xidMap.remove(xid);
    }

    public void forget(FBManagedConnection mc, Xid xid) {
        this.xidMap.remove(xid);
    }

    public void recover(FBManagedConnection mc, Xid xid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCompleteInLimboTransaction(Xid xid, boolean commit) throws XAException {
        block27: {
            try {
                FBManagedConnection tempMc = null;
                FBLocalTransaction tempLocalTx = null;
                try {
                    tempMc = this.createManagedConnection();
                    tempLocalTx = tempMc.getLocalTransaction();
                    tempLocalTx.begin();
                    long fbTransactionId = 0L;
                    boolean found = false;
                    if (tempMc.getGDSHelper().compareToVersion(2, 0) < 0) {
                        FBXid[] inLimboIds;
                        for (FBXid inLimboId : inLimboIds = (FBXid[])tempMc.getXAResource().recover(0x1000000)) {
                            if (!inLimboId.equals(xid)) continue;
                            found = true;
                            fbTransactionId = inLimboId.getFirebirdTransactionId();
                        }
                    } else {
                        FBXid foundXid = (FBXid)tempMc.findSingleXid(xid);
                        if (foundXid != null && foundXid.equals(xid)) {
                            found = true;
                            fbTransactionId = foundXid.getFirebirdTransactionId();
                        }
                    }
                    if (!found) {
                        throw new FBXAException((commit ? "Commit" : "Rollback") + " called with unknown transaction.", -4);
                    }
                    FbDatabase dbHandle = tempMc.getGDSHelper().getCurrentDatabase();
                    FbTransaction trHandle = dbHandle.reconnectTransaction(fbTransactionId);
                    if (commit) {
                        trHandle.commit();
                    } else {
                        trHandle.rollback();
                    }
                    if (tempMc.getGDSHelper().compareToVersion(3, 0) >= 0) break block27;
                    try {
                        String query = "delete from rdb$transactions where rdb$transaction_id = " + fbTransactionId;
                        FbTransaction trHandle2 = dbHandle.startTransaction(this.getDefaultTpb().getTransactionParameterBuffer());
                        FbStatement stmtHandle2 = dbHandle.createStatement(trHandle2);
                        stmtHandle2.prepare(query);
                        stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
                        stmtHandle2.close();
                        trHandle2.commit();
                    }
                    catch (SQLException sqle) {
                        throw new FBXAException("unable to remove in limbo transaction from rdb$transactions where rdb$transaction_id = " + fbTransactionId, -3);
                    }
                }
                catch (SQLException ex) {
                    int errorCode = -3;
                    int sqlError = ex.getErrorCode();
                    if (sqlError == 335544353) {
                        if (ex.getMessage().contains("committed")) {
                            errorCode = 7;
                        } else if (ex.getMessage().contains("rolled back")) {
                            errorCode = 7;
                        }
                    }
                    throw new FBXAException("unable to complete in limbo transaction", errorCode, ex);
                }
                finally {
                    try {
                        if (tempLocalTx != null && tempLocalTx.inTransaction()) {
                            tempLocalTx.commit();
                        }
                    }
                    finally {
                        if (tempMc != null) {
                            tempMc.destroy();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new FBXAException(-3, ex);
            }
        }
    }

    FBConnection newConnection(FBManagedConnection mc) throws SQLException {
        Class<?> connectionClass = GDSFactory.getConnectionClass(this.getGDSType());
        if (!FBConnection.class.isAssignableFrom(connectionClass)) {
            throw new IllegalArgumentException("Specified connection class does not extend " + FBConnection.class.getName() + " class");
        }
        try {
            Constructor<?> constructor = connectionClass.getConstructor(FBManagedConnection.class);
            return (FBConnection)constructor.newInstance(mc);
        }
        catch (NoSuchMethodException ex) {
            throw new SQLException("Cannot instantiate connection class " + connectionClass.getName() + ", no constructor accepting " + FBManagedConnection.class + " class as single parameter was found.");
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLException("Constructor for class " + connectionClass.getName() + " is not accessible.", ex);
        }
        catch (InstantiationException ex) {
            throw new SQLException("Cannot instantiate class" + connectionClass.getName(), ex);
        }
    }

    public FBConnectionProperties getCacheKey() {
        return (FBConnectionProperties)this.connectionProperties.clone();
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean shared;
        private final XcaConnectionManager fbCm;
        private final String type;
        private final FBConnectionProperties fbConnectionProperties;

        private SerializationProxy(FBManagedConnectionFactory connectionFactory) {
            this.shared = connectionFactory.shared;
            this.fbCm = connectionFactory.defaultCm;
            this.type = connectionFactory.getType();
            this.fbConnectionProperties = connectionFactory.connectionProperties;
        }

        protected Object readResolve() {
            GDSType gdsType = GDSType.getType(this.type);
            if (gdsType == null) {
                gdsType = GDSFactory.getDefaultGDSType();
            }
            FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(this.shared, gdsType, this.fbConnectionProperties);
            mcf.setDefaultConnectionManager(this.fbCm);
            if (!this.shared) {
                return mcf;
            }
            FBManagedConnectionFactory canonicalizedMcf = mcf.internalCanonicalize();
            return canonicalizedMcf != null ? canonicalizedMcf : mcf;
        }
    }
}

