/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;

abstract class VectorScorer {
    protected final VectorSimilarityFunction similarity;

    static FloatVectorScorer create(LeafReaderContext context, FieldInfo fi, float[] query) throws IOException {
        FloatVectorValues values2 = context.reader().getFloatVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new FloatVectorScorer(values2, query, similarity);
    }

    static ByteVectorScorer create(LeafReaderContext context, FieldInfo fi, byte[] query) throws IOException {
        ByteVectorValues values2 = context.reader().getByteVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        return new ByteVectorScorer(values2, query, similarity);
    }

    VectorScorer(VectorSimilarityFunction similarity) {
        this.similarity = similarity;
    }

    abstract float score() throws IOException;

    abstract boolean advanceExact(int var1) throws IOException;

    private static class FloatVectorScorer
    extends VectorScorer {
        private final float[] query;
        private final FloatVectorValues values;

        protected FloatVectorScorer(FloatVectorValues values2, float[] query, VectorSimilarityFunction similarity) {
            super(similarity);
            this.query = query;
            this.values = values2;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }

    private static class ByteVectorScorer
    extends VectorScorer {
        private final byte[] query;
        private final ByteVectorValues values;

        protected ByteVectorScorer(ByteVectorValues values2, byte[] query, VectorSimilarityFunction similarity) {
            super(similarity);
            this.values = values2;
            this.query = query;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            int vectorDoc = this.values.docID();
            if (vectorDoc < doc) {
                vectorDoc = this.values.advance(doc);
            }
            return vectorDoc == doc;
        }

        @Override
        public float score() throws IOException {
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }
}

