/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.Notifier;

public final class WindowsNotifier
extends Notifier<Void> {
    static final Logger LOG = Logger.getLogger(WindowsNotifier.class.getName());
    public static HANDLE INVALID_HANDLE_VALUE = new HANDLE(Pointer.createConstant((long)(Native.POINTER_SIZE == 8 ? -1L : 0xFFFFFFFFL)));
    static final Kernel32 KERNEL32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    public static final int INFINITE = -1;
    public static final int FILE_NOTIFY_CHANGE_NAME = 3;
    public static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    public static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    public static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    public static final int FILE_NOTIFY_CHANGE_CREATION = 64;
    public static final int FILE_NOTIFY_CHANGE_SECURITY = 256;
    private static final int NOTIFY_MASK = 351;
    public static final int FILE_LIST_DIRECTORY = 1;
    public static final int OPEN_EXISTING = 3;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int FILE_SHARE_DELETE = 4;
    public static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    public static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    private static int watcherThreadID;
    private Thread watcher;
    private HANDLE port;
    private final Map<String, FileInfo> rootMap = new HashMap<String, FileInfo>();
    private final Map<HANDLE, FileInfo> handleMap = new HashMap<HANDLE, FileInfo>();
    private final BlockingQueue<String> events = new LinkedBlockingQueue<String>();
    private static final int BUFFER_SIZE = 4096;

    public void removeWatch(Void void_) throws IOException {
    }

    public String nextEvent() throws IOException, InterruptedException {
        return this.events.take();
    }

    public Void addWatch(String string) throws IOException {
        int n;
        if (string.isEmpty()) {
            return null;
        }
        String string2 = null;
        if (string.length() >= 3 && string.charAt(1) == ':') {
            string2 = string.substring(0, 3).replace('/', '\\');
            if (string2.charAt(2) != '\\') {
                throw new IOException("wrong path: " + string);
            }
            if (string.length() == 3) {
                LOG.log(Level.INFO, "Adding listener for drive {0}", string);
            }
        } else {
            String string3 = string.replace('/', '\\');
            if (string3.startsWith("\\\\")) {
                n = string3.indexOf(92, 3);
                if (n != -1) {
                    int n2 = string3.indexOf(92, n + 1);
                    if (n2 == -1) {
                        n2 = string3.length();
                    }
                    string2 = string3.substring(0, n2);
                } else {
                    throw new IOException("wrong path: " + string);
                }
            }
        }
        if (this.rootMap.containsKey(string2)) {
            return null;
        }
        string = string2;
        int n3 = 7;
        n = 0x42000000;
        HANDLE hANDLE = KERNEL32.CreateFile(string, 1, n3, null, 3, n, null);
        if (INVALID_HANDLE_VALUE.equals((Object)hANDLE)) {
            throw new IOException("Unable to open " + string + ": " + KERNEL32.GetLastError());
        }
        FileInfo fileInfo = new FileInfo(string, hANDLE);
        this.rootMap.put(string, fileInfo);
        this.handleMap.put(hANDLE, fileInfo);
        this.port = KERNEL32.CreateIoCompletionPort(hANDLE, this.port, hANDLE.getPointer(), 0);
        if (INVALID_HANDLE_VALUE.equals((Object)this.port)) {
            throw new IOException("Unable to create/use I/O Completion port for " + string + ": " + KERNEL32.GetLastError());
        }
        if (!KERNEL32.ReadDirectoryChangesW(hANDLE, fileInfo.info, fileInfo.info.size(), true, 351, fileInfo.infoLength, fileInfo.overlapped, null)) {
            int n4 = KERNEL32.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + fileInfo.path + ", handle " + (Object)((Object)hANDLE) + ": " + n4);
        }
        if (this.watcher == null) {
            Thread thread = new Thread("W32 File Monitor"){

                @Override
                public void run() {
                    while (WindowsNotifier.this.watcher != null) {
                        FileInfo fileInfo = WindowsNotifier.this.waitForChange();
                        if (fileInfo == null) continue;
                        try {
                            WindowsNotifier.this.handleChanges(fileInfo);
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.INFO, "handleChanges", iOException);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            this.watcher = thread;
        }
        return null;
    }

    protected void start() throws IOException {
    }

    public void stop() throws IOException {
        try {
            Thread thread = this.watcher;
            if (thread == null) {
                return;
            }
            this.watcher = null;
            thread.interrupt();
            thread.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new InterruptedIOException().initCause(interruptedException);
        }
    }

    private void notify(File file) {
        this.events.add(file.getPath());
    }

    private void handleChanges(FileInfo fileInfo) throws IOException {
        FILE_NOTIFY_INFORMATION fILE_NOTIFY_INFORMATION = fileInfo.info;
        fILE_NOTIFY_INFORMATION.read();
        do {
            File file = new File(fileInfo.path, fILE_NOTIFY_INFORMATION.getFilename());
            this.notify(file);
        } while ((fILE_NOTIFY_INFORMATION = fILE_NOTIFY_INFORMATION.next()) != null);
        if (!KERNEL32.ReadDirectoryChangesW(fileInfo.handle, fileInfo.info, fileInfo.info.size(), true, 351, fileInfo.infoLength, fileInfo.overlapped, null)) {
            int n = KERNEL32.GetLastError();
            throw new IOException("ReadDirectoryChangesW failed on " + fileInfo.path + ": " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo waitForChange() {
        IntByReference intByReference = new IntByReference();
        HANDLEByReference hANDLEByReference = new HANDLEByReference();
        PointerByReference pointerByReference = new PointerByReference();
        KERNEL32.GetQueuedCompletionStatus(this.port, intByReference, hANDLEByReference, pointerByReference, -1);
        WindowsNotifier windowsNotifier = this;
        synchronized (windowsNotifier) {
            return this.handleMap.get((Object)hANDLEByReference.getValue());
        }
    }

    private class FileInfo {
        public final String path;
        public final HANDLE handle;
        public final FILE_NOTIFY_INFORMATION info = new FILE_NOTIFY_INFORMATION(4096);
        public final IntByReference infoLength = new IntByReference();
        public final OVERLAPPED overlapped = new OVERLAPPED();

        public FileInfo(String string, HANDLE hANDLE) {
            this.path = string;
            this.handle = hANDLE;
        }
    }

    static interface Kernel32
    extends StdCallLibrary {
        public HANDLE CreateFile(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, HANDLE var7);

        public HANDLE CreateIoCompletionPort(HANDLE var1, HANDLE var2, Pointer var3, int var4);

        public int GetLastError();

        public boolean GetQueuedCompletionStatus(HANDLE var1, IntByReference var2, ByReference var3, PointerByReference var4, int var5);

        public boolean PostQueuedCompletionStatus(HANDLE var1, int var2, Pointer var3, OVERLAPPED var4);

        public boolean CloseHandle(HANDLE var1);

        public boolean ReadDirectoryChangesW(HANDLE var1, FILE_NOTIFY_INFORMATION var2, int var3, boolean var4, int var5, IntByReference var6, OVERLAPPED var7, OVERLAPPED_COMPLETION_ROUTINE var8);

        public static interface OVERLAPPED_COMPLETION_ROUTINE
        extends StdCallLibrary.StdCallCallback {
            public void callback(int var1, int var2, OVERLAPPED var3);
        }
    }

    @Structure.FieldOrder(value={"nLength", "lpSecurityDescriptor", "bInheritHandle"})
    public static class SECURITY_ATTRIBUTES
    extends Structure {
        public final int nLength = this.size();
        public Pointer lpSecurityDescriptor;
        public boolean bInheritHandle;
    }

    @Structure.FieldOrder(value={"NextEntryOffset", "Action", "FileNameLength", "FileName"})
    public static class FILE_NOTIFY_INFORMATION
    extends Structure {
        public int NextEntryOffset;
        public int Action;
        public int FileNameLength;
        public char[] FileName = new char[1];

        private FILE_NOTIFY_INFORMATION() {
        }

        public FILE_NOTIFY_INFORMATION(int n) {
            if (n < this.size()) {
                throw new IllegalArgumentException("Size must greater than " + this.size() + ", requested " + n);
            }
            this.allocateMemory(n);
        }

        public String getFilename() {
            return new String(this.FileName, 0, this.FileNameLength / 2);
        }

        public void read() {
            this.FileName = new char[0];
            super.read();
            this.FileName = this.getPointer().getCharArray(12L, this.FileNameLength / 2);
        }

        public FILE_NOTIFY_INFORMATION next() {
            if (this.NextEntryOffset == 0) {
                return null;
            }
            FILE_NOTIFY_INFORMATION fILE_NOTIFY_INFORMATION = new FILE_NOTIFY_INFORMATION();
            fILE_NOTIFY_INFORMATION.useMemory(this.getPointer(), this.NextEntryOffset);
            fILE_NOTIFY_INFORMATION.read();
            return fILE_NOTIFY_INFORMATION;
        }
    }

    public static class HANDLEByReference
    extends ByReference {
        public HANDLEByReference() {
            this(null);
        }

        public HANDLEByReference(HANDLE hANDLE) {
            super(Native.POINTER_SIZE);
            this.setValue(hANDLE);
        }

        public void setValue(HANDLE hANDLE) {
            this.getPointer().setPointer(0L, hANDLE != null ? hANDLE.getPointer() : null);
        }

        public HANDLE getValue() {
            Pointer pointer = this.getPointer().getPointer(0L);
            if (pointer == null) {
                return null;
            }
            if (INVALID_HANDLE_VALUE.getPointer().equals((Object)pointer)) {
                return INVALID_HANDLE_VALUE;
            }
            HANDLE hANDLE = new HANDLE();
            hANDLE.setPointer(pointer);
            return hANDLE;
        }
    }

    @Structure.FieldOrder(value={"Internal", "InternalHigh", "Offset", "OffsetHigh", "hEvent"})
    public static class OVERLAPPED
    extends Structure {
        public ULONG_PTR Internal;
        public ULONG_PTR InternalHigh;
        public int Offset;
        public int OffsetHigh;
        public HANDLE hEvent;
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long l) {
            super(Native.POINTER_SIZE, l);
        }
    }

    public static final class HANDLE
    extends PointerType {
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer pointer) {
            this.setPointer(pointer);
            this.immutable = true;
        }

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            Object object2 = super.fromNative(object, fromNativeContext);
            if (INVALID_HANDLE_VALUE.equals(object2)) {
                return INVALID_HANDLE_VALUE;
            }
            return object2;
        }

        public void setPointer(Pointer pointer) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable reference");
            }
            super.setPointer(pointer);
        }
    }
}

