/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkClosingByReconstructionImageFilter_h
#define sitkClosingByReconstructionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ClosingByReconstructionImageFilter
\brief Closing by reconstruction of an image.

This filter is similar to the morphological closing, but contrary to the morphological closing, the closing by reconstruction preserves the shape of the components. The closing by reconstruction of an image "f" is defined as:

ClosingByReconstruction(f) = ErosionByReconstruction(f, Dilation(f)).

Closing by reconstruction not only preserves structures preserved by the dilation, but also levels raises the contrast of the darkest regions. If PreserveIntensities is on, a subsequent reconstruction by dilation using a marker image that is the original image for all unaffected pixels.

Closing by reconstruction is described in Chapter 6.3.9 of Pierre Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


\see GrayscaleMorphologicalClosingImageFilter
\sa itk::simple::ClosingByReconstruction for the procedural interface
\sa itk::ClosingByReconstructionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ClosingByReconstructionImageFilter : public ImageFilter {
    public:
      using Self = ClosingByReconstructionImageFilter;

      /** Destructor */
      virtual ~ClosingByReconstructionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ClosingByReconstructionImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set the radius of the kernel structuring element.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius ( std::vector<unsigned int> KernelRadius ) { this->m_KernelRadius = std::move(KernelRadius); return *this; }

      /** Set the values of the KernelRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius( unsigned int value ) { this->m_KernelRadius = std::vector<unsigned int>(3, value); return *this; }

      /**
       * Get the radius of the kernel structuring element.
       */
      std::vector<unsigned int> GetKernelRadius() const { return this->m_KernelRadius; }\

      /**
       * Set the kernel or structuring element used for the morphology.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType ( KernelEnum KernelType ) { this->m_KernelType = KernelType; return *this; }

      /**
       * Get the kernel or structuring element used for the morphology.
       */
      KernelEnum GetKernelType() const { return this->m_KernelType; }\

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      bool GetFullyConnected() const { return this->m_FullyConnected; }\

      /**
       * Set/Get whether the original intensities of the image retained for those pixels unaffected by the opening by reconstruction. If Off, the output pixel contrast will be reduced.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetPreserveIntensities ( bool PreserveIntensities ) { this->m_PreserveIntensities = PreserveIntensities; return *this; }

      /** Set the value of PreserveIntensities to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER PreserveIntensitiesOn() { return this->SetPreserveIntensities(true); }
      SITK_RETURN_SELF_TYPE_HEADER PreserveIntensitiesOff() { return this->SetPreserveIntensities(false); }

      /**
       * Set/Get whether the original intensities of the image retained for those pixels unaffected by the opening by reconstruction. If Off, the output pixel contrast will be reduced.
       */
      bool GetPreserveIntensities() const { return this->m_PreserveIntensities; }

      /** Name of this class */
      std::string GetName() const { return std::string ("ClosingByReconstructionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_KernelRadius{std::vector<uint32_t>(3, 1)};

      KernelEnum  m_KernelType{itk::simple::sitkBall};

      /*  */
      bool  m_FullyConnected{false};

      /*  */
      bool  m_PreserveIntensities{false};


    };

    /**\
     * \brief Closing by reconstruction of an image.
     *
     * This function directly calls the execute method of ClosingByReconstructionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ClosingByReconstructionImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image ClosingByReconstruction ( const Image& image1, std::vector<unsigned int> kernelRadius = std::vector<uint32_t>(3, 1), KernelEnum kernelType = itk::simple::sitkBall, bool fullyConnected = false, bool preserveIntensities = false );

     /** @} */
}
#endif
