/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;

final class HgIncomingOutgoingWidget
extends EditorBasedWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget.Multiframe {
    private static final String INCOMING_WIDGET_ID = "InHgIncomingOutgoingWidget";
    private static final String OUTGOING_WIDGET_ID = "OutHgIncomingOutgoingWidget";
    @NotNull
    private final HgVcs myVcs;
    private final boolean myIsIncoming;
    @NotNull
    private final Icon myEnabledIcon;
    @NotNull
    private final Icon myDisabledIcon;
    private volatile @NlsContexts.Tooltip String myTooltip;
    private Icon myCurrentIcon;

    HgIncomingOutgoingWidget(@NotNull HgVcs vcs, boolean isIncoming) {
        if (vcs == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myTooltip = "";
        this.myIsIncoming = isIncoming;
        this.myVcs = vcs;
        this.myEnabledIcon = this.myIsIncoming ? AllIcons.Ide.IncomingChangesOn : AllIcons.Ide.OutgoingChangesOn;
        this.myCurrentIcon = this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myEnabledIcon);
        this.updateLater();
    }

    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(1);
        }
        super.registerCustomListeners(connection);
        connection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> this.updateLater());
        connection.subscribe(HgVcs.STATUS_TOPIC, (project, root) -> this.updateLater());
        connection.subscribe(HgVcs.REMOTE_TOPIC, (project, root) -> this.updateLater());
        connection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)new HgWidgetUpdater(){

            @Override
            public void update() {
                HgIncomingOutgoingWidget.this.updateLater();
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                HgIncomingOutgoingWidget.this.updateLater();
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(3);
                }
                HgIncomingOutgoingWidget.this.updateLater();
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(4);
                }
                HgIncomingOutgoingWidget.this.updateLater();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public StatusBarWidget copy() {
        return new HgIncomingOutgoingWidget(this.myVcs, this.myIsIncoming);
    }

    @NotNull
    public String ID() {
        return this.myIsIncoming ? INCOMING_WIDGET_ID : OUTGOING_WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> this.updateLater();
    }

    public void updateLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            HgRemoteStatusUpdater statusUpdater = this.myVcs.getRemoteStatusUpdater();
            if (statusUpdater == null) {
                return;
            }
            HgChangesetStatus status = statusUpdater.getStatus(this.myIsIncoming);
            boolean changesAvailable = status.getNumChanges() > 0;
            this.myCurrentIcon = changesAvailable ? this.myEnabledIcon : this.myDisabledIcon;
            Object object = this.myTooltip = changesAvailable ? "\n" + status.getToolTip() : HgBundle.message("no.changes.available", new Object[0]);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        });
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomListeners";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static abstract class MyWidgetFactory
    implements StatusBarWidgetFactory {
        private final boolean myIsIncoming;

        protected MyWidgetFactory(boolean isIncoming) {
            this.myIsIncoming = isIncoming;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                MyWidgetFactory.$$$reportNull$$$0(0);
            }
            return HgRemoteStatusUpdater.isCheckingEnabled(project);
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                MyWidgetFactory.$$$reportNull$$$0(1);
            }
            HgVcs hgVcs = Objects.requireNonNull(HgVcs.getInstance(project));
            return new HgIncomingOutgoingWidget(hgVcs, this.myIsIncoming);
        }

        @NotNull
        public String getId() {
            return this.myIsIncoming ? HgIncomingOutgoingWidget.INCOMING_WIDGET_ID : HgIncomingOutgoingWidget.OUTGOING_WIDGET_ID;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myIsIncoming ? HgBundle.message("hg4idea.status.bar.incoming.widget.name", new Object[0]) : HgBundle.message("hg4idea.status.bar.outgoing.widget.name", new Object[0]);
            if (string == null) {
                MyWidgetFactory.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$MyWidgetFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$MyWidgetFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static final class OutgoingFactory
    extends MyWidgetFactory {
        OutgoingFactory() {
            super(false);
        }
    }

    static final class IncomingFactory
    extends MyWidgetFactory {
        IncomingFactory() {
            super(true);
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener,
    HgWidgetUpdater {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            this.updateVisibility();
        }

        @Override
        public void updateVisibility() {
            StatusBarWidgetsManager widgetManager = (StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class);
            widgetManager.updateWidget(IncomingFactory.class);
            widgetManager.updateWidget(OutgoingFactory.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$Listener", "<init>"));
        }
    }
}

