/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveDecoratorQuickFix;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyNestedDecoratorsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNestedDecoratorsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyNestedDecoratorsInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyNestedDecoratorsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private static final Set<String> TRANSFORMING_DECORATORS = Set.of("classmethod", "staticmethod");
        private static final Set<String> UNAFFECTED_DECORATORS = Set.of("typing.final", "typing.no_type_check", "typing.overload", "typing.override", "typing.type_check_only", "typing_extensions.final", "typing_extensions.no_type_check", "typing_extensions.overload", "typing_extensions.override", "typing_extensions.type_check_only", "functools.singledispatchmethod", "pydantic.functional_validators.field_validator", "pydantic.functional_validators.model_validator", "pydantic.class_validators.validator", "django.views.decorators.cache.cache_page", "tenacity.retry");

        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            PyAstDecoratorList decolist;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((decolist = node.getDecoratorList()) == null) {
                return;
            }
            PyDecorator[] decos = decolist.getDecorators();
            if (decos.length < 2) {
                return;
            }
            for (int i = decos.length - 1; i >= 1; --i) {
                boolean isTransforming;
                PyDecorator decoInner = decos[i];
                String decoInnerName = decoInner.getName();
                boolean bl = isTransforming = TRANSFORMING_DECORATORS.contains(decoInnerName) && decoInner.isBuiltin();
                if (!isTransforming) continue;
                for (int j = i - 1; j >= 0; --j) {
                    boolean maybeAffected;
                    PyDecorator decoOuter = decos[j];
                    boolean bl2 = maybeAffected = !this.isUnaffectedDecorator(decoOuter);
                    if (!maybeAffected) continue;
                    this.registerProblem((PsiElement)decoOuter, PyPsiBundle.message("INSP.decorator.receives.unexpected.builtin", decoInnerName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new LocalQuickFix[]{new RemoveDecoratorQuickFix()});
                    return;
                }
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private boolean isUnaffectedDecorator(@NotNull PyDecorator decorator) {
            if (decorator == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            @NotNull List pyCallables = decorator.multiResolveCalleeFunction(this.getResolveContext());
            for (PyCallable callable : pyCallables) {
                String decoOuterName = Visitor.getQualifiedName(callable);
                if (!UNAFFECTED_DECORATORS.contains(decoOuterName)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private static String getQualifiedName(PyCallable callable) {
            PyFunction pyFunction;
            PyClass constrClass;
            String decoOuterName = null;
            if (callable instanceof PyFunction && (constrClass = PyUtil.turnConstructorIntoClass(pyFunction = (PyFunction)callable)) != null) {
                decoOuterName = constrClass.getQualifiedName();
            }
            if (decoOuterName == null) {
                decoOuterName = callable.getQualifiedName();
            }
            return decoOuterName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyNestedDecoratorsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnaffectedDecorator";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

