/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.util;

import git4idea.remote.GitRemoteUrlCoordinates;
import git4idea.remote.hosting.HostedGitRepositoryMapping;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitRepositoryMappingData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;", "Lgit4idea/remote/hosting/HostedGitRepositoryMapping;", "Lgit4idea/ui/branch/GitRepositoryMappingData;", "repository", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Lgit4idea/remote/GitRemoteUrlCoordinates;)V", "getRepository", "()Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "getRemote", "()Lgit4idea/remote/GitRemoteUrlCoordinates;", "gitRemote", "Lgit4idea/repo/GitRemote;", "getGitRemote", "()Lgit4idea/repo/GitRemote;", "gitRepository", "Lgit4idea/repo/GitRepository;", "getGitRepository", "()Lgit4idea/repo/GitRepository;", "repositoryPath", "", "getRepositoryPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.vcs.gitlab"})
public final class GitLabProjectMapping
implements HostedGitRepositoryMapping,
GitRepositoryMappingData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitLabProjectCoordinates repository;
    @NotNull
    private final GitRemoteUrlCoordinates remote;

    public GitLabProjectMapping(@NotNull GitLabProjectCoordinates repository, @NotNull GitRemoteUrlCoordinates remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.repository = repository;
        this.remote = remote;
    }

    @NotNull
    public GitLabProjectCoordinates getRepository() {
        return this.repository;
    }

    @NotNull
    public GitRemoteUrlCoordinates getRemote() {
        return this.remote;
    }

    @NotNull
    public GitRemote getGitRemote() {
        return this.getRemote().getRemote();
    }

    @NotNull
    public GitRepository getGitRepository() {
        return this.getRemote().getRepository();
    }

    @NotNull
    public String getRepositoryPath() {
        return this.getRepository().getProjectPath().getName();
    }

    @NotNull
    public final GitLabProjectCoordinates component1() {
        return this.repository;
    }

    @NotNull
    public final GitRemoteUrlCoordinates component2() {
        return this.remote;
    }

    @NotNull
    public final GitLabProjectMapping copy(@NotNull GitLabProjectCoordinates repository, @NotNull GitRemoteUrlCoordinates remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return new GitLabProjectMapping(repository, remote);
    }

    public static /* synthetic */ GitLabProjectMapping copy$default(GitLabProjectMapping gitLabProjectMapping, GitLabProjectCoordinates gitLabProjectCoordinates, GitRemoteUrlCoordinates gitRemoteUrlCoordinates, int n, Object object) {
        if ((n & 1) != 0) {
            gitLabProjectCoordinates = gitLabProjectMapping.repository;
        }
        if ((n & 2) != 0) {
            gitRemoteUrlCoordinates = gitLabProjectMapping.remote;
        }
        return gitLabProjectMapping.copy(gitLabProjectCoordinates, gitRemoteUrlCoordinates);
    }

    @NotNull
    public String toString() {
        return "GitLabProjectMapping(repository=" + this.repository + ", remote=" + this.remote + ")";
    }

    public int hashCode() {
        int result2 = this.repository.hashCode();
        result2 = result2 * 31 + this.remote.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabProjectMapping)) {
            return false;
        }
        GitLabProjectMapping gitLabProjectMapping = (GitLabProjectMapping)other;
        if (!Intrinsics.areEqual((Object)this.repository, (Object)gitLabProjectMapping.repository)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.remote, (Object)gitLabProjectMapping.remote);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabProjectMapping create(@NotNull GitLabServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GitLabProjectCoordinates gitLabProjectCoordinates = GitLabProjectCoordinates.Companion.create(server, remote);
            if (gitLabProjectCoordinates == null) {
                return null;
            }
            GitLabProjectCoordinates repository = gitLabProjectCoordinates;
            return new GitLabProjectMapping(repository, remote);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

