/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import java.util.Collections;

public class ArrayInitializerExpression
extends Expression {
    public static final ArrayInitializerExpression NULL = new NullArrayInitializerExpression();

    public ArrayInitializerExpression() {
        super(-34);
    }

    public ArrayInitializerExpression(Iterable<Expression> elements) {
        super(-34);
        if (elements != null) {
            AstNodeCollection<Expression> elementsCollection = this.getElements();
            for (Expression element : elements) {
                elementsCollection.add(element);
            }
        }
    }

    public ArrayInitializerExpression(Expression ... elements) {
        super(-34);
        if (elements != null) {
            Collections.addAll(this.getElements(), elements);
        }
    }

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<Expression> getElements() {
        return this.getChildrenByRole(Roles.EXPRESSION);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitArrayInitializerExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ArrayInitializerExpression) {
            ArrayInitializerExpression otherInitializer = (ArrayInitializerExpression)other;
            return !otherInitializer.isNull() && this.getElements().matches(otherInitializer.getElements(), match);
        }
        return false;
    }

    private static final class NullArrayInitializerExpression
    extends ArrayInitializerExpression {
        private NullArrayInitializerExpression() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

