/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;

public class DelayTile
extends AbstractTile
implements Tile {
    private final Delay delay;
    private final TileArguments tileArguments;
    private Real middle;
    private final YGauge yGauge;

    @Override
    public Event getEvent() {
        return this.delay;
    }

    public DelayTile(Delay delay, TileArguments tileArguments, YGauge currentY) {
        super(tileArguments.getStringBounder(), currentY);
        this.delay = delay;
        this.tileArguments = tileArguments;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    private void init(StringBounder stringBounder) {
        if (this.middle != null) {
            return;
        }
        Real first = this.tileArguments.getFirstLivingSpace().getPosC(stringBounder);
        Component comp = this.getComponent(stringBounder);
        Real last = this.tileArguments.getLastLivingSpace().getPosC(stringBounder);
        this.middle = RealUtils.middle(first, last);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.tileArguments.getSkin().createComponent(this.delay.getUsedStyles(), ComponentType.DELAY_TEXT, null, this.tileArguments.getSkinParam(), this.delay.getText());
        return comp;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.init(stringBounder);
        Component comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = Area.create(this.getPreferredWidth(stringBounder), dim.getHeight());
        double ypos = this.getTimeHook().getValue();
        this.tileArguments.getLivingSpaces().delayOn(ypos, dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.getMinX().getCurrentValue()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        this.init(this.getStringBounder());
        return this.middle.addFixed(-this.getPreferredWidth(this.getStringBounder()) / 2.0);
    }

    @Override
    public Real getMaxX() {
        this.init(this.getStringBounder());
        return this.middle.addFixed(this.getPreferredWidth(this.getStringBounder()) / 2.0);
    }
}

