/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.ReplicaKey;
import org.slf4j.Logger;

public class ResignedState
implements EpochState {
    private final int localId;
    private final int epoch;
    private final Endpoints endpoints;
    private final Set<Integer> voters;
    private final long electionTimeoutMs;
    private final Set<Integer> unackedVoters;
    private final Timer electionTimer;
    private final List<ReplicaKey> preferredSuccessors;
    private final Logger log;

    public ResignedState(Time time, int localId, int epoch, Set<Integer> voters, long electionTimeoutMs, List<ReplicaKey> preferredSuccessors, Endpoints endpoints, LogContext logContext) {
        this.localId = localId;
        this.epoch = epoch;
        this.voters = voters;
        this.unackedVoters = new HashSet<Integer>(voters);
        this.unackedVoters.remove(localId);
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer(electionTimeoutMs);
        this.preferredSuccessors = preferredSuccessors;
        this.endpoints = endpoints;
        this.log = logContext.logger(ResignedState.class);
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localId, Optional.empty(), this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return this.endpoints;
    }

    public Set<Integer> unackedVoters() {
        return this.unackedVoters;
    }

    public void acknowledgeResignation(int voterId) {
        if (!this.voters.contains(voterId)) {
            throw new IllegalArgumentException("Attempt to acknowledge delivery of `EndQuorumEpoch` by a non-voter " + voterId);
        }
        this.unackedVoters.remove(voterId);
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public List<ReplicaKey> preferredSuccessors() {
        return this.preferredSuccessors;
    }

    @Override
    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        if (isPreVote && isLogUpToDate) {
            return true;
        }
        this.log.debug("Rejecting Vote request (preVote={}) from replica ({}) since we are in ResignedState in epoch {} and the replica's log is up-to-date={}", new Object[]{isPreVote, replicaKey, this.epoch, isLogUpToDate});
        return false;
    }

    @Override
    public String name() {
        return "Resigned";
    }

    public String toString() {
        return "ResignedState(localId=" + this.localId + ", epoch=" + this.epoch + ", voters=" + String.valueOf(this.voters) + ", electionTimeoutMs=" + this.electionTimeoutMs + ", unackedVoters=" + String.valueOf(this.unackedVoters) + ", preferredSuccessors=" + String.valueOf(this.preferredSuccessors) + ")";
    }

    @Override
    public void close() {
    }
}

