/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.itk.simple.InterpolatorEnum;
import org.itk.simple.PixelIDValueEnum;
import org.itk.simple.SWIGTYPE_p_itk__DataObject;
import org.itk.simple.SWIGTYPE_p_std__complexT_double_t;
import org.itk.simple.SWIGTYPE_p_std__complexT_float_t;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorFloat;
import org.itk.simple.VectorInt16;
import org.itk.simple.VectorInt32;
import org.itk.simple.VectorInt64;
import org.itk.simple.VectorInt8;
import org.itk.simple.VectorString;
import org.itk.simple.VectorUInt16;
import org.itk.simple.VectorUInt32;
import org.itk.simple.VectorUInt64;
import org.itk.simple.VectorUInt8;

public class Image {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
    public static final double DefaultImageCoordinateTolerance = SimpleITKJNI.Image_DefaultImageCoordinateTolerance_get();
    public static final double DefaultImageDirectionTolerance = SimpleITKJNI.Image_DefaultImageDirectionTolerance_get();

    protected Image(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Image image) {
        return image == null ? 0L : image.swigCPtr;
    }

    protected static long swigRelease(Image image) {
        long l = 0L;
        if (image != null) {
            if (!image.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = image.swigCPtr;
            image.swigCMemOwn = false;
            image.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_Image(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Buffer getBufferAsBuffer() {
        ByteBuffer byteBuffer = this.getBufferAsByteBuffer();
        if (this.getPixelID() == PixelIDValueEnum.sitkInt16 || this.getPixelID() == PixelIDValueEnum.sitkVectorInt16) {
            return byteBuffer.asShortBuffer();
        }
        if (this.getPixelID() == PixelIDValueEnum.sitkUInt16 || this.getPixelID() == PixelIDValueEnum.sitkVectorUInt16) {
            return byteBuffer.asCharBuffer();
        }
        if (this.getPixelID() == PixelIDValueEnum.sitkInt32 || this.getPixelID() == PixelIDValueEnum.sitkVectorInt32) {
            return byteBuffer.asIntBuffer();
        }
        if (this.getPixelID() == PixelIDValueEnum.sitkFloat32 || this.getPixelID() == PixelIDValueEnum.sitkComplexFloat32 || this.getPixelID() == PixelIDValueEnum.sitkVectorFloat32) {
            return byteBuffer.asFloatBuffer();
        }
        if (this.getPixelID() == PixelIDValueEnum.sitkFloat64 || this.getPixelID() == PixelIDValueEnum.sitkComplexFloat64 || this.getPixelID() == PixelIDValueEnum.sitkVectorFloat64) {
            return byteBuffer.asDoubleBuffer();
        }
        return byteBuffer;
    }

    public Image() {
        this(SimpleITKJNI.new_Image__SWIG_0(), true);
    }

    public Image(Image image) {
        this(SimpleITKJNI.new_Image__SWIG_1(Image.getCPtr(image), image), true);
    }

    public Image(long l, long l2, PixelIDValueEnum pixelIDValueEnum) {
        this(SimpleITKJNI.new_Image__SWIG_2(l, l2, pixelIDValueEnum.swigValue()), true);
    }

    public Image(long l, long l2, long l3, PixelIDValueEnum pixelIDValueEnum) {
        this(SimpleITKJNI.new_Image__SWIG_3(l, l2, l3, pixelIDValueEnum.swigValue()), true);
    }

    public Image(VectorUInt32 vectorUInt32, PixelIDValueEnum pixelIDValueEnum, long l) {
        this(SimpleITKJNI.new_Image__SWIG_4(VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, pixelIDValueEnum.swigValue(), l), true);
    }

    public Image(VectorUInt32 vectorUInt32, PixelIDValueEnum pixelIDValueEnum) {
        this(SimpleITKJNI.new_Image__SWIG_5(VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, pixelIDValueEnum.swigValue()), true);
    }

    public SWIGTYPE_p_itk__DataObject getITKBase() {
        long l = SimpleITKJNI.Image_getITKBase__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_itk__DataObject(l, false);
    }

    public PixelIDValueEnum getPixelID() {
        return PixelIDValueEnum.swigToEnum(SimpleITKJNI.Image_getPixelID(this.swigCPtr, this));
    }

    public int getPixelIDValue() {
        return SimpleITKJNI.Image_getPixelIDValue(this.swigCPtr, this);
    }

    public String getPixelIDTypeAsString() {
        return SimpleITKJNI.Image_getPixelIDTypeAsString(this.swigCPtr, this);
    }

    public long getDimension() {
        return SimpleITKJNI.Image_getDimension(this.swigCPtr, this);
    }

    public long getNumberOfComponentsPerPixel() {
        return SimpleITKJNI.Image_getNumberOfComponentsPerPixel(this.swigCPtr, this);
    }

    public BigInteger getNumberOfPixels() {
        return SimpleITKJNI.Image_getNumberOfPixels(this.swigCPtr, this);
    }

    public long getSizeOfPixelComponent() {
        return SimpleITKJNI.Image_getSizeOfPixelComponent(this.swigCPtr, this);
    }

    public VectorDouble getOrigin() {
        return new VectorDouble(SimpleITKJNI.Image_getOrigin(this.swigCPtr, this), true);
    }

    public void setOrigin(VectorDouble vectorDouble) {
        SimpleITKJNI.Image_setOrigin(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getSpacing() {
        return new VectorDouble(SimpleITKJNI.Image_getSpacing(this.swigCPtr, this), true);
    }

    public void setSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.Image_setSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getDirection() {
        return new VectorDouble(SimpleITKJNI.Image_getDirection(this.swigCPtr, this), true);
    }

    public void setDirection(VectorDouble vectorDouble) {
        SimpleITKJNI.Image_setDirection(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble transformIndexToPhysicalPoint(VectorInt64 vectorInt64) {
        return new VectorDouble(SimpleITKJNI.Image_transformIndexToPhysicalPoint(this.swigCPtr, this, VectorInt64.getCPtr(vectorInt64), vectorInt64), true);
    }

    public VectorInt64 transformPhysicalPointToIndex(VectorDouble vectorDouble) {
        return new VectorInt64(SimpleITKJNI.Image_transformPhysicalPointToIndex(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public VectorDouble transformPhysicalPointToContinuousIndex(VectorDouble vectorDouble) {
        return new VectorDouble(SimpleITKJNI.Image_transformPhysicalPointToContinuousIndex(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public VectorDouble transformContinuousIndexToPhysicalPoint(VectorDouble vectorDouble) {
        return new VectorDouble(SimpleITKJNI.Image_transformContinuousIndexToPhysicalPoint(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public VectorDouble evaluateAtContinuousIndex(VectorDouble vectorDouble, InterpolatorEnum interpolatorEnum) {
        return new VectorDouble(SimpleITKJNI.Image_evaluateAtContinuousIndex__SWIG_0(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble, interpolatorEnum.swigValue()), true);
    }

    public VectorDouble evaluateAtContinuousIndex(VectorDouble vectorDouble) {
        return new VectorDouble(SimpleITKJNI.Image_evaluateAtContinuousIndex__SWIG_1(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public VectorDouble evaluateAtPhysicalPoint(VectorDouble vectorDouble, InterpolatorEnum interpolatorEnum) {
        return new VectorDouble(SimpleITKJNI.Image_evaluateAtPhysicalPoint__SWIG_0(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble, interpolatorEnum.swigValue()), true);
    }

    public VectorDouble evaluateAtPhysicalPoint(VectorDouble vectorDouble) {
        return new VectorDouble(SimpleITKJNI.Image_evaluateAtPhysicalPoint__SWIG_1(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public boolean isCongruentImageGeometry(Image image, double d, double d2) {
        return SimpleITKJNI.Image_isCongruentImageGeometry(this.swigCPtr, this, Image.getCPtr(image), image, d, d2);
    }

    public boolean isSameImageGeometryAs(Image image, double d, double d2) {
        return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_0(this.swigCPtr, this, Image.getCPtr(image), image, d, d2);
    }

    public boolean isSameImageGeometryAs(Image image, double d) {
        return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_1(this.swigCPtr, this, Image.getCPtr(image), image, d);
    }

    public boolean isSameImageGeometryAs(Image image) {
        return SimpleITKJNI.Image_isSameImageGeometryAs__SWIG_2(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    public VectorUInt32 getSize() {
        return new VectorUInt32(SimpleITKJNI.Image_getSize(this.swigCPtr, this), true);
    }

    public long getWidth() {
        return SimpleITKJNI.Image_getWidth(this.swigCPtr, this);
    }

    public long getHeight() {
        return SimpleITKJNI.Image_getHeight(this.swigCPtr, this);
    }

    public long getDepth() {
        return SimpleITKJNI.Image_getDepth(this.swigCPtr, this);
    }

    public void copyInformation(Image image) {
        SimpleITKJNI.Image_copyInformation(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    public VectorString getMetaDataKeys() {
        return new VectorString(SimpleITKJNI.Image_getMetaDataKeys(this.swigCPtr, this), true);
    }

    public boolean hasMetaDataKey(String string) {
        return SimpleITKJNI.Image_hasMetaDataKey(this.swigCPtr, this, string);
    }

    public String getMetaData(String string) {
        return SimpleITKJNI.Image_getMetaData(this.swigCPtr, this, string);
    }

    public void setMetaData(String string, String string2) {
        SimpleITKJNI.Image_setMetaData(this.swigCPtr, this, string, string2);
    }

    public boolean eraseMetaData(String string) {
        return SimpleITKJNI.Image_eraseMetaData(this.swigCPtr, this, string);
    }

    public String toString() {
        return SimpleITKJNI.Image_toString(this.swigCPtr, this);
    }

    public Image toVectorImage(boolean bl) {
        return new Image(SimpleITKJNI.Image_toVectorImage__SWIG_0(this.swigCPtr, this, bl), true);
    }

    public Image toVectorImage() {
        return new Image(SimpleITKJNI.Image_toVectorImage__SWIG_1(this.swigCPtr, this), true);
    }

    public Image toScalarImage(boolean bl) {
        return new Image(SimpleITKJNI.Image_toScalarImage__SWIG_0(this.swigCPtr, this, bl), true);
    }

    public Image toScalarImage() {
        return new Image(SimpleITKJNI.Image_toScalarImage__SWIG_1(this.swigCPtr, this), true);
    }

    public byte getPixelAsInt8(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public short getPixelAsUInt8(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsUInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public short getPixelAsInt16(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public int getPixelAsUInt16(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsUInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public int getPixelAsInt32(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public long getPixelAsUInt32(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsUInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public long getPixelAsInt64(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public BigInteger getPixelAsUInt64(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsUInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public float getPixelAsFloat(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsFloat(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public double getPixelAsDouble(VectorUInt32 vectorUInt32) {
        return SimpleITKJNI.Image_getPixelAsDouble(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorInt8 getPixelAsVectorInt8(VectorUInt32 vectorUInt32) {
        return new VectorInt8(SimpleITKJNI.Image_getPixelAsVectorInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorUInt8 getPixelAsVectorUInt8(VectorUInt32 vectorUInt32) {
        return new VectorUInt8(SimpleITKJNI.Image_getPixelAsVectorUInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorInt16 getPixelAsVectorInt16(VectorUInt32 vectorUInt32) {
        return new VectorInt16(SimpleITKJNI.Image_getPixelAsVectorInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorUInt16 getPixelAsVectorUInt16(VectorUInt32 vectorUInt32) {
        return new VectorUInt16(SimpleITKJNI.Image_getPixelAsVectorUInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorInt32 getPixelAsVectorInt32(VectorUInt32 vectorUInt32) {
        return new VectorInt32(SimpleITKJNI.Image_getPixelAsVectorInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorUInt32 getPixelAsVectorUInt32(VectorUInt32 vectorUInt32) {
        return new VectorUInt32(SimpleITKJNI.Image_getPixelAsVectorUInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorInt64 getPixelAsVectorInt64(VectorUInt32 vectorUInt32) {
        return new VectorInt64(SimpleITKJNI.Image_getPixelAsVectorInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorUInt64 getPixelAsVectorUInt64(VectorUInt32 vectorUInt32) {
        return new VectorUInt64(SimpleITKJNI.Image_getPixelAsVectorUInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorFloat getPixelAsVectorFloat32(VectorUInt32 vectorUInt32) {
        return new VectorFloat(SimpleITKJNI.Image_getPixelAsVectorFloat32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public VectorDouble getPixelAsVectorFloat64(VectorUInt32 vectorUInt32) {
        return new VectorDouble(SimpleITKJNI.Image_getPixelAsVectorFloat64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public SWIGTYPE_p_std__complexT_float_t getPixelAsComplexFloat32(VectorUInt32 vectorUInt32) {
        return new SWIGTYPE_p_std__complexT_float_t(SimpleITKJNI.Image_getPixelAsComplexFloat32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public SWIGTYPE_p_std__complexT_double_t getPixelAsComplexFloat64(VectorUInt32 vectorUInt32) {
        return new SWIGTYPE_p_std__complexT_double_t(SimpleITKJNI.Image_getPixelAsComplexFloat64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    public void setPixelAsInt8(VectorUInt32 vectorUInt32, byte by) {
        SimpleITKJNI.Image_setPixelAsInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, by);
    }

    public void setPixelAsUInt8(VectorUInt32 vectorUInt32, short s) {
        SimpleITKJNI.Image_setPixelAsUInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, s);
    }

    public void setPixelAsInt16(VectorUInt32 vectorUInt32, short s) {
        SimpleITKJNI.Image_setPixelAsInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, s);
    }

    public void setPixelAsUInt16(VectorUInt32 vectorUInt32, int n) {
        SimpleITKJNI.Image_setPixelAsUInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, n);
    }

    public void setPixelAsInt32(VectorUInt32 vectorUInt32, int n) {
        SimpleITKJNI.Image_setPixelAsInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, n);
    }

    public void setPixelAsUInt32(VectorUInt32 vectorUInt32, long l) {
        SimpleITKJNI.Image_setPixelAsUInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, l);
    }

    public void setPixelAsInt64(VectorUInt32 vectorUInt32, long l) {
        SimpleITKJNI.Image_setPixelAsInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, l);
    }

    public void setPixelAsUInt64(VectorUInt32 vectorUInt32, BigInteger bigInteger) {
        SimpleITKJNI.Image_setPixelAsUInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, bigInteger);
    }

    public void setPixelAsFloat(VectorUInt32 vectorUInt32, float f) {
        SimpleITKJNI.Image_setPixelAsFloat(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, f);
    }

    public void setPixelAsDouble(VectorUInt32 vectorUInt32, double d) {
        SimpleITKJNI.Image_setPixelAsDouble(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, d);
    }

    public void setPixelAsVectorInt8(VectorUInt32 vectorUInt32, VectorInt8 vectorInt8) {
        SimpleITKJNI.Image_setPixelAsVectorInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorInt8.getCPtr(vectorInt8), vectorInt8);
    }

    public void setPixelAsVectorUInt8(VectorUInt32 vectorUInt32, VectorUInt8 vectorUInt8) {
        SimpleITKJNI.Image_setPixelAsVectorUInt8(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorUInt8.getCPtr(vectorUInt8), vectorUInt8);
    }

    public void setPixelAsVectorInt16(VectorUInt32 vectorUInt32, VectorInt16 vectorInt16) {
        SimpleITKJNI.Image_setPixelAsVectorInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorInt16.getCPtr(vectorInt16), vectorInt16);
    }

    public void setPixelAsVectorUInt16(VectorUInt32 vectorUInt32, VectorUInt16 vectorUInt16) {
        SimpleITKJNI.Image_setPixelAsVectorUInt16(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorUInt16.getCPtr(vectorUInt16), vectorUInt16);
    }

    public void setPixelAsVectorInt32(VectorUInt32 vectorUInt32, VectorInt32 vectorInt32) {
        SimpleITKJNI.Image_setPixelAsVectorInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorInt32.getCPtr(vectorInt32), vectorInt32);
    }

    public void setPixelAsVectorUInt32(VectorUInt32 vectorUInt32, VectorUInt32 vectorUInt322) {
        SimpleITKJNI.Image_setPixelAsVectorUInt32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorUInt32.getCPtr(vectorUInt322), vectorUInt322);
    }

    public void setPixelAsVectorInt64(VectorUInt32 vectorUInt32, VectorInt64 vectorInt64) {
        SimpleITKJNI.Image_setPixelAsVectorInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorInt64.getCPtr(vectorInt64), vectorInt64);
    }

    public void setPixelAsVectorUInt64(VectorUInt32 vectorUInt32, VectorUInt64 vectorUInt64) {
        SimpleITKJNI.Image_setPixelAsVectorUInt64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorUInt64.getCPtr(vectorUInt64), vectorUInt64);
    }

    public void setPixelAsVectorFloat32(VectorUInt32 vectorUInt32, VectorFloat vectorFloat) {
        SimpleITKJNI.Image_setPixelAsVectorFloat32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorFloat.getCPtr(vectorFloat), vectorFloat);
    }

    public void setPixelAsVectorFloat64(VectorUInt32 vectorUInt32, VectorDouble vectorDouble) {
        SimpleITKJNI.Image_setPixelAsVectorFloat64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public void setPixelAsComplexFloat32(VectorUInt32 vectorUInt32, SWIGTYPE_p_std__complexT_float_t sWIGTYPE_p_std__complexT_float_t) {
        SimpleITKJNI.Image_setPixelAsComplexFloat32(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, SWIGTYPE_p_std__complexT_float_t.getCPtr(sWIGTYPE_p_std__complexT_float_t));
    }

    public void setPixelAsComplexFloat64(VectorUInt32 vectorUInt32, SWIGTYPE_p_std__complexT_double_t sWIGTYPE_p_std__complexT_double_t) {
        SimpleITKJNI.Image_setPixelAsComplexFloat64(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32, SWIGTYPE_p_std__complexT_double_t.getCPtr(sWIGTYPE_p_std__complexT_double_t));
    }

    public ByteBuffer getBufferAsByteBuffer() {
        return SimpleITKJNI.Image_getBufferAsByteBuffer(this.swigCPtr, this);
    }

    public void makeUnique() {
        SimpleITKJNI.Image_makeUnique(this.swigCPtr, this);
    }

    public boolean isUnique() {
        return SimpleITKJNI.Image_isUnique(this.swigCPtr, this);
    }

    public long getBufferAsNativePointer() {
        return SimpleITKJNI.Image_getBufferAsNativePointer(this.swigCPtr, this);
    }
}

